/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.sp;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.sp.StorEdge_6x20ApplicationServer;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import com.sun.netstorage.mgmt.dm.util.logic.HostID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;

public class StorEdge_6x20OperatingSystem
extends StorEdge_InstanceProvider {
    private static final String PROP_CREATION_CLASSNAME = "CreationClassName";
    private static final String PROP_CS_CREATION_CLASSNAME = "CSCreationClassName";
    protected static final String PROP_CS_NAME = "CSName";
    private static final String PROP_NAME = "Name";
    private static final String PROP_OS_TYPE = "OSType";
    private static final String PROP_VERSION = "Version";
    private static final String PROP_IP_ADDRESS = "NTPServerIpAddr";
    private static final String PROP_NTP_ENABLE = "NTPEnabled";
    private static final String PROP_ZONE_NAME = "TimeZoneName";
    private static final String PROP_DATE_TIME = "LocalDateTime";
    private static final String PROP_TIME_ZONE = "CurrentTimeZone";
    private static final String CS_CLASSNAME_VALUE = "StorEdge_6x20ApplicationServer";
    private static final String NAME_VALUE = "Solaris";
    private static final int OS_TYPE_VALUE = 29;
    private static final String VERSION_VALUE = "5.9.0";
    private static final String NTPCONF_FILE = "/etc/inet/ntp.conf";
    private static final String DEFAULT_NTP_IP = "127.127.1.0";
    private static final String CLASSNAME = "StorEdge_6x20OperatingSystem";
    private static String ntpServerAddress;
    private static long CACHE_EXPIRATION;
    private static int FETCH_ADDRESS;
    private static int FETCH_HEADER;
    private static Date lastNtpRead;
    private static final String PERSISTENT_TIME_ZONE = "StorEdge_6x20OperatingSystem.TimeZoneName";

    public String getClassName() {
        return CLASSNAME;
    }

    protected static CIMInstance getOperatingSystemInstance(HostID hostID, CIMOMHandle cimomhandle, String nameSpace) throws CIMException {
        String METHOD = "getOperatingSystemInstance";
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.getOperatingSystemInstance entered ");
        CIMInstance ci = null;
        try {
            CIMObjectPath cop = new CIMObjectPath(CLASSNAME);
            cop.setNameSpace(nameSpace);
            ci = cimomhandle.getClass(cop, false, true, true, null).newInstance();
            ci.setProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)CLASSNAME));
            ci.setProperty(PROP_CS_CREATION_CLASSNAME, new CIMValue((Object)CS_CLASSNAME_VALUE));
            ci.setProperty(PROP_NAME, new CIMValue((Object)NAME_VALUE));
            ci.setProperty(PROP_OS_TYPE, new CIMValue((Object)new UnsignedInt16(29), new CIMDataType(2)));
            ci.setProperty(PROP_VERSION, new CIMValue((Object)VERSION_VALUE));
            if (hostID != null && hostID.toString() != null) {
                ci.setProperty(PROP_CS_NAME, new CIMValue((Object)hostID.toString()));
            } else {
                ci.setProperty(PROP_CS_NAME, new CIMValue((Object)StorEdge_6x20ApplicationServer.getHostID().toString()));
            }
            StorEdge_6x20OperatingSystem.updateNtpAddr();
            ci.setProperty(PROP_IP_ADDRESS, new CIMValue((Object)(ntpServerAddress == null || ntpServerAddress.indexOf(DEFAULT_NTP_IP) >= 0 ? "" : ntpServerAddress)));
            WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getOperatingSystemInstance ntpAddress is " + ntpServerAddress));
            ci.setProperty(PROP_NTP_ENABLE, new CIMValue((Object)new Boolean(ntpServerAddress != null && ntpServerAddress.indexOf(DEFAULT_NTP_IP) < 0), new CIMDataType(9)));
            String timeZoneNameValue = StorEdge_6x20OperatingSystem.getPersistedProperty(PERSISTENT_TIME_ZONE);
            ci.setProperty(PROP_ZONE_NAME, new CIMValue((Object)timeZoneNameValue));
            Calendar now = Calendar.getInstance();
            int msecOffset = now.getTimeZone().getOffset(now.getTime().getTime());
            short minsOffset = 0;
            if (msecOffset != 0) {
                minsOffset = (short)(msecOffset / 60000);
            }
            ci.setProperty(PROP_TIME_ZONE, new CIMValue((Object)new Short(minsOffset), new CIMDataType(3)));
            WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getOperatingSystemInstance Current time is " + now.getTime()));
            CIMDateTime cimnow = new CIMDateTime(now);
            ci.setProperty(PROP_DATE_TIME, new CIMValue((Object)cimnow, new CIMDataType(12)));
        }
        catch (CIMException e) {
            WBEMDebug.trace1((String)"getOperatingSystemInstance failed to build instance", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"StorEdge_6x20OperatingSystem.getOperatingSystemInstance", (Throwable)e);
        }
        return ci;
    }

    private static String getPersistedProperty(String name) {
        String METHOD = "getPersistedProperty";
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.getPersistedProperty entered");
        String nameValue = StorEdge_PersistentStorage.getInstance().getPersistentString(PERSISTENT_TIME_ZONE);
        WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getPersistedProperty From persistant storage timezone is |" + nameValue + "|"));
        if (nameValue == null) {
            nameValue = TimeZone.getDefault().getID();
            StorEdge_PersistentStorage.getInstance().setPersistentString(PERSISTENT_TIME_ZONE, nameValue, true);
        }
        return nameValue;
    }

    protected Vector enumerate(String nameSpace) throws CIMException {
        String METHOD = "enumerate";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " entered"));
        Vector<CIMInstance> v = new Vector<CIMInstance>(1);
        v.addElement(StorEdge_6x20OperatingSystem.getOperatingSystemInstance(null, (CIMOMHandle)this.getCimomHandle(), nameSpace));
        return v;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                throw new CIMException("CIM_ERR_INVALID_CLASS");
            }
            Vector keys = op.getKeys();
            HostID hostID = null;
            int i = 0;
            while (i < keys.size()) {
                CIMProperty prop = (CIMProperty)keys.elementAt(i);
                if (prop.getName().equalsIgnoreCase(PROP_CS_NAME)) {
                    hostID = new HostID((String)prop.getValue().getValue());
                }
                ++i;
            }
            CIMInstance ci = StorEdge_6x20OperatingSystem.getOperatingSystemInstance(hostID, (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
            ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
            if (localOnly) {
                ci.localElements();
            }
            return ci;
        }
        catch (CIMException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " unknown failure."), (Throwable)ex);
            throw ex;
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                throw new CIMException("CIM_ERR_INVALID_CLASS");
            }
            if (ci.getProperty(PROP_NTP_ENABLE) != null && ci.getProperty(PROP_NTP_ENABLE).getValue() != null) {
                CIMProperty ntpset = ci.getProperty(PROP_NTP_ENABLE);
                boolean flag = ntpset.getValue().equals((Object)CIMValue.TRUE);
                WBEMDebug.trace2((String)(this.getClassName() + "." + "setInstance" + " Setting ntp enabled to " + flag));
                if (!flag && ci.getProperty(PROP_DATE_TIME) != null && ci.getProperty(PROP_DATE_TIME).getValue() != null && ci.getProperty(PROP_DATE_TIME).getValue().getValue() != null) {
                    WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.setInstance setting date_time to " + ci.getProperty(PROP_DATE_TIME).getValue().getValue()));
                    String newdate = new SimpleDateFormat("MMddHHmmyyyy.ss").format(((CIMDateTime)ci.getProperty(PROP_DATE_TIME).getValue().getValue()).getCalendar().getTime());
                    StorEdge_6x20OperatingSystem.setNtpAddr(null);
                    this.restartNtpDaemon();
                    WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.setInstance Executing date " + newdate));
                    Runtime.getRuntime().exec("date " + newdate);
                }
                if (flag && ci.getProperty(PROP_IP_ADDRESS) != null && ci.getProperty(PROP_IP_ADDRESS).getValue() != null) {
                    CIMProperty ntpserver = ci.getProperty(PROP_IP_ADDRESS);
                    String ntpServerValue = (String)ntpserver.getValue().getValue();
                    WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.setInstance setting ip address to " + ntpServerValue));
                    StorEdge_6x20OperatingSystem.setNtpAddr(ntpServerValue);
                    this.restartNtpDaemon();
                    WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.setInstance running ntpdate " + ntpServerValue));
                    Runtime.getRuntime().exec("ntpdate " + ntpServerValue);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (ci.getProperty(PROP_ZONE_NAME) != null && ci.getProperty(PROP_ZONE_NAME).getValue() != null) {
                CIMProperty tz = ci.getProperty(PROP_ZONE_NAME);
                String zoneid = (String)tz.getValue().getValue();
                WBEMDebug.trace2((String)(" Setting the time zone to  " + zoneid));
                StorEdge_PersistentStorage.getInstance().setPersistentString(PERSISTENT_TIME_ZONE, zoneid, true);
            }
        }
        catch (CIMException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " CIM Exception."), (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " unknown failure."), (Throwable)e);
            e.printStackTrace();
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    private void restartNtpDaemon() throws IOException {
        String METHOD = "restartNtpDaemon";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "restartNtpDaemon" + " entered."));
        WBEMDebug.trace3((String)(this.getClassName() + "." + "restartNtpDaemon" + " executing /etc/init.d/xntpd stop"));
        Runtime.getRuntime().exec("/etc/init.d/xntpd stop");
        WBEMDebug.trace3((String)(this.getClassName() + "." + "restartNtpDaemon" + " executing  /etc/init.d/xntpd start"));
        Runtime.getRuntime().exec("/etc/init.d/xntpd start");
    }

    private static boolean ntpCacheExpired() {
        String METHOD = "ntpCacheExpired";
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.ntpCacheExpired Entered");
        Date now = new Date();
        boolean result = true;
        WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.ntpCacheExpired lastNtpRead is " + lastNtpRead));
        if (lastNtpRead != null && !lastNtpRead.after(now)) {
            long difference = now.getTime() - lastNtpRead.getTime();
            WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.ntpCacheExpired time difference is " + difference));
            result = difference >= CACHE_EXPIRATION;
        }
        WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.ntpCacheExpired Returning result is " + result));
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.ntpCacheExpired Method exited.");
        return result;
    }

    private static void updateNtpAddr() {
        String newAddress;
        String METHOD = "updateNtpAddr";
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.updateNtpAddr entered");
        if ((ntpServerAddress == null || ntpServerAddress != null && StorEdge_6x20OperatingSystem.ntpCacheExpired()) && (newAddress = StorEdge_6x20OperatingSystem.getInfoFromFile(FETCH_ADDRESS)) != null && !newAddress.equals(ntpServerAddress)) {
            StorEdge_6x20OperatingSystem.setNtpAddr(newAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized String getInfoFromFile(int infoType) {
        String result;
        block16: {
            String METHOD = "getInfoFromFile";
            WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.getInfoFromFile entered");
            WBEMDebug.trace3((String)("StorEdge_6x20OperatingSystem.getInfoFromFile getting " + infoType));
            BufferedReader in = null;
            result = null;
            try {
                block15: {
                    try {
                        File ntpConfFile = new File(NTPCONF_FILE);
                        if (!ntpConfFile.exists()) {
                            WBEMDebug.trace2((String)"StorEdge_6x20OperatingSystem.getInfoFromFile File missing :/etc/inet/ntp.conf");
                            WBEMDebug.trace2((String)"StorEdge_6x20OperatingSystem.getInfoFromFile Creating the file ");
                            if (infoType == FETCH_HEADER) {
                                result = StorEdge_6x20OperatingSystem.createDefaultNtpConfFile().toString();
                            } else if (infoType == FETCH_ADDRESS) {
                                result = DEFAULT_NTP_IP;
                            }
                            String[] arg = new String[]{NTPCONF_FILE};
                            LogAPI.staticLog((String)"PERSISTENCE_IO_ERROR_ON_FILE", (String[])arg, (String[])new String[0]);
                            break block15;
                        }
                        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.getInfoFromFile File npt.conf exists.");
                        in = new BufferedReader(new FileReader(ntpConfFile));
                        String line = null;
                        String preferredServer = null;
                        String server = null;
                        StringBuffer content = new StringBuffer("");
                        while (true) {
                            if ((line = in.readLine()) == null) {
                                if (infoType != FETCH_HEADER) break;
                                result = content.toString();
                                break block15;
                            }
                            if (infoType == FETCH_ADDRESS) {
                                StringTokenizer tokenizer;
                                int numberOfTokens;
                                if (line.startsWith("#") || line.indexOf("server") < 0 || (numberOfTokens = (tokenizer = new StringTokenizer(line, " ")).countTokens()) < 2) continue;
                                tokenizer.nextToken();
                                String second = tokenizer.nextToken();
                                WBEMDebug.trace3((String)(" second is " + second));
                                if (numberOfTokens == 2) {
                                    if (server != null) {
                                        WBEMDebug.trace2((String)"StorEdge_6x20OperatingSystem.getInfoFromFile /etc/inet/ntp.conf has more than one server line");
                                        continue;
                                    }
                                    server = second;
                                    continue;
                                }
                                if (numberOfTokens == 3 && tokenizer.nextToken().equals("prefer")) {
                                    if (preferredServer != null) {
                                        WBEMDebug.trace2((String)"StorEdge_6x20OperatingSystem.getInfoFromFile /etc/inet/ntp.conf has more than one server prefer line");
                                        continue;
                                    }
                                    preferredServer = second;
                                    continue;
                                }
                                WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getInfoFromFile /etc/inet/ntp.conf has invalid server line" + line));
                                continue;
                            }
                            if (infoType != FETCH_HEADER || line.indexOf("server") >= 0) continue;
                            content.append(line + "\n");
                        }
                        if (infoType != FETCH_ADDRESS) break block15;
                        WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getInfoFromFile Preferred is " + preferredServer + " \n sever is " + server));
                        result = preferredServer != null ? preferredServer : server;
                    }
                    catch (IOException ioe) {
                        WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getInfoFromFile Exception " + ioe));
                        Object var13_15 = null;
                        StorEdge_6x20OperatingSystem.closeReader(in);
                        break block16;
                    }
                }
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                StorEdge_6x20OperatingSystem.closeReader(in);
                throw throwable;
            }
            StorEdge_6x20OperatingSystem.closeReader(in);
        }
        WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.getInfoFromFile returned " + result));
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.getInfoFromFile Method exited.");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized StringBuffer createDefaultNtpConfFile() {
        StringBuffer result;
        block13: {
            String METHOD = "createDefaultNtpConfFile";
            WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.createDefaultNtpConfFileentered");
            WBEMDebug.trace2((String)"StorEdge_6x20OperatingSystem.createDefaultNtpConfFile Creating default ntp.conf");
            PrintWriter out = null;
            File ntpConfTempFile = new File("/etc/inet/ntp.conf.tmp");
            result = new StringBuffer("# file created by admin provider \n");
            File ntpConfFile = new File(NTPCONF_FILE);
            StringBuffer content = new StringBuffer("# file created by admin provider \nserver 127.127.1.0\n");
            if (ntpServerAddress != null) {
                content.append("server  " + ntpServerAddress + " prefer \n");
            }
            out = new PrintWriter(new FileWriter(ntpConfTempFile));
            out.print(content.toString());
            out.flush();
            WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.createDefaultNtpConfFile Content of default ntp.conf file is " + content));
            ntpConfTempFile.renameTo(ntpConfFile);
            WBEMDebug.trace2((String)"StorEdge_6x20OperatingSystem.createDefaultNtpConfFile ntp.conf created");
            Object var7_7 = null;
            try {
                if (ntpConfTempFile.exists()) {
                    ntpConfTempFile.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            StorEdge_6x20OperatingSystem.closeWriter(out);
            {
                break block13;
                catch (IOException ioe) {
                    WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.createDefaultNtpConfFile Exception " + ioe));
                    Object var7_8 = null;
                    try {
                        if (ntpConfTempFile.exists()) {
                            ntpConfTempFile.delete();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    StorEdge_6x20OperatingSystem.closeWriter(out);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (ntpConfTempFile.exists()) {
                        ntpConfTempFile.delete();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                StorEdge_6x20OperatingSystem.closeWriter(out);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized void setNtpAddr(String ntpAddr) {
        block15: {
            String METHOD = "setNtpAddr";
            WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.setNtpAddr entered");
            PrintWriter out = null;
            StringBuffer content = new StringBuffer(StorEdge_6x20OperatingSystem.getInfoFromFile(FETCH_HEADER));
            File ntpConfTempFile = new File("/etc/inet/ntp.conf.tmp");
            File ntpConfFile = new File(NTPCONF_FILE);
            content.append("server 127.127.1.0\n");
            if (ntpAddr != null) {
                if (!ntpAddr.equals(DEFAULT_NTP_IP)) {
                    content.append("server  " + ntpAddr + " prefer" + " \n");
                }
                ntpServerAddress = ntpAddr;
            } else {
                ntpServerAddress = DEFAULT_NTP_IP;
            }
            lastNtpRead = new Date();
            WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.setNtpAddr \n last ntp read time updated to " + lastNtpRead));
            out = new PrintWriter(new FileWriter(ntpConfTempFile));
            out.print(content.toString());
            out.flush();
            ntpConfTempFile.renameTo(ntpConfFile);
            Object var8_6 = null;
            try {
                if (ntpConfTempFile.exists()) {
                    ntpConfTempFile.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            StorEdge_6x20OperatingSystem.closeWriter(out);
            {
                break block15;
                catch (IOException ioe) {
                    WBEMDebug.trace2((String)("StorEdge_6x20OperatingSystem.setNtpAddr Exception " + ioe));
                    Object var8_7 = null;
                    try {
                        if (ntpConfTempFile.exists()) {
                            ntpConfTempFile.delete();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    StorEdge_6x20OperatingSystem.closeWriter(out);
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (ntpConfTempFile.exists()) {
                        ntpConfTempFile.delete();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                StorEdge_6x20OperatingSystem.closeWriter(out);
                throw throwable;
            }
        }
    }

    private static void closeWriter(Writer out) {
        String METHOD = "closeWriter";
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.closeWriter entered");
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void closeReader(Reader in) {
        String METHOD = "closeReader";
        WBEMDebug.trace3((String)"StorEdge_6x20OperatingSystem.closeReader entered");
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        PROP_CREATION_CLASSNAME = PROP_CREATION_CLASSNAME;
        PROP_CS_CREATION_CLASSNAME = PROP_CS_CREATION_CLASSNAME;
        PROP_CS_NAME = PROP_CS_NAME;
        PROP_NAME = PROP_NAME;
        PROP_OS_TYPE = PROP_OS_TYPE;
        PROP_VERSION = PROP_VERSION;
        PROP_IP_ADDRESS = PROP_IP_ADDRESS;
        PROP_NTP_ENABLE = PROP_NTP_ENABLE;
        PROP_ZONE_NAME = PROP_ZONE_NAME;
        PROP_DATE_TIME = PROP_DATE_TIME;
        PROP_TIME_ZONE = PROP_TIME_ZONE;
        CS_CLASSNAME_VALUE = CS_CLASSNAME_VALUE;
        NAME_VALUE = NAME_VALUE;
        OS_TYPE_VALUE = 29;
        VERSION_VALUE = VERSION_VALUE;
        NTPCONF_FILE = NTPCONF_FILE;
        DEFAULT_NTP_IP = DEFAULT_NTP_IP;
        CLASSNAME = CLASSNAME;
        CACHE_EXPIRATION = 600000L;
        FETCH_ADDRESS = 0;
        FETCH_HEADER = 1;
        StorEdge_6x20OperatingSystem.updateNtpAddr();
        PERSISTENT_TIME_ZONE = PERSISTENT_TIME_ZONE;
    }
}

