/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.admin;

import com.sun.netstorage.array.mgmt.admin.StorEdge_6x20MessageLog;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;

public class StorEdge_6x20LogRecord
extends StorEdge_InstanceProvider {
    private static final String DELIMITER = "|";
    private static final String PROP_LOG_CREATION_CLASSNAME = "LogCreationClassName";
    private static final String PROP_CREATION_CLASSNAME = "CreationClassName";
    static final String PROP_LOG_NAME = "LogName";
    private static final String PROP_RECORD_ID = "RecordID";
    private static final String PROP_MESSAGE_TIMESTAMP = "MessageTimestamp";
    private static final String PROP_DATA_FORMAT = "DataFormat";
    private static final String PROP_RECORD_DATA = "RecordData";
    private static final String PROP_LANGUAGE_ID = "LanguageIdentifier";
    private static final String PROP_LOG_EVENT_TYPE = "LogEventType";
    private static final String LOG_CREATION_CLASSNAME_VAL = "StorEdge_6x20MessageLog";
    private static final String DATA_FORMAT_VAL = "One line is of a form ...";
    static final HashMap SUBCLASS_MAP;
    static final String ENGLISH = "StorEdge_6x20EnglishLogRecord";
    private static final String GERMAN = "StorEdge_6x20GermanLogRecord";
    private static final String FRENCH = "StorEdge_6x20FrenchLogRecord";
    private static final String CHINESE = "StorEdge_6x20ChineseLogRecord";
    private static final String JAPANESE = "StorEdge_6x20JapaneseLogRecord";
    private static final String CLASSNAME = "StorEdge_6x20LogRecord";

    public Vector getClassNames() {
        String METHOD = "getClassNames";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.getClassNames entered");
        Vector<String> result = new Vector<String>();
        Set keySet = SUBCLASS_MAP.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            result.addElement((String)iterator.next());
        }
        result.addElement(this.getClassName());
        return result;
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public boolean isMultiClassProvider() {
        return true;
    }

    protected static CIMInstance getLogRecordInstance(String logName, String creationClassName, String recordId, String content, CIMOMHandle cimomhandle, String nameSpace) throws CIMException {
        String METHOD = "getLogRecordInstance";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.getLogRecordInstance entered");
        CIMInstance ci = null;
        try {
            CIMObjectPath cop = new CIMObjectPath(CLASSNAME);
            cop.setNameSpace(nameSpace);
            ci = cimomhandle.getClass(cop, false, true, true, null).newInstance();
            ci.setProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)CLASSNAME));
            ci.setProperty(PROP_LOG_CREATION_CLASSNAME, new CIMValue((Object)LOG_CREATION_CLASSNAME_VAL));
            if (logName != null && recordId != null && creationClassName != null && SUBCLASS_MAP.containsKey(creationClassName)) {
                String languageIdentifier = (String)SUBCLASS_MAP.get(creationClassName);
                ci.setProperty(PROP_LANGUAGE_ID, new CIMValue((Object)languageIdentifier));
                ci.setProperty(PROP_LOG_NAME, new CIMValue((Object)logName));
                ci.setProperty(PROP_RECORD_ID, new CIMValue((Object)recordId));
                ci.setProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)creationClassName));
                if (content == null) {
                    content = StorEdge_6x20LogRecord.getTranslatedEntries(logName, (String)SUBCLASS_MAP.get(creationClassName))[Integer.parseInt(recordId)];
                    WBEMDebug.trace2((String)("StorEdge_6x20LogRecord.getLogRecordInstance content reset to " + content));
                }
                if (content == null) {
                    WBEMDebug.trace1((String)"StorEdge_6x20LogRecord.getLogRecordInstance (Internal Error) Client attempted to retireve  an instance with one or more invalid property.");
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            } else {
                WBEMDebug.trace1((String)"StorEdge_6x20LogRecord.getLogRecordInstance (Internal Error) Client attempted to retireve  an instance with one or more invalid property.");
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String[] parts = StorEdge_6x20LogRecord.parseLogEntry(content);
            Date date = StorEdge_6x20LogRecord.getTimestamp(parts[0], (String)SUBCLASS_MAP.get(creationClassName));
            CIMDateTime cimDate = new CIMDateTime(date);
            ci.setProperty(PROP_MESSAGE_TIMESTAMP, new CIMValue((Object)cimDate, new CIMDataType(12)));
            ci.setProperty(PROP_RECORD_DATA, new CIMValue((Object)parts[2]));
            ci.setProperty(PROP_LOG_EVENT_TYPE, new CIMValue((Object)parts[1]));
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"StorEdge_6x20LogRecord.getLogRecordInstance failed to build instance", (Throwable)e);
            if (e instanceof CIMException) {
                throw (CIMException)((Object)e);
            }
            throw new CIMException("CIM_ERR_FAILED");
        }
        return ci;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            Vector keys = op.getKeys();
            String logName = null;
            String recordId = null;
            String createClassName = null;
            if (keys != null) {
                int i = 0;
                while (i < keys.size()) {
                    CIMProperty prop = (CIMProperty)keys.elementAt(i);
                    WBEMDebug.trace2((String)(this.getClassName() + "." + "getInstance" + " prop  " + prop.getName() + "=" + prop.getValue()));
                    if (prop.getName().equals(PROP_LOG_NAME)) {
                        logName = (String)prop.getValue().getValue();
                    } else if (prop.getName().equals(PROP_CREATION_CLASSNAME)) {
                        createClassName = (String)prop.getValue().getValue();
                    } else if (prop.getName().equals(PROP_RECORD_ID)) {
                        recordId = (String)prop.getValue().getValue();
                    }
                    ++i;
                }
            }
            WBEMDebug.trace2((String)(this.getClassName() + "." + "getInstance" + " recordId key is " + recordId));
            WBEMDebug.trace2((String)(this.getClassName() + "." + "getInstance" + " logName is " + logName));
            WBEMDebug.trace2((String)(this.getClassName() + "." + "getInstance" + " creation classname is " + createClassName));
            if (SUBCLASS_MAP.containsKey(createClassName)) {
                CIMInstance ci = StorEdge_6x20LogRecord.getLogRecordInstance(logName, createClassName, recordId, null, (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                if (localOnly) {
                    ci.localElements();
                }
                return ci;
            }
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " (Internal Error) Client attempted to retrieve " + " access point with bad CreationClassName: " + createClassName));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Failure: "), (Throwable)ex);
            if (ex instanceof CIMException) {
                throw (CIMException)((Object)ex);
            }
            throw new CIMException(ex.getMessage());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    protected Vector enumerate(CIMObjectPath op) throws CIMException {
        String METHOD = "enumerate";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " entered"));
        WBEMDebug.trace2((String)(this.getClassName() + "." + "enumerate" + " with op value " + op));
        String creationClassName = op.getObjectName();
        WBEMDebug.trace2((String)(this.getClassName() + "." + "enumerate" + " creation class is " + creationClassName));
        Vector<CIMInstance> v = new Vector<CIMInstance>();
        if (this.getClassName().equals(creationClassName)) {
            return v;
        }
        if (creationClassName == null || !SUBCLASS_MAP.containsKey(creationClassName)) {
            creationClassName = ENGLISH;
        }
        Vector files = StorEdge_6x20MessageLog.getLoggerFiles();
        WBEMDebug.trace2((String)(this.getClassName() + "." + "enumerate" + " creationclass name  is " + creationClassName));
        WBEMDebug.trace2((String)(this.getClassName() + "." + "enumerate" + " locale is " + SUBCLASS_MAP.get(creationClassName)));
        int j = 0;
        while (j < files.size()) {
            String logName = ((File)files.get(j)).getName();
            WBEMDebug.trace2((String)(this.getClassName() + "." + "enumerate" + " logger name is " + logName));
            String[] entries = StorEdge_6x20LogRecord.getTranslatedEntries(logName, (String)SUBCLASS_MAP.get(creationClassName));
            if (entries != null) {
                WBEMDebug.trace2((String)(this.getClassName() + "." + "enumerate" + " there are " + entries.length));
                int i = 0;
                while (i < entries.length) {
                    CIMInstance instance = StorEdge_6x20LogRecord.getLogRecordInstance(logName, creationClassName, new Integer(i).toString(), entries[i], (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                    v.addElement(instance);
                    ++i;
                }
            }
            ++j;
        }
        return v;
    }

    public static String[] getTranslatedEntries(String loggerName, String locale) {
        String METHOD = "getTranslatedEntries";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.getTranslatedEntries entered");
        String[] result = new String[]{};
        try {
            int index = StorEdge_6x20LogRecord.getLoggerIndex(loggerName);
            result = LogAPI.staticTranslate((int)index, (String)locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static int getLoggerIndex(String loggerName) throws NumberFormatException {
        String METHOD = "getLoggerIndex";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.getLoggerIndex entered");
        String indexStr = loggerName.substring("logger".length(), loggerName.length() - ".log".length());
        return Integer.parseInt(indexStr);
    }

    private static String[] parseLogEntry(String content) {
        String METHOD = "parseLogEntry";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.parseLogEntry entered");
        StringTokenizer tokenizer = new StringTokenizer(content, DELIMITER);
        String[] result = new String[tokenizer.countTokens()];
        int numberOfTokens = tokenizer.countTokens();
        int i = 0;
        while (i < numberOfTokens) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    public static Date getTimestamp(String dateString, String localeStr) throws ParseException {
        String METHOD = "getTimestamp";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.getTimestamp entered");
        StringTokenizer tokenizer = new StringTokenizer(dateString, DELIMITER);
        String timeStamp = tokenizer.nextToken();
        Locale locale = new Locale(localeStr);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, locale);
        return dateFormat.parse(timeStamp);
    }

    protected static CIMObjectPath getLogRecordObjectPath(String logName, String creationClassName, String recordId, String content, boolean isEnglish, CIMOMHandle cimomhandle, String nameSpace) throws CIMException {
        String METHOD = "getLogRecordObjectPath";
        WBEMDebug.trace3((String)"StorEdge_6x20LogRecord.getLogRecordObjectPath entered");
        CIMObjectPath cop = new CIMObjectPath(CLASSNAME);
        try {
            cop.setNameSpace(nameSpace);
            Vector<CIMProperty> keys = new Vector<CIMProperty>();
            CIMProperty prop = new CIMProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)CLASSNAME));
            keys.addElement(prop);
            prop = new CIMProperty(PROP_LOG_CREATION_CLASSNAME, new CIMValue((Object)LOG_CREATION_CLASSNAME_VAL));
            keys.addElement(prop);
            if (logName != null && recordId != null && creationClassName != null && SUBCLASS_MAP.containsKey(creationClassName)) {
                prop = new CIMProperty(PROP_LOG_NAME, new CIMValue((Object)logName));
                keys.addElement(prop);
                prop = new CIMProperty(PROP_RECORD_ID, new CIMValue((Object)recordId));
                keys.addElement(prop);
                prop = new CIMProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)creationClassName));
                keys.addElement(prop);
                if (content == null) {
                    WBEMDebug.trace1((String)"StorEdge_6x20LogRecord.getLogRecordObjectPath (Internal Error) Client attempted to retireve  an instance with one or more invalid property.");
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            } else {
                WBEMDebug.trace1((String)"StorEdge_6x20LogRecord.getLogRecordObjectPath (Internal Error) Client attempted to retireve  an instance with one or more invalid property.");
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String[] parts = StorEdge_6x20LogRecord.parseLogEntry(content);
            Date date = null;
            date = isEnglish ? StorEdge_6x20LogRecord.getTimestamp(parts[0], (String)SUBCLASS_MAP.get(ENGLISH)) : StorEdge_6x20LogRecord.getTimestamp(parts[0], (String)SUBCLASS_MAP.get(creationClassName));
            CIMDateTime cimDate = new CIMDateTime(date);
            prop = new CIMProperty(PROP_MESSAGE_TIMESTAMP, new CIMValue((Object)cimDate, new CIMDataType(12)));
            keys.addElement(prop);
            cop.setKeys(keys);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"StorEdge_6x20LogRecord.getLogRecordObjectPath (Internal Error) while retreiving an instance of StorEdge_6x20LogRecord");
            throw new CIMException("CIM_ERR_FAILED");
        }
        return cop;
    }

    static {
        DELIMITER = DELIMITER;
        PROP_LOG_CREATION_CLASSNAME = PROP_LOG_CREATION_CLASSNAME;
        PROP_CREATION_CLASSNAME = PROP_CREATION_CLASSNAME;
        PROP_LOG_NAME = PROP_LOG_NAME;
        PROP_RECORD_ID = PROP_RECORD_ID;
        PROP_MESSAGE_TIMESTAMP = PROP_MESSAGE_TIMESTAMP;
        PROP_DATA_FORMAT = PROP_DATA_FORMAT;
        PROP_RECORD_DATA = PROP_RECORD_DATA;
        PROP_LANGUAGE_ID = PROP_LANGUAGE_ID;
        PROP_LOG_EVENT_TYPE = PROP_LOG_EVENT_TYPE;
        LOG_CREATION_CLASSNAME_VAL = LOG_CREATION_CLASSNAME_VAL;
        DATA_FORMAT_VAL = DATA_FORMAT_VAL;
        SUBCLASS_MAP = new HashMap();
        ENGLISH = ENGLISH;
        GERMAN = GERMAN;
        FRENCH = FRENCH;
        CHINESE = CHINESE;
        JAPANESE = JAPANESE;
        SUBCLASS_MAP.put(ENGLISH, "en");
        SUBCLASS_MAP.put(GERMAN, "de");
        SUBCLASS_MAP.put(FRENCH, "fr");
        SUBCLASS_MAP.put(CHINESE, "zh");
        SUBCLASS_MAP.put(JAPANESE, "ja");
        CLASSNAME = CLASSNAME;
    }
}

