/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.inventory.StorEdge_6120Account;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;

public class ModifyNetworkSettings
extends ModifyModule {
    public static final String CLASSNAME = "ModifyNetworkSettings";

    public ModifyNetworkSettings(ArrayObject system) {
        super(system);
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        WBEMDebug.trace3((String)"ModifyNetworkSettings.handleRequest entered");
        if (request == null) {
            WBEMDebug.trace2((String)"ModifyNetworkSettings.handleRequest Null argument.");
            throw new CIMException("CIM_ERR_FAILED");
        }
        String classname = request.getCIMClassName();
        if (!classname.equalsIgnoreCase("StorEdge_6120RemoteServiceAccessPoint")) {
            WBEMDebug.trace2((String)"ModifyNetworkSettings.handleRequest Class not supported.");
            return false;
        }
        if (!(request instanceof SetRequest)) {
            WBEMDebug.trace2((String)"ModifyNetworkSettings.handleRequest Not supported.");
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
        Properties props = ((SetRequest)request).getProperties();
        String systemName = props.getProperty("SystemName");
        String accessInfo = props.getProperty("AccessInfo");
        Vector<String> postv = new Vector<String>();
        String val = null;
        if (accessInfo != null) {
            postv.add("sysIpAddr=" + accessInfo);
        }
        if ((val = props.getProperty("NetMask")) != null) {
            postv.add("sysSubNet=" + val);
        }
        if ((val = props.getProperty("GatewayAddress")) != null) {
            postv.add("sysGateway=" + val);
        }
        if ((val = props.getProperty("RARPAccess")) != null) {
            postv.add(val.equals("false") ? "sysRarpEnabled=no" : "sysRarpEnabled=yes");
        }
        DevComm.getInstance().post(this.getSystem(), postv, "sysApplySettings");
        try {
            if (postv.size() == 1 && (val = props.getProperty("GatewayAddress")) != null) {
                WBEMDebug.trace3((String)"ModifyNetworkSettings.handleRequest Not resetting as only gateway is changed.");
                RequestBroker.getInstance().invalidateCache(this.getSystem());
                return true;
            }
            WBEMDebug.trace3((String)"ModifyNetworkSettings.handleRequest Performing the reset of the cluster.");
            DevComm.getInstance().post(this.getSystem(), new Vector(0), "sysReset");
        }
        catch (ArrayException ae) {
            WBEMDebug.trace3((String)("ModifyNetworkSettings.handleRequest Caught and swallowed ArrayException: " + ae.getMessage()));
        }
        if (systemName != null && accessInfo != null && !systemName.equals(accessInfo)) {
            WBEMDebug.trace3((String)"ModifyNetworkSettings.handleRequest Changing IP address...");
            this.replaceAccount(systemName, accessInfo);
        } else {
            RequestBroker.getInstance().setClusterOperationalStatus(this.getSystem(), 1, "Rebooting");
        }
        return true;
    }

    public void replaceAccount(String oldIPAddress, String newIPAddress) throws CIMException {
        String METHOD = "replaceAccount";
        CIMOMHandle handle = StorEdge_6120ArrayProvider.getCIMOMHandle();
        if (handle == null) {
            WBEMDebug.trace1((String)"ModifyNetworkSettings.replaceAccount CIMOM handle is null.  Unable to proceed. ");
            throw new CIMException("Internal error: null CIMOM handle.");
        }
        StorEdge_6120Account account = new StorEdge_6120Account();
        CIMInstance oldInstance = account.getAccountInstance(oldIPAddress, handle, "\\root\\se6x20");
        CIMObjectPath oldInstancePath = oldInstance.getObjectPath();
        WBEMDebug.trace3((String)("ModifyNetworkSettings.replaceAccount Old Account instance path: " + oldInstancePath));
        account.deleteInstance(oldInstancePath);
        CIMValue password = oldInstance.getProperty("UserPassword").getValue();
        CIMValue persist = oldInstance.getProperty("PersistPassword").getValue();
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120Account");
        cop.setNameSpace("\\root\\se6x20");
        CIMClass cimClass = handle.getClass(cop, false, false, false, null);
        CIMInstance cimInstance = cimClass.newInstance();
        cimInstance.setProperty("Name", new CIMValue((Object)newIPAddress));
        cimInstance.setProperty("UserPassword", password);
        cimInstance.setProperty("PersistPassword", persist);
        cimInstance.setProperty("Status", new CIMValue((Object)"Starting"));
        handle.createInstance(cop, cimInstance);
        WBEMDebug.trace3((String)"ModifyNetworkSettings.replaceAccountNew Account created.");
    }

    public void shutdown() {
    }

    static {
        CLASSNAME = CLASSNAME;
    }
}

