/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.CreateRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DeleteRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.se6120.internal.InstanceFormer;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyConfigService;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.SetRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdge_6120ArrayProvider;
import com.sun.netstorage.array.mgmt.se6120.internal.Uploader;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ModifyJobs
extends ModifyModule {
    private static final int MAX_STALL_COUNT = 120;
    String[] classes = new String[]{"StorEdge_6120ConcreteJob", "StorEdge_6120CreateStoragePoolJob", "StorEdge_6120CreateStorageVolumeJob", "StorEdge_6120CreateMappedStorageVolumeJob", "StorEdge_6120DeleteStoragePoolJob", "StorEdge_6120InitializeStoragePoolJob", "StorEdge_6120DeleteStorageVolumeJob"};
    private static final String CLASSNAME = "ModifyJobs";
    private static final String FILENAME = "volInfoFile";
    private static final String PROPS = "/opt/se6x20/resources/StorEdge_6120.properties";
    private static final String T4_VOL_INFO_FILE = "/opt/se6x20/t4files/volinfo.htm";
    private static String T4FILENAME;
    private static CIMObjectPath staticclassop;
    private CIMClass cimJob = null;
    private CIMClass cimJobConfigAssoc = null;
    private CIMClass poolclass = null;
    private CIMObjectPath configService = null;
    private CIMObjectPath classop = null;
    private CIMObjectPath poolcop = null;
    private static CIMClass createPoolClass;
    private static CIMClass createVolumeClass;
    private static CIMClass createMappedVolumeClass;
    private static CIMClass deletePoolClass;
    private static CIMClass deleteVolumeClass;
    private static CIMClass initializePoolClass;
    private int jobcounter = 1;
    private HashMap jobs = new HashMap();
    private ArrayList waitq = new ArrayList();
    private Job activejob = null;
    private String sysId = null;
    private JobThread jobthread = null;
    private boolean initialized = false;

    public static ModifyJobs getInstance(String hostname) {
        return (ModifyJobs)ModifyBroker.getInstance().getModule(hostname, CLASSNAME);
    }

    public static void update(String hostname) throws CIMException {
        CIMInstance[] disjobs;
        WBEMDebug.trace3((String)("ModifyJobs: in ModifyJob.update() with hostname=" + hostname));
        if (staticclassop == null) {
            staticclassop = new CIMObjectPath("StorEdge_6120ConcreteJob");
            staticclassop.setNameSpace("\\root\\se6x20");
        }
        if ((disjobs = RequestBroker.getInstance().enumerateInstances(staticclassop, false, true, true, null, null)) == null) {
            WBEMDebug.trace3((String)"ModifyJobs: Discovery returned no jobs.");
            return;
        }
        WBEMDebug.trace3((String)("ModifyJobs: Discovery returned " + disjobs.length + " jobs."));
        int i = 0;
        while (i < disjobs.length) {
            if (RequestBroker.getInstance().isSyntheticCacheInstance(disjobs[i].getObjectPath())) {
                WBEMDebug.trace3((String)"ModifyJobs: is user job");
            } else {
                WBEMDebug.trace3((String)"ModifyJobs: is retrieved job");
                RequestBroker.getInstance().deleteInstance(disjobs[i].getObjectPath());
            }
            ++i;
        }
        WBEMDebug.trace3((String)"ModifyJobs: returning from ModifyJob.update() ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void update() {
        block29: {
            disjobs = null;
            inStream = null;
            try {
                inStream = DevComm.getInstance().get(this.getSystem(), ModifyJobs.T4FILENAME);
                disjobs = (ArrayList)InstanceFormer.parseXml(inStream);
                var6_3 = null;
                ** if (inStream == null) goto lbl-1000
            }
            catch (Throwable var5_13) {
                var6_4 = null;
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                throw var5_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    inStream.close();
                }
                catch (IOException ignore) {}
            }
lbl-1000:
            // 2 sources

            {
                break block29;
                catch (StorEdgeIOException ioex) {
                    WBEMDebug.trace1((String)("ModifyJobs: StorEdgeIOException" + ioex.getMessage()), (Throwable)ioex);
                    if (ioex.getType() == 1 && this.getSystem().permitUpload()) {
                        try {
                            file = new FileInputStream("/opt/se6x20/t4files/volinfo.htm");
                            if (file != null) {
                                Uploader.upload(this.getSystem(), file, ModifyJobs.T4FILENAME);
                                disjobs = (ArrayList)InstanceFormer.parseXml(DevComm.getInstance().get(this.getSystem(), ModifyJobs.T4FILENAME));
                            } else {
                                WBEMDebug.trace1((String)"Unable to find volinfo file to upload.");
                            }
                        }
                        catch (Exception ex) {
                            WBEMDebug.trace1((String)("ModifyJobs: ERROR: Uploading " + ModifyJobs.T4FILENAME), (Throwable)ex);
                        }
                    }
                    var6_3 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                    break block29;
                }
                catch (Exception ex) {
                    WBEMDebug.trace1((String)("ModifyJobs: ERROR: Error retrieving " + ModifyJobs.T4FILENAME));
                    var6_3 = null;
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
        }
        if (disjobs == null) {
            WBEMDebug.trace3((String)"ModifyJobs: ERROR: Discovery returned no jobs.");
            return;
        }
        WBEMDebug.trace3((String)("ModifyJobs: num of Jobs = " + disjobs.size()));
        updated = false;
        i = 0;
        while (i < disjobs.size()) {
            disjob = (CIMInstance)disjobs.get(i);
            WBEMDebug.trace3((String)("ModifyJobs: " + i + disjob.getObjectPath()));
            instanceId = (String)disjob.getProperty("InstanceID").getValue().getValue();
            if (this.activejob != null && (this.activejob.type.equalsIgnoreCase("createPool") || this.activejob.type.equalsIgnoreCase("initializePool")) && this.activejob.jobStatus.equalsIgnoreCase("initializing") && this.compareIds(this.activejob.instanceId, instanceId)) {
                WBEMDebug.trace3((String)"ModifyJobs: is active job");
                this.activejob.percentComplete = ((UnsignedInt16)disjob.getProperty("PercentComplete").getValue().getValue()).intValue();
                desc = (String)disjob.getProperty("Description").getValue().getValue();
                this.activejob.volWWN = desc.substring(0, desc.indexOf(58));
                WBEMDebug.trace3((String)("ModifyJobs: volWWN:volStatus:volOper = " + desc));
                desc = desc.substring(desc.indexOf(58) + 1, desc.length());
                volstatus = desc.substring(0, desc.indexOf(58));
                running = true;
                if (desc.indexOf(58) == desc.length() - 1 && this.jobthread.initstarted) {
                    running = false;
                }
                if (desc.indexOf(58) != desc.length() - 1) {
                    this.jobthread.initstarted = true;
                }
                this.activejob.elapsedTime = System.currentTimeMillis();
                WBEMDebug.trace3((String)("ModifyJobs: running=" + running));
                WBEMDebug.trace3((String)("ModifyJobs: volOperProgress=" + this.activejob.percentComplete));
                WBEMDebug.trace3((String)("ModifyJobs: status=" + this.activejob.jobStatus));
                if (this.jobthread.initstarted || this.activejob.elapsedTime - this.jobthread.initstarttime > 600000L) {
                    this.jobthread.initstarted = true;
                }
                if (!running || this.activejob.percentComplete == 100) {
                    if (volstatus.equalsIgnoreCase("unmounted")) {
                        this.activejob.jobStatus = "initialized";
                    } else {
                        this.activejob.jobStatus = volstatus;
                        this.activejob.status = "Error";
                    }
                }
                RequestBroker.getInstance().addSyntheticCacheInstance(this.activejob.getInstance());
                updated = true;
                return;
            }
            ++i;
        }
        if (!updated && this.activejob != null && !this.activejob.deleted && this.jobthread.initstarted && this.activejob.jobStatus.equalsIgnoreCase("initializing") && (this.activejob.type.equalsIgnoreCase("createPool") || this.activejob.type.equalsIgnoreCase("initializePool"))) {
            WBEMDebug.trace3((String)"ModifyJobs: Aborting Pool activejob");
            this.activejob.status = "Error";
            this.jobthread.trigger();
        }
    }

    private void initSynCache() {
        try {
            CIMInstance[] disjobs;
            this.initialized = true;
            if (this.classop == null) {
                this.classop = new CIMObjectPath("StorEdge_6120ConcreteJob");
                this.classop.setNameSpace("\\root\\se6x20");
            }
            if (this.cimJob == null) {
                this.cimJob = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(this.classop, false, true, true, null);
            }
            if ((disjobs = RequestBroker.getInstance().enumerateInstances(this.getSystem(), this.classop, false, true, true, null, this.cimJob)) == null || disjobs.length == 0) {
                return;
            }
            int i = 0;
            while (i < disjobs.length) {
                if (!RequestBroker.getInstance().isSyntheticCacheInstance(disjobs[i].getObjectPath())) {
                    String instanceId = (String)disjobs[i].getProperty("InstanceID").getValue().getValue();
                    int perComp = ((UnsignedInt16)disjobs[i].getProperty("PercentComplete").getValue().getValue()).intValue();
                    if (perComp < 100 && perComp > 0) {
                        this.activejob = new Job();
                        this.activejob.type = "createPool";
                        this.activejob.instanceId = instanceId;
                        this.activejob.counter = 0;
                        this.activejob.startTime = System.currentTimeMillis();
                        String desc = (String)disjobs[i].getProperty("Description").getValue().getValue();
                        this.activejob.volWWN = desc.substring(0, desc.indexOf(58));
                        Vector<String> postv = new Vector<String>();
                        int col1 = instanceId.indexOf(58);
                        int col2 = instanceId.indexOf(58, col1 + 1);
                        int col3 = instanceId.indexOf(58, col2 + 1);
                        postv.add("unitIndex=" + instanceId.substring(col1 + 1, col2));
                        postv.add("volIndex=" + instanceId.substring(col2 + 1, col3));
                        this.activejob.postIndex = postv;
                        boolean running = true;
                        if (desc.indexOf(58) == desc.length() - 1) {
                            running = false;
                        }
                        if (!running) {
                            this.activejob.status = "Error";
                            this.activejob = null;
                            return;
                        }
                        this.activejob.status = "OK";
                        this.jobs.put(this.activejob.instanceId + this.activejob.counter, this.activejob);
                        this.activejob.percentComplete = perComp;
                        this.activejob.jobStatus = (String)disjobs[i].getProperty("JobStatus").getValue().getValue();
                        RequestBroker.getInstance().addSyntheticCacheInstance(this.activejob.getInstance());
                        RequestBroker.getInstance().addSyntheticCacheInstance(this.activejob.getConfigAssocInstance());
                        if (this.waitq.size() == 0) {
                            this.waitq.add(0, this.activejob);
                            if (this.jobthread.isAlive()) {
                                this.jobthread.trigger();
                            }
                        }
                    }
                    RequestBroker.getInstance().deleteInstance(disjobs[i].getObjectPath());
                }
                ++i;
            }
        }
        catch (CIMException cex) {
            WBEMDebug.trace3((String)("ModifyJobs: Error adding active job:" + (Object)((Object)cex)));
        }
    }

    public ModifyJobs(ArrayObject t4) throws Exception {
        super(t4);
        try {
            FileInputStream propStream = new FileInputStream(PROPS);
            Properties props = new Properties();
            props.load(propStream);
            T4FILENAME = props.getProperty(FILENAME);
            WBEMDebug.trace3((String)("ModifyJobs: fileName = " + T4FILENAME));
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"ModifyJobs: Unable to load properties!", (Throwable)e);
        }
        this.sysId = this.getSystem().getHost();
        this.jobcounter = 1;
        this.jobthread = new JobThread();
        this.jobthread.setName("StorEdge JobThread " + this.getSystem().getHost());
        this.jobthread.setDaemon(true);
        this.jobthread.start();
    }

    public void shutdown() {
        WBEMDebug.trace1((String)("ModifyJobs: Shutting down jobs module " + this));
        this.jobthread.exist = false;
        this.waitq = null;
        if (this.activejob != null && !this.activejob.deleted) {
            this.jobthread.abort();
        }
        Iterator keys = this.jobs.keySet().iterator();
        WBEMDebug.trace1((String)("ModifyJobs: Cleaning up " + this.jobs.size() + " jobs for array " + this.getSystem().getHost()));
        while (keys.hasNext()) {
            Job job = (Job)this.jobs.get(keys.next());
            try {
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getConfigAssocInstance().getObjectPath());
            }
            catch (CIMException ex) {
                WBEMDebug.trace1((String)"ModifyJobs: Exception in shutdown", (Throwable)ex);
            }
        }
        this.jobs = null;
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException {
        WBEMDebug.trace3((String)"ModifyJobs: entered handleRequest");
        boolean validClass = false;
        String classname = request.getCIMClassName();
        int arrind = 0;
        while (arrind < this.classes.length) {
            if (classname.equalsIgnoreCase(this.classes[arrind])) {
                validClass = true;
            }
            ++arrind;
        }
        if (!validClass) {
            return false;
        }
        if (request instanceof SetRequest) {
            Properties props = ((SetRequest)request).getProperties();
            Job job = (Job)this.jobs.get(props.getProperty("InstanceID"));
            if (job == null) {
                return true;
            }
            if (props.getProperty("Description") != null) {
                job.description = props.getProperty("Description");
            }
            if (props.getProperty("Name") != null) {
                job.name = props.getProperty("Name");
            }
            if (props.getProperty("Notify") != null) {
                if (job.status.equalsIgnoreCase("Completed") || job.status.equalsIgnoreCase("Aborted") || job.status.equalsIgnoreCase("Error")) {
                    throw new CIMException("CIM_ERR_NOT_SUPPORTED");
                }
                job.notify = props.getProperty("Notify");
            }
            if (props.getProperty("DeleteOnCompletion") != null) {
                job.deleteOnCompletion = Boolean.getBoolean(props.getProperty("DeleteOnCompletion"));
            }
            RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
        } else {
            if (request instanceof CreateRequest) {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
            if (request instanceof DeleteRequest) {
                Job job = null;
                Vector props = request.getObjectPath().getKeys();
                int i = 0;
                while (i < props.size()) {
                    if (((CIMProperty)props.elementAt(i)).getName().equals("InstanceID")) {
                        job = (Job)this.jobs.get((String)((CIMProperty)props.elementAt(i)).getValue().getValue());
                    }
                    ++i;
                }
                if (job == null) {
                    return true;
                }
                if (job == this.activejob) {
                    this.jobthread.abort();
                }
                job.deleted = true;
                this.jobs.remove(job.instanceId + job.counter);
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
                RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getConfigAssocInstance().getObjectPath());
            } else if (request instanceof InvokeRequest) {
                if (!((InvokeRequest)request).getMethodName().equalsIgnoreCase("killJob")) {
                    throw new CIMException("CIM_ERR_NOT_SUPPORTED");
                }
                Job job = null;
                Vector props = request.getObjectPath().getKeys();
                int i = 0;
                while (i < props.size()) {
                    if (((CIMProperty)props.elementAt(i)).getName().equalsIgnoreCase("InstanceID")) {
                        job = (Job)this.jobs.get((String)((CIMProperty)props.elementAt(i)).getValue().getValue());
                    }
                    ++i;
                }
                if (job == null) {
                    return true;
                }
                String[] args = new String[]{job.instanceId + job.counter};
                if (job.status.equalsIgnoreCase("Dormant")) {
                    job.deleted = true;
                    job.status = "Aborted";
                    job.jobStatus = "Aborted";
                    RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
                    LogAPI.staticLog((String)"ARRAY_JOB_TERMINATION", (String[])args, (String[])job.getNotifyList());
                } else {
                    if (job.status.equalsIgnoreCase("Complete")) {
                        return true;
                    }
                    if (job.status.equalsIgnoreCase("Aborted")) {
                        return true;
                    }
                    if (job.status.equalsIgnoreCase("Error")) {
                        return true;
                    }
                    if (job.status.equalsIgnoreCase("OK")) {
                        if (!job.type.equalsIgnoreCase("createPool") && !job.type.equalsIgnoreCase("initializePool")) {
                            WBEMDebug.trace3((String)("ModifyJobs: Abort failure on " + job.type + " for " + job.instanceId + job.counter));
                            CIMException cimex = new CIMException("CIM_ERR_NOT_SUPPORTED");
                            cimex.setDescription("This Operation cannot be aborted while running");
                            throw cimex;
                        }
                        this.jobthread.abort();
                        RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
                        LogAPI.staticLog((String)"ARRAY_JOB_TERMINATION", (String[])args, (String[])job.getNotifyList());
                    } else {
                        WBEMDebug.trace3((String)"ModifyJobs: Job.Status undefined");
                    }
                }
                if (job.deleteOnCompletion) {
                    this.jobs.remove(job.instanceId + job.counter);
                    RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
                    RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getConfigAssocInstance().getObjectPath());
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
        }
        return true;
    }

    public CIMObjectPath createJob(String jobType, Vector postArgs) {
        return this.createJob(jobType, postArgs, null);
    }

    public CIMObjectPath createJob(String jobType, Vector postArgs, String[] telcmd) {
        return this.createJob(jobType, postArgs, telcmd, null);
    }

    public CIMObjectPath createJob(String jobType, Vector postArgs, String[] telcmd, String jobDescription) {
        WBEMDebug.trace3((String)("ModifyJobs: createJob " + jobType + postArgs));
        String unitId = this.rhsValue((String)postArgs.elementAt(0));
        String volId = this.rhsValue((String)postArgs.elementAt(1));
        Job job = new Job();
        WBEMDebug.trace3((String)"ModifyJobs: past element 1 & 2");
        job.type = jobType;
        job.postArgs = postArgs;
        job.telnetcmd = telcmd;
        Vector<String> postv = new Vector<String>();
        postv.add("unitIndex=" + unitId);
        postv.add("volIndex=" + volId);
        job.postIndex = postv;
        job.description = jobDescription;
        job.counter = this.jobcounter++;
        job.status = "Dormant";
        job.jobStatus = "Queued";
        job.timeSubmitted = Calendar.getInstance().getTime();
        this.jobcounter %= 1000000000;
        if (job.type.equalsIgnoreCase("createPool")) {
            job.storagePoolName = this.rhsValue((String)postArgs.elementAt(2));
            job.storagePoolExtents = (Vector)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
        } else if (job.type.equalsIgnoreCase("createVolume")) {
            job.storageVolumeName = this.rhsValue((String)postArgs.elementAt(3));
            job.storageVolumeSize = (UnsignedInt64)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storagePoolName = (String)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
        } else if (job.type.equalsIgnoreCase("createMappedVolume")) {
            WBEMDebug.trace3((String)"Creating mapped volume");
            job.storageVolumeName = this.rhsValue((String)postArgs.elementAt(3));
            job.storageVolumeSize = (UnsignedInt64)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            job.storagePoolName = (String)postArgs.elementAt(postArgs.size() - 1);
            postArgs.remove(postArgs.size() - 1);
            if (postArgs.elementAt(postArgs.size() - 1) != null) {
                job.accessMode = (UnsignedInt16)postArgs.elementAt(postArgs.size() - 1);
            }
            if (postArgs.elementAt(postArgs.size() - 2) != null) {
                job.deviceNumber = (UnsignedInt16)postArgs.elementAt(postArgs.size() - 2);
            }
        } else if (job.type.equalsIgnoreCase("initializePool")) {
            job.storagePoolName = this.rhsValue((String)postArgs.elementAt(2));
        } else if (job.type.equalsIgnoreCase("deletePool")) {
            job.storagePoolName = this.rhsValue((String)postArgs.elementAt(2));
        } else if (job.type.equalsIgnoreCase("deleteVolume")) {
            job.storageVolumeName = this.rhsValue((String)postArgs.elementAt(2));
        } else {
            WBEMDebug.trace1((String)("ModifyJobs: Unknown job type " + job.type));
        }
        job.instanceId = new String(this.getSystem().getHost() + ":" + unitId + ":" + job.storagePoolName + ":");
        try {
            RequestBroker.getInstance().addSyntheticCacheInstance(job.getInstance());
            RequestBroker.getInstance().addSyntheticCacheInstance(job.getConfigAssocInstance());
        }
        catch (CIMException ce) {
            WBEMDebug.trace1((String)"ModifyJobs: Error in adding synthetic cache instances");
            RequestBroker.getInstance().deleteSyntheticCacheInstance(job.getInstance().getObjectPath());
            return null;
        }
        this.jobs.put(job.instanceId + job.counter, job);
        this.waitq.add(0, job);
        if (!this.jobthread.isAlive()) {
            WBEMDebug.trace3((String)"ModifyJobs: jobthread created");
            this.jobthread = new JobThread();
            this.jobthread.start();
        } else if (!this.jobthread.isalive) {
            this.jobthread.trigger();
        }
        return job.getInstance().getObjectPath();
    }

    private String rhsValue(String str) {
        if (str == null) {
            return null;
        }
        int eq = str.indexOf(61);
        return str.substring(eq + 1);
    }

    private boolean compareIds(String hostn, String sysn) {
        WBEMDebug.trace3((String)("ModifyJobs: compareIds arg1=" + hostn + " arg2=" + sysn));
        return sysn.equalsIgnoreCase(hostn);
    }

    public static String getHostname(CIMObjectPath jobop) {
        Vector keys = jobop.getKeys();
        int i = 0;
        while (i < keys.size()) {
            if (((CIMProperty)keys.elementAt(i)).getName().equalsIgnoreCase("InstanceID")) {
                return ModifyJobs.getHostname((String)((CIMProperty)keys.elementAt(i)).getValue().getValue());
            }
            ++i;
        }
        return null;
    }

    public static String getHostname(String instanceid) {
        if (instanceid == null) {
            return null;
        }
        return instanceid.substring(0, instanceid.indexOf(58));
    }

    static {
        MAX_STALL_COUNT = 120;
        CLASSNAME = CLASSNAME;
        FILENAME = FILENAME;
        PROPS = PROPS;
        T4_VOL_INFO_FILE = T4_VOL_INFO_FILE;
        T4FILENAME = "volinfo.htm";
        staticclassop = null;
        createPoolClass = null;
        createVolumeClass = null;
        createMappedVolumeClass = null;
        deletePoolClass = null;
        deleteVolumeClass = null;
        initializePoolClass = null;
    }

    private class JobThread
    extends Thread {
        private boolean waiting = false;
        private boolean stopped = false;
        private boolean isalive = false;
        private boolean exist = true;
        public boolean initstarted = false;
        public long initstarttime = 0L;

        private JobThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.exist) {
                WBEMDebug.trace3((String)"*JobThread* started ");
                this.isalive = true;
                while (ModifyJobs.this.waitq != null && ModifyJobs.this.waitq.size() > 0) {
                    block52: {
                        this.waiting = false;
                        WBEMDebug.trace3((String)"*JobThread* next job ");
                        try {
                            if (ModifyJobs.this.activejob != null) {
                                if (!((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("OK")) {
                                    if (((ModifyJobs)ModifyJobs.this).activejob.deleteOnCompletion) {
                                        ModifyJobs.this.jobs.remove(((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter);
                                        RequestBroker.getInstance().deleteSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance().getObjectPath());
                                        RequestBroker.getInstance().deleteSyntheticCacheInstance(ModifyJobs.this.activejob.getConfigAssocInstance().getObjectPath());
                                    } else {
                                        RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                    }
                                    ModifyJobs.this.activejob = null;
                                } else {
                                    try {
                                        ((ModifyJobs)ModifyJobs.this).activejob.deleted = true;
                                        if (!((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createPool")) {
                                            ((ModifyJobs)ModifyJobs.this).activejob.status = "Error";
                                            throw new Exception("Not a CreatePool job");
                                        }
                                        ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "initializing";
                                        JobThread jobThread = this;
                                        synchronized (jobThread) {
                                            this.waiting = true;
                                            int i = 0;
                                            while (i < 80) {
                                                this.wait(120000L);
                                                RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
                                                if (!((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("OK") || !((ModifyJobs)ModifyJobs.this).activejob.jobStatus.equalsIgnoreCase("initializing")) break;
                                                ++i;
                                            }
                                            this.waiting = false;
                                        }
                                        if (((ModifyJobs)ModifyJobs.this).activejob.jobStatus.equalsIgnoreCase("initialized")) {
                                            DevComm.getInstance().post(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.postIndex, "volMount");
                                            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Mounted";
                                        }
                                    }
                                    catch (InterruptedException iex) {
                                        WBEMDebug.trace1((String)ModifyJobs.CLASSNAME, (Throwable)iex);
                                        this.waiting = false;
                                        ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                                        ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Aborted";
                                        this.cleanup(((ModifyJobs)ModifyJobs.this).activejob.postIndex);
                                    }
                                    if (((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("OK")) {
                                        ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                                    }
                                    if (!((ModifyJobs)ModifyJobs.this).activejob.deleted) {
                                        RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                    }
                                }
                            }
                            try {
                                while (ModifyJobs.this.waitq.size() > 0 && (ModifyJobs.this.activejob == null || ((ModifyJobs)ModifyJobs.this).activejob.deleted)) {
                                    ModifyJobs.this.activejob = (Job)ModifyJobs.this.waitq.get(ModifyJobs.this.waitq.size() - 1);
                                    ModifyJobs.this.waitq.remove(ModifyJobs.this.waitq.size() - 1);
                                    if (!((ModifyJobs)ModifyJobs.this).activejob.deleted) continue;
                                    ModifyJobs.this.activejob = null;
                                }
                                if (ModifyJobs.this.activejob == null) {
                                    WBEMDebug.trace3((String)"*JobThread* breaking out of loop ");
                                    break;
                                }
                                WBEMDebug.trace3((String)("*JobThread* job=" + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
                                ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
                                if (!((ModifyJobs)ModifyJobs.this).activejob.deleted) {
                                    RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                                }
                                if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createPool")) {
                                    this.createVol();
                                } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("deletePool")) {
                                    this.deleteVol();
                                } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("initializePool")) {
                                    this.initializeVol();
                                } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createVolume")) {
                                    this.createSlice();
                                } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createMappedVolume")) {
                                    this.createMappedSlice();
                                } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("deleteVolume")) {
                                    this.deleteSlice();
                                }
                            }
                            catch (Exception ex) {
                                WBEMDebug.trace1((String)("*JobThread* Exception:" + ex));
                                WBEMDebug.trace1((String)ModifyJobs.CLASSNAME, (Throwable)ex);
                                ((ModifyJobs)ModifyJobs.this).activejob.status = "Error";
                                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Error";
                                ((ModifyJobs)ModifyJobs.this).activejob.errorDescription = ex.getMessage();
                                ((ModifyJobs)ModifyJobs.this).activejob.errorCode = 1;
                                ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
                                try {
                                    if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createPool")) {
                                        LogAPI.staticLog((String)"POOL_CREATE_ERROR", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("initializePool")) {
                                        LogAPI.staticLog((String)"POOL_INITIALIZE_ERROR", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("deletePool")) {
                                        LogAPI.staticLog((String)"POOL_DELETE_ERROR", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createVolume") || ((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("createMappedVolume")) {
                                        LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    } else if (((ModifyJobs)ModifyJobs.this).activejob.type.equalsIgnoreCase("deleteVolume")) {
                                        LogAPI.staticLog((String)"VOLUME_DELETE_ERROR", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (Exception exc) {
                            WBEMDebug.trace1((String)("*JobThread* Main Loop Exception: " + exc));
                            WBEMDebug.trace1((String)ModifyJobs.CLASSNAME, (Throwable)exc);
                            if (!((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("OK")) break block52;
                            ((ModifyJobs)ModifyJobs.this).activejob.status = "Error";
                        }
                    }
                    RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
                    if (!((ModifyJobs)ModifyJobs.this).activejob.deleted) {
                        RequestBroker.getInstance().addSyntheticCacheInstance(ModifyJobs.this.activejob.getInstance());
                    }
                    if (((ModifyJobs)ModifyJobs.this).activejob.deleteOnCompletion) continue;
                    ModifyJobs.this.activejob = null;
                }
                WBEMDebug.trace3((String)"*JobThread* Terminating as no more jobs.");
                try {
                    JobThread exc = this;
                    synchronized (exc) {
                        this.isalive = false;
                        this.wait(3600000L);
                        this.isalive = true;
                    }
                }
                catch (InterruptedException iex) {
                    this.isalive = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createVol() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* createVol for " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = false;
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Started";
            ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
            ((ModifyJobs)ModifyJobs.this).activejob.startTime = System.currentTimeMillis();
            int sep1 = ((ModifyJobs)ModifyJobs.this).activejob.instanceId.lastIndexOf(58);
            int sep2 = ((ModifyJobs)ModifyJobs.this).activejob.instanceId.lastIndexOf(58, sep1 - 1);
            int sep3 = ((ModifyJobs)ModifyJobs.this).activejob.instanceId.lastIndexOf(58, sep2 - 1);
            if (sep3 < 0) {
                WBEMDebug.trace3((String)"*JobThread* ModifyJobs: instanceId malformed");
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Error";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Error";
                ((ModifyJobs)ModifyJobs.this).activejob.errorDescription = "Malformed instanceId";
                return;
            }
            String unitId = ((ModifyJobs)ModifyJobs.this).activejob.instanceId.substring(sep3 + 1, sep2);
            String volId = ((ModifyJobs)ModifyJobs.this).activejob.instanceId.substring(sep2 + 1, sep1);
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 0;
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Creating";
                try {
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[3], 2);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[0]);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[3]);
                    throw throwable;
                }
                ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[3]);
                {
                }
            }
            RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
            if (ModifyJobs.this.poolcop == null) {
                ModifyJobs.this.poolcop = new CIMObjectPath("StorEdge_6120StoragePool");
                ModifyJobs.this.poolcop.setNameSpace("\\root\\se6x20");
                ModifyJobs.this.poolclass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(ModifyJobs.this.poolcop, false, true, true, null);
            }
            CIMInstance[] pools = null;
            pools = RequestBroker.getInstance().enumerateInstances(ModifyJobs.this.getSystem(), ModifyJobs.this.poolcop, false, true, true, null, ModifyJobs.this.poolclass);
            String poolname = null;
            if (pools == null) {
                throw new Exception("Pool Creation Failed. Discovery didnot find" + (String)((ModifyJobs)ModifyJobs.this).activejob.postArgs.elementAt(2));
            }
            int i = 0;
            while (i < pools.length) {
                WBEMDebug.trace3((String)("pool[" + i + "]=" + pools[i]));
                poolname = (String)pools[i].getProperty("ElementName").getValue().getValue();
                if (poolname.equalsIgnoreCase(ModifyJobs.this.rhsValue((String)((ModifyJobs)ModifyJobs.this).activejob.postArgs.elementAt(2)))) {
                    String poolid = (String)pools[i].getProperty("PoolID").getValue().getValue();
                    WBEMDebug.trace3((String)("*JobThread* poolid=" + poolid + " old postIndex=" + ((ModifyJobs)ModifyJobs.this).activejob.postIndex));
                    ((ModifyJobs)ModifyJobs.this).activejob.postIndex.set(0, "unitIndex=" + poolid.substring(poolid.indexOf(117) + 1, poolid.indexOf(118)));
                    ((ModifyJobs)ModifyJobs.this).activejob.postIndex.set(1, "volIndex=" + poolid.substring(poolid.indexOf(118) + 1));
                    WBEMDebug.trace3((String)("*JobThread* pool postIndex=" + ((ModifyJobs)ModifyJobs.this).activejob.postIndex));
                    break;
                }
                ++i;
            }
            if (i == pools.length) {
                throw new Exception("Pool Creation Failed. Discovery didnot find" + (String)((ModifyJobs)ModifyJobs.this).activejob.postArgs.elementAt(2));
            }
            if (!this.stopped) {
                DevComm.getInstance().post(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.postIndex, "volInit");
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Initializing";
            }
            this.initstarted = false;
            this.initstarttime = System.currentTimeMillis();
            this.jobWait();
            if (((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("Error")) {
                throw new Exception("Error in initializing StoragePool");
            }
            if (((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("Aborted")) {
                this.stopped = true;
            }
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Mounting";
                try {
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[3], 4);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2]);
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[3]);
                    throw throwable;
                }
                ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[3]);
                ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 100;
            }
            ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"POOL_CREATE_ABORT", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Completed";
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                LogAPI.staticLog((String)"POOL_CREATE", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* createVol end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            Thread.yield();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeVol() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* initializeVol " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = false;
            ((ModifyJobs)ModifyJobs.this).activejob.startTime = System.currentTimeMillis();
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Started";
            ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
            if (!this.stopped) {
                DevComm.getInstance().post(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.postIndex, "volInit");
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Initializing";
            }
            this.initstarted = false;
            this.initstarttime = System.currentTimeMillis();
            this.jobWait();
            if (((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("Error")) {
                throw new Exception("Error in initializing StoragePool");
            }
            if (((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("Aborted")) {
                this.stopped = true;
            }
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Mounting";
                WBEMDebug.trace3((String)("*JobThread* mounting initialized Vol " + ((ModifyJobs)ModifyJobs.this).activejob.postIndex));
                try {
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2], 4);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1]);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2]);
                    throw throwable;
                }
                ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2]);
                ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 100;
            }
            ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"POOL_INITIALIZE_ABORT", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Completed";
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                LogAPI.staticLog((String)"POOL_INITIALIZE", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* initializeVol end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            Thread.yield();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteVol() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* deleteVol " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = false;
            ((ModifyJobs)ModifyJobs.this).activejob.startTime = System.currentTimeMillis();
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Started";
            ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 0;
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Deleting";
                try {
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2], 5);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[0]);
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2]);
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2], 3);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1]);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2]);
                    throw throwable;
                }
                ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[2]);
                {
                }
            }
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 100;
            ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"POOL_DELETE_ABORT", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Completed";
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                LogAPI.staticLog((String)"POOL_DELETE", (String[])ModifyJobs.this.activejob.getVolLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* deleteVol end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            Thread.yield();
        }

        private void createMappedSlice() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* createMappedSli " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = false;
            ((ModifyJobs)ModifyJobs.this).activejob.startTime = System.currentTimeMillis();
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Started";
            ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 0;
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Deleting";
                DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[0]);
            }
            RequestBroker.getInstance().invalidateCache(ModifyJobs.this.getSystem());
            CIMObjectPath volOp = new CIMObjectPath("StorEdge_6120StorageVolume");
            volOp.setNameSpace("\\root\\se6x20");
            CIMInstance[] vols = RequestBroker.getInstance().enumerateInstances(ModifyJobs.this.getSystem(), volOp, false, true, false, null, null);
            CIMInstance ourVol = null;
            int i = 0;
            while (vols != null && i < vols.length) {
                String instName = (String)((Vector)vols[i].getProperty("OtherIdentifyingInfo").getValue().getValue()).get(0);
                if (instName.equals(((ModifyJobs)ModifyJobs.this).activejob.storageVolumeName)) {
                    ourVol = vols[i];
                    break;
                }
                ++i;
            }
            if (ourVol == null) {
                WBEMDebug.trace1((String)("Could not find instance of StorageVolume that we are looking for, " + ((ModifyJobs)ModifyJobs.this).activejob.storageVolumeName));
                CIMException ce = new CIMException("CIM_ERR_NOT_FOUND");
                ce.setDescription("StorageVolume " + ((ModifyJobs)ModifyJobs.this).activejob.storageVolumeName + " was not found");
                throw ce;
            }
            CIMInstance newVol = ourVol.filterProperties(null, true, true);
            if (((ModifyJobs)ModifyJobs.this).activejob.postArgs.get(5) != null) {
                newVol.setProperty("DeviceNumber", new CIMValue((Object)((UnsignedInt16)((ModifyJobs)ModifyJobs.this).activejob.postArgs.get(5)).toString()));
            }
            if (((ModifyJobs)ModifyJobs.this).activejob.postArgs.get(6) != null) {
                String defAccess = ((UnsignedInt16)((ModifyJobs)ModifyJobs.this).activejob.postArgs.get(6)).toString();
                if (defAccess.equals("2")) {
                    defAccess = "None";
                } else if (defAccess.equals("3")) {
                    defAccess = "Read/Write";
                } else if (defAccess.equals("4")) {
                    defAccess = "Read-only";
                }
                Vector<String> defVector = new Vector<String>();
                defVector.add(defAccess);
                newVol.setProperty("AccessType", new CIMValue(defVector));
            }
            ModifyBroker.getInstance().setInstance(newVol.getObjectPath(), newVol, true, null);
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 100;
            ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"VOLUME_CREATE_ABORT", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Completed";
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                LogAPI.staticLog((String)"VOLUME_CREATE", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* createMappedSli end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            Thread.yield();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSlice() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* createSli " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = false;
            ((ModifyJobs)ModifyJobs.this).activejob.startTime = System.currentTimeMillis();
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Started";
            ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 0;
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Deleting";
                try {
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1], 0);
                    DevComm.getInstance().telnetPost(ModifyJobs.this.getSystem(), ((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[0]);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1]);
                    throw throwable;
                }
                ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1]);
                {
                }
            }
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 100;
            ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"VOLUME_CREATE_ABORT", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Completed";
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                LogAPI.staticLog((String)"VOLUME_CREATE", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* createSli end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            Thread.yield();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteSlice() throws Exception {
            WBEMDebug.trace3((String)("*JobThread* deleteSli " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = false;
            ((ModifyJobs)ModifyJobs.this).activejob.startTime = System.currentTimeMillis();
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Started";
            ((ModifyJobs)ModifyJobs.this).activejob.status = "OK";
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 0;
            if (!this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Deleting";
                String[] dscmds = new String[]{((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[0], "y"};
                String[] dsresp = new String[]{"Continue ?", ":/:<"};
                String[] dserrs = new String[]{"ERROR", "usage: ", "Command not reentrant", "Command not found"};
                int[] dswait = new int[]{30000, 120000};
                try {
                    ModifyConfigService.createStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1], 1);
                    DevComm.getInstance().telnetMultiPost(ModifyJobs.this.getSystem(), dscmds, dsresp, dserrs, dsresp, dswait);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1]);
                    throw throwable;
                }
                ModifyConfigService.removeStorADELock(((ModifyJobs)ModifyJobs.this).activejob.telnetcmd[1]);
                {
                }
            }
            ((ModifyJobs)ModifyJobs.this).activejob.percentComplete = 100;
            ((ModifyJobs)ModifyJobs.this).activejob.elapsedTime = System.currentTimeMillis();
            if (this.stopped) {
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
                LogAPI.staticLog((String)"VOLUME_DELETE_ABORT", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            } else {
                ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = "Completed";
                ((ModifyJobs)ModifyJobs.this).activejob.status = "Completed";
                LogAPI.staticLog((String)"VOLUME_DELETE", (String[])ModifyJobs.this.activejob.getSliceLogArgs(), (String[])ModifyJobs.this.activejob.getNotifyList());
            }
            WBEMDebug.trace3((String)("*JobThread* deleteSli end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            Thread.yield();
        }

        public synchronized void trigger() {
            WBEMDebug.trace3((String)"ModifyJobs jobthread trigger-ed ");
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void jobWait() {
            Thread.yield();
            try {
                JobThread jobThread = this;
                synchronized (jobThread) {
                    this.waiting = true;
                    WBEMDebug.trace3((String)("*JobThread* Wait " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
                    boolean keepTrying = true;
                    int stalledCount = 0;
                    while (keepTrying) {
                        this.wait(60000L);
                        int oldPercentComplete = ((ModifyJobs)ModifyJobs.this).activejob.percentComplete;
                        ModifyJobs.this.update();
                        WBEMDebug.trace3((String)("*JobThread* old % complete: " + oldPercentComplete + "  new % complete: " + ((ModifyJobs)ModifyJobs.this).activejob.percentComplete));
                        stalledCount = oldPercentComplete == ((ModifyJobs)ModifyJobs.this).activejob.percentComplete ? ++stalledCount : 0;
                        if (!((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("OK") || !((ModifyJobs)ModifyJobs.this).activejob.jobStatus.equalsIgnoreCase("initializing")) {
                            WBEMDebug.trace3((String)"*JobThread* job not OK or initializing, so will no longer update status.");
                            keepTrying = false;
                            continue;
                        }
                        if (stalledCount <= 120) continue;
                        WBEMDebug.trace1((String)("*JobThread* stalled for too long with no progress. Will abort initialization after %complete: " + ((ModifyJobs)ModifyJobs.this).activejob.percentComplete));
                        keepTrying = false;
                    }
                    WBEMDebug.trace3((String)("*JobThread* Wait end " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
                    this.waiting = false;
                }
                WBEMDebug.trace3((String)("*JobThread* %complete=" + ((ModifyJobs)ModifyJobs.this).activejob.percentComplete));
                if (!((ModifyJobs)ModifyJobs.this).activejob.jobStatus.equalsIgnoreCase("initialized")) {
                    if (((ModifyJobs)ModifyJobs.this).activejob.status.equalsIgnoreCase("OK")) {
                        ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Error";
                        ((ModifyJobs)ModifyJobs.this).activejob.status = "Error";
                    }
                    ((ModifyJobs)ModifyJobs.this).activejob.errorDescription = "Error in vol initializing";
                    this.cleanup(((ModifyJobs)ModifyJobs.this).activejob.postIndex);
                    return;
                }
            }
            catch (InterruptedException iex) {
                this.stopped = true;
                this.waiting = false;
                this.cleanup(((ModifyJobs)ModifyJobs.this).activejob.postIndex);
            }
            if (this.stopped) {
                // empty if block
            }
        }

        public void abort() {
            WBEMDebug.trace3((String)("*JobThread* Abort " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            this.stopped = true;
            ((ModifyJobs)ModifyJobs.this).activejob.status = "Aborted";
            ((ModifyJobs)ModifyJobs.this).activejob.jobStatus = ((ModifyJobs)ModifyJobs.this).activejob.jobStatus + "Aborted";
            if (this.waiting) {
                this.interrupt();
            }
        }

        private void cleanup(Vector postv) {
            WBEMDebug.trace3((String)("*JobThread* Cleanup " + ((ModifyJobs)ModifyJobs.this).activejob.instanceId + ((ModifyJobs)ModifyJobs.this).activejob.counter));
            try {
                DevComm.getInstance().post(ModifyJobs.this.getSystem(), postv, "volAbort");
            }
            catch (Exception aex) {
                WBEMDebug.trace3((String)("*JobThread* Exception during jobthread cleanup" + ModifyJobs.this.activejob + aex));
            }
        }
    }

    private class Job {
        String type = null;
        boolean deleted = false;
        Vector postIndex = null;
        Vector postArgs = null;
        String[] telnetcmd = null;
        String storagePoolName = null;
        Vector storagePoolExtents = null;
        String storageVolumeName = null;
        UnsignedInt64 storageVolumeSize = null;
        UnsignedInt16 deviceNumber = null;
        UnsignedInt16 accessMode = null;
        String volWWN = null;
        String instanceId = null;
        int counter;
        String name = null;
        String description = null;
        long startTime = 0L;
        Date timeSubmitted = null;
        long elapsedTime = 0L;
        String notify = null;
        int percentComplete = 0;
        String status = null;
        String jobStatus = null;
        String operationalStatus = null;
        int errorCode = 0;
        String errorDescription = null;
        boolean deleteOnCompletion = false;

        private Job() {
        }

        CIMInstance getInstance() {
            CIMObjectPath cop;
            CIMInstance inst = null;
            if (this.type.equalsIgnoreCase("createPool")) {
                if (createPoolClass == null) {
                    try {
                        cop = new CIMObjectPath("StorEdge_6120CreateStoragePoolJob");
                        cop.setNameSpace("\\root\\se6x20");
                        createPoolClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = createPoolClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = createPoolClass.newInstance();
                }
                inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                inst.setProperty("StorageExtents", new CIMValue(this.storagePoolExtents, new CIMDataType(22)));
            } else if (this.type.equalsIgnoreCase("createVolume")) {
                if (createVolumeClass == null) {
                    try {
                        cop = new CIMObjectPath("StorEdge_6120CreateStorageVolumeJob");
                        cop.setNameSpace("\\root\\se6x20");
                        createVolumeClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = createVolumeClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = createVolumeClass.newInstance();
                }
                inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                inst.setProperty("StorageVolumeName", new CIMValue((Object)this.storageVolumeName));
                inst.setProperty("Size", new CIMValue((Object)this.storageVolumeSize, new CIMDataType(6)));
            } else if (this.type.equalsIgnoreCase("createMappedVolume")) {
                if (createMappedVolumeClass == null) {
                    try {
                        cop = new CIMObjectPath("StorEdge_6120CreateMappedStorageVolumeJob");
                        cop.setNameSpace("\\root\\se6x20");
                        createVolumeClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = createVolumeClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = createMappedVolumeClass.newInstance();
                }
                inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
                inst.setProperty("StorageVolumeName", new CIMValue((Object)this.storageVolumeName));
                inst.setProperty("Size", new CIMValue((Object)this.storageVolumeSize, new CIMDataType(6)));
                inst.setProperty("DeviceNumber", new CIMValue((Object)this.deviceNumber, new CIMDataType(2)));
                inst.setProperty("AccessMode", new CIMValue((Object)this.accessMode, new CIMDataType(2)));
            } else if (this.type.equalsIgnoreCase("initializePool")) {
                if (initializePoolClass == null) {
                    try {
                        cop = new CIMObjectPath("StorEdge_6120InitializeStoragePoolJob");
                        cop.setNameSpace("\\root\\se6x20");
                        initializePoolClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = initializePoolClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = initializePoolClass.newInstance();
                }
                inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
            } else if (this.type.equalsIgnoreCase("deletePool")) {
                if (deletePoolClass == null) {
                    try {
                        cop = new CIMObjectPath("StorEdge_6120DeleteStoragePoolJob");
                        cop.setNameSpace("\\root\\se6x20");
                        deletePoolClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = deletePoolClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = deletePoolClass.newInstance();
                }
                inst.setProperty("StoragePoolName", new CIMValue((Object)this.storagePoolName));
            } else if (this.type.equalsIgnoreCase("deleteVolume")) {
                if (deleteVolumeClass == null) {
                    try {
                        cop = new CIMObjectPath("StorEdge_6120DeleteStorageVolumeJob");
                        cop.setNameSpace("\\root\\se6x20");
                        deleteVolumeClass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(cop, false, true, true, null);
                        inst = deleteVolumeClass.newInstance();
                    }
                    catch (CIMException ce) {
                        WBEMDebug.trace3((String)"ModifyJobs: Failed to get CIMClass", (Throwable)ce);
                        inst = new CIMInstance();
                    }
                } else {
                    inst = deleteVolumeClass.newInstance();
                }
                inst.setProperty("StorageVolumeName", new CIMValue((Object)this.storageVolumeName));
            } else {
                WBEMDebug.trace1((String)"ModifyJobs: Unknown job type");
                return null;
            }
            inst.setProperty("InstanceID", new CIMValue((Object)(this.instanceId + this.counter)));
            inst.setProperty("Name", new CIMValue((Object)this.name));
            inst.setProperty("Description", new CIMValue((Object)this.description));
            inst.setProperty("SystemName", new CIMValue((Object)ModifyJobs.this.getSystem().getHost()));
            inst.setProperty("Notify", new CIMValue((Object)this.notify));
            if (this.status.equalsIgnoreCase("Completed")) {
                this.percentComplete = 100;
            }
            inst.setProperty("PercentComplete", new CIMValue((Object)new UnsignedInt16(this.percentComplete), new CIMDataType(2)));
            Vector<UnsignedInt16> u16a = new Vector<UnsignedInt16>();
            if (this.status.equalsIgnoreCase("Dormant")) {
                u16a.add(new UnsignedInt16(15));
            } else if (this.status.equalsIgnoreCase("Completed")) {
                u16a.add(new UnsignedInt16(17));
                u16a.add(new UnsignedInt16(2));
            } else if (this.status.equalsIgnoreCase("Error")) {
                u16a.add(new UnsignedInt16(17));
                u16a.add(new UnsignedInt16(6));
            } else if (this.status.equalsIgnoreCase("Aborted")) {
                u16a.add(new UnsignedInt16(17));
                u16a.add(new UnsignedInt16(14));
            } else if (this.status.equalsIgnoreCase("OK")) {
                u16a.add(new UnsignedInt16(2));
            }
            inst.setProperty("OperationalStatus", new CIMValue(u16a, new CIMDataType(16)));
            inst.setProperty("JobStatus", new CIMValue((Object)this.jobStatus));
            if (this.startTime != 0L) {
                inst.setProperty("StartTime", new CIMValue((Object)new CIMDateTime(new Date(this.startTime)), new CIMDataType(12)));
            }
            if (this.timeSubmitted != null) {
                inst.setProperty("TimeSubmitted", new CIMValue((Object)new CIMDateTime(this.timeSubmitted), new CIMDataType(12)));
            }
            if (this.elapsedTime != 0L) {
                inst.setProperty("ElapsedTime", new CIMValue((Object)new CIMDateTime(new Date(this.elapsedTime - this.startTime)), new CIMDataType(12)));
            }
            inst.setProperty("ErrorCode", new CIMValue((Object)new UnsignedInt16(this.errorCode), new CIMDataType(2)));
            inst.setProperty("ErrorDescription", new CIMValue((Object)this.errorDescription));
            return inst;
        }

        CIMInstance getConfigAssocInstance() throws CIMException {
            try {
                if (ModifyJobs.this.cimJobConfigAssoc == null) {
                    CIMObjectPath assocop = new CIMObjectPath("StorEdge_6120ConfigurationServiceJobElement");
                    assocop.setNameSpace("\\root\\se6x20");
                    ModifyJobs.this.cimJobConfigAssoc = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(assocop, false, true, true, null);
                }
                if (ModifyJobs.this.configService == null) {
                    CIMObjectPath csvcop = new CIMObjectPath("StorEdge_6120StorageConfigurationService");
                    csvcop.setNameSpace("\\root\\se6x20");
                    ModifyJobs.this.poolcop = new CIMObjectPath("StorEdge_6120StoragePool");
                    ModifyJobs.this.poolcop.setNameSpace("\\root\\se6x20");
                    ModifyJobs.this.poolclass = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(ModifyJobs.this.poolcop, false, true, true, null);
                    CIMClass csvccls = StorEdge_6120ArrayProvider.getCIMOMHandle().getClass(csvcop, false, true, true, null);
                    CIMInstance[] csvclist = RequestBroker.getInstance().enumerateInstances(ModifyJobs.this.getSystem(), csvcop, false, true, true, null, csvccls);
                    if (csvccls == null) {
                        CIMException ce = new CIMException("CIM_ERR_FAILED");
                        ce.setDescription("ModifyJobs: ConfigService not found.");
                        throw ce;
                    }
                    int i = 0;
                    while (i < csvclist.length) {
                        if (csvclist[i].getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ModifyJobs.this.getSystem().getHost())) {
                            ModifyJobs.this.configService = csvclist[i].getObjectPath();
                            break;
                        }
                        ++i;
                    }
                    if (ModifyJobs.this.configService == null) {
                        CIMException ce = new CIMException("CIM_ERR_FAILED");
                        ce.setDescription("ModifyJobs: ConfigService not found");
                        throw ce;
                    }
                    WBEMDebug.trace3((String)("ModifyJobs: configservice = " + ModifyJobs.this.configService));
                }
            }
            catch (CIMException cex) {
                WBEMDebug.trace3((String)"ModifyJobs Construction failed: ", (Throwable)cex);
            }
            CIMInstance inst = ModifyJobs.this.cimJobConfigAssoc.newInstance();
            inst.setProperty("OwningElement", new CIMValue((Object)ModifyJobs.this.configService));
            inst.setProperty("OwnedElement", new CIMValue((Object)this.getInstance().getObjectPath()));
            return inst;
        }

        public String[] getNotifyList() {
            if (this.notify == null) {
                return new String[0];
            }
            StringTokenizer tk = new StringTokenizer(this.notify, ",");
            String[] ids = new String[tk.countTokens()];
            int i = 0;
            while (tk.hasMoreElements()) {
                ids[i] = tk.nextToken();
                ++i;
            }
            return ids;
        }

        public String[] getVolLogArgs() {
            String[] logargs = new String[]{this.storagePoolName, ModifyJobs.this.getSystem().getHost()};
            return logargs;
        }

        public String[] getSliceLogArgs() {
            String[] logargs = new String[]{this.storageVolumeName, ModifyJobs.this.getSystem().getHost(), this.storagePoolName};
            return logargs;
        }
    }
}

