/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.InvokeRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyJobs;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyModule;
import com.sun.netstorage.array.mgmt.se6120.internal.ModifyRequest;
import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.se6120.internal.StorEdgeIOException;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;

public class ModifyConfigService
extends ModifyModule {
    static Vector classMap = new Vector();
    public static final int MAX_NAME_LENGTH_VOL = 80;
    public static final int MAX_NAME_LENGTH_POOL = 12;
    public static final int _LOCK_FILE_VOL_CREATE_ = 0;
    public static final int _LOCK_FILE_VOL_DELETE_ = 1;
    public static final int _LOCK_FILE_POOL_CREATE_ = 2;
    public static final int _LOCK_FILE_POOL_DELETE_ = 3;
    public static final int _LOCK_FILE_POOL_MOUNT_ = 4;
    public static final int _LOCK_FILE_POOL_UNMOUNT_ = 5;
    private static final CIMValue _CONF_SERVICE_FAILURE;
    private static final CIMValue _CONF_SERVICE_INVALID_PARAMETER;
    private static final CIMValue _CONF_SERVICE_COMPLETE_SUCCESSFUL;
    private static final CIMValue _CONF_SERVICE_JOB_STARTED;
    private static String CLASSNAME;

    public ModifyConfigService(ArrayObject host) {
        super(host);
    }

    public ModifyConfigService(String hostname) {
        super(hostname);
    }

    public boolean handleRequest(ModifyRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "handleRequest";
        boolean reqReturn = false;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        if (classMap.contains(request.getCIMClassName())) {
            if (request instanceof InvokeRequest) {
                try {
                    reqReturn = this.invokeStorageConfigurationService((InvokeRequest)request);
                }
                catch (CIMException e) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " threw an exception: " + e.getMessage()));
                    throw e;
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
        }
        return reqReturn;
    }

    private boolean invokeStorageConfigurationService(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        boolean ret;
        block9: {
            String METHOD = "invokeStorageConfigurationService";
            ret = false;
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
            String method = request.getMethodName();
            try {
                if (method.equalsIgnoreCase("DeleteStoragePool")) {
                    ret = true;
                    this.deleteStoragePool(request);
                    break block9;
                }
                if (method.equalsIgnoreCase("CreateOrModifyStoragePool")) {
                    ret = true;
                    this.createOrModifyStoragePool(request);
                    break block9;
                }
                if (method.equalsIgnoreCase("ReturnToStoragePool")) {
                    ret = true;
                    this.returnToStoragePool(request);
                    break block9;
                }
                if (method.equalsIgnoreCase("CreateOrModifyElementFromStoragePool")) {
                    ret = true;
                    this.createOrModifyElementFromStoragePool(request, false);
                    break block9;
                }
                if (method.equalsIgnoreCase("CreateMappedElementFromStoragePool")) {
                    ret = true;
                    this.createMappedElementFromStoragePool(request);
                    break block9;
                }
                if (method.equalsIgnoreCase("InitializeStoragePool")) {
                    ret = true;
                    this.initializeStoragePool(request);
                    break block9;
                }
                throw new CIMException("CIM_ERR_FAILED");
            }
            catch (ArrayException ae) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " encountered an" + " exception, " + ae));
                throw ae;
            }
            catch (StorEdgeIOException ioe) {
                request.setResults(_CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " encountered an" + " exception, " + ioe));
                throw ioe;
            }
        }
        return ret;
    }

    public void shutdown() {
    }

    private void createMappedElementFromStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        this.createOrModifyElementFromStoragePool(request, true);
    }

    /*
     * Unable to fully structure code
     */
    private void createOrModifyElementFromStoragePool(InvokeRequest request, boolean isMapped) throws CIMException, ArrayException, StorEdgeIOException {
        METHOD = "createOrModifyElementFromStoragePool";
        poolInst = null;
        tokenArgs = new Vector<String>();
        retCode = ModifyConfigService._CONF_SERVICE_FAILURE;
        thisVol = null;
        vInst = null;
        aInst = null;
        volSliceName = null;
        volSliceIndex = null;
        jobOp = null;
        storVols = null;
        _ELEMENT_TYPE_INDEX = 1;
        _ELEMENT_NAME_INDEX = 0;
        _POOL_SIZE_INDEX = 4;
        _STORAGE_POOL_INDEX = 5;
        _JOB_DESCRIPTION_INDEX = 7;
        _DEVICE_NUMBER_INDEX = 8;
        _ACCESS_MODE_INDEX = 9;
        _MAX_SLICE_NUMBER = 64;
        _MAX_SLICE_SIZE = 0x10000000000L;
        _GIG_VALUE = 1.073741824E9;
        _MEG_VALUE = 1048576.0;
        _MIN_SLICE_SIZE = 1.048576E7;
        _STORAGE_VOLUME = 2;
        elementType = null;
        availPoolSpace = 0L;
        paramIndex = new int[]{_ELEMENT_NAME_INDEX, _ELEMENT_TYPE_INDEX, _POOL_SIZE_INDEX, _STORAGE_POOL_INDEX};
        paramNames = new String[]{"ElementName", "ElementType", "Size", "Pool"};
        WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " entered"));
        try {
            badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
            return;
        }
        inArgs = request.getInParams();
        elementType = (UnsignedInt16)inArgs[_ELEMENT_TYPE_INDEX].getValue().getValue();
        gaa = RequestBroker.getInstance().enumerateInstances(this.getSystem().getHost(), new CIMObjectPath("StorEdge_6120PortSCSIController"), false, true, false, null, null);
        if (gaa == null) {
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover instance of PortSCSIController for" + " this cluster. "));
            request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
            return;
        }
        gaai = gaa[0];
        prop = gaai.getProperty("MaxNumberControlled");
        if (prop.getValue() == null || prop.getValue().getValue() == null) {
            request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover MaxNumberControlled property of" + " Storage Pool: " + gaai));
            return;
        }
        _MAX_SLICE_NUMBER = ((UnsignedInt32)prop.getValue().getValue()).intValue();
        if (elementType.intValue() != _STORAGE_VOLUME || inArgs[_STORAGE_POOL_INDEX].getType().getType() != 28) ** GOTO lbl255
        if (inArgs[_STORAGE_POOL_INDEX].getType().getRefClassName().equalsIgnoreCase("storedge_6120storagepool")) {
            op = (CIMObjectPath)inArgs[_STORAGE_POOL_INDEX].getValue().getValue();
            poolInst = RequestBroker.getInstance().getInstance(op, false, true, false, null, null);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": gotInstance: " + poolInst.getObjectPath()));
            if (poolInst == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover instance of Storage Pool: " + op));
                return;
            }
            prop = poolInst.getProperty("PoolID");
            if (prop.getValue() == null || prop.getValue().getValue() == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover PoolID property of StoragePool: " + poolInst));
                return;
            }
            poolid = (String)prop.getValue().getValue();
            uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
            vIndex = poolid.substring(poolid.indexOf("v") + 1);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": pool id val:" + poolid + " unitIndex: " + uIndex + " volIndex: " + vIndex));
            prop = poolInst.getProperty("ElementName");
            if (prop.getValue() == null || prop.getValue().getValue() == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover ElementName property of StoragePool: " + poolInst));
                return;
            }
            poolName = (String)prop.getValue().getValue();
            prop = poolInst.getProperty("TotalAvailableSpace");
            if (prop.getValue() == null || prop.getValue().getValue() == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover TotalAvailableSpace " + "property of Storage Pool: " + poolInst));
                return;
            }
            capacity = ((UnsignedInt64)prop.getValue().getValue()).longValue();
            capacity = capacity * 1024L * 1024L;
            assocInst = null;
            assoc = new CIMObjectPath("StorEdge_6120AllocatedFromStoragePool");
            qualified = poolInst.getObjectPath();
            qualified.setNameSpace("\\root\\se6x20");
            assocInst = RequestBroker.getInstance().associators(assoc, qualified, "StorEdge_6120StorageVolume", null, null, true, false, null);
            volSliceName = (String)inArgs[_ELEMENT_NAME_INDEX].getValue().getValue();
            if (volSliceName.length() >= 80) {
                volSliceName = volSliceName.substring(0, Math.min(volSliceName.length(), 80));
            }
            if (assocInst != null) {
                i = 0;
                while (i < assocInst.length) {
                    aInst = assocInst[i];
                    oii = aInst.getProperty("OtherIdentifyingInfo");
                    if (oii.getValue() == null || oii.getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover OtherIdentyingInfo" + " from instance of StorageVolume: " + aInst));
                        return;
                    }
                    oiiv = oii.getValue();
                    oiivv = (Vector)oiiv.getValue();
                    tempName = (String)oiivv.firstElement();
                    WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": comparing " + tempName));
                    if (tempName.equals(volSliceName)) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name: " + volSliceName));
                        return;
                    }
                    oii = aInst.getProperty("ConsumableBlocks");
                    if (oii.getValue() == null || oii.getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover property ConsumableBlocks" + " from instance of StorageVolume: " + aInst));
                        return;
                    }
                    vsize = ((UnsignedInt64)oii.getValue().getValue()).longValue();
                    capacity -= vsize;
                    ++i;
                }
            }
            sliceIndex = new Vector<String>();
            otherPools = new Vector<E>();
            ourCluster = null;
            clustInsts = null;
            qualified = request.getObjectPath();
            qualified.setNameSpace("\\root\\se6x20");
            clustInsts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120HostedConfigService"), qualified, "StorEdge_6120Cluster", null, null, true, false, null);
            if (clustInsts == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to return an instance for associators of " + " this ConfigService to a cluster: " + request.getObjectPath()));
                return;
            }
            ourCluster = clustInsts[0];
            if (ourCluster == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": No Cluster found for this system!" + this.getSystem().getHost()));
                return;
            }
            poolInsts = null;
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": checking for pool - cluster association "));
            qualified = ourCluster.getObjectPath();
            qualified.setNameSpace("\\root\\se6x20");
            poolInsts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120HostedStoragePool"), qualified, "StorEdge_6120StoragePool", null, null, true, false, null);
            if (poolInsts == null) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to return an instance of HostedStoragePool" + " for cluster: " + request.getObjectPath()));
                return;
            }
            i = 0;
            while (i < poolInsts.length) {
                aPool = poolInsts[i];
                vols = null;
                WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": checking for pool - volume association"));
                qualified = aPool.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                vols = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AllocatedFromStoragePool"), qualified, "StorEdge_6120StorageVolume", null, null, true, false, null);
                vollength = 0;
                if (vols != null) {
                    vollength = vols.length;
                }
                j = 0;
                while (j < vollength) {
                    if (vols[j].getProperty("Name").getValue() == null || vols[j].getProperty("Name").getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover property Name " + "for StorageVolume : " + vols[j]));
                        return;
                    }
                    sliceIndex.add((String)vols[j].getProperty("Name").getValue().getValue());
                    otherProp = vols[j].getProperty("OtherIdentifyingInfo");
                    if (otherProp.getValue() == null || otherProp.getValue().getValue() == null) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Failed to discover OtherIdentifyingInfo " + "for StorageVolume : " + vols[j]));
                        return;
                    }
                    tempName = (String)((Vector)otherProp.getValue().getValue()).firstElement();
                    WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": comparing " + tempName));
                    if (tempName.equals(volSliceName)) {
                        request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                        WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " was given a duplicate StorageVolume name: " + volSliceName));
                        return;
                    }
                    ++j;
                }
                ++i;
            }
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": finding slice value for volume "));
            volSliceIndex = this.getLowSeqValue(sliceIndex);
            sliceSizeIn = (UnsignedInt64)inArgs[_POOL_SIZE_INDEX].getValue().getValue();
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": calculating GB for size entered:" + sliceSizeIn));
            sliceSizeLong = -1L;
            try {
                sliceSizeLong = sliceSizeIn.longValue();
            }
            catch (NumberFormatException nfe) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Value given for Size is invalid: " + sliceSizeIn));
                return;
            }
            if ((double)sliceSizeLong < _MIN_SLICE_SIZE || sliceSizeLong > _MAX_SLICE_SIZE || sliceSizeLong > capacity) {
                request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Size for this volSlice is invalid: " + sliceSizeLong + " max size is :" + _MAX_SLICE_SIZE + " min size is :" + _MIN_SLICE_SIZE + " remaining capacity is: " + capacity));
                return;
            }
            divisor = 0.0;
            suffix = null;
            if ((double)sliceSizeLong >= _GIG_VALUE) {
                divisor = _GIG_VALUE;
                suffix = "gb";
            } else if ((double)sliceSizeLong < _GIG_VALUE && (double)sliceSizeLong >= _MIN_SLICE_SIZE) {
                divisor = _MEG_VALUE;
                suffix = "mb";
            }
            flt = (double)sliceSizeLong / divisor;
            df = new DecimalFormat("##0.00");
            volSliceSize = df.format(flt);
            volSliceSize = volSliceSize.concat(suffix);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": size determined as " + volSliceSize));
            tokenArgs.add("unitIndex=" + uIndex);
            tokenArgs.add("volIndex=" + vIndex);
            tokenArgs.add("volSliceIndex=" + volSliceIndex);
            tokenArgs.add("volSliceName=" + volSliceName);
            tokenArgs.add("volSliceSize=" + volSliceSize);
            jobCommand = "createVolume";
            if (isMapped) {
                lunNum = (UnsignedInt16)inArgs[_DEVICE_NUMBER_INDEX].getValue().getValue();
                accVal = (UnsignedInt16)inArgs[_ACCESS_MODE_INDEX].getValue().getValue();
                if (lunNum != null || accVal != null) {
                    tokenArgs.add((String)lunNum);
                    tokenArgs.add((String)accVal);
                    jobCommand = "createMappedVolume";
                }
            }
            tokenArgs.add(poolName);
            tokenArgs.add((String)sliceSizeIn);
            WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": arguments for tokens are:"));
            i = 0;
            while (i < tokenArgs.size()) {
                WBEMDebug.trace3((String)(ModifyConfigService.CLASSNAME + "." + METHOD + "" + tokenArgs.get(i)));
                ++i;
            }
            telnetcmds = new String[]{"volslice create " + volSliceName + " -z " + volSliceSize + " " + poolName, this.getSystem().getHost()};
            jobDesc = null;
            try {
                jobDesc = (String)inArgs[_JOB_DESCRIPTION_INDEX].getValue().getValue();
            }
            catch (NullPointerException ne) {
            }
            catch (ArrayIndexOutOfBoundsException ae) {
            }
            catch (Exception e) {
                request.setResults(ModifyConfigService._CONF_SERVICE_FAILURE);
                WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()));
                return;
            }
        } else {
            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " failed to discover the correct parameters:" + " StoragePool name = " + inArgs[_STORAGE_POOL_INDEX].getType().getRefClassName()));
            return;
lbl255:
            // 1 sources

            request.setResults(ModifyConfigService._CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(ModifyConfigService.CLASSNAME + "." + METHOD + " failed to discover the correct parameters:" + " Element Type = " + inArgs[_ELEMENT_TYPE_INDEX].getValue().getValue()));
            return;
        }
        jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob(jobCommand, tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob(jobCommand, tokenArgs, telnetcmds);
        request.setResults(ModifyConfigService._CONF_SERVICE_JOB_STARTED);
        outArgs = request.getOutParams();
        outArgs[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
        outArgs[1] = new CIMArgument("Size", new CIMValue((Object)jobOp));
        outArgs[2] = new CIMArgument("TheElement", new CIMValue(null));
    }

    private void createOrModifyStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "createOrModifyStoragePool";
        Vector extents = new Vector();
        CIMInstance storSet = null;
        CIMInstance cluster = null;
        String unitIndex = "-1";
        String volName = null;
        String volRaidLevel = "raid";
        boolean hotSpare = false;
        String volIndex = null;
        int _VOL_INIT_RATE = 8;
        boolean _VOL_SAFETY_LEVEL = true;
        boolean _INSTANCE_NAME_INDEX = false;
        int _STOR_SETT_INDEX = 2;
        int _POOL_SIZE_INDEX = 3;
        int _EXTENT_ARRAY_INDEX = 5;
        int _JOB_DESCRIPTION_INDEX = 7;
        int[] paramIndex = new int[]{0, 2, 5};
        String[] paramNames = new String[]{"Name", "Goal", "InExtents[]"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        int i = 0;
        while (i < inArgs.length) {
            if (inArgs[i].getName().equalsIgnoreCase("InExtents")) {
                extents = (Vector)inArgs[i].getValue().getValue();
            }
            if (inArgs[i].getName().equalsIgnoreCase("Goal")) {
                storSet = RequestBroker.getInstance().getInstance((CIMObjectPath)inArgs[i].getValue().getValue(), false, false, false, null, null);
                WBEMDebug.trace2((String)(CLASSNAME + "." + METHOD + ": StorageSetting" + storSet.toString()));
            }
            ++i;
        }
        if (extents.isEmpty()) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " failed to discover any StorageExtents for this Pool"));
            return;
        }
        volName = (String)inArgs[0].getValue().getValue();
        if (volName == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " No name found for the intended pool "));
            return;
        }
        if (volName.length() >= 12) {
            volName = volName.substring(0, Math.min(volName.length(), 12));
        }
        int numDrives = extents.size();
        Vector<String> fruIds = new Vector<String>();
        Iterator driveIter = extents.iterator();
        while (driveIter.hasNext()) {
            String extent = (String)driveIter.next();
            int begInd = extent.indexOf("DeviceID=") + 11;
            int endInd = extent.indexOf(92, begInd);
            fruIds.add(extent.substring(begInd, endInd));
        }
        int dmin = 15;
        int dmax = 0;
        String inUnitIndex = null;
        Iterator fruIter = fruIds.iterator();
        while (fruIter.hasNext()) {
            String elementname = (String)fruIter.next();
            inUnitIndex = elementname.substring(elementname.indexOf("u") + 1, elementname.indexOf("d"));
            if (unitIndex.equals("-1")) {
                unitIndex = inUnitIndex;
            }
            if (!unitIndex.equals(inUnitIndex)) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " StorageExtents for Pool aren't within the same tray"));
                return;
            }
            int dval = new Integer(elementname.substring(elementname.indexOf("d") + 1));
            if (dval < dmin) {
                dmin = dval;
            }
            if (dval <= dmax) continue;
            dmax = dval;
        }
        if (dmax - dmin + 1 > numDrives || dmax < dmin) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " StorageExtents Not Proper"));
            return;
        }
        CIMObjectPath clusOp = new CIMObjectPath();
        clusOp.setNameSpace(request.getObjectPath().getNameSpace());
        clusOp.setObjectName("StorEdge_6120Cluster");
        CIMInstance[] insts = null;
        CIMObjectPath qualified = request.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120HostedConfigService"), qualified, "StorEdge_6120Cluster", null, null, true, false, null);
        if (insts == null) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Failed to discover the ConfigService for cluster: " + request.getObjectPath()));
            return;
        }
        cluster = insts[0];
        if (cluster == null) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the Cluster this array is supposed to map to: " + this.getSystem().getHost()));
            request.setResults(_CONF_SERVICE_FAILURE);
            return;
        }
        CIMObjectPath assocName = new CIMObjectPath("StorEdge_6120ComputerSystemPackage");
        qualified = cluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(assocName, qualified, "StorEdge_6120Chassis", null, null, true, false, null);
        if (insts.length == 0) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " : There are no trays for this pool to be created, on to: " + this.getSystem().getHost()));
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            return;
        }
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + ": found Cluster for this system."));
        HashSet<String> usedVolIndices = new HashSet<String>();
        assocName = new CIMObjectPath("StorEdge_6120HostedStoragePool");
        qualified = cluster.getObjectPath();
        qualified.setNameSpace("\\root\\se6x20");
        insts = RequestBroker.getInstance().associators(assocName, qualified, "StorEdge_6120StoragePool", null, null, true, false, null);
        int iUnitIndex = Integer.parseInt(unitIndex);
        if (insts != null) {
            int i2 = 0;
            while (i2 < insts.length) {
                CIMInstance poolInst = insts[i2];
                CIMProperty poolProp = poolInst.getProperty("PoolID");
                if (poolProp.getValue() == null || poolProp.getValue().getValue() == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find the PoolID property for " + "Pool: " + poolInst));
                    request.setResults(_CONF_SERVICE_FAILURE);
                    return;
                }
                String poolid = (String)poolProp.getValue().getValue();
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                if (Integer.parseInt(uIndex) + 1 == iUnitIndex) {
                    String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                    WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " adding to usedVolIndices: " + vIndex));
                    usedVolIndices.add(vIndex);
                }
                ++i2;
            }
        }
        if (usedVolIndices.size() >= 2) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Maximum pools already exist on this tray!"));
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            return;
        }
        volIndex = usedVolIndices.contains("0") ? "1" : "0";
        Vector props = storSet.getProperties();
        Iterator iter = props.iterator();
        boolean noSinglePoint = false;
        int dataRedun = -1;
        int spindleRedun = -1;
        while (iter.hasNext()) {
            CIMProperty settProp = (CIMProperty)iter.next();
            if (settProp.getValue() == null || settProp.getValue().getValue() == null) {
                if (!settProp.getName().equalsIgnoreCase("SpindleRedundancyMin") && !settProp.getName().equalsIgnoreCase("NoSinglePointOfFailure") && !settProp.getName().equalsIgnoreCase("DataRedundancyMin")) continue;
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Volume index not accepted:  " + unitIndex));
                return;
            }
            if (settProp.getName().equalsIgnoreCase("SpindleRedundancyMin")) {
                spindleRedun = ((UnsignedInt16)settProp.getValue().getValue()).intValue();
            }
            if (settProp.getName().equalsIgnoreCase("NoSinglePointOfFailure") && settProp.getType().getType() == 9) {
                Boolean b = (Boolean)settProp.getValue().getValue();
                noSinglePoint = b;
            }
            if (!settProp.getName().equalsIgnoreCase("DataRedundancyMin")) continue;
            dataRedun = ((UnsignedInt16)settProp.getValue().getValue()).intValue();
        }
        int raid = -1;
        try {
            raid = this.getRaidLevel(spindleRedun, noSinglePoint, dataRedun);
        }
        catch (CIMException ce) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " RAID level is not within defined parameters,  " + " SpindleRedundancy = " + spindleRedun + " NoSinglePointOfFailure = " + noSinglePoint + " DataRedundancy = " + dataRedun));
            return;
        }
        hotSpare = spindleRedun == 2 && (raid == 5 || raid == 1);
        String drives = "u" + unitIndex + "d";
        drives = dmin > 9 ? drives + dmin : drives + "0" + dmin;
        drives = dmax > 9 ? drives + "-" + dmax : drives + "-0" + dmax;
        String cmd = "vol add " + volName + " data " + drives + " raid " + raid;
        if (hotSpare) {
            cmd = cmd + " standby u" + unitIndex + "d14";
        }
        if (RequestBroker.getInstance().isSyntheticCacheInstance(storSet.getObjectPath())) {
            RequestBroker.getInstance().deleteInstance(storSet.getObjectPath());
        }
        String[] telnetcmds = new String[4];
        WBEMDebug.trace3((String)(CLASSNAME + ": telnet create pool cmd = " + cmd));
        telnetcmds[0] = cmd;
        telnetcmds[1] = cmd = "vol init " + volName + " data";
        telnetcmds[2] = cmd = "vol mount " + volName;
        telnetcmds[3] = this.getSystem().getHost();
        unitIndex = this.subtractOne(unitIndex);
        Vector<Object> tokenArgs = new Vector<Object>();
        tokenArgs.add("unitIndex=" + unitIndex);
        tokenArgs.add("volIndex=" + volIndex);
        tokenArgs.add("volName=" + volName);
        tokenArgs.add("volArrayWidth=" + numDrives);
        tokenArgs.add("volRaidLevel=" + volRaidLevel + raid);
        tokenArgs.add("volSafety=1");
        tokenArgs.add("volInitRate=8");
        tokenArgs.add("unitStandby=" + this.convertBooleanToYes(hotSpare));
        tokenArgs.add(extents);
        String jobDesc = null;
        try {
            jobDesc = (String)inArgs[7].getValue().getValue();
        }
        catch (NullPointerException ne) {
        }
        catch (ArrayIndexOutOfBoundsException ae) {
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_FAILURE);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()));
            return;
        }
        CIMObjectPath jobOp = null;
        jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("createPool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("createPool", tokenArgs, telnetcmds);
        CIMArgument[] outParams = request.getOutParams();
        outParams[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
        outParams[1] = new CIMArgument("Size", null);
        outParams[2] = new CIMArgument("Pool", null);
        request.setResults(_CONF_SERVICE_JOB_STARTED);
    }

    private void initializeStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "initializeStoragePool";
        boolean _POOL_INDEX = true;
        int _JOB_DESCRIPTION_INDEX = 2;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        int[] paramIndex = new int[]{1};
        String[] paramNames = new String[]{"Pool"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (inArgs[1].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[1].getType().getRefClassName().equalsIgnoreCase("storedge_6120storagepool")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have storage pool to initialize"));
                CIMObjectPath op = (CIMObjectPath)inArgs[1].getValue().getValue();
                poolInst = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (poolInst == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of Pool to initialize"));
                    return;
                }
                CIMProperty prop = poolInst.getProperty("PoolID");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover PoolID property for Pool: " + poolInst));
                    return;
                }
                String poolid = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsing poolId: " + poolid));
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsed uIndex: " + uIndex + " vIndex: " + vIndex));
                prop = poolInst.getProperty("ElementName");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover ElementName property for Pool: " + poolInst));
                    return;
                }
                String volName = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have volName: " + volName));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volName=" + volName);
                tokenArgs.add(poolid);
                String[] telnetcmds = new String[]{"vol init " + volName + " data", "vol mount " + volName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[2].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()));
                    return;
                }
                CIMObjectPath jobOp = null;
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("initializePool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("initializePool", tokenArgs, telnetcmds);
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue((Object)jobOp);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void deleteStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "deleteStoragePool";
        boolean _POOL_INDEX = true;
        int _JOB_DESCRIPTION_INDEX = 2;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        int[] paramIndex = new int[]{1};
        String[] paramNames = new String[]{"Pool"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs == null) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not have any parameters"));
            return;
        }
        if (inArgs[1].getValue().getType().getType() == 28) {
            WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have reference type"));
            if (inArgs[1].getType().getRefClassName().equalsIgnoreCase("storedge_6120storagepool")) {
                CIMArgument delArg;
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have storage pool to delete"));
                CIMObjectPath op = (CIMObjectPath)inArgs[1].getValue().getValue();
                poolInst = RequestBroker.getInstance().getInstance(op, false, false, false, null, null);
                if (poolInst == null) {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not find instance of Pool to delete"));
                    return;
                }
                CIMProperty prop = poolInst.getProperty("PoolID");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover PoolID property for Pool: " + poolInst));
                    return;
                }
                String poolid = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsing poolId: " + poolid));
                String uIndex = poolid.substring(poolid.indexOf("u") + 1, poolid.indexOf("v"));
                String vIndex = poolid.substring(poolid.indexOf("v") + 1);
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " parsed uIndex: " + uIndex + " vIndex: " + vIndex));
                prop = poolInst.getProperty("ElementName");
                if (prop.getValue() == null || prop.getValue().getValue() == null) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover ElementName property for Pool: " + poolInst));
                    return;
                }
                String volName = (String)prop.getValue().getValue();
                WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " have volName: " + volName));
                tokenArgs.add("unitIndex=" + uIndex);
                tokenArgs.add("volIndex=" + vIndex);
                tokenArgs.add("volName=" + volName);
                tokenArgs.add(poolid);
                String[] telnetcmds = new String[]{"vol unmount " + volName, "vol -y remove " + volName, this.getSystem().getHost()};
                String jobDesc = null;
                try {
                    jobDesc = (String)inArgs[2].getValue().getValue();
                }
                catch (NullPointerException ne) {
                }
                catch (ArrayIndexOutOfBoundsException ae) {
                }
                catch (Exception e) {
                    request.setResults(_CONF_SERVICE_FAILURE);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()));
                    return;
                }
                CIMObjectPath jobOp = null;
                jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deletePool", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deletePool", tokenArgs, telnetcmds);
                CIMArgument[] outParams = request.getOutParams();
                CIMValue jobVal = new CIMValue((Object)jobOp);
                outParams[0] = delArg = new CIMArgument("Job", jobVal);
                request.setResults(_CONF_SERVICE_JOB_STARTED);
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
        }
    }

    private void returnToStoragePool(InvokeRequest request) throws CIMException, ArrayException, StorEdgeIOException {
        String METHOD = "returnToStoragePool";
        boolean _STOR_VOL_INDEX = true;
        boolean _VOL_SLICE_NAME = false;
        boolean _JOB_INDEX = false;
        int _JOB_DESCRIPTION_INDEX = 2;
        CIMInstance poolInst = null;
        Vector<String> tokenArgs = new Vector<String>();
        boolean _VOLSLICE_INDEX = true;
        CIMInstance volInst = null;
        String uIndex = null;
        String vIndex = null;
        CIMInstance[] assocs = null;
        int[] paramIndex = new int[]{1};
        String[] paramNames = new String[]{"TheElement"};
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        try {
            int badIndex = this.checkForNullParams(paramIndex, request);
            if (badIndex != -1) {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered a null parameter: " + paramNames[badIndex]));
                return;
            }
        }
        catch (Exception e) {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e));
            return;
        }
        CIMArgument[] inArgs = request.getInParams();
        if (inArgs[1].getType().getType() == 28) {
            if (inArgs[1].getType().getRefClassName().equalsIgnoreCase("storedge_6120storagevolume")) {
                CIMProperty prop;
                int i;
                CIMObjectPath op = (CIMObjectPath)inArgs[1].getValue().getValue();
                volInst = RequestBroker.getInstance().getInstance(op, false, true, false, null, null);
                if (volInst == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover instance of StorageVolume" + " in cache to delete."));
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    return;
                }
                CIMObjectPath qualified = volInst.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                assocs = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120MappedSCSILun"), qualified, "StorEdge_6120AuthorizationViewSCSIController", null, null, true, false, null);
                if (assocs != null) {
                    i = 0;
                    while (i < assocs.length) {
                        CIMInstance mapInst = assocs[i];
                        CIMProperty defGlobAcc = mapInst.getProperty("DefaultGlobalAccess");
                        if (defGlobAcc.getValue() == null || defGlobAcc.getValue().getValue() == null) {
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Could not discover instance of StorageVolume" + " in cache to delete."));
                            request.setResults(_CONF_SERVICE_FAILURE);
                            return;
                        }
                        if (!((Boolean)defGlobAcc.getValue().getValue()).booleanValue()) {
                            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": There remains an ACI non-default instance for " + "this StorageVolume: " + volInst));
                            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                            return;
                        }
                        ++i;
                    }
                }
                qualified = volInst.getObjectPath();
                qualified.setNameSpace("\\root\\se6x20");
                assocs = RequestBroker.getInstance().associators(new CIMObjectPath("StorEdge_6120AllocatedFromStoragePool"), qualified, "StorEdge_6120StoragePool", null, null, true, false, null);
                if (assocs == null) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find allocation for this storage volume."));
                    request.setResults(_CONF_SERVICE_FAILURE);
                    return;
                }
                i = 0;
                if (i < assocs.length) {
                    poolInst = assocs[i];
                    prop = poolInst.getProperty("PoolID");
                    if (prop.getValue() == null || prop.getValue().getValue() == null) {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Did not find property PoolID for Pool: " + poolInst));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                    String poolId = (String)poolInst.getProperty("PoolID").getValue().getValue();
                    if (poolId != null) {
                        uIndex = poolId.substring(poolId.indexOf("u") + 1, poolId.indexOf("v"));
                        vIndex = poolId.substring(poolId.indexOf("v") + 1);
                    } else {
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "No PoolID existed for this StoragePool"));
                        request.setResults(_CONF_SERVICE_FAILURE);
                        return;
                    }
                }
                prop = volInst.getProperty("OtherIdentifyingInfo");
                if (prop.getType().isArrayType()) {
                    String volSliceName = (String)((Vector)prop.getValue().getValue()).get(0);
                    tokenArgs.add("unitIndex=" + uIndex);
                    tokenArgs.add("volIndex=" + vIndex);
                    tokenArgs.add("volSliceName=" + volSliceName);
                    String[] telnetcmds = new String[]{"volslice remove " + volSliceName, this.getSystem().getHost()};
                    String jobDesc = null;
                    try {
                        jobDesc = (String)inArgs[2].getValue().getValue();
                    }
                    catch (NullPointerException ne) {
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                    }
                    catch (Exception e) {
                        request.setResults(_CONF_SERVICE_FAILURE);
                        WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + ": Encountered an exception. " + e.getMessage()));
                        return;
                    }
                    CIMObjectPath jobOp = null;
                    jobOp = jobDesc != null ? ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deleteVolume", tokenArgs, telnetcmds, jobDesc) : ModifyJobs.getInstance(this.getSystem().getHost()).createJob("deleteVolume", tokenArgs, telnetcmds);
                    request.setResults(_CONF_SERVICE_JOB_STARTED);
                    CIMArgument[] outParams = request.getOutParams();
                    outParams[0] = new CIMArgument("Job", new CIMValue((Object)jobOp));
                } else {
                    request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " unitIndex and volIndex were not discovered in" + " OtherIdentifyingInfo array"));
                }
            } else {
                request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "Discovered element is not an instance of StorEdge" + "_6120StoragePool, required for this method"));
            }
        } else {
            request.setResults(_CONF_SERVICE_INVALID_PARAMETER);
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + "The discovered element provided is not a Reference type, " + " required for this method"));
        }
    }

    private String convertBooleanToYes(boolean in) {
        if (in) {
            return "yes";
        }
        return "no";
    }

    private int getRaidLevel(int spindleRedun, boolean noSinglePoint, int dataRedun) throws CIMException {
        String METHOD = "getRaidLevel ";
        int level = -1;
        WBEMDebug.trace3((String)(CLASSNAME + "." + METHOD + " entered"));
        if (!noSinglePoint && dataRedun == 1 && spindleRedun == 0) {
            level = 0;
        } else if (noSinglePoint && dataRedun == 2) {
            if (spindleRedun == 1 || spindleRedun == 2) {
                level = 1;
            }
        } else if (noSinglePoint && dataRedun == 1 && (spindleRedun == 1 || spindleRedun == 2)) {
            level = 5;
        }
        if (level == -1) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD + " Invalid RAID level given in as parameters: " + " spindleRedundancy = " + spindleRedun + " noSinglePointOfFailure = " + noSinglePoint + " dataRedundancyMin = " + dataRedun));
            throw new CIMException("CIM_ERR_INVALID_PARAMETERinvalid RAID level");
        }
        return level;
    }

    private String getLowSeqValue(Vector valueVec) {
        int tempVal;
        if (valueVec.isEmpty()) {
            return "0";
        }
        int maxVal = Integer.parseInt((String)Collections.max(valueVec));
        WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " Have maxVal: " + maxVal + ", minVal: " + tempVal));
        if (tempVal <= 0) {
            for (tempVal = Integer.parseInt((String)Collections.min(valueVec)); tempVal < maxVal; ++tempVal) {
                if (valueVec.contains(Integer.toString(tempVal + 1))) {
                    continue;
                }
                WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " will inside return: " + (tempVal + 1)));
                return Integer.toString(tempVal + 1);
            }
            WBEMDebug.trace3((String)(CLASSNAME + "." + "getLowSeqValue" + " will return: " + (maxVal + 1)));
            return Integer.toString(maxVal + 1);
        }
        return "0";
    }

    private boolean isContiguous(Vector values, String cSize) {
        int size = Integer.parseInt(cSize);
        int maxcontinuity = 0;
        int continuity = 0;
        int[] vals = new int[values.size()];
        int i = 0;
        while (i < vals.length) {
            vals[i] = Integer.parseInt((String)values.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < vals.length - 1) {
            if (vals[i2 + 1] == vals[i2] + 1) {
                ++continuity;
            } else {
                maxcontinuity = Math.max(continuity, maxcontinuity);
                continuity = 0;
            }
            ++i2;
        }
        return maxcontinuity >= size;
    }

    private int checkForNullParams(int[] paramIndices, InvokeRequest request) throws Exception {
        int i = 0;
        while (i < paramIndices.length) {
            if (request.getInParamValue(paramIndices[i]) == null) {
                return i;
            }
            WBEMDebug.trace3((String)("Parameter " + i + " passed null value checking"));
            ++i;
        }
        return -1;
    }

    private String subtractOne(String val) {
        String result = val;
        try {
            val = Integer.toString(Integer.parseInt(val) - 1);
        }
        catch (NumberFormatException nfe) {
            WBEMDebug.trace3((String)("subtractOne received non-number string: " + val));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createStorADELock(String sysId, int code) {
        String[] lockFileDesc = new String[]{"Creating new StorageVolume", "Deleting existing StorageVolume", "Creating new StoragePool", "Deleting existing StoragePool", "Mounting a StoragePool", "Unmounting a StoragePool"};
        String METHOD = "createStorADELock";
        String MGMT_SOFT = "management_sw";
        File f = null;
        BufferedWriter w = null;
        f = new File("/tmp/" + sysId);
        w = new BufferedWriter(new FileWriter(f));
        w.write(MGMT_SOFT);
        w.newLine();
        w.write(code + ": " + lockFileDesc[code]);
        w.flush();
        Object var9_7 = null;
        if (w == null) return;
        try {
            w.close();
            return;
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
        }
        return;
        {
            catch (Exception ex) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ex);
                Object var9_8 = null;
                if (w == null) return;
                try {
                    w.close();
                    return;
                }
                catch (IOException ioe) {
                    WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (w == null) throw throwable;
            try {
                w.close();
                throw throwable;
            }
            catch (IOException ioe) {
                WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ioe);
            }
            throw throwable;
        }
    }

    public static void removeStorADELock(String sysId) {
        String METHOD = "removeStorADELock";
        File f = null;
        try {
            f = new File("/tmp/" + sysId);
            f.delete();
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + METHOD), (Throwable)ex);
        }
    }

    static {
        classMap.add("StorEdge_6120StorageConfigurationService");
        MAX_NAME_LENGTH_VOL = 80;
        MAX_NAME_LENGTH_POOL = 12;
        _LOCK_FILE_VOL_CREATE_ = 0;
        _LOCK_FILE_VOL_DELETE_ = 1;
        _LOCK_FILE_POOL_CREATE_ = 2;
        _LOCK_FILE_POOL_DELETE_ = 3;
        _LOCK_FILE_POOL_MOUNT_ = 4;
        _LOCK_FILE_POOL_UNMOUNT_ = 5;
        _CONF_SERVICE_FAILURE = new CIMValue((Object)new UnsignedInt32(4L), new CIMDataType(4));
        _CONF_SERVICE_INVALID_PARAMETER = new CIMValue((Object)new UnsignedInt32(5L), new CIMDataType(4));
        _CONF_SERVICE_COMPLETE_SUCCESSFUL = new CIMValue((Object)new UnsignedInt32(0L), new CIMDataType(4));
        _CONF_SERVICE_JOB_STARTED = new CIMValue((Object)new UnsignedInt32(4096L), new CIMDataType(4));
        CLASSNAME = "ModifyConfigService";
    }
}

