/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ExpectSession;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionException;
import com.sun.netstorage.array.mgmt.se6120.internal.InteractiveSessionPrtl;
import com.sun.netstorage.array.mgmt.se6120.internal.PatchProProperties;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class InteractiveSessionConsole
extends Thread {
    private static String CLASSNAME = "InteractiveSessionConsole";
    protected static final int BUFFERSIZE = 256;
    private BufferedReader subProcessStdOut;
    private BufferedReader subProcessStdErr;
    private InteractiveSessionPrtl interactiveSession;
    private ByteArrayOutputStream sessionBaos;
    private ByteArrayOutputStream sessionSummaryBaos;
    private Vector expectSessionList;
    private ExpectSession eS;
    private PatchProProperties properties;
    private boolean debug = false;
    private String currentLine = "";
    private char[] charBuffer = new char[256];

    public InteractiveSessionConsole(InteractiveSessionPrtl p) {
        this.interactiveSession = p;
        this.properties = PatchProProperties.getInstance();
        this.debug = this.properties.getProperty("patchpro.debug", "false").equals("true");
    }

    public void run() {
        String METHOD = "run";
        try {
            this.expectSessionList = this.interactiveSession.getExpectSessionList();
            this.subProcessStdOut = this.interactiveSession.getStdInputReader();
            this.subProcessStdErr = this.interactiveSession.getStdErrorReader();
            this.sessionBaos = this.interactiveSession.getArrayOutputStream();
            this.sessionSummaryBaos = this.interactiveSession.getSessionArrayOutputStream();
            while (true) {
                if (this.interactiveSession.getTerminateStatus()) {
                    if (this.debug) {
                        System.out.println("*** Request to terminate thread detected ***");
                    }
                    break;
                }
                if (this.subProcessStdOut.ready()) {
                    this.subProcessStdOut.read(this.charBuffer);
                    this.currentLine = new String(this.charBuffer);
                }
                if (this.subProcessStdErr.ready()) {
                    this.subProcessStdErr.read(this.charBuffer);
                    this.currentLine = new String(this.charBuffer);
                }
                int i = 0;
                while (i < 256) {
                    this.charBuffer[i] = '\u0000';
                    ++i;
                }
                if (this.currentLine == null || this.currentLine.length() == 0) continue;
                if (this.debug) {
                    System.out.print(this.currentLine);
                }
                this.sessionBaos.write(this.currentLine.getBytes(), 0, this.currentLine.length());
                this.sessionSummaryBaos.write(this.currentLine.getBytes(), 0, this.currentLine.length());
                int i2 = 0;
                while (i2 < this.expectSessionList.size()) {
                    this.eS = (ExpectSession)this.expectSessionList.elementAt(i2);
                    if (this.currentLine.indexOf(this.eS.getPattern()) != -1 && !this.eS.getResponse().equals("")) {
                        try {
                            this.interactiveSession.send(this.eS.getResponse());
                        }
                        catch (InteractiveSessionException ise) {
                            // empty catch block
                        }
                    }
                    ++i2;
                }
                this.currentLine = "";
                System.gc();
            }
        }
        catch (IOException ex) {
            WBEMDebug.trace1((String)(CLASSNAME + "." + "run"), (Throwable)ex);
        }
    }

    static {
        BUFFERSIZE = 256;
    }
}

