/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayException;
import com.sun.netstorage.array.mgmt.se6120.internal.CimInstanceXMLFilter;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMInstance;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class InstanceFormer {
    private static final String CRIMSON_PARSER = "org.apache.crimson.parser.XMLReaderImpl";

    public static List parseXml(InputStream inStream) throws ArrayException {
        return InstanceFormer.parseXmlImpl(new InputSource(inStream));
    }

    public static List parseXml(Reader reader) throws ArrayException {
        return InstanceFormer.parseXmlImpl(new InputSource(reader));
    }

    protected static List parseXmlImpl(InputSource srcXml) throws ArrayException {
        ArrayList instanceList = new ArrayList();
        long start = 0L;
        long parse = 0L;
        CimInstanceXMLFilter cimInstFilter = null;
        try {
            if (WBEMDebug.getTraceLevel() > 1) {
                start = System.currentTimeMillis();
            }
            XMLReader reader = XMLReaderFactory.createXMLReader(CRIMSON_PARSER);
            cimInstFilter = new CimInstanceXMLFilter(reader, instanceList);
            cimInstFilter.setFeature("http://xml.org/sax/features/validation", false);
            cimInstFilter.parse(srcXml);
            if (WBEMDebug.getTraceLevel() > 1) {
                parse = System.currentTimeMillis();
                WBEMDebug.trace2((String)("CIM Instance Parse Time: " + (parse - start) + "mSec"));
                WBEMDebug.trace2((String)("CIM Instances Returned: " + instanceList.size()));
            }
            return instanceList;
        }
        catch (SAXException saxe) {
            WBEMDebug.trace1((String)("Error Parsing CIM Instances, got " + instanceList.size() + " Instances."));
            if (cimInstFilter != null) {
                WBEMDebug.trace1((String)("Last Processed Instance: " + cimInstFilter.getLastInstance() + "." + cimInstFilter.getLastProperty()));
            }
            WBEMDebug.trace1((String)("Parser Exception: " + saxe));
            throw new ArrayException("Parser Exception reading XML data " + saxe.getMessage());
        }
        catch (IOException ioe) {
            WBEMDebug.trace1((String)"IOException reading from stream.");
            throw new ArrayException("IOException reading XML data " + ioe.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.out.println("Usage: java com.sun.netstorage.array.mgmt.se6120.internal.InstanceFormer Filename");
            return;
        }
        String document = args[0];
        try {
            WBEMDebug.traceOpen((String)"2", (String)"stdout");
            InstanceFormer inf = new InstanceFormer();
            System.out.println("File: " + document);
            FileReader fileReader = new FileReader(document);
            BufferedReader bufReader = new BufferedReader(fileReader);
            List instList = InstanceFormer.parseXml(bufReader);
            System.out.println("Found " + instList.size() + " Instances");
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            fileReader = new FileReader(document);
            bufReader = new BufferedReader(fileReader);
            InstanceFormer.parseXml(bufReader);
            System.out.println(((CIMInstance)instList.get(0)).toString());
        }
        catch (ArrayException ae) {
            System.out.println(ae);
            ArrayException.printExceptionChain(ae);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static {
        CRIMSON_PARSER = CRIMSON_PARSER;
    }
}

