/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.se6120.internal;

import com.sun.netstorage.array.mgmt.se6120.internal.RequestBroker;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.util.HashMap;

public class ArrayObject {
    private String host;
    private int port = 80;
    private String user;
    private String password;
    private boolean useCRAM = true;
    private boolean isAlive = true;
    private Thread refreshThread = null;
    private boolean keepRunning = true;
    private boolean cacheBeingUpdated = false;
    private static final int SLEEP_A_MINUTE = 60000;
    private int numberOfSleeps = 5;
    private static HashMap instances;

    private ArrayObject() {
    }

    public static ArrayObject getInstance(String host, String user, String pass) {
        ArrayObject ao = (ArrayObject)instances.get(host);
        if (null == ao) {
            ao = new ArrayObject();
            ao.host = host;
        }
        ao.user = user;
        ao.password = null == pass ? "" : pass;
        instances.put(ao.host, ao);
        return ao;
    }

    public static ArrayObject getInstance(String host, int port, String user, String pass) {
        ArrayObject ao = ArrayObject.getInstance(host, user, pass);
        ao.port = port;
        return ao;
    }

    public static void removeArray(ArrayObject ao) {
        instances.remove(ao.getHost());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getCRAMFlag() {
        return this.useCRAM;
    }

    public void endRefreshThread() {
        this.keepRunning = false;
        if (null != this.refreshThread) {
            this.refreshThread.interrupt();
        }
    }

    public void cacheRefreshed() {
        if (null != this.refreshThread && !this.cacheBeingUpdated) {
            this.refreshThread.interrupt();
        }
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (null != obj && obj instanceof ArrayObject) {
            ret = this.host.equals(((ArrayObject)obj).getHost());
        }
        return ret;
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    void startRefreshThread() {
        if (null != this.refreshThread) {
            return;
        }
        this.refreshThread = new Thread(new Runnable(){

            public void run() {
                while (ArrayObject.this.keepRunning) {
                    try {
                        if (!ArrayObject.this.cacheBeingUpdated) {
                            WBEMDebug.trace2((String)(ArrayObject.this + " Cache expiring... "));
                            ArrayObject.this.cacheBeingUpdated = true;
                            RequestBroker.getInstance().invalidateCache(ArrayObject.this);
                        }
                        ArrayObject.this.cacheBeingUpdated = false;
                        try {
                            int i = 0;
                            while (i < ArrayObject.this.numberOfSleeps) {
                                WBEMDebug.trace2((String)(ArrayObject.this + " Refreshing in ... " + (ArrayObject.this.numberOfSleeps - i) * 60000 + " ms"));
                                Thread.sleep(60000L);
                                ++i;
                            }
                        }
                        catch (InterruptedException iex) {
                            WBEMDebug.trace2((String)(ArrayObject.this + " Interrupted... "));
                            ArrayObject.this.cacheBeingUpdated = true;
                        }
                    }
                    catch (Exception ex) {
                        WBEMDebug.trace1((String)"", (Throwable)ex);
                    }
                }
            }
        });
        this.refreshThread.setName(this + " Refresh");
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    public boolean permitUpload() {
        return true;
    }

    public String toString() {
        return "ArrayObject:" + this.getHost();
    }

    static {
        SLEEP_A_MINUTE = 60000;
        instances = new HashMap();
    }
}

