/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.inventory;

import com.sun.netstorage.array.mgmt.se6120.internal.ArrayInventory;
import com.sun.netstorage.array.mgmt.se6120.internal.ArrayObject;
import com.sun.netstorage.array.mgmt.se6120.internal.DevComm;
import com.sun.netstorage.array.mgmt.sp.StorEdge_6x20ApplicationServer;
import com.sun.netstorage.array.mgmt.util.StorEdge_CriptoUtility;
import com.sun.netstorage.array.mgmt.util.StorEdge_InstanceProvider;
import com.sun.netstorage.array.mgmt.util.StorEdge_PersistentStorage;
import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.CIMMethodProvider;

public class StorEdge_6120Account
extends StorEdge_InstanceProvider
implements CIMMethodProvider {
    private static final String PROPS = "/opt/se6x20/resources/StorEdge_6120.properties";
    private static String validateFileName;
    private static long CACHE_EXPIRATION;
    private static final String FILENAME = "dataFile";
    private static final String PROP_SYSTEM_NAME = "SystemName";
    private static final String PROP_SYSTEM_CREATION_CLASSNAME = "SystemCreationClassName";
    private static final String PROP_CREATION_CLASSNAME = "CreationClassName";
    static final String PROP_NAME = "Name";
    static final String PROP_STATUS = "Status";
    static final String PROP_USER_ID = "UserID";
    static final String PROP_USER_PASSWORD = "UserPassword";
    static final String PROP_PERSIST_PASSWORD = "PersistPassword";
    static final String PROP_OPERATIONAL_STATUS = "OperationalStatus";
    private static final String SYSTEM_CREATION_CLASSNAME_VAL = "StorEdge_6x20ApplicationServer";
    private static final String USER_ID_VAL = "root";
    private static final String STARTING = "Starting";
    private static final int OK = 2;
    private static final int ERROR = 6;
    private static final String CLASSNAME = "StorEdge_6120Account";
    private static Vector hosts;
    private static Vector userPasswords;
    private static final String PERSISTENT_NAME = "StorEdge_6120Account.Name";
    private static final String PERSISTENT_USER_PASSWORD = "StorEdge_6120Account.UserPassword.";
    private static final String PERSISTENT_PERSIST_PASSWORD = "StorEdge_6120Account.PersistPassword.";
    private static final HashMap REGISTERED_T4S;

    public String getClassName() {
        return CLASSNAME;
    }

    public void initialize(CIMOMHandle cimom) throws CIMException {
        super.initialize(cimom);
        String METHOD = "initialize";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "initialize" + " entered"));
        WBEMDebug.trace3((String)(this.getClassName() + "." + "initialize" + " cimom handle is " + this.getCimomHandle()));
        if (this.getCimomHandle() != null) {
            CIMObjectPath cop = new CIMObjectPath("StorEdge_6120Cluster");
            cop.setNameSpace("\\root\\se6x20");
            Enumeration instances = this.getCimomHandle().enumerateInstances(cop, false, false, false, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadPropertiesFile() {
        String METHOD = "loadPropertiesFile";
        WBEMDebug.trace3((String)"StorEdge_6120Account.loadPropertiesFile Method entered.");
        try {
            try {
                FileInputStream propStream = new FileInputStream(PROPS);
                Properties props = new Properties();
                props.load(propStream);
                validateFileName = props.getProperty(FILENAME);
                WBEMDebug.trace3((String)("StorEdge_6120Account.loadPropertiesFile fileName = " + validateFileName));
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)"StorEdge_6120Account.loadPropertiesFile Unable to load properties from dataFile!!!!");
                Object var4_5 = null;
                WBEMDebug.trace3((String)"StorEdge_6120Account.loadPropertiesFile Method exiting.");
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            WBEMDebug.trace3((String)"StorEdge_6120Account.loadPropertiesFile Method exiting.");
            throw throwable;
        }
        WBEMDebug.trace3((String)"StorEdge_6120Account.loadPropertiesFile Method exiting.");
    }

    public synchronized CIMInstance getAccountInstance(String ipAddress, CIMOMHandle cimomhandle, String nameSpace) throws CIMException {
        String METHOD = "getAccountInstance";
        WBEMDebug.trace3((String)"StorEdge_6120Account.getAccountInstance entered");
        CIMInstance ci = null;
        try {
            CIMObjectPath cop = new CIMObjectPath(CLASSNAME);
            cop.setNameSpace(nameSpace);
            ci = cimomhandle.getClass(cop, false, true, true, null).newInstance();
            if (ipAddress == null || !REGISTERED_T4S.containsKey(ipAddress)) {
                WBEMDebug.trace1((String)("StorEdge_6120Account.getAccountInstance (Internal Error) Client attempted to retireve  an instance with invalid ipAddress " + ipAddress));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            ci.setProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)CLASSNAME));
            ci.setProperty(PROP_SYSTEM_CREATION_CLASSNAME, new CIMValue((Object)SYSTEM_CREATION_CLASSNAME_VAL));
            ci.setProperty(PROP_SYSTEM_NAME, new CIMValue((Object)StorEdge_6x20ApplicationServer.getHostID().toString()));
            ci.setProperty(PROP_USER_ID, new CIMValue((Object)USER_ID_VAL));
            ci.setProperty(PROP_NAME, new CIMValue((Object)ipAddress));
            T4Object t4 = (T4Object)REGISTERED_T4S.get(ipAddress);
            WBEMDebug.trace3((String)("StorEdge_6120Account.getAccountInstance Retrieved t4: " + t4));
            Vector<String> passVector = new Vector<String>();
            String password = t4.getPassword();
            if (password != null) {
                passVector.addElement(password);
            } else {
                passVector.addElement("");
            }
            ci.setProperty(PROP_USER_PASSWORD, new CIMValue(passVector));
            ci.setProperty(PROP_PERSIST_PASSWORD, new CIMValue((Object)t4.isShouldPersist()));
            int operStatus = t4.getOperationalStatus();
            Vector<UnsignedInt16> operationalStateVector = new Vector<UnsignedInt16>();
            operationalStateVector.add(new UnsignedInt16(operStatus));
            ci.setProperty(PROP_OPERATIONAL_STATUS, new CIMValue(operationalStateVector));
        }
        catch (CIMException e) {
            WBEMDebug.trace1((String)"StorEdge_6120Account.getAccountInstance failed to build instance", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)"StorEdge_6120Account.getAccountInstance failed to build instance", (Throwable)e);
            if (e instanceof CIMException) {
                throw (CIMException)((Object)e);
            }
            throw new CIMException("CIM_ERR_FAILED");
        }
        return ci;
    }

    private static int validate(String ip, String password) {
        String METHOD = "validate";
        WBEMDebug.trace3((String)"StorEdge_6120Account.validate Method entered.");
        WBEMDebug.trace3((String)(" trying to validate " + ip));
        if (validateFileName == null) {
            StorEdge_6120Account.loadPropertiesFile();
        }
        int result = 6;
        if (ip != null && password != null) {
            try {
                if (validateFileName != null) {
                    result = DevComm.getInstance().validate(ArrayObject.getInstance(ip, USER_ID_VAL, password), validateFileName) ? 2 : 6;
                }
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)"StorEdge_6120Account.validate Exception from DevComm.validate - operational  status is set to ERROR ");
                result = 6;
            }
        }
        return result;
    }

    public static CIMObjectPath getAccountObjectPath(String ipAddress, String nameSpace) throws CIMException {
        String METHOD = "getAccountObjectPath";
        WBEMDebug.trace3((String)"StorEdge_6120Account.getAccountObjectPath entered");
        CIMObjectPath result = new CIMObjectPath(CLASSNAME);
        result.setNameSpace(nameSpace);
        if (ipAddress == null || !REGISTERED_T4S.containsKey(ipAddress)) {
            WBEMDebug.trace1((String)("StorEdge_6120Account.getAccountObjectPath (Internal Error) Client attempted to retireve  an instance with invalid ipAddress " + ipAddress));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty prop = new CIMProperty(PROP_CREATION_CLASSNAME, new CIMValue((Object)CLASSNAME));
        keys.addElement(prop);
        prop = new CIMProperty(PROP_SYSTEM_CREATION_CLASSNAME, new CIMValue((Object)SYSTEM_CREATION_CLASSNAME_VAL));
        keys.addElement(prop);
        prop = new CIMProperty(PROP_SYSTEM_NAME, new CIMValue((Object)StorEdge_6x20ApplicationServer.getHostID().toString()));
        keys.addElement(prop);
        prop = new CIMProperty(PROP_NAME, new CIMValue((Object)ipAddress));
        keys.addElement(prop);
        result.setKeys(keys);
        return result;
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        String METHOD = "getInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "getInstance");
        try {
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Wrong class requested: " + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            Vector keys = op.getKeys();
            String parentClass = null;
            String ipAddress = null;
            if (keys != null) {
                int i = 0;
                while (i < keys.size()) {
                    CIMProperty prop = (CIMProperty)keys.elementAt(i);
                    if (prop.getName().equals(PROP_NAME)) {
                        ipAddress = (String)prop.getValue().getValue();
                    } else if (prop.getName().equals(PROP_SYSTEM_CREATION_CLASSNAME) && prop.getValue() != null) {
                        WBEMDebug.trace3((String)(" Property is " + prop));
                        parentClass = (String)prop.getValue().getValue();
                    }
                    ++i;
                }
            }
            WBEMDebug.trace3((String)(this.getClassName() + "." + "getInstance" + " ipAddress is " + ipAddress));
            if (parentClass != null && parentClass.equalsIgnoreCase(SYSTEM_CREATION_CLASSNAME_VAL) && REGISTERED_T4S.containsKey(ipAddress)) {
                CIMInstance ci = this.getAccountInstance(ipAddress, (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
                ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
                if (localOnly) {
                    ci.localElements();
                }
                return ci;
            }
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " (Internal Error) Client attempted to retrieve " + " access point with bad SystemCreationClassName: " + parentClass + " and Name: " + ipAddress));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (CIMException ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " unknown failure."), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "getInstance" + " Failure: "), (Throwable)ex);
            throw new CIMException(ex.getMessage());
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci, boolean includeQualifiers, String[] propertyList) throws CIMException {
        String METHOD = "setInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "setInstance" + " entered"));
        this.checkAuth("sunw.nws.provider." + this.getClassName() + "." + "setInstance");
        try {
            T4Object newT4;
            String ip;
            if (!op.getObjectName().equalsIgnoreCase(this.getClassName())) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " Wrong class requested:" + op.getObjectName()));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            if (ci.getProperty(PROP_NAME) != null && ci.getProperty(PROP_NAME).getValue() != null && REGISTERED_T4S.containsKey((String)ci.getProperty(PROP_NAME).getValue().getValue())) {
                ip = (String)ci.getProperty(PROP_NAME).getValue().getValue();
                newT4 = new T4Object((T4Object)REGISTERED_T4S.get(ip));
                if (ci.getProperty(PROP_USER_PASSWORD) != null && ci.getProperty(PROP_USER_PASSWORD).getValue() != null && ci.getProperty(PROP_USER_PASSWORD).getValue().getValue() != null) {
                    Vector userPasswordVector = (Vector)ci.getProperty(PROP_USER_PASSWORD).getValue().getValue();
                    if (userPasswordVector.size() != 1) {
                        WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " Password property not correct. "));
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                    }
                    this.setPassword((String)userPasswordVector.get(0), newT4, false);
                }
                if (ci.getProperty(PROP_PERSIST_PASSWORD) != null && ci.getProperty(PROP_PERSIST_PASSWORD).getValue() != null && ci.getProperty(PROP_PERSIST_PASSWORD).getValue().getValue() != null) {
                    Boolean persistPassword = (Boolean)ci.getProperty(PROP_PERSIST_PASSWORD).getValue().getValue();
                    newT4.setShouldPersist(persistPassword);
                }
            } else {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " Name property not correct. "));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            REGISTERED_T4S.put(ip, newT4);
            StorEdge_6120Account.persistT4Object(newT4);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)(this.getClassName() + "." + "setInstance" + " Exception is " + e.getMessage()));
        }
    }

    private synchronized void setPassword(String newPassword, T4Object t4, boolean shouldPersist) {
        String METHOD = "setPassword";
        WBEMDebug.trace3((String)"StorEdge_6120Account.setPassword Method entered.");
        if (newPassword == null || !newPassword.equals(t4.getPassword())) {
            WBEMDebug.trace3((String)"StorEdge_6120Account.setPassword calling ArrayInventroy.getInstance() .updateInventoryMember()) ");
            ArrayInventory.getInstance().updateInventoryMember(ArrayObject.getInstance(t4.getIpAddress(), USER_ID_VAL, newPassword));
            t4.setPassword(newPassword);
        }
        if (shouldPersist) {
            REGISTERED_T4S.put(t4.getIpAddress(), t4);
            StorEdge_6120Account.persistT4Object(t4);
        }
        WBEMDebug.trace3((String)"StorEdge_6120Account.setPassword Method exiting");
    }

    private static void persistT4Object(T4Object t4) {
        String METHOD = "persistT4Object";
        WBEMDebug.trace3((String)"StorEdge_6120Account.persistT4Object Method entered.");
        String ip = t4.getIpAddress();
        if (ip != null) {
            WBEMDebug.trace3((String)("StorEdge_6120Account.persistT4Object Persisting ip  " + ip));
            Vector persisted = StorEdge_PersistentStorage.getInstance().getPersistentArray(PERSISTENT_NAME);
            if (!persisted.contains(ip)) {
                persisted.addElement(ip);
                StorEdge_PersistentStorage.getInstance().setPersistentArray(PERSISTENT_NAME, persisted, true);
            }
            StorEdge_PersistentStorage.getInstance().setPersistentString(PERSISTENT_PERSIST_PASSWORD + ip, t4.isShouldPersist().toString(), true);
            if (t4.isShouldPersist().booleanValue() && t4.getPassword() != null) {
                String clearPassword = t4.getPassword();
                try {
                    byte[] encodedPass = StorEdge_CriptoUtility.doEncryption((int)0, (byte[])clearPassword.getBytes(), null);
                    StorEdge_PersistentStorage.getInstance().setPersistentEncodedString(PERSISTENT_USER_PASSWORD + ip, encodedPass, true);
                }
                catch (Exception e) {
                    WBEMDebug.trace1((String)"StorEdge_6120Account.persistT4Object Exception while decrypting  user passwords.", (Throwable)e);
                }
            } else {
                StorEdge_PersistentStorage.getInstance().removePersistentEncodedString(PERSISTENT_USER_PASSWORD + ip, true);
            }
        }
    }

    private static void unpersistT4Object(T4Object t4) {
        String METHOD = "unpersistT4Object";
        WBEMDebug.trace3((String)"StorEdge_6120Account.unpersistT4Object Method entered.");
        String ip = t4.getIpAddress();
        if (ip != null) {
            WBEMDebug.trace3((String)("StorEdge_6120Account.unpersistT4Object Unpersisting ip  " + ip));
            Vector persisted = StorEdge_PersistentStorage.getInstance().getPersistentArray(PERSISTENT_NAME);
            persisted.remove(ip);
            StorEdge_PersistentStorage.getInstance().setPersistentArray(PERSISTENT_NAME, persisted, true);
            StorEdge_PersistentStorage.getInstance().removePersistentString(PERSISTENT_PERSIST_PASSWORD + ip, true);
            StorEdge_PersistentStorage.getInstance().removePersistentEncodedString(PERSISTENT_USER_PASSWORD + ip, true);
        }
    }

    private static T4Object retrievePersistentT4Object(String ip) {
        String METHOD = "retrievePersistentT4Object";
        WBEMDebug.trace3((String)("StorEdge_6120Account.retrievePersistentT4Object Method entered for " + ip));
        StorEdge_6120Account storEdge_6120Account = new StorEdge_6120Account();
        ((Object)((Object)storEdge_6120Account)).getClass();
        T4Object t4Obj = storEdge_6120Account.new T4Object(ip);
        String shouldPersist = StorEdge_PersistentStorage.getInstance().getPersistentString(PERSISTENT_PERSIST_PASSWORD + ip);
        t4Obj.setShouldPersist(new Boolean(shouldPersist));
        byte[] encodedPassword = null;
        try {
            encodedPassword = StorEdge_PersistentStorage.getInstance().getPersistentEncodedString(PERSISTENT_USER_PASSWORD + ip);
        }
        catch (Exception e) {
            WBEMDebug.trace1((String)("StorEdge_6120Account.retrievePersistentT4Object Excepton reading from persistent storage " + e.getMessage()));
            encodedPassword = null;
        }
        if (encodedPassword != null) {
            try {
                byte[] clearPassword = StorEdge_CriptoUtility.doEncryption((int)1, (byte[])encodedPassword, null);
                t4Obj.setPassword(new String(clearPassword));
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)" Exception while decrypting user passwords.", (Throwable)e);
            }
        }
        return t4Obj;
    }

    public synchronized Vector enumerate(String nameSpace) throws CIMException {
        return this.enumerate(nameSpace, (CIMOMHandle)this.getCimomHandle());
    }

    public synchronized Vector enumerate(String nameSpace, CIMOMHandle ch) throws CIMException {
        String METHOD = "enumerate";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " entered"));
        Set ipAddresses = REGISTERED_T4S.keySet();
        WBEMDebug.trace3((String)(this.getClassName() + "." + "enumerate" + " ipAddresses " + ipAddresses));
        Vector<CIMInstance> result = new Vector<CIMInstance>();
        Iterator iterator = ipAddresses.iterator();
        while (iterator.hasNext()) {
            String ip = (String)iterator.next();
            CIMInstance instance = this.getAccountInstance(ip, ch, nameSpace);
            result.addElement(instance);
        }
        return result;
    }

    public static synchronized Vector enumerateObjectPaths(String nameSpace) throws CIMException {
        String METHOD = "enumerateObjectPaths";
        WBEMDebug.trace3((String)"StorEdge_6120Account.enumerateObjectPaths entered");
        Set ipAddresses = REGISTERED_T4S.keySet();
        WBEMDebug.trace3((String)("StorEdge_6120Account.enumerateObjectPaths ipAddresses " + ipAddresses));
        Vector<CIMObjectPath> result = new Vector<CIMObjectPath>();
        Iterator iterator = ipAddresses.iterator();
        while (iterator.hasNext()) {
            String ip = (String)iterator.next();
            CIMObjectPath instance = StorEdge_6120Account.getAccountObjectPath(ip, nameSpace);
            result.addElement(instance);
        }
        return result;
    }

    public synchronized void deleteInstance(CIMObjectPath op) throws CIMException {
        String METHOD = "deleteInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "deleteInstance" + " Method entered."));
        String ip = null;
        Vector keys = op.getKeys();
        int i = 0;
        while (i < keys.size()) {
            CIMProperty property = (CIMProperty)keys.get(i);
            if (property.getValue() != null && property.getName().equals(PROP_NAME)) {
                ip = (String)property.getValue().getValue();
            }
            ++i;
        }
        if (ip != null && REGISTERED_T4S.containsKey(ip)) {
            T4Object t4 = (T4Object)REGISTERED_T4S.get(ip);
            WBEMDebug.trace3((String)("t4 to be deleted is " + t4));
            StorEdge_6120Account.unpersistT4Object(t4);
            REGISTERED_T4S.remove(ip);
            try {
                WBEMDebug.trace3((String)("calling ArrayInventroy.getInstance() .removeInventoryMember()) for ip " + t4.getIpAddress()));
                ArrayInventory.getInstance().removeInventoryMember(ArrayObject.getInstance(t4.getIpAddress(), USER_ID_VAL, t4.getPassword()));
                WBEMDebug.trace3((String)"call returned ");
            }
            catch (Exception e) {
                WBEMDebug.trace1((String)" Exception while removingInventory member  on ArrayInventory.");
                e.printStackTrace();
            }
        } else {
            if (ip == null) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " Name property has to be specified for " + " creating an instance"));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            WBEMDebug.trace1((String)(this.getClassName() + "." + "deleteInstance" + " Instance with specified ip already exists : " + ip));
            throw new CIMException("CIM_ERR_NOT_FOUND");
        }
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        T4Object t4;
        String METHOD = "createInstance";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "createInstance" + " entered"));
        String ip = null;
        String password = null;
        Boolean persist = new Boolean(false);
        CIMInstance result = ci;
        boolean shouldValidate = true;
        Vector properties = ci.getProperties();
        int i = 0;
        while (i < properties.size()) {
            CIMProperty property = (CIMProperty)properties.get(i);
            if (property.getValue() != null) {
                if (property.getName().equals(PROP_NAME)) {
                    ip = (String)property.getValue().getValue();
                } else if (property.getName().equals(PROP_PERSIST_PASSWORD)) {
                    persist = (Boolean)property.getValue().getValue();
                } else if (property.getName().equals(PROP_USER_PASSWORD)) {
                    Vector userPasswords = (Vector)property.getValue().getValue();
                    if (userPasswords.size() >= 1) {
                        password = (String)userPasswords.get(0);
                    }
                } else if (property.getName().equals(PROP_STATUS) && property.getValue() != null && property.getValue().getValue() != null) {
                    String status = (String)property.getValue().getValue();
                    shouldValidate = !STARTING.equals(status);
                }
            }
            ++i;
        }
        if (ip != null && !REGISTERED_T4S.containsKey(ip) && password != null) {
            WBEMDebug.trace3((String)"StorEdge_6120Account.createInstance \n Adding the array to inventory before validation ");
            ArrayInventory.getInstance().addInventoryMember(ArrayObject.getInstance(ip, USER_ID_VAL, password));
            t4 = new T4Object(ip);
            t4.setPassword(password, shouldValidate);
            WBEMDebug.trace3((String)("t4 is created " + t4));
            if (t4.getOperationalStatus() != 2) {
                WBEMDebug.trace3((String)"StorEdge_6120Account.createInstance \n Removing array from inventory since validation failed ");
                ArrayInventory.getInstance().removeInventoryMember(ArrayObject.getInstance(ip, USER_ID_VAL, password));
                WBEMDebug.trace3((String)"StorEdge_6120Account.createInstance Throwing Invalid password exception");
                CIMException exc = new CIMException("CIM_ERR_FAILED");
                exc.setDescription("Invalid HTTP credentials.");
                throw exc;
            }
        } else {
            if (ip == null && password == null) {
                WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " Name and UserPassword propertes have to be specified for" + " creating an instance"));
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            WBEMDebug.trace1((String)(this.getClassName() + "." + "createInstance" + " Instance with specified ip already exists : " + ip));
            CIMException exc = new CIMException("CIM_ERR_FAILED");
            exc.setDescription("Attempt to create duplicate array.");
            throw exc;
        }
        t4.setShouldPersist(persist);
        WBEMDebug.trace3((String)("t4 is " + t4));
        REGISTERED_T4S.put(ip, t4);
        StorEdge_6120Account.persistT4Object(t4);
        result = this.getAccountInstance(ip, (CIMOMHandle)this.getCimomHandle(), op.getNameSpace());
        WBEMDebug.trace3((String)("StorEdge_6120Account.createInstancecalling ArrayInventroy.getInstance() .addInventoryMember()) for ip " + t4.getIpAddress()));
        ArrayInventory.getInstance().addInventoryMember(ArrayObject.getInstance(t4.getIpAddress(), USER_ID_VAL, t4.getPassword()));
        WBEMDebug.trace3((String)"StorEdge_6120Account.createInstance Call returned");
        return result.getObjectPath();
    }

    public CIMValue invokeMethod(CIMObjectPath op, String methodName, CIMArgument[] inParams, CIMArgument[] outParams) throws CIMException {
        String METHOD = "invokeMethod";
        WBEMDebug.trace3((String)(this.getClassName() + "." + "invokeMethod" + " Method entered."));
        CIMValue result = new CIMValue((Object)new Integer(0));
        if (op.getObjectName().equalsIgnoreCase(this.getClassName()) && methodName.equalsIgnoreCase("setPassword") && inParams != null && inParams.length >= 1) {
            CIMValue newPassArgValue = inParams[0].getValue();
            if (newPassArgValue != null) {
                String newPassword = (String)newPassArgValue.getValue();
                Vector keys = op.getKeys();
                String ip = null;
                int i = 0;
                while (i < keys.size()) {
                    CIMProperty prop = (CIMProperty)keys.get(i);
                    if (prop.getName().equalsIgnoreCase(PROP_NAME) && prop.getValue() != null) {
                        ip = (String)prop.getValue().getValue();
                        break;
                    }
                    ++i;
                }
                if (ip != null && REGISTERED_T4S.containsKey(ip)) {
                    T4Object t4 = (T4Object)REGISTERED_T4S.get(ip);
                    WBEMDebug.trace3((String)("StorEdge_6120Account.invokeMethod Changing password on " + t4));
                    int status = t4.forceValidation();
                    WBEMDebug.trace3((String)(this.getClassName() + "." + "invokeMethod" + "Status is " + status));
                    String oldPassword = t4.getPassword();
                    if (oldPassword != null && !newPassword.equals(oldPassword) && status == 2) {
                        ArrayObject t4OldArrayObject = ArrayObject.getInstance(t4.getIpAddress(), USER_ID_VAL, oldPassword);
                        WBEMDebug.trace3((String)(this.getClassName() + "." + "invokeMethod" + " Calling the telnet passwd on " + t4OldArrayObject.getHost()));
                        String[] cmds = new String[]{"passwd", oldPassword, newPassword, newPassword};
                        String[] responses = new String[]{"OLD password", "NEW password", "NEW password"};
                        String[] prompts = new String[]{"OLD password", "NEW password", "NEW password", null};
                        String[] errorResponses = new String[]{"system password not changed"};
                        try {
                            result = new CIMValue((Object)new Integer(4));
                            DevComm.getInstance().telnetMultiPost(t4OldArrayObject, cmds, responses, errorResponses, prompts, new int[0]);
                            WBEMDebug.trace3((String)"telnet returned successfully");
                            result = new CIMValue((Object)new Integer(5));
                            this.setPassword(newPassword, t4, true);
                            result = new CIMValue((Object)new Integer(0));
                        }
                        catch (Exception e) {
                            WBEMDebug.trace1((String)" Exception ", (Throwable)e);
                        }
                    } else if (status == 6) {
                        WBEMDebug.trace3((String)(this.getClassName() + "." + "invokeMethod" + " Password couldn't be validates against t4"));
                        result = new CIMValue((Object)new Integer(3));
                    }
                } else {
                    WBEMDebug.trace3((String)(this.getClassName() + "." + "invokeMethod" + " ip is null or not registered " + ip));
                    result = new CIMValue((Object)new Integer(2));
                }
            } else {
                result = new CIMValue((Object)new Integer(1));
            }
        } else {
            result = new CIMValue((Object)new Integer(1));
        }
        WBEMDebug.trace3((String)(this.getClassName() + "." + "invokeMethod" + " Method exiting."));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        PROPS = PROPS;
        validateFileName = null;
        CACHE_EXPIRATION = 2L;
        FILENAME = FILENAME;
        PROP_SYSTEM_NAME = PROP_SYSTEM_NAME;
        PROP_SYSTEM_CREATION_CLASSNAME = PROP_SYSTEM_CREATION_CLASSNAME;
        PROP_CREATION_CLASSNAME = PROP_CREATION_CLASSNAME;
        PROP_NAME = PROP_NAME;
        PROP_STATUS = PROP_STATUS;
        PROP_USER_ID = PROP_USER_ID;
        PROP_USER_PASSWORD = PROP_USER_PASSWORD;
        PROP_PERSIST_PASSWORD = PROP_PERSIST_PASSWORD;
        PROP_OPERATIONAL_STATUS = PROP_OPERATIONAL_STATUS;
        SYSTEM_CREATION_CLASSNAME_VAL = SYSTEM_CREATION_CLASSNAME_VAL;
        USER_ID_VAL = USER_ID_VAL;
        STARTING = STARTING;
        OK = 2;
        ERROR = 6;
        CLASSNAME = CLASSNAME;
        hosts = new Vector();
        userPasswords = new Vector();
        PERSISTENT_NAME = PERSISTENT_NAME;
        PERSISTENT_USER_PASSWORD = PERSISTENT_USER_PASSWORD;
        PERSISTENT_PERSIST_PASSWORD = PERSISTENT_PERSIST_PASSWORD;
        REGISTERED_T4S = new HashMap();
        Vector registeredT4s = StorEdge_PersistentStorage.getInstance().getPersistentArray(PERSISTENT_NAME);
        HashMap hashMap = REGISTERED_T4S;
        synchronized (hashMap) {
            int i = 0;
            while (i < registeredT4s.size()) {
                String ip = (String)registeredT4s.get(i);
                T4Object t4Obj = StorEdge_6120Account.retrievePersistentT4Object(ip);
                REGISTERED_T4S.put(ip, t4Obj);
                ++i;
            }
        }
        StorEdge_6120Account.loadPropertiesFile();
    }

    public class T4Object {
        private static final String CLASSNAME = "T4Object";
        private Boolean shouldPersist;
        private String password;
        private String ipAddress;
        private int operationalStatus = 6;
        private long operationalStatusUpdated = System.currentTimeMillis();

        T4Object(T4Object t4) {
            this.ipAddress = t4.getIpAddress();
            this.setPassword(t4.getPassword());
            this.setShouldPersist(t4.isShouldPersist());
            this.forceValidation();
        }

        T4Object(String ip) {
            this.ipAddress = ip;
            this.setPassword(null);
            this.setShouldPersist(new Boolean(false));
            this.forceValidation();
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getPassword() {
            return this.password;
        }

        public Boolean isShouldPersist() {
            return this.shouldPersist;
        }

        private void updateOperationalStatus() {
            String METHOD = "upadateOperationalStatus";
            WBEMDebug.trace3((String)"T4Object.upadateOperationalStatus Method entered.");
            long difference = System.currentTimeMillis() - this.getOperationalStatusUpdated();
            WBEMDebug.trace3((String)("T4Object.upadateOperationalStatus difference is  " + difference));
            if (difference < 0L || difference >= CACHE_EXPIRATION * 60000L) {
                WBEMDebug.trace3((String)"T4Object.upadateOperationalStatus Updating cached operational status ");
                this.forceValidation();
            }
            WBEMDebug.trace3((String)"T4Object.upadateOperationalStatus Method exiting.");
        }

        private int forceValidation() {
            if (this.getIpAddress() != null && this.getPassword() != null) {
                this.setOperationalStatus(StorEdge_6120Account.validate(this.getIpAddress(), this.getPassword()));
            } else {
                this.setOperationalStatus(6);
            }
            return this.getOperationalStatus();
        }

        public void setPassword(String password) {
            String METHOD = "setPassword";
            WBEMDebug.trace3((String)"T4Object.setPassword Method entered.");
            this.setPassword(password, true);
            WBEMDebug.trace3((String)"T4Object.setPassword Method exited.");
        }

        public void setPassword(String password, boolean shouldValidate) {
            String METHOD = "setPassword";
            WBEMDebug.trace3((String)"T4Object.setPassword Method entered.");
            this.password = password;
            if (!shouldValidate) {
                this.setOperationalStatus(2);
            } else {
                this.forceValidation();
            }
            WBEMDebug.trace3((String)"T4Object.setPassword Method exited.");
        }

        public void setShouldPersist(Boolean shouldPersist) {
            this.shouldPersist = shouldPersist;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("\n T4: ");
            result.append("\n ip = " + this.getIpAddress());
            result.append("\n password = " + (this.getPassword() != null ? "******" : "NULL"));
            result.append("\n shouldPersist = " + this.isShouldPersist());
            result.append("\n operationalStatus = " + this.getOperationalStatus());
            result.append("\n operationalStatusUpdated = " + this.getOperationalStatusUpdated());
            return result.toString();
        }

        public int getOperationalStatus() {
            this.updateOperationalStatus();
            return this.operationalStatus;
        }

        private void setOperationalStatus(int operationalStatus) {
            this.operationalStatus = operationalStatus;
            this.operationalStatusUpdated = System.currentTimeMillis();
        }

        public long getOperationalStatusUpdated() {
            return this.operationalStatusUpdated;
        }

        static {
            CLASSNAME = CLASSNAME;
        }
    }
}

