/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.util;

import com.sun.netstorage.array.mgmt.util.ProviderLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public final class WBEMDebug {
    private static final boolean ON = true;
    private static final String TRACE_DIR = "/var/tmp";
    private static final String TRACE_STDOUT_NAME = "stdout";
    private static final String TRACE_STDERR_NAME = "stderr";
    private static final int TRACE_OFF = 0;
    private static final int TRACE_STDOUT = 1;
    private static final int TRACE_STDERR = 2;
    private static final int TRACE_FILE = 3;
    private static final int TRACE_RETRY = 5;
    private static boolean traceInit;
    private static int traceLevel;
    private static boolean traceTime;
    private static boolean traceMethod;
    private static boolean traceThread;
    private static int traceOut;
    private static FileWriter traceFW;
    private static BufferedWriter traceBW;
    private static PrintWriter tracePW;
    static final String sccs_id = "@(#)Debug.java 1.2  02/02/13 SMI";

    public static final void traceOpen(String level, String filename) {
        WBEMDebug.openTrace(level, filename);
    }

    public static final boolean isOn() {
        return traceLevel > 0;
    }

    public static final int getTraceLevel() {
        return traceLevel;
    }

    public static final void trace1(String message) {
        if (traceLevel > 0) {
            WBEMDebug.writeTrace(message);
        }
        ProviderLogger.getInstance();
        ProviderLogger.log(Level.SEVERE, message);
    }

    public static final void trace1(String message, Throwable ex) {
        if (traceLevel > 0) {
            WBEMDebug.writeTrace(message);
            if (ex != null) {
                WBEMDebug.writeStackTrace(ex);
            }
        }
        ProviderLogger.getInstance();
        ProviderLogger.log(Level.SEVERE, message, ex);
    }

    public static final void trace2(String message) {
        if (traceLevel > 1) {
            WBEMDebug.writeTrace(message);
        }
        ProviderLogger.getInstance();
        ProviderLogger.log(Level.WARNING, message);
    }

    public static final void trace2(String message, Throwable ex) {
        if (traceLevel > 1) {
            WBEMDebug.writeTrace(message);
            if (ex != null) {
                WBEMDebug.writeStackTrace(ex);
            }
        }
        ProviderLogger.getInstance();
        ProviderLogger.log(Level.WARNING, message, ex);
    }

    public static final void trace3(String message) {
        if (traceLevel > 2) {
            WBEMDebug.writeTrace(message);
        }
        ProviderLogger.getInstance();
        ProviderLogger.log(Level.INFO, message);
    }

    public static final void trace3(String message, Throwable ex) {
        if (traceLevel > 2) {
            WBEMDebug.writeTrace(message);
            if (ex != null) {
                WBEMDebug.writeStackTrace(ex);
            }
        }
        ProviderLogger.getInstance();
        ProviderLogger.log(Level.INFO, message, ex);
    }

    private static void openTrace(String level, String filename) {
        String traceFile = null;
        String traceSufx = null;
        if (traceInit) {
            return;
        }
        traceLevel = 0;
        traceTime = false;
        traceMethod = false;
        traceThread = false;
        if (level != null) {
            Integer ix;
            try {
                ix = new Integer(level.substring(0, 1));
            }
            catch (Exception ex) {
                ix = new Integer(0);
            }
            traceLevel = ix;
            if (level.indexOf(116) > 0) {
                traceTime = true;
            }
            if (level.indexOf(109) > 0) {
                traceMethod = true;
            }
            if (level.indexOf(112) > 0) {
                traceThread = true;
            }
        }
        if (traceLevel == 0) {
            return;
        }
        if (filename != null && filename.trim().length() != 0) {
            if (filename.equals(TRACE_STDOUT_NAME)) {
                traceOut = 1;
            } else if (filename.equals(TRACE_STDERR_NAME)) {
                traceOut = 2;
            } else {
                traceOut = 3;
                traceFile = filename.trim();
            }
        } else {
            traceLevel = 2;
        }
        if (traceOut == 3 && traceLevel > 0) {
            if (traceFile.indexOf(File.separatorChar) < 0) {
                traceFile = WBEMDebug.getLogDir() + File.separator + traceFile;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("MMdd_HHmm");
            traceSufx = "_" + sdf.format(new Date());
            String name = traceFile = traceFile + traceSufx;
            int i = 1;
            while (i < 5) {
                try {
                    File fd1 = new File(name);
                    if (!fd1.exists()) break;
                    name = traceFile + "_" + i;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
            if (i < 5) {
                try {
                    traceFW = new FileWriter(name);
                    traceBW = new BufferedWriter(traceFW);
                    tracePW = new PrintWriter((Writer)traceBW, true);
                }
                catch (Exception ex) {
                    traceLevel = 0;
                }
            } else {
                traceLevel = 0;
            }
        }
        traceInit = true;
    }

    private static void writeStackTrace(Throwable ex) {
        try {
            if (traceOut == 3) {
                ex.printStackTrace(tracePW);
            } else if (traceOut == 1) {
                ex.printStackTrace(System.out);
            } else if (traceOut == 2) {
                ex.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getLogDir() {
        return TRACE_DIR;
    }

    private static String getClassMethod() {
        String clm = null;
        try {
            String line;
            InputStream is = WBEMDebug.getStackStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            do {
                if (null != (line = br.readLine())) continue;
                return "??:??";
            } while (!WBEMDebug.getCaller(line).equals("Debug:writeTrace"));
            br.readLine();
            line = br.readLine();
            if (null == line) {
                return "??:??";
            }
            clm = WBEMDebug.getCaller(line);
            br.close();
        }
        catch (Exception ex) {
            clm = "??:??";
        }
        return clm;
    }

    private static synchronized void writeTrace(String msg) {
        String traceMsg = "NWS: ";
        if (traceTime) {
            Time tim = new Time(System.currentTimeMillis());
            traceMsg = traceMsg + tim.toString() + " | ";
        }
        if (traceThread) {
            Thread th = Thread.currentThread();
            traceMsg = traceMsg + th.getName() + " | ";
        }
        if (traceMethod) {
            traceMsg = traceMsg + WBEMDebug.getClassMethod() + " | ";
        }
        traceMsg = traceMsg + msg;
        try {
            if (traceOut == 3) {
                tracePW.println(traceMsg);
            } else if (traceOut == 1) {
                System.out.println(traceMsg);
            } else if (traceOut == 2) {
                System.err.println(traceMsg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream getStackStream() {
        ByteArrayInputStream is = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter pw = new PrintWriter(os);
            new Exception().printStackTrace(pw);
            pw.close();
            is = new ByteArrayInputStream(os.toByteArray());
        }
        catch (Exception ex) {
            is = null;
        }
        return is;
    }

    private static String getCaller(String line) {
        String str = line;
        int i = line.indexOf(40);
        if (i > 0) {
            str = line.substring(0, i);
        }
        if ((i = str.indexOf("at")) > 0) {
            str = str.substring(i + 3);
        }
        if ((i = str.lastIndexOf(46)) > 0) {
            String mth = str.substring(i + 1);
            String cls = (i = (str = str.substring(0, i)).lastIndexOf(46)) > 0 ? str.substring(i + 1) : str;
            str = cls + ":" + mth;
        }
        return str;
    }

    static {
        ON = true;
        TRACE_DIR = TRACE_DIR;
        TRACE_STDOUT_NAME = TRACE_STDOUT_NAME;
        TRACE_STDERR_NAME = TRACE_STDERR_NAME;
        TRACE_OFF = 0;
        TRACE_STDOUT = 1;
        TRACE_STDERR = 2;
        TRACE_FILE = 3;
        TRACE_RETRY = 5;
        traceInit = false;
        traceLevel = 0;
        traceTime = false;
        traceMethod = false;
        traceThread = false;
        traceOut = 2;
        sccs_id = sccs_id;
    }
}

