/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.util;

import com.sun.netstorage.array.mgmt.util.WBEMDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class StorEdge_CriptoUtility {
    private static final String CLASSNAME = "StorEdge_CriptoUtility";
    public static final int ENCRYPT = 0;
    public static final int DECRYPT = 1;
    private static final String ALGORITHM = "DES/ECB/PKCS5Padding";
    private static final String KEYSTORE_DEFAULT = "/opt/se6x20/.providerkeystore";
    private static final String ALIAS = "maserati";
    private static final String PASSWORD = "masPass";
    private static KeyGenerator keyGenerator;
    private static String keyStorePath;
    private static KeyStore keyStore;
    private static Cipher cipher;

    private static Cipher getCipher() throws GeneralSecurityException {
        if (cipher == null) {
            cipher = Cipher.getInstance(ALGORITHM);
        }
        return cipher;
    }

    public static SecretKey getSecretKey() throws Exception {
        String METHOD = "getSecretKey";
        WBEMDebug.trace3("StorEdge_CriptoUtility.getSecretKey Method entered.");
        WBEMDebug.trace3("StorEdge_CriptoUtility.getSecretKey Getting the key ");
        SecretKey result = null;
        File keyStoreFile = new File(keyStorePath);
        if (!keyStoreFile.exists()) {
            StorEdge_CriptoUtility.createKeyStore();
        }
        FileInputStream in = new FileInputStream(keyStoreFile);
        if (keyStore == null) {
            keyStore = KeyStore.getInstance("JCEKS", "SunJCE");
            keyStore.load(in, null);
        }
        result = (SecretKey)keyStore.getKey(ALIAS, PASSWORD.toCharArray());
        WBEMDebug.trace3("StorEdge_CriptoUtility.getSecretKey key now is " + result);
        return result;
    }

    public static byte[] doEncryption(int action, byte[] text, Key key) throws Exception {
        String METHOD = "doEncryption";
        WBEMDebug.trace3("StorEdge_CriptoUtility.doEncryption Method entered.");
        if (key == null) {
            key = StorEdge_CriptoUtility.getSecretKey();
        }
        WBEMDebug.trace2("StorEdge_CriptoUtility.doEncryption Secret key is " + key);
        if (cipher == null) {
            cipher = Cipher.getInstance(ALGORITHM);
        }
        byte[] result = null;
        if (action == 0) {
            cipher.init(1, key);
            result = cipher.doFinal(text);
        } else {
            cipher.init(2, key);
            result = cipher.doFinal(text);
        }
        WBEMDebug.trace3("StorEdge_CriptoUtility.doEncryption Method exited.");
        return result;
    }

    private static void createKeyStore() throws Exception {
        String METHOD = "getKeyStore";
        WBEMDebug.trace3("StorEdge_CriptoUtility.getKeyStore Method entered.");
        WBEMDebug.trace2("StorEdge_CriptoUtility.getKeyStore Creating key store");
        KeyGenerator keyGen = KeyGenerator.getInstance("DES");
        SecretKey desKey = keyGen.generateKey();
        keyStore = KeyStore.getInstance("JCEKS", "SunJCE");
        keyStore.load(null, PASSWORD.toCharArray());
        Certificate[] chain = new Certificate[]{};
        keyStore.setKeyEntry(ALIAS, desKey, PASSWORD.toCharArray(), chain);
        FileOutputStream f = new FileOutputStream(keyStorePath);
        keyStore.store(f, PASSWORD.toCharArray());
    }

    static {
        CLASSNAME = CLASSNAME;
        ENCRYPT = 0;
        DECRYPT = 1;
        ALGORITHM = ALGORITHM;
        KEYSTORE_DEFAULT = KEYSTORE_DEFAULT;
        ALIAS = ALIAS;
        PASSWORD = PASSWORD;
        keyStorePath = System.getProperty("account.keystore", KEYSTORE_DEFAULT);
    }
}

