/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.Poller;
import auth.utauthd.WatchIOListener;
import auth.utauthd.WatchIORequest;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class WatchIO
implements Runnable,
WatchIOListener {
    public static final short INPUT = 1;
    private static final int FIRSTLIMIT = 32;
    private static final int INCREMENT = 1024;
    private WatchIORequest[] mapping = new WatchIORequest[32];
    private Poller mux;
    private int[] fds = new int[32];
    private short[] revents = new short[32];
    private TreeSet timeSortedList = new TreeSet();
    private static WatchIO watcher;
    private static Thread thread;
    private Object inhibitUpdatesLock = new Object();
    private boolean inhibitUpdates = false;
    private Object updatesPendingLock = new Object();
    private int updatesPending = 0;
    FileInputStream alertInStream;
    FileOutputStream alertOutStream;
    FileDescriptor pipeIn;
    int pipeInFDN;

    static {
        System.loadLibrary("watchio");
        if (watcher == null) {
            watcher = new WatchIO();
            thread = new Thread((Runnable)watcher, "WatchIO");
            thread.start();
        }
    }

    private WatchIO() {
        int n = 0;
        while (n < this.mapping.length) {
            this.mapping[n] = null;
            this.fds[n] = 0;
            this.revents[n] = 0;
            ++n;
        }
        try {
            this.mux = new Poller();
        }
        catch (Exception exception) {
            Log.unexpectedError((String)"Cannot initializer Poller object");
            System.exit(1);
        }
        int[] nArray = WatchIO.pipe();
        Class<?> clazz = null;
        Field field = null;
        try {
            clazz = Class.forName("java.io.FileDescriptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.unexpectedError((String)("program error: " + classNotFoundException));
            System.exit(1);
        }
        try {
            field = clazz.getDeclaredField("fd");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.unexpectedError((String)("program error: " + noSuchFieldException));
            System.exit(1);
        }
        ((AccessibleObject)field).setAccessible(true);
        FileDescriptor fileDescriptor = new FileDescriptor();
        try {
            field.set(fileDescriptor, new Integer(nArray[0]));
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.unexpectedError((String)("program error: " + illegalAccessException));
        }
        this.alertOutStream = new FileOutputStream(fileDescriptor);
        this.pipeIn = new FileDescriptor();
        this.pipeInFDN = nArray[1];
        try {
            field.set(this.pipeIn, new Integer(this.pipeInFDN));
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.unexpectedError((String)("program error: " + illegalAccessException));
        }
        this.alertInStream = new FileInputStream(this.pipeIn);
        try {
            this.doAdd(new WatchIORequest(this.alertInStream.getFD(), 1, this, false, "alert"));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)exception.toString());
            System.exit(1);
        }
    }

    public static void add(WatchIORequest watchIORequest) {
        watcher.addRemove(watchIORequest, true);
    }

    private void addRemove(WatchIORequest watchIORequest, boolean bl) {
        if (Thread.currentThread() == thread) {
            if (bl) {
                watcher.doAdd(watchIORequest);
            } else {
                watcher.doRemove(watchIORequest);
            }
            return;
        }
        Object object = this.updatesPendingLock;
        synchronized (object) {
            if (this.updatesPending++ == 0) {
                try {
                    this.alert();
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)"WatchIO.addRemove: alert");
                }
            }
        }
        object = this.inhibitUpdatesLock;
        synchronized (object) {
            while (this.inhibitUpdates) {
                try {
                    this.inhibitUpdatesLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.unexpectedError((String)"WatchIO.addRemove: inhibitUpdatesLock intr");
                }
                if (!this.inhibitUpdates) continue;
                Log.unexpectedError((String)"WatchIO.addRemove: still waiting for inhibitUpdatesLock");
            }
            if (bl) {
                this.doAdd(watchIORequest);
            } else {
                this.doRemove(watchIORequest);
            }
        }
        object = this.updatesPendingLock;
        synchronized (object) {
            if (--this.updatesPending < 0) {
                Log.unexpectedError((String)"WatchIO.addRemove: program error");
            }
            if (this.updatesPending == 0) {
                this.updatesPendingLock.notifyAll();
            }
        }
    }

    private void alert() {
        try {
            this.alertOutStream.write(0);
            this.alertOutStream.flush();
        }
        catch (IOException iOException) {
            Log.unexpectedError((String)("WatchIO.alert: " + iOException));
        }
    }

    private static native void clearAlert(int var0) throws IOException;

    private synchronized void doAdd(WatchIORequest watchIORequest) {
        int n;
        try {
            n = this.mux.add(watchIORequest.getFdObj(), watchIORequest.mask);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("WatchIO.doAdd: cannot add wl socket to mux: " + exception));
            n = -1;
            System.exit(1);
        }
        if (this.mapping.length < n + 1) {
            int n2 = n + 1023 & 0xFFFFFC00;
            WatchIORequest[] watchIORequestArray = new WatchIORequest[n2];
            int n3 = 0;
            while (n3 < this.mapping.length) {
                watchIORequestArray[n3] = this.mapping[n3];
                this.mapping[n3] = null;
                ++n3;
            }
            this.mapping = watchIORequestArray;
        }
        if (watchIORequest == null) {
            Log.unexpectedError((String)"add null WatchIORequest!");
            System.exit(1);
        }
        this.mapping[n] = watchIORequest;
        if (watchIORequest.resetExpiryTime()) {
            WatchIORequest watchIORequest2 = watchIORequest;
            synchronized (watchIORequest2) {
                watchIORequest.busy = true;
                this.timeSortedList.add(watchIORequest);
            }
        }
    }

    private synchronized void doRemove(WatchIORequest watchIORequest) {
        int n;
        if (watchIORequest == null) {
            Log.unexpectedError((String)"WatchIO.doRemove(null)");
            return;
        }
        if (watchIORequest.isActiveAlarm()) {
            WatchIORequest watchIORequest2 = watchIORequest;
            synchronized (watchIORequest2) {
                watchIORequest.busy = false;
                this.timeSortedList.remove(watchIORequest);
            }
        }
        if ((n = watchIORequest.getFd()) == -1) {
            Log.unexpectedError((String)("WatchIO.doRemove: cannot get fd for " + watchIORequest));
            return;
        }
        WatchIORequest watchIORequest3 = this.mapping[n];
        FileDescriptor fileDescriptor = watchIORequest.getFdObj();
        if (watchIORequest3 != null && watchIORequest3.getFdObj() == fileDescriptor && watchIORequest3 == watchIORequest) {
            try {
                this.mux.remove(fileDescriptor);
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("WatchIO.doRemove: " + exception));
                System.exit(1);
            }
            this.mapping[n] = null;
        }
    }

    private static native int[] pipe();

    private void printQueue(String string, int n) {
        System.out.println(String.valueOf(string) + "WatchIO queue: " + (n <= 0 ? "empty" : "(" + n + ")"));
        int n2 = 0;
        while (n2 < n) {
            System.out.print(String.valueOf(string) + "    " + n2 + ": ");
            int n3 = this.fds[n2];
            System.out.print(String.valueOf(n3) + ", ");
            if (n3 >= 0) {
                System.out.println(this.mapping[n3]);
            } else {
                System.out.println("invalid");
            }
            ++n2;
        }
        System.out.println("");
    }

    public static void remove(WatchIORequest watchIORequest) {
        watcher.addRemove(watchIORequest, false);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        var1_1 = 0;
        var2_2 = 0;
        var4_3 = 0L;
        var6_4 = null;
        try lbl-1000:
        // 2 sources

        {
            while (true) {
                var3_5 = null;
                var7_7 = this.inhibitUpdatesLock;
                synchronized (var7_7) {
                    this.inhibitUpdates = false;
                    this.inhibitUpdatesLock.notifyAll();
                }
                var7_7 = this.updatesPendingLock;
                synchronized (var7_7) {
                    while (true) {
                        if (this.updatesPending <= 0) {
                            break;
                        }
                        try {
                            this.updatesPendingLock.wait();
                        }
                        catch (InterruptedException v1) {
                            Log.unexpectedError((String)"updatesPendingLock intr");
                        }
                    }
                }
                var7_7 = this.inhibitUpdatesLock;
                synchronized (var7_7) {
                    this.inhibitUpdates = true;
                    this.inhibitUpdatesLock.notifyAll();
                }
                var6_4 = null;
                try {
                    var6_4 = (WatchIORequest)this.timeSortedList.first();
                }
                catch (NoSuchElementException v4) {}
                var7_6 = -1L;
                if (var6_4 != null) {
                    var7_6 = var6_4.getExpiryTime() - System.currentTimeMillis();
                    if (var7_6 <= 0L) {
                        var7_6 = 1L;
                    }
                    var6_4 = null;
                }
                try {
                    var1_1 = this.mux.waitMultiple(this.fds, this.revents, var7_6);
                }
                catch (Exception var9_10) {
                    Log.unexpectedError((String)("WatchIO.run: program error: " + var9_10));
                    System.exit(1);
                }
                var4_3 = System.currentTimeMillis();
                var2_2 = 0;
                while (var2_2 < var1_1) {
                    if (this.fds[var2_2] != -1) {
                        if (this.revents[var2_2] == 0) {
                            Log.unexpectedError((String)"WatchIO.run: revents=0");
                        }
                        if ((var3_5 = this.mapping[this.fds[var2_2]]) != null) {
                            if (var3_5.isAutoRemove()) {
                                this.doRemove(var3_5);
                            }
                            if (var3_5.isExpired(var4_3)) {
                                v5 = var2_2;
                                this.revents[v5] = (short)(this.revents[v5] | 4096);
                                var9_9 = var3_5;
                                synchronized (var9_9) {
                                    var3_5.busy = false;
                                    this.timeSortedList.remove(var3_5);
                                }
                            }
                            if (var3_5.listener.watchIOEvent(this.revents[var2_2], var3_5.arg)) {
                                if (var3_5.isAutoRemove()) {
                                    var3_5.resetExpiryTime();
                                    WatchIO.watcher.doAdd(var3_5);
                                }
                            } else if (!var3_5.isAutoRemove()) {
                                this.doRemove(var3_5);
                            }
                        }
                    }
                    ++var2_2;
                }
                break;
            }
        }
        catch (Exception var7_8) {
            Log.unexpectedError((String)("WatchIO.run():" + var7_8));
            return;
        }
        while (true) {
            try {
                var3_5 = (WatchIORequest)this.timeSortedList.first();
            }
            catch (NoSuchElementException v7) {
                var3_5 = null;
            }
            if (var3_5 == null || !var3_5.isExpired(var4_3)) break;
            if (var3_5.isAutoRemove()) {
                this.doRemove(var3_5);
            }
            if (var3_5.listener.watchIOEvent((short)4096, var3_5.arg)) {
                if (!var3_5.isAutoRemove()) continue;
                var3_5.resetExpiryTime();
                WatchIO.watcher.doAdd(var3_5);
                continue;
            }
            if (var3_5.isAutoRemove()) continue;
            this.doRemove(var3_5);
        }
        var3_5 = null;
        ** while (true)
    }

    public boolean watchIOEvent(short s, Object object) {
        try {
            WatchIO.clearAlert(this.pipeInFDN);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("clearAlert(): " + exception));
            System.exit(1);
        }
        return true;
    }
}

