/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.admin.UTDtuGroup;
import auth.admin.User;
import auth.sdk.Log;
import auth.sdk.Task;
import auth.sdk.TaskListener;
import auth.sdk.Utils;
import auth.utauthd.AuthRecord;
import auth.utauthd.Configuration;
import auth.utauthd.Control;
import auth.utauthd.DaemonManager;
import auth.utauthd.GroupManager;
import auth.utauthd.SessionId;
import auth.utauthd.Terminal;
import auth.utauthd.Worker;
import auth.utauthd.utauthd;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CallBack
implements Runnable,
TaskListener {
    private static int cbcount = 0;
    private ServerSocket callBackSocket;
    private static Vector daemonManagers = new Vector();
    private static CallBack callBack = null;
    private static Object debuggerWait = new Object();

    private CallBack() {
        Log.unexpectedError((String)"attempt to instantiate CallBack()");
    }

    private CallBack(int n) {
        if (callBack != null) {
            Log.configError((String)"attempt to instantiate CallBack 2nd time.");
        }
        try {
            this.callBackSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            Log.configError((String)("Cannot open call back socket on port " + n + ": " + iOException));
            return;
        }
    }

    private void amStatus(OutputStream outputStream) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        bufferedWriter.write("starttime=" + utauthd.startTime() / 1000L);
        bufferedWriter.write("\ndesktops=" + AuthRecord.numberOfConnections());
        bufferedWriter.write("\n");
        bufferedWriter.flush();
    }

    private boolean attach(Socket socket, String string, StringTokenizer stringTokenizer) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            string2 = stringTokenizer2.nextToken();
            string3 = stringTokenizer2.nextToken();
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.unexpectedError((String)"CallBack: malformed command");
            return false;
        }
        Log.debug((String)("CallBack command = \"attach\"\" host = \"" + string2 + "\" port = \"" + string3 + "\" cookie\"=" + string4 + "\""));
        if (string2 == null || string3 == null || string4 == null) {
            Log.notice((String)("Invalid call back attempt: " + string));
            return false;
        }
        int n = 0;
        while (n < daemonManagers.size()) {
            DaemonManager daemonManager = (DaemonManager)daemonManagers.elementAt(n);
            if (Utils.cookieMatch((String)string4, (String)daemonManager.cookie)) {
                Log.debug((String)("CallBack.attach: CALLING dm.setSocket() managerName = " + daemonManager.getName()));
                daemonManager.setSocket(socket);
                Log.debug((String)"CallBack.attach: dm.setSocket() returned");
                string4 = null;
                break;
            }
            ++n;
        }
        if (string4 != null) {
            Log.unexpectedError((String)"CallBack.attach: cookie NOT consumed");
            return false;
        }
        Log.debug((String)"CallBack.attach: cookie was consumed");
        return true;
    }

    private void cleanup(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {}
            socket = null;
        }
    }

    public static void clearCallBack(DaemonManager daemonManager) {
        Log.debug((String)(" call clearCallBack with dm : " + daemonManager));
        daemonManagers.removeElement(daemonManager);
    }

    private boolean control(BufferedReader bufferedReader, BufferedWriter bufferedWriter, StringTokenizer stringTokenizer) {
        SessionId sessionId;
        try {
            sessionId = new SessionId(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            String string = exception instanceof NoSuchElementException ? "error: malformed command" : "error: malformed session id";
            Log.unexpectedError((String)string);
            this.print(bufferedWriter, string);
            return false;
        }
        AuthRecord authRecord = AuthRecord.getBySid(sessionId);
        boolean bl = false;
        if (authRecord == null || authRecord.isTerminated()) {
            this.print(bufferedWriter, "error: invalid sessionId " + sessionId.partialId());
            return false;
        }
        Control control = null;
        try {
            Log.debug((String)"Callback:: locking for set controller");
            control = new Control(bufferedReader, bufferedWriter, authRecord);
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("error: Callback.control failed" + exception));
            return false;
        }
        if (control != null) {
            control.execute();
        }
        return true;
    }

    private void findPrimary(StringTokenizer stringTokenizer, BufferedWriter bufferedWriter) throws Exception {
        Terminal terminal;
        String string = "";
        String string2 = stringTokenizer.nextToken();
        SessionId sessionId = new SessionId(string2);
        AuthRecord authRecord = AuthRecord.getBySid(sessionId);
        if (authRecord != null && (terminal = authRecord.getTerminal()) != null) {
            block5: {
                terminal.lock();
                try {
                    String string3 = null;
                    if (authRecord.getTerminal() == null) {
                        string3 = "error: no terminal found";
                    } else {
                        String string4 = authRecord.getPrimaryId();
                        string = authRecord.getIPAddress();
                        string3 = string4 == null ? "error: no primary" : (AuthRecord.getByTerminalId(string4) != null ? "localhost" : GroupManager.findPrimary(string4, string));
                    }
                    if (string3 == null) break block5;
                    this.print(bufferedWriter, string3);
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    terminal.unlock();
                    throw throwable;
                }
            }
            Object var9_10 = null;
            terminal.unlock();
        }
    }

    public static void init(int n) {
        if (callBack == null) {
            callBack = new CallBack(n);
            new Thread((Runnable)callBack, "CallBack" + cbcount++).start();
        }
    }

    private boolean print(BufferedWriter bufferedWriter, String string) {
        if (bufferedWriter == null) {
            return false;
        }
        try {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("error: CallBack.print: " + exception));
            return false;
        }
        return true;
    }

    private String recv(BufferedReader bufferedReader) throws IOException {
        String string = "";
        string = bufferedReader.readLine();
        return string;
    }

    public void run() {
        Socket socket = null;
        Log.debug((String)"CallBack.run()");
        while (true) {
            try {
                while (true) {
                    socket = this.callBackSocket.accept();
                    socket.setSoTimeout(Configuration.cbtimeout);
                    Log.debug((String)("CallBack accept: socket s = " + socket));
                    Worker.begin(new Task((TaskListener)this, (Object)socket, false));
                }
            }
            catch (SocketException socketException) {
                this.cleanup(socket);
                socket = null;
                if (this.callBackSocket != null) {
                    Log.unexpectedError((String)("TCP error, cannot accept on socket: " + socketException + " : CallBack thread recovered from the error and Continuing.."));
                    continue;
                }
                Log.unexpectedError((String)("TCP error, cannot accept on socket: " + socketException + " : CallBack thread cannot continue"));
                return;
            }
            catch (IOException iOException) {
                Log.unexpectedError((String)("I/O error, cannot accept on socket: " + iOException + " : CallBack thread cannot continue"));
                this.cleanup(socket);
                return;
            }
            break;
        }
    }

    public static void setupCallBack(DaemonManager daemonManager) {
        Log.debug((String)(" call setupCallBack with dm : " + daemonManager));
        CallBack.clearCallBack(daemonManager);
        daemonManagers.addElement(daemonManager);
    }

    private void syncTerminalGroupsFromDB(StringTokenizer stringTokenizer, BufferedWriter bufferedWriter) throws Exception {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        Hashtable<String, UTDtuGroup> hashtable2 = new Hashtable<String, UTDtuGroup>(10);
        Admin admin = Admin.getAdmin();
        String string = "retry=false";
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            String string2 = "error: malformed command. Missing generation number";
            Log.unexpectedError((String)string2);
            this.print(bufferedWriter, string2);
            return;
        }
        if (admin == null) {
            return;
        }
        if (!admin.isGenerationValid("MULTIHEAD", n)) {
            string = "retry=true";
            Log.debug((String)"Callback:sending out a resync notice");
            this.print(bufferedWriter, string);
            return;
        }
        UTDtuGroup[] uTDtuGroupArray = admin.getDtuGrpByDtuGID(null, "MULTIHEAD");
        if (uTDtuGroupArray != null) {
            Log.debug((String)("Callback:sync group length = " + uTDtuGroupArray.length));
            int n2 = 0;
            while (n2 < uTDtuGroupArray.length) {
                int n3 = uTDtuGroupArray[n2].getPrimaryIdx();
                String[] stringArray = uTDtuGroupArray[n2].getDtuCIDs();
                String string3 = stringArray[n3];
                hashtable2.put(string3, uTDtuGroupArray[n2]);
                int n4 = 0;
                while (n4 < stringArray.length) {
                    hashtable.put(stringArray[n4], string3);
                    ++n4;
                }
                ++n2;
            }
        }
        AuthRecord.syncTerminalGroups(hashtable, hashtable2);
        this.print(bufferedWriter, string);
    }

    public void taskEvent(Object object) {
        block49: {
            Task task = (Task)object;
            Socket socket = (Socket)task.param;
            BufferedReader bufferedReader = null;
            try {
                String string;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "8859_1"));
                    socket.setSoTimeout(15000);
                    string = this.recv(bufferedReader);
                    Log.debug((String)("CB.taskEvent: input = " + string));
                    socket.setSoTimeout(0);
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("CB.taskEvent:read failed : e = " + exception));
                    this.cleanup(socket);
                    return;
                }
                if (string == null) {
                    this.cleanup(socket);
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                String string2 = null;
                try {
                    string2 = stringTokenizer.nextToken();
                    Log.debug((String)("CallBack: command=" + string2));
                }
                catch (NoSuchElementException noSuchElementException) {
                    Log.unexpectedError((String)"CallBack: malformed command");
                    this.cleanup(socket);
                    return;
                }
                if (string2.equals("attach")) {
                    if (!this.attach(socket, string, stringTokenizer)) {
                        this.cleanup(socket);
                        socket = null;
                        bufferedReader = null;
                    }
                    break block49;
                }
                if (string2.equals("wakeup")) {
                    this.wakeup(string, stringTokenizer);
                    this.cleanup(socket);
                    return;
                }
                if (string2.equals("status") || string2.equals("dstatus")) {
                    String string3 = null;
                    try {
                        string3 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    try {
                        AuthRecord.status(socket.getOutputStream(), string3);
                    }
                    catch (IOException iOException) {}
                    this.cleanup(socket);
                    return;
                }
                if (string2.equals("ustatus")) {
                    try {
                        this.userStatus(socket.getOutputStream());
                    }
                    catch (Exception exception) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    break block49;
                }
                if (string2.equals("amstatus")) {
                    try {
                        this.amStatus(socket.getOutputStream());
                    }
                    catch (Exception exception) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    break block49;
                }
                if (string2.equals("gstatus")) {
                    try {
                        GroupManager.status(socket.getOutputStream());
                    }
                    catch (IOException iOException) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    break block49;
                }
                if (string2.equals("tstatus")) {
                    try {
                        String string4;
                        String string5 = stringTokenizer.nextToken();
                        try {
                            string4 = stringTokenizer.nextToken();
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            string4 = null;
                        }
                        GroupManager.tokenStatus(socket.getOutputStream(), string5, string4);
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    break block49;
                }
                if (string2.equals("sessions")) {
                    try {
                        String string6 = stringTokenizer.nextToken();
                        GroupManager.tokenStatus(socket.getOutputStream(), null, string6);
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    break block49;
                }
                if (string2.equals("findPrimary")) {
                    BufferedWriter bufferedWriter = null;
                    try {
                        bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
                        this.findPrimary(stringTokenizer, bufferedWriter);
                    }
                    catch (Exception exception) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    bufferedWriter = null;
                    break block49;
                }
                if (string2.equals("sync")) {
                    BufferedWriter bufferedWriter = null;
                    try {
                        String string7 = stringTokenizer.nextToken();
                        if (string7.equals("MULTIHEAD")) {
                            bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
                            this.syncTerminalGroupsFromDB(stringTokenizer, bufferedWriter);
                        }
                    }
                    catch (Exception exception) {}
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    bufferedWriter = null;
                    break block49;
                }
                if (string2.equals("control")) {
                    BufferedWriter bufferedWriter = null;
                    try {
                        bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "8859_1"));
                    }
                    catch (Exception exception) {
                        this.cleanup(socket);
                        return;
                    }
                    if (!this.control(bufferedReader, bufferedWriter, stringTokenizer)) {
                        this.cleanup(socket);
                    }
                    bufferedReader = null;
                    bufferedWriter = null;
                    socket = null;
                    break block49;
                }
                if (string2.equals("continue")) {
                    Object object2 = debuggerWait;
                    synchronized (object2) {
                        try {
                            debuggerWait.notifyAll();
                        }
                        catch (Exception exception) {}
                    }
                    this.cleanup(socket);
                    socket = null;
                    bufferedReader = null;
                    break block49;
                }
                Log.unexpectedError((String)"CallBack: unrecognized command.");
                this.cleanup(socket);
                socket = null;
                bufferedReader = null;
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("CallBack: disaster!. ae = " + exception));
                exception.printStackTrace();
                this.cleanup(socket);
                socket = null;
                bufferedReader = null;
            }
        }
    }

    private void userStatus(OutputStream outputStream) throws Exception {
        Admin admin = Admin.getAdmin();
        User[] userArray = admin.getUstatus();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        int n = 0;
        while (n < userArray.length) {
            User user = userArray[n];
            bufferedWriter.write("begin\n");
            bufferedWriter.write("lastDesktopId=" + user.getLastDesktopId() + "\n");
            bufferedWriter.write("userId=" + user.getId() + "\n");
            switch (user.getStatus()) {
                case 0: {
                    bufferedWriter.write("state=never\n");
                    break;
                }
                case 1: {
                    bufferedWriter.write("state=insert\n");
                    break;
                }
                case 2: {
                    bufferedWriter.write("state=remove\n");
                    break;
                }
                default: {
                    bufferedWriter.write("state=unknown\n");
                }
            }
            bufferedWriter.write("createTime=" + user.getCreateTime() + "\n");
            bufferedWriter.write("lastTime=" + user.getLastTime() + "\n");
            bufferedWriter.write("end\n");
            bufferedWriter.flush();
            ++n;
        }
    }

    public static void waitForDebugger() {
        Object object = debuggerWait;
        synchronized (object) {
            try {
                debuggerWait.wait();
            }
            catch (Exception exception) {}
        }
    }

    private void wakeup(String string, StringTokenizer stringTokenizer) {
        String string2 = null;
        String string3 = null;
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            Log.debug((String)("CB.wakeup: mgrId = " + string2 + " daemonName = " + string3));
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.unexpectedError((String)"CallBack: missing command");
            return;
        }
        DaemonManager.wakeup(string2, string3);
    }
}

