/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.sdk.Log;
import auth.utauthd.GroupManager;
import auth.utauthd.SmartCardID;
import auth.utauthd.SmartCardWordException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;

public class SmartCardWordsImpl {
    private static final String SCCS_ID = "@(#)SmartCardWordsImpl.java\t1.22 02/12/17 SMI";
    private SmartCardID scid;
    private Stack configStack;
    private String bTRUE = "true";
    private String bFALSE = "false";
    private Properties configProps;
    private Hashtable clist = null;
    private int tagLength;
    private boolean useTagLength;
    private String bigLengthFlag;
    private int bigLengthSize;
    private boolean bigLengthEndian;
    private String tBuffer = null;
    private int tBufferPos;
    private boolean tBufferValid = false;
    private int vBufferOffset;
    private String useTagLengthFlag = "useTag";
    private String useBigEndianFlag = "bigEndian";
    private String useLittleEndianFlag = "littleEndian";
    private boolean debugMessage = false;
    private Stack executeControl;
    static final char CMD_prefixchar = '\u00ff';
    private static final int IDX_nocode = 0;
    private static final String CMD_setprop = "setprop";
    private static final int IDX_setprop = 10;
    private static final String CMD_getprop = "getprop";
    private static final int IDX_getprop = 11;
    private static final String CMD_add = "+";
    private static final int IDX_add = 22;
    private static final String CMD_subtract = "-";
    private static final int IDX_subtract = 23;
    private static final String CMD_equals = "=";
    private static final int IDX_equals = 30;
    private static final String CMD_hexequals = "hexequals";
    private static final int IDX_hexequals = 130;
    private static final String CMD_lessThan = "<";
    private static final int IDX_lessThan = 31;
    private static final String CMD_lessThanOrEqual = "<=";
    private static final int IDX_lessThanOrEqual = 32;
    private static final String CMD_greaterThan = ">";
    private static final int IDX_greaterThan = 33;
    private static final String CMD_greaterThanOrEqual = ">=";
    private static final int IDX_greaterThanOrEqual = 34;
    private static final String CMD_multiply = "*";
    private static final int IDX_multiply = 35;
    private static final String CMD_divide = "/";
    private static final int IDX_divide = 36;
    private static final String CMD_length = "length";
    private static final int IDX_length = 40;
    private static final String CMD_hexlength = "hexlength";
    private static final int IDX_hexlength = 140;
    private static final String CMD_chop = "chop";
    private static final int IDX_chop = 41;
    private static final String CMD_hexchop = "hexchop";
    private static final int IDX_hexchop = 141;
    private static final String CMD_toUpper = "toUpper";
    private static final int IDX_toUpper = 42;
    private static final String CMD_toLower = "toLower";
    private static final int IDX_toLower = 142;
    private static final String CMD_toASCII = "toASCII";
    private static final int IDX_toASCII = 242;
    private static final String CMD_toHEX = "toHEX";
    private static final int IDX_toHEX = 342;
    private static final String CMD_findString = "findString";
    private static final int IDX_findString = 442;
    private static final String CMD_padLeft = "padLeft";
    private static final int IDX_padLeft = 542;
    private static final String CMD_hexpadLeft = "hexpadLeft";
    private static final int IDX_hexpadLeft = 642;
    private static final String CMD_padRight = "padRight";
    private static final int IDX_padRight = 742;
    private static final String CMD_hexpadRight = "hexpadRight";
    private static final int IDX_hexpadRight = 842;
    private static final String CMD_dup = "dup";
    private static final int IDX_dup = 43;
    private static final String CMD_drop = "drop";
    private static final int IDX_drop = 44;
    private static final String CMD_not = "!";
    private static final int IDX_not = 45;
    private static final String CMD_concat = "concat";
    private static final int IDX_concat = 46;
    private static final String CMD_swap = "swap";
    private static final int IDX_swap = 47;
    private static final String CMD_clearstack = "clearstack";
    private static final int IDX_clearstack = 48;
    private static final String CMD_sendAPDU = "sendAPDU";
    private static final int IDX_sendAPDU = 50;
    private static final String CMD_exchangeAPDU = "exchangeAPDU";
    private static final int IDX_exchangeAPDU = 51;
    private static final String CMD_exchangeAPDUwHash = "exchangeAPDUwithHash";
    private static final int IDX_exchangeAPDUwHash = 52;
    private static final String CMD_shiftBytesRIGHT = "shiftBytesRIGHT";
    private static final int IDX_shiftBytesRIGHT = 60;
    private static final String CMD_shiftBytesLEFT = "shiftBytesLEFT";
    private static final int IDX_shiftBytesLEFT = 61;
    private static final String CMD_shiftBitsRIGHT = "shiftBitsRIGHT";
    private static final int IDX_shiftBitsRIGHT = 62;
    private static final String CMD_shiftBitsLEFT = "shiftBitsLEFT";
    private static final int IDX_shiftBitsLEFT = 63;
    private static final String CMD_maskAND = "&";
    private static final int IDX_maskAND = 64;
    private static final String CMD_maskOR = "|";
    private static final int IDX_maskOR = 65;
    private static final String CMD_complement = "~";
    private static final int IDX_complement = 66;
    private static final String CMD_andNot = "&~";
    private static final int IDX_andNot = 67;
    private static final String CMD_xor = "^";
    private static final int IDX_xor = 68;
    private static final String CMD_setBit = "setBit";
    private static final int IDX_setBit = 69;
    private static final String CMD_clearBit = "clearBit";
    private static final int IDX_clearBit = 70;
    private static final String CMD_flipBit = "flipBit";
    private static final int IDX_flipBit = 71;
    private static final String CMD_testBit = "testBit";
    private static final int IDX_testBit = 72;
    private static final String CMD_msg = "msg";
    private static final int IDX_msg = 80;
    private static final String CMD_msgDebug = "msgDebug";
    private static final int IDX_msgDebug = 81;
    private static final String CMD_msgLog = "msgLog";
    private static final int IDX_msgLog = 82;
    private static final String CMD_showstack = "showstack";
    private static final int IDX_showstack = 83;
    private static final String CMD_jmp = "jmp";
    private static final int IDX_jmp = 90;
    private static final String CMD_jmpIfTrue = "jmpIfTrue";
    private static final int IDX_jmpIfTrue = 91;
    private static final String CMD_jmpIfFalse = "jmpIfFalse";
    private static final int IDX_jmpIfFalse = 92;
    private static final String CMD_returnID = "returnID";
    private static final int IDX_returnID = 93;
    private static final String CMD_return = "return";
    private static final int IDX_return = 94;
    private static final String CMD_onException = "onException";
    private static final int IDX_onException = 95;
    private static final String CMD_cardReset = "cardReset";
    private static final int IDX_cardReset = 100;
    private static final String CMD_hasSession = "hasSession";
    private static final int IDX_hasSession = 101;
    private static final String CMD_isWord = "isWord";
    private static final int IDX_isWord = 102;
    private static final String CMD_needWords = "needWords";
    private static final int IDX_needWords = 103;
    private static final String CMD_setupTbufferParser = "setupTbufferParser";
    private static final int IDX_setupTbufferParser = 104;
    private static final String CMD_parseTbuffer = "parseTbuffer";
    private static final int IDX_parseTbuffer = 204;
    static final int Next_Word = 0;
    static final int Send_APDU = 10;
    static final int Xchange_APDU = 11;
    static final int ID_Available = 20;
    static final int No_ID = 21;
    static final int Display_Message = 30;
    static final int Log_Message = 31;
    static final int Debug_Set = 32;
    static final int Jump = 40;
    static final int Set_Exception_Handler = 50;
    static final int Card_Reset = 100;

    public SmartCardWordsImpl(SmartCardID smartCardID) {
        this.scid = smartCardID;
        this.executeControl = new Stack();
        this.configStack = new Stack();
        this.configProps = new Properties();
    }

    public SmartCardWordsImpl(Hashtable hashtable) {
        SmartCardWordsImpl.populateCmdList(hashtable);
    }

    private boolean checkBoolean(String string) throws NumberFormatException {
        if (string.equals(this.bTRUE)) {
            return true;
        }
        if (string.equals(this.bFALSE)) {
            return false;
        }
        throw new NumberFormatException("Invalid boolean word: [" + string + "]");
    }

    public void clear() {
        this.clearStack();
        this.clearProperties();
    }

    public void clearProperties() {
        ((Hashtable)this.configProps).clear();
        this.debugMessage = false;
    }

    public void clearStack() {
        this.configStack.clear();
        this.executeControl.clear();
    }

    public String flipEndian(String string) throws SmartCardWordException {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = string.toCharArray();
        if ((n & 1) == 1) {
            throw new SmartCardWordException("not enough bytes in buffer to flipEndian");
        }
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 0;
        while (n4 < n / 2) {
            cArray[n2++] = cArray2[n3 - 1];
            cArray[n2++] = cArray2[n3];
            n3 -= 2;
            ++n4;
        }
        return new String(cArray);
    }

    public String getCmdWordCode(String string) throws SmartCardWordException {
        String string2;
        if (this.clist == null) {
            this.clist = new Hashtable();
            SmartCardWordsImpl.populateCmdList(this.clist);
        }
        if ((string2 = (String)this.clist.get(string)) == null) {
            throw new SmartCardWordException("no command found for: [" + string + "]");
        }
        return string2;
    }

    public String getHexFromString(String string) {
        return string.toLowerCase();
    }

    private int parseTbuffer(String string) throws SmartCardWordException {
        if (!this.tBufferValid) {
            throw new SmartCardWordException("T-buffer parser not properly initialized");
        }
        if (this.useTagLength) {
            this.tagLength = string.length();
        } else {
            if (string.length() < this.tagLength) {
                throw new SmartCardWordException("tag smaller than required tag length");
            }
            if (string.length() > this.tagLength) {
                throw new SmartCardWordException("tag larger than required tag length");
            }
        }
        if (((this.tagLength | string.length()) & 1) == 1) {
            throw new SmartCardWordException("tag length is odd");
        }
        if (this.tBuffer.length() < this.tagLength) {
            throw new SmartCardWordException("tBuffer smaller than tag");
        }
        try {
            while (this.tBufferPos < this.tBuffer.length() - this.tagLength) {
                int n;
                int n2 = n = this.tBufferPos + this.tagLength;
                int n3 = n + 2;
                int n4 = this.tBufferPos;
                this.tBufferPos += 2;
                if (this.tBuffer.startsWith(this.bigLengthFlag, n)) {
                    n2 = n + 2;
                    n3 = n + 2 + this.bigLengthSize * 2;
                    this.tBufferPos += this.bigLengthSize * 2;
                }
                this.tBufferPos += this.tagLength;
                String string2 = this.tBuffer.substring(n2, n3);
                if (!this.bigLengthEndian) {
                    string2 = this.flipEndian(string2);
                }
                int n5 = Integer.parseInt(string2, 16);
                if (this.tBuffer.regionMatches(true, n4, string, 0, this.tagLength)) {
                    return n5;
                }
                this.vBufferOffset += n5;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        return -1;
    }

    private static void populateCmdList(Hashtable hashtable) {
        hashtable.put(CMD_setprop, String.valueOf('\u00ff') + Integer.toString(10));
        hashtable.put(CMD_getprop, String.valueOf('\u00ff') + Integer.toString(11));
        hashtable.put(CMD_add, String.valueOf('\u00ff') + Integer.toString(22));
        hashtable.put(CMD_subtract, String.valueOf('\u00ff') + Integer.toString(23));
        hashtable.put(CMD_equals, String.valueOf('\u00ff') + Integer.toString(30));
        hashtable.put(CMD_hexequals, String.valueOf('\u00ff') + Integer.toString(130));
        hashtable.put(CMD_lessThan, String.valueOf('\u00ff') + Integer.toString(31));
        hashtable.put(CMD_lessThanOrEqual, String.valueOf('\u00ff') + Integer.toString(32));
        hashtable.put(CMD_greaterThan, String.valueOf('\u00ff') + Integer.toString(33));
        hashtable.put(CMD_greaterThanOrEqual, String.valueOf('\u00ff') + Integer.toString(34));
        hashtable.put(CMD_multiply, String.valueOf('\u00ff') + Integer.toString(35));
        hashtable.put(CMD_divide, String.valueOf('\u00ff') + Integer.toString(36));
        hashtable.put(CMD_length, String.valueOf('\u00ff') + Integer.toString(40));
        hashtable.put(CMD_hexlength, String.valueOf('\u00ff') + Integer.toString(140));
        hashtable.put(CMD_chop, String.valueOf('\u00ff') + Integer.toString(41));
        hashtable.put(CMD_hexchop, String.valueOf('\u00ff') + Integer.toString(141));
        hashtable.put(CMD_toUpper, String.valueOf('\u00ff') + Integer.toString(42));
        hashtable.put(CMD_toLower, String.valueOf('\u00ff') + Integer.toString(142));
        hashtable.put(CMD_toASCII, String.valueOf('\u00ff') + Integer.toString(242));
        hashtable.put(CMD_toHEX, String.valueOf('\u00ff') + Integer.toString(342));
        hashtable.put(CMD_findString, String.valueOf('\u00ff') + Integer.toString(442));
        hashtable.put(CMD_padLeft, String.valueOf('\u00ff') + Integer.toString(542));
        hashtable.put(CMD_hexpadLeft, String.valueOf('\u00ff') + Integer.toString(642));
        hashtable.put(CMD_padRight, String.valueOf('\u00ff') + Integer.toString(742));
        hashtable.put(CMD_hexpadRight, String.valueOf('\u00ff') + Integer.toString(842));
        hashtable.put(CMD_dup, String.valueOf('\u00ff') + Integer.toString(43));
        hashtable.put(CMD_drop, String.valueOf('\u00ff') + Integer.toString(44));
        hashtable.put(CMD_not, String.valueOf('\u00ff') + Integer.toString(45));
        hashtable.put(CMD_concat, String.valueOf('\u00ff') + Integer.toString(46));
        hashtable.put(CMD_swap, String.valueOf('\u00ff') + Integer.toString(47));
        hashtable.put(CMD_clearstack, String.valueOf('\u00ff') + Integer.toString(48));
        hashtable.put(CMD_sendAPDU, String.valueOf('\u00ff') + Integer.toString(50));
        hashtable.put(CMD_exchangeAPDU, String.valueOf('\u00ff') + Integer.toString(51));
        hashtable.put(CMD_exchangeAPDUwHash, String.valueOf('\u00ff') + Integer.toString(52));
        hashtable.put(CMD_shiftBytesRIGHT, String.valueOf('\u00ff') + Integer.toString(60));
        hashtable.put(CMD_shiftBytesLEFT, String.valueOf('\u00ff') + Integer.toString(61));
        hashtable.put(CMD_shiftBitsRIGHT, String.valueOf('\u00ff') + Integer.toString(62));
        hashtable.put(CMD_shiftBitsLEFT, String.valueOf('\u00ff') + Integer.toString(63));
        hashtable.put(CMD_maskAND, String.valueOf('\u00ff') + Integer.toString(64));
        hashtable.put(CMD_maskOR, String.valueOf('\u00ff') + Integer.toString(65));
        hashtable.put(CMD_complement, String.valueOf('\u00ff') + Integer.toString(66));
        hashtable.put(CMD_andNot, String.valueOf('\u00ff') + Integer.toString(67));
        hashtable.put(CMD_xor, String.valueOf('\u00ff') + Integer.toString(68));
        hashtable.put(CMD_setBit, String.valueOf('\u00ff') + Integer.toString(69));
        hashtable.put(CMD_clearBit, String.valueOf('\u00ff') + Integer.toString(70));
        hashtable.put(CMD_flipBit, String.valueOf('\u00ff') + Integer.toString(71));
        hashtable.put(CMD_testBit, String.valueOf('\u00ff') + Integer.toString(72));
        hashtable.put(CMD_msg, String.valueOf('\u00ff') + Integer.toString(80));
        hashtable.put(CMD_msgDebug, String.valueOf('\u00ff') + Integer.toString(81));
        hashtable.put(CMD_msgLog, String.valueOf('\u00ff') + Integer.toString(82));
        hashtable.put(CMD_showstack, String.valueOf('\u00ff') + Integer.toString(83));
        hashtable.put(CMD_jmp, String.valueOf('\u00ff') + Integer.toString(90));
        hashtable.put(CMD_jmpIfTrue, String.valueOf('\u00ff') + Integer.toString(91));
        hashtable.put(CMD_jmpIfFalse, String.valueOf('\u00ff') + Integer.toString(92));
        hashtable.put(CMD_returnID, String.valueOf('\u00ff') + Integer.toString(93));
        hashtable.put(CMD_return, String.valueOf('\u00ff') + Integer.toString(94));
        hashtable.put(CMD_onException, String.valueOf('\u00ff') + Integer.toString(95));
        hashtable.put(CMD_cardReset, String.valueOf('\u00ff') + Integer.toString(100));
        hashtable.put(CMD_hasSession, String.valueOf('\u00ff') + Integer.toString(101));
        hashtable.put(CMD_isWord, String.valueOf('\u00ff') + Integer.toString(102));
        hashtable.put(CMD_needWords, String.valueOf('\u00ff') + Integer.toString(103));
        hashtable.put(CMD_setupTbufferParser, String.valueOf('\u00ff') + Integer.toString(104));
        hashtable.put(CMD_parseTbuffer, String.valueOf('\u00ff') + Integer.toString(204));
    }

    public void push(String string) {
        this.configStack.push(string);
    }

    public void push(boolean bl) {
        if (bl) {
            this.configStack.push(this.bTRUE);
        } else {
            this.configStack.push(this.bFALSE);
        }
    }

    public void pushHex(String string) {
        this.configStack.push(string.toLowerCase());
    }

    public int wordImpl(String string, Hashtable hashtable) throws EmptyStackException, NumberFormatException, SmartCardWordException {
        int n = 0;
        if (string.length() > 0 && string.charAt(0) == '\u00ff') {
            n = Integer.parseInt(string.substring(1));
        }
        int n2 = 0;
        switch (n) {
            case 0: {
                this.configStack.push(string);
                break;
            }
            case 10: {
                String string2 = (String)this.configStack.pop();
                String string3 = (String)this.configStack.pop();
                if (string2.startsWith("atr.")) {
                    throw new SmartCardWordException("ATR property [" + string2 + "] is READ ONLY");
                }
                if (string2.startsWith("dtu.")) {
                    String string4 = string2.substring(string2.indexOf("dtu.") + "dtu.".length());
                    if (string4.length() < 1) {
                        throw new SmartCardWordException("Missing DTU property name");
                    }
                    hashtable.put(string4, string3);
                    break;
                }
                this.configProps.setProperty(string2, string3);
                if (!string2.equals("debug.msg")) break;
                if (this.checkBoolean(string3)) {
                    this.debugMessage = true;
                    break;
                }
                this.debugMessage = false;
                break;
            }
            case 11: {
                String string5;
                String string6 = (String)this.configStack.pop();
                if (string6.startsWith("atr.")) {
                    string5 = this.scid.ATRprops.getProperty(string6);
                    if (string5 == null) {
                        throw new SmartCardWordException("ATR property [" + string6 + "] not found");
                    }
                } else if (string6.startsWith("dtu.")) {
                    String string7 = string6.substring(string6.indexOf("dtu.") + "dtu.".length());
                    if (string7.length() < 1) {
                        throw new SmartCardWordException("Missing DTU property name");
                    }
                    string5 = (String)hashtable.get(string7);
                    if (string5 == null) {
                        throw new SmartCardWordException("Property [" + string6 + "] not found");
                    }
                } else {
                    string5 = this.configProps.getProperty(string6);
                    if (string5 == null) {
                        throw new SmartCardWordException("Property [" + string6 + "] not found");
                    }
                }
                this.configStack.push(string5);
                break;
            }
            case 64: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger2 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger3 = bigInteger2.and(bigInteger);
                this.pushHex(bigInteger3.toString(16));
                break;
            }
            case 65: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger4 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger5 = bigInteger4.or(bigInteger);
                this.pushHex(bigInteger5.toString(16));
                break;
            }
            case 66: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger6 = bigInteger.not();
                this.pushHex(bigInteger6.toString(16));
                break;
            }
            case 67: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger7 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger8 = bigInteger7.andNot(bigInteger);
                this.pushHex(bigInteger8.toString(16));
                break;
            }
            case 68: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger9 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger10 = bigInteger9.xor(bigInteger);
                this.pushHex(bigInteger10.toString(16));
                break;
            }
            case 69: {
                int n3 = Integer.parseInt((String)this.configStack.pop(), 16);
                if (n3 < 0) {
                    throw new SmartCardWordException("negative bit number");
                }
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger11 = bigInteger.setBit(n3);
                this.pushHex(bigInteger11.toString(16));
                break;
            }
            case 70: {
                int n4 = Integer.parseInt((String)this.configStack.pop(), 16);
                if (n4 < 0) {
                    throw new SmartCardWordException("negative bit number");
                }
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger12 = bigInteger.clearBit(n4);
                this.pushHex(bigInteger12.toString(16));
                break;
            }
            case 71: {
                int n5 = Integer.parseInt((String)this.configStack.pop(), 16);
                if (n5 < 0) {
                    throw new SmartCardWordException("negative bit number");
                }
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger13 = bigInteger.flipBit(n5);
                this.pushHex(bigInteger13.toString(16));
                break;
            }
            case 72: {
                int n6 = Integer.parseInt((String)this.configStack.pop(), 16);
                if (n6 < 0) {
                    throw new SmartCardWordException("negative bit number");
                }
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                if (bigInteger.testBit(n6)) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 22: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger14 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger15 = bigInteger14.add(bigInteger);
                this.pushHex(bigInteger15.toString(16));
                break;
            }
            case 23: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger16 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger17 = bigInteger16.subtract(bigInteger);
                this.pushHex(bigInteger17.toString(16));
                break;
            }
            case 30: {
                if (((String)this.configStack.pop()).equalsIgnoreCase((String)this.configStack.pop())) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 130: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger18 = new BigInteger((String)this.configStack.pop(), 16);
                if (bigInteger18.equals(bigInteger)) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 31: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger19 = new BigInteger((String)this.configStack.pop(), 16);
                if (bigInteger19.compareTo(bigInteger) < 0) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 32: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger20 = new BigInteger((String)this.configStack.pop(), 16);
                if (bigInteger20.compareTo(bigInteger) <= 0) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 33: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger21 = new BigInteger((String)this.configStack.pop(), 16);
                if (bigInteger21.compareTo(bigInteger) > 0) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 34: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger22 = new BigInteger((String)this.configStack.pop(), 16);
                if (bigInteger22.compareTo(bigInteger) >= 0) {
                    this.configStack.push(this.bTRUE);
                    break;
                }
                this.configStack.push(this.bFALSE);
                break;
            }
            case 35: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger23 = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger24 = bigInteger23.multiply(bigInteger);
                this.pushHex(bigInteger24.toString(16));
                break;
            }
            case 36: {
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                BigInteger bigInteger25 = new BigInteger((String)this.configStack.pop(), 16);
                try {
                    BigInteger[] bigIntegerArray = bigInteger25.divideAndRemainder(bigInteger);
                    this.pushHex(bigIntegerArray[1].toString(16));
                    this.pushHex(bigIntegerArray[0].toString(16));
                    break;
                }
                catch (ArithmeticException arithmeticException) {
                    throw new NumberFormatException("divide by zero");
                }
            }
            case 40: {
                this.pushHex(Integer.toString(((String)this.configStack.pop()).length(), 16));
                break;
            }
            case 140: {
                int n7 = ((String)this.configStack.pop()).length();
                if ((n7 & 1) == 1) {
                    ++n7;
                }
                this.pushHex(Integer.toString(n7 /= 2, 16));
                break;
            }
            case 50: {
                hashtable.remove("_WI_Xchange_APDU.rlen");
                hashtable.put("_WI_Xchange_APDU.APDU", (String)this.configStack.pop());
                n2 = 10;
                break;
            }
            case 51: {
                int n8 = Integer.parseInt((String)this.configStack.pop(), 16);
                if (n8 > 255) {
                    throw new SmartCardWordException("length out of range: " + n8);
                }
                hashtable.put("_WI_Xchange_APDU.rlen", Integer.toString(n8, 16));
                hashtable.put("_WI_Xchange_APDU.APDU", (String)this.configStack.pop());
                hashtable.remove("_WI_Xchange_APDU.bitmask");
                n2 = 11;
                break;
            }
            case 52: {
                hashtable.put("_WI_Xchange_APDU.bitmask", (String)this.configStack.pop());
                int n9 = Integer.parseInt((String)this.configStack.pop(), 16);
                if (n9 > 255) {
                    throw new SmartCardWordException("length out of range: " + n9);
                }
                hashtable.put("_WI_Xchange_APDU.rlen", Integer.toString(n9, 16));
                hashtable.put("_WI_Xchange_APDU.APDU", (String)this.configStack.pop());
                n2 = 11;
                break;
            }
            case 60: {
                int n10 = Integer.parseInt((String)this.configStack.pop(), 16);
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                this.pushHex(bigInteger.shiftRight(n10 * 8).toString(16));
                break;
            }
            case 61: {
                int n11 = Integer.parseInt((String)this.configStack.pop(), 16);
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                this.pushHex(bigInteger.shiftLeft(n11 * 8).toString(16));
                break;
            }
            case 62: {
                int n12 = Integer.parseInt((String)this.configStack.pop(), 16);
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                this.pushHex(bigInteger.shiftRight(n12).toString(16));
                break;
            }
            case 63: {
                int n13 = Integer.parseInt((String)this.configStack.pop(), 16);
                BigInteger bigInteger = new BigInteger((String)this.configStack.pop(), 16);
                this.pushHex(bigInteger.shiftLeft(n13).toString(16));
                break;
            }
            case 41: 
            case 141: {
                int n14 = Integer.parseInt((String)this.configStack.pop(), 16);
                int n15 = Integer.parseInt((String)this.configStack.pop(), 16);
                String string8 = (String)this.configStack.pop();
                if (n == 141) {
                    n14 *= 2;
                    n15 *= 2;
                }
                if (n15 >= string8.length() || n15 + n14 > string8.length()) {
                    throw new SmartCardWordException("length or offset out of range");
                }
                String string9 = string8.substring(n15, n15 + n14);
                if (n == 141) {
                    this.pushHex(string9);
                    break;
                }
                this.configStack.push(string9);
                break;
            }
            case 42: {
                this.configStack.push(((String)this.configStack.pop()).toUpperCase());
                break;
            }
            case 142: {
                this.configStack.push(((String)this.configStack.pop()).toLowerCase());
                break;
            }
            case 242: {
                String string10 = (String)this.configStack.pop();
                int n16 = string10.length();
                if ((n16 & 1) == 1) {
                    throw new SmartCardWordException("hex string has odd number of characters: " + n16);
                }
                char[] cArray = string10.toCharArray();
                char[] cArray2 = new char[n16 / 2];
                int n17 = 0;
                int n18 = 0;
                while (n18 < n16 / 2) {
                    cArray2[n18] = (char)(Character.digit(cArray[n17++], 16) << 4 | Character.digit(cArray[n17++], 16));
                    ++n18;
                }
                this.configStack.push(String.valueOf(cArray2));
                break;
            }
            case 342: {
                String string11 = (String)this.configStack.pop();
                char[] cArray = string11.toCharArray();
                int n19 = string11.length();
                char[] cArray3 = new char[n19 * 2];
                int n20 = 0;
                int n21 = 0;
                while (n21 < n19) {
                    cArray3[n20++] = Character.forDigit(cArray[n21] >> 4, 16);
                    cArray3[n20++] = Character.forDigit(cArray[n21] & 0xF, 16);
                    ++n21;
                }
                this.pushHex(String.valueOf(cArray3));
                break;
            }
            case 442: {
                String string12 = (String)this.configStack.pop();
                int n22 = ((String)this.configStack.pop()).indexOf(string12);
                if (n22 < 0) {
                    this.configStack.push(this.bFALSE);
                    break;
                }
                this.pushHex(Integer.toString(n22, 16));
                this.configStack.push(this.bTRUE);
                break;
            }
            case 542: 
            case 742: {
                String string13;
                int n23 = Integer.parseInt((String)this.configStack.pop(), 16);
                String string14 = (String)this.configStack.pop();
                String string15 = (String)this.configStack.pop();
                if (string15.length() >= n23) {
                    string13 = string15;
                } else {
                    if (string14.length() == 0) {
                        throw new SmartCardWordException("pad value is empty");
                    }
                    int n24 = n23 - string15.length();
                    char[] cArray = new char[n24];
                    int n25 = 0;
                    while (n25 < n24) {
                        cArray[n25] = string14.charAt(n25 % string14.length());
                        ++n25;
                    }
                    string13 = n == 542 ? String.valueOf(new String(cArray)) + string15 : String.valueOf(string15) + new String(cArray);
                }
                this.configStack.push(string13);
                break;
            }
            case 642: 
            case 842: {
                String string16;
                int n26 = Integer.parseInt((String)this.configStack.pop(), 16);
                int n27 = Integer.parseInt((String)this.configStack.pop(), 16);
                String string17 = (String)this.configStack.pop();
                int n28 = Integer.parseInt(string17, 16);
                if (n27 > 255) {
                    throw new SmartCardWordException("pad value too large: " + Integer.toString(n27, 16));
                }
                if (string17.length() >= (n26 *= 2)) {
                    string16 = string17;
                } else {
                    int n29 = n26 - string17.length();
                    char[] cArray = new char[n29];
                    char c = Integer.toString(n27 >> 4, 16).charAt(0);
                    char c2 = Integer.toString(n27 & 0xF).charAt(0);
                    if (n == 642) {
                        if ((string17.length() & 1) == 1) {
                            cArray[--n29] = c;
                        }
                        while (n29 > 0) {
                            cArray[--n29] = c2;
                            cArray[--n29] = c;
                        }
                        string16 = String.valueOf(new String(cArray)) + string17;
                    } else {
                        int n30 = 0;
                        if ((string17.length() & 1) == 1) {
                            cArray[n30++] = c2;
                        }
                        while (n30 < n29) {
                            cArray[n30++] = c;
                            cArray[n30++] = c2;
                        }
                        string16 = String.valueOf(string17) + new String(cArray);
                    }
                }
                this.pushHex(string16);
                break;
            }
            case 43: {
                this.configStack.push(this.configStack.peek());
                break;
            }
            case 44: {
                this.configStack.pop();
                break;
            }
            case 45: {
                if (this.checkBoolean((String)this.configStack.pop())) {
                    this.configStack.push(this.bFALSE);
                    break;
                }
                this.configStack.push(this.bTRUE);
                break;
            }
            case 46: {
                String string18 = (String)this.configStack.pop();
                String string19 = (String)this.configStack.pop();
                this.configStack.push(String.valueOf(string19) + string18);
                break;
            }
            case 47: {
                String string20 = (String)this.configStack.pop();
                String string21 = (String)this.configStack.pop();
                this.configStack.push(string20);
                this.configStack.push(string21);
                break;
            }
            case 93: {
                hashtable.put("_WI_TokenID.name", (String)this.configStack.pop());
                hashtable.put("_WI_TokenID.ID", (String)this.configStack.pop());
                n2 = 20;
                break;
            }
            case 94: {
                n2 = 21;
                break;
            }
            case 95: {
                hashtable.put("_WI_Jump_Label", (String)this.configStack.pop());
                n2 = 50;
                break;
            }
            case 80: {
                hashtable.put("_WI_Display_Message", String.valueOf((String)this.configStack.pop()) + "\n");
                n2 = 30;
                break;
            }
            case 81: {
                String string22 = (String)this.configStack.pop();
                if (!this.debugMessage) break;
                hashtable.put("_WI_Display_Message", String.valueOf(string22) + "\n");
                n2 = 30;
                break;
            }
            case 82: {
                hashtable.put("_WI_Display_Message", (String)this.configStack.pop());
                n2 = 31;
                break;
            }
            case 83: {
                String string23 = "";
                int n31 = this.configStack.size();
                int n32 = 0;
                if (n31 > 0) {
                    while (n31-- > 0) {
                        string23 = String.valueOf(string23) + "[(" + n32++ + "):" + this.configStack.get(n31) + "]\n";
                    }
                } else {
                    string23 = "(empty)";
                }
                string23 = String.valueOf(string23) + "\n";
                hashtable.put("_WI_Display_Message", string23);
                n2 = 30;
                break;
            }
            case 48: {
                this.configStack.clear();
                break;
            }
            case 90: {
                hashtable.put("_WI_Jump_Label", (String)this.configStack.pop());
                n2 = 40;
                break;
            }
            case 91: {
                String string24 = (String)this.configStack.pop();
                if (!this.checkBoolean((String)this.configStack.pop())) break;
                hashtable.put("_WI_Jump_Label", string24);
                n2 = 40;
                break;
            }
            case 92: {
                String string25 = (String)this.configStack.pop();
                if (this.checkBoolean((String)this.configStack.pop())) break;
                hashtable.put("_WI_Jump_Label", string25);
                n2 = 40;
                break;
            }
            case 100: {
                n2 = 100;
                break;
            }
            case 101: {
                boolean bl = false;
                String string26 = (String)this.configStack.pop();
                BufferedReader bufferedReader = new BufferedReader(new StringReader(GroupManager.listSessionsByToken(string26)));
                while (true) {
                    try {
                        String string27 = bufferedReader.readLine();
                        if (string27 == null) break;
                        Log.notice((String)("hasSession: token=[" + string26 + "] " + "sessioninfo=[" + string27 + "]"));
                        StringTokenizer stringTokenizer = new StringTokenizer(string27);
                        stringTokenizer.nextToken();
                        try {
                            if (Integer.parseInt(stringTokenizer.nextToken()) < 0) continue;
                            bl = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new NoSuchElementException("Bad display data from group manager: [" + numberFormatException.getMessage() + "]");
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SmartCardWordException("Error getting session info for token: [" + string26 + "] : [" + noSuchElementException.getMessage() + "]");
                    }
                    catch (IOException iOException) {
                        throw new SmartCardWordException("Bad token data from group manager for token: [" + string26 + "]");
                    }
                }
                this.configStack.push(bl ? this.bTRUE : this.bFALSE);
                break;
            }
            case 102: 
            case 103: {
                if (this.clist == null) {
                    this.clist = new Hashtable();
                    SmartCardWordsImpl.populateCmdList(this.clist);
                }
                StringTokenizer stringTokenizer = new StringTokenizer((String)this.configStack.pop());
                boolean bl = false;
                while (!bl && stringTokenizer.hasMoreTokens()) {
                    String string28 = stringTokenizer.nextToken();
                    if (this.clist.containsKey(string28)) continue;
                    if (n == 103) {
                        throw new SmartCardWordException("required word not a SwapDrop word: " + string28);
                    }
                    this.configStack.push(string28);
                    this.configStack.push(this.bFALSE);
                    bl = true;
                }
                if (bl) break;
                this.configStack.push(this.bTRUE);
                break;
            }
            case 104: {
                this.tBufferValid = false;
                this.useTagLength = false;
                this.tBufferPos = 0;
                this.vBufferOffset = 0;
                this.tagLength = 0;
                String string29 = ((String)this.configStack.pop()).toLowerCase();
                this.bigLengthSize = Integer.parseInt((String)this.configStack.pop(), 16);
                this.bigLengthFlag = ((String)this.configStack.pop()).toLowerCase();
                String string30 = ((String)this.configStack.pop()).toLowerCase();
                this.tBuffer = ((String)this.configStack.pop()).toLowerCase();
                try {
                    if (string29.equals(this.useTagLengthFlag.toLowerCase())) {
                        this.useTagLength = true;
                    } else {
                        this.tagLength = Integer.parseInt(string29, 16) * 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SmartCardWordException("invalid tag length specification");
                }
                if (string30.equals(this.useBigEndianFlag.toLowerCase())) {
                    this.bigLengthEndian = true;
                } else if (string30.equals(this.useLittleEndianFlag.toLowerCase())) {
                    this.bigLengthEndian = false;
                } else {
                    throw new SmartCardWordException("invalid endian specification");
                }
                if ((this.tBuffer.length() & 1) == 1) {
                    throw new SmartCardWordException("tBuffer length is odd");
                }
                this.tBufferValid = true;
                break;
            }
            case 204: {
                boolean bl = false;
                int n33 = this.parseTbuffer(((String)this.configStack.pop()).toLowerCase());
                if (n33 >= 0) {
                    this.configStack.push(Integer.toString(this.vBufferOffset, 16));
                    this.configStack.push(Integer.toString(n33, 16));
                    this.vBufferOffset += n33;
                    bl = true;
                } else {
                    this.tBufferPos = 0;
                    this.vBufferOffset = 0;
                }
                this.configStack.push(bl ? this.bTRUE : this.bFALSE);
                break;
            }
            default: {
                throw new SmartCardWordException("Invalid word encountered: [" + string + "]");
            }
        }
        return n2;
    }
}

