/*
 * Decompiled with CFR 0.152.
 */
package auth.utauthd;

import auth.admin.Admin;
import auth.admin.UTDtuGroup;
import auth.admin.UTPolicyAttributes;
import auth.protocol.RegisterKeys;
import auth.sdk.AccessControl;
import auth.sdk.AuthenticationClient;
import auth.sdk.JobQueue;
import auth.sdk.JobQueueEntry;
import auth.sdk.Log;
import auth.sdk.LogicalToken;
import auth.sdk.RawToken;
import auth.sdk.TaskListener;
import auth.sdk.Utils;
import auth.utauthd.Configuration;
import auth.utauthd.Controller;
import auth.utauthd.Crypto;
import auth.utauthd.Mutex;
import auth.utauthd.Session;
import auth.utauthd.SessionId;
import auth.utauthd.SessionManager;
import auth.utauthd.Terminal;
import auth.utauthd.utauthd;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AuthRecord
implements AccessControl,
TaskListener {
    private static final int TERMINAL_DOES_NOT_EXIST = 0;
    private static final int TERMINAL_EXISTS = 1;
    private boolean terminated = false;
    private boolean destroyed = false;
    private String terminalId = null;
    private String name;
    private String udpPort = null;
    private Terminal terminal;
    private AuthenticationClient client;
    private Session session;
    private String ipAddress = null;
    private Crypto crypto;
    private final String sessionRefused = "sessionrefused";
    private boolean clientCreated = false;
    private boolean reapable = false;
    private boolean connected = false;
    private boolean tokenIn = false;
    private int expecting = 0;
    private long createTime = 0L;
    private long connectTime = 0L;
    private String firmware = null;
    private String lastExist = null;
    private Hashtable taggedControllers = new Hashtable();
    private Hashtable annotations = new Hashtable();
    private Mutex mutex = null;
    private AuthRecord primary = null;
    private UTDtuGroup groupInfo = null;
    private AuthRecord[] secondaries = null;
    private boolean isPrimary = false;
    private String groupTerminalId = null;
    private int currentMod = 0;
    private static JobQueue jobQueue = null;
    private static Method m_connRsp = null;
    private static boolean jobQGroup = false;
    private static Hashtable bySocket = new Hashtable(16);
    private static Hashtable byTerminalId = new Hashtable(16);
    private static Hashtable bySid = new Hashtable(16);
    private static String uniquePrefix = null;
    private static long uniqueNumber = 0L;
    private static Properties nameMappings = null;
    private static File nameFile = null;
    private static Properties sessionTypes = null;
    private static Vector tickets = null;
    private String callbackCookie = null;
    public String insertToken = null;
    public String tokenName = null;
    static /* synthetic */ Class class$auth$utauthd$AuthRecord;

    private AuthRecord() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthRecord(Terminal terminal, String string, String string2, String string3, String string4, Mutex mutex, Crypto crypto) throws Exception {
        boolean bl = false;
        AuthRecord authRecord = null;
        String string5 = "";
        while (true) {
            block22: {
                Object var13_14;
                Object object;
                if (bl) {
                    this.lastExist = this.adminEvent("exist=true,session=false", this.lastExist, this.firmware);
                    return;
                }
                if (authRecord != null) {
                    Log.debug((String)"AuthRecord:: oldar is not null.. destroying old terminal");
                    object = authRecord.terminal;
                    if (object != null) {
                        block18: {
                            block17: {
                                ((Terminal)object).lock();
                                try {
                                    if (authRecord.terminal == null) {
                                        Log.debug((String)"AuthRecord:: oldar.terminal is null");
                                        string5 = "";
                                        authRecord = null;
                                        var13_14 = null;
                                        ((Terminal)object).unlock();
                                        continue;
                                    }
                                    if (object != authRecord.terminal) {
                                        bl = false;
                                        break block17;
                                    }
                                    ((Terminal)object).disable();
                                    authRecord.disconnect("reauthenticating" + string5, false);
                                    authRecord.destroy();
                                    ((Terminal)object).close();
                                    break block18;
                                }
                                catch (Throwable throwable) {
                                    var13_14 = null;
                                    ((Terminal)object).unlock();
                                    throw throwable;
                                }
                            }
                            var13_14 = null;
                            ((Terminal)object).unlock();
                            continue;
                        }
                        var13_14 = null;
                        ((Terminal)object).unlock();
                    } else {
                        Log.unexpectedError((String)"AuthRecord:: oldar terminal exists..");
                    }
                    string5 = "";
                    authRecord = null;
                    object = null;
                }
                object = terminal.getAuthIPAandPortString();
                AuthRecord authRecord2 = this;
                synchronized (authRecord2) {
                    block21: {
                        block23: {
                            Hashtable hashtable = byTerminalId;
                            synchronized (hashtable) {
                                Object var15_16;
                                block20: {
                                    block19: {
                                        authRecord = AuthRecord.getBySocket((String)object);
                                        if (authRecord != null) {
                                            bl = false;
                                            string5 = "DuplicateIPA";
                                            var15_16 = null;
                                            break block19;
                                        }
                                        authRecord = AuthRecord.getByTerminalId(string);
                                        if (authRecord != null) {
                                            bl = false;
                                            string5 = "DuplicateTID";
                                            break block20;
                                        }
                                        this.createTime = System.currentTimeMillis();
                                        this.terminalId = string;
                                        this.firmware = string2;
                                        this.terminal = terminal;
                                        this.crypto = crypto;
                                        this.client = null;
                                        this.name = AuthRecord.uniqueTransientName();
                                        this.mutex = mutex;
                                        this.ipAddress = string4;
                                        bySocket.put(object, this);
                                        byTerminalId.put(string, this);
                                        bl = true;
                                        break block21;
                                    }
                                    break block23;
                                }
                                var15_16 = null;
                            }
                        }
                        var13_14 = null;
                        break block22;
                    }
                    continue;
                }
            }
        }
    }

    public synchronized boolean addSecondary(String string, String string2) throws Exception {
        UTDtuGroup[] uTDtuGroupArray;
        Log.debug((String)("AuthRecord::addSecondary: Primaryid = " + string + ", Secondary Id = " + string2));
        AuthRecord authRecord = AuthRecord.getByTerminalId(string);
        if (authRecord == null) {
            return false;
        }
        Admin admin = Admin.getAdmin();
        if (admin != null && (uTDtuGroupArray = admin.getDtuGrpByDtuCID(string, "MULTIHEAD")) != null) {
            this.groupInfo = uTDtuGroupArray[0];
        }
        uTDtuGroupArray = authRecord.getTerminal();
        boolean bl = false;
        if (uTDtuGroupArray == null) {
            throw new Exception("Primary disconnected before Secondary could connect..disconnecting secondary now !");
        }
        uTDtuGroupArray.lock();
        try {
            if (authRecord.isTerminated()) {
                throw new Exception("Primary destroyed before Secondary could get lock");
            }
            bl = authRecord.setSecondary(string2, this);
        }
        finally {
            Object var8_7 = null;
            uTDtuGroupArray.unlock();
        }
        if (bl) {
            this.primary = authRecord;
            this.groupTerminalId = string;
            this.tokenName = authRecord.tokenName;
        }
        return bl;
    }

    private String adminEvent(String string, String string2, String string3) {
        String string4;
        String string5;
        Admin admin = Admin.getAdmin();
        if (admin == null) {
            return string2;
        }
        String string6 = null;
        int n = string.indexOf("exist=");
        if (n >= 0) {
            string5 = "exist=true";
            string4 = "exist=false";
            if (string.regionMatches(n, string5, 0, string5.length())) {
                string6 = "true";
            } else if (string.regionMatches(n, string4, 0, string4.length())) {
                string6 = "false";
            } else {
                Log.unexpectedError((String)("adminEvent strange event=" + string + " lastExist=" + string2 + " exists=" + string6 + " ei=" + n + " etrue<" + string5 + ">" + string5.length()));
                string6 = "unknown";
            }
        }
        if (Configuration.reportAllDesktopEvents || string2 == null || string6 == null || !string6.equals(string2)) {
            string5 = this.terminal.getModel();
            string4 = this.terminal.getSerialNumber();
            admin.desktopEvent(string5, string4, string4, string, string3, System.currentTimeMillis());
        }
        return string6;
    }

    public void annotate(String string, Object object) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"annotate:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (object == null) {
            this.annotations.remove(string);
        } else {
            this.annotations.put(string, object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void cleanUpOnRedirect() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"cleanUpOnRedirect::Assertion failed");
            System.exit(1);
        }
        String string = this.terminal.getAuthIPAandPortString();
        byTerminalId.remove(this.terminalId);
        bySocket.remove(string);
    }

    public boolean compareCookie(String string) {
        boolean bl = Utils.cookieMatch((String)string, (String)this.callbackCookie);
        Log.debug((String)("compareCookie: match = " + bl));
        return bl;
    }

    public boolean connReq(Hashtable hashtable) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"connReq:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        if (hashtable.get("currentMod") != null) {
            this.currentMod = (Integer)hashtable.get("currentMod");
        }
        return this.client.connReq(hashtable);
    }

    public boolean connRsp(String string) {
        this.udpPort = string;
        return this.connRsp(false);
    }

    public boolean connRsp(boolean bl) {
        block33: {
            block32: {
                StringBuffer stringBuffer = new StringBuffer("");
                Hashtable<String, String> hashtable = new Hashtable<String, String>(6);
                String string = "";
                if (!this.mutex.assert()) {
                    Log.unexpectedError((String)"AuthRecord::connRsp:: Assertion failed.");
                    System.exit(1);
                }
                if (bl && !this.connected || this.destroyed) {
                    Log.debug((String)"AuthRecord:: connRsp returning as primary not connected");
                    return true;
                }
                if (this.isPrimary) {
                    Object object;
                    int n = 0;
                    while (n < this.secondaries.length) {
                        object = this.secondaries[n];
                        if (object != null && ((AuthRecord)object).udpPort != null) {
                            int n2;
                            Crypto crypto = ((AuthRecord)object).getCrypto();
                            Terminal terminal = ((AuthRecord)object).getTerminal();
                            stringBuffer.append(" ip" + n + "=" + ((AuthRecord)object).ipAddress + " port" + n + "=" + ((AuthRecord)object).udpPort);
                            String string2 = null;
                            if (crypto != null && (string2 = crypto.getMasterKey()) != null) {
                                stringBuffer.append(" key" + n + "=" + string2);
                            }
                            if (terminal != null && (n2 = terminal.getMTU()) != 0 && n2 != 1500) {
                                stringBuffer.append(" mtu" + n + "=" + n2);
                            }
                        } else {
                            stringBuffer.append(" ip" + n + "=" + " port" + n + "= ");
                        }
                        ++n;
                    }
                    object = null;
                    if (this.crypto != null && (object = this.crypto.getMasterKey()) != null) {
                        stringBuffer.append(" encUp=" + this.crypto.getEncUpType());
                        stringBuffer.append(" encDown=" + this.crypto.getEncDownType());
                    }
                    stringBuffer.append(" " + this.groupInfo.getPrivateData());
                } else if (this.primary == null) {
                    String string3 = null;
                    if (this.crypto != null && (string3 = this.crypto.getMasterKey()) != null) {
                        stringBuffer.append(" key=" + string3);
                        stringBuffer.append(" encUp=" + this.crypto.getEncUpType());
                        stringBuffer.append(" encDown=" + this.crypto.getEncDownType());
                    }
                    if (this.terminal != null) {
                        int n = this.terminal.getMTU();
                        Log.notice((String)("MTU = " + n));
                        if (n != 0 && n != 1500) {
                            stringBuffer.append(" mtu=" + n);
                        }
                    }
                }
                if (this.isPrimary || this.primary == null) {
                    hashtable.put("module", this.client.getModuleName());
                    if (!this.createClient()) {
                        if (this.tokenName != null) {
                            hashtable.put("token", this.tokenName);
                        }
                        string = "cannot init session";
                        hashtable.put("cause", string);
                        hashtable.put("access", "denied");
                        if (this.session != null) {
                            this.disconnect(string);
                        } else {
                            this.send("discInf", hashtable);
                        }
                        return false;
                    }
                    boolean bl2 = false;
                    if (bl) {
                        if (this.tokenIn && this.connected) {
                            bl2 = true;
                        }
                    } else if (this.expecting <= 0) {
                        Log.debug((String)"AuthRecord::Protocol error:unexpected connRsp");
                        this.expecting = 0;
                    } else if (--this.expecting == 0 && this.tokenIn && !this.connected) {
                        bl2 = true;
                    }
                    if (bl2) {
                        Log.debug((String)("Invoking session.connect with : " + stringBuffer));
                        if (!this.session.connect(this.ipAddress, this.udpPort, stringBuffer.toString())) {
                            Log.unexpectedError((String)"Cannot connect on port change");
                            this.destroy();
                        } else if (!this.connected) {
                            this.connectTime = System.currentTimeMillis();
                            this.connected = true;
                        }
                    }
                    return true;
                }
                Log.debug((String)("AuthRecord::connRsp of secondary,  calling primary: " + this.primary));
                if (this.expecting > 0) break block32;
                Log.debug((String)"AuthRecord::Protocol error:unexpected connRsp");
                this.expecting = 0;
                break block33;
            }
            if (--this.expecting != 0) break block33;
            this.connected = true;
            if (this.primary.isTerminated()) {
                Log.debug((String)"AuthRecord::Primary has been terminated.. do not queue secondary");
                return false;
            }
            try {
                jobQueue.submit((TaskListener)new AuthRecord(), (Object)this.primary, m_connRsp, new Object[]{this}, false);
            }
            catch (Exception exception) {
                Log.unexpectedError((String)("AuthRecord:: connRsp : " + exception));
            }
        }
        return true;
    }

    public boolean connect(String string) {
        return this.connect(string, this.terminal.renderIpa(), this.udpPort);
    }

    public boolean connect(String string, InetAddress inetAddress, String string2) {
        Admin admin;
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"connect:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(6);
        String string3 = "";
        if (this.tokenName == null) {
            this.tokenName = this.client.getGlobalName();
        }
        hashtable.put("module", this.client.getModuleName());
        if (this.connected) {
            Log.unexpectedError((String)("AuthRecord.connect: " + this.tokenName + " already connected"));
        }
        this.connected = false;
        if (this.tokenName != null) {
            hashtable.put("token", this.tokenName);
        }
        if (this.tokenIn) {
            ++this.expecting;
        }
        hashtable.put("access", "allowed");
        String string4 = null;
        this.setupCrypto(this.tokenName);
        string4 = this.crypto.getMyDHMsg();
        if (string4 != null) {
            hashtable.put("serverDH", string4);
        }
        if ((string4 = this.crypto.getServerRandom()) != null) {
            hashtable.put("serverRand", string4);
        }
        if ((string4 = this.crypto.getSignature()) != null) {
            hashtable.put("signature", string4);
        }
        if ((string4 = this.crypto.getEncUpType()) != null) {
            hashtable.put("encUpType", string4);
        }
        if ((string4 = this.crypto.getEncDownType()) != null) {
            hashtable.put("encDownType", string4);
        }
        if ((admin = Admin.getAdmin()) != null) {
            String string5;
            admin.getPolicyAttributes();
            if (UTPolicyAttributes.isMultiheadEnabled() && (string5 = admin.getDtuGrpPrimByDtuCID(this.terminalId, "MULTIHEAD")) != null && string5.equals(this.terminalId)) {
                AuthRecord.startJobQGroup();
                this.primary = this;
                this.isPrimary = true;
                this.groupTerminalId = this.terminalId;
                UTDtuGroup[] uTDtuGroupArray = admin.getDtuGrpByDtuCID(string5, "MULTIHEAD");
                if (uTDtuGroupArray != null) {
                    this.groupInfo = uTDtuGroupArray[0];
                    this.secondaries = new AuthRecord[this.groupInfo.getNDtus()];
                    Log.debug((String)("AuthRecord:: Num of Secondaries = " + this.secondaries.length));
                    String[] stringArray = this.groupInfo.getDtuCIDs();
                    if (this.terminalId.equals(stringArray[this.groupInfo.getPrimaryIdx()])) {
                        this.secondaries[this.groupInfo.getPrimaryIdx()] = this;
                    }
                }
            }
        }
        if (this.send("connInf", hashtable)) {
            this.lastExist = this.adminEvent("exist=true,session=true", this.lastExist, this.firmware);
            if (string == null) {
                Log.notice((String)("CONNECT " + this.terminalId + ", " + this.tokenName));
            } else {
                Log.notice((String)("CONNECT " + this.terminalId + ", " + this.tokenName + ", " + string));
            }
            return true;
        }
        if (this.tokenIn) {
            --this.expecting;
        }
        this.connected = false;
        if (this.session != null) {
            this.session.disconnect(inetAddress.getHostAddress());
        }
        Log.unexpectedError((String)(String.valueOf(this.getName()) + " cannot send connInf, " + "disconnecting session"));
        string3 = "cannot send connInf";
        Log.unexpectedError((String)(String.valueOf(this.tokenName) + " connect failed: " + string3));
        return false;
    }

    public void controlRsp(Hashtable hashtable) {
        Object object;
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"controlRsp:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        String string = (String)hashtable.get("tag");
        if (string == null) {
            object = this.taggedControllers.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
            }
            Log.debug((String)"Get the last tag from hash. Old firmare");
        }
        if (string != null) {
            object = (Controller)this.taggedControllers.get(string);
            if (object != null) {
                object.response(hashtable);
            } else {
                Log.notice((String)("No tagged controller  available to handle message: " + hashtable));
            }
        } else {
            Log.notice((String)("No controller available to handle message: " + hashtable));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createClient() {
        String string;
        Object object;
        Object object2;
        String string2;
        String string3 = this.terminal.getTokenSet();
        String string4 = null;
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"createClient:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        if (this.clientCreated) {
            return true;
        }
        if (utauthd.attachInProgress) {
            Log.debug((String)"AuthRecord:: attach in progress..");
            return false;
        }
        try {
            string2 = Configuration.forceSessionLocation ? String.valueOf(Configuration.sessionHost) + ":" + Configuration.sessionPort : this.client.getSessionManagerId();
            if (this.crypto.getSessionType() == 2) {
                string4 = this.getServiceStartCommand("sessionrefused");
                this.tokenName = "sessionrefused." + this.tokenName;
            } else {
                string4 = this.client.getServiceInitCommand();
            }
            if (string4 == null) {
                Log.notice((String)("Null command for client: " + this.client));
            }
            this.session = new Session(this.tokenName, string2);
            if (this.session.getSid() == null) {
                this.session = null;
                return false;
            }
            Log.debug((String)("bySid: sid = " + this.session.sessionId.toString()));
            Log.debug((String)("insertToken = " + this.insertToken));
            Log.debug((String)("tokenName = " + this.tokenName));
            Log.debug((String)("tokenSet = " + string3));
            if (bySid.get(this.session.sessionId.toString()) != null && (string3.indexOf("mobile") != -1 || string3.indexOf("asc") != -1 || string3.indexOf("auth") != -1)) {
                Log.debug((String)("createClient:bySid.get :: " + bySid.get(this.session.sessionId.toString()) + ", sid = " + this.session.sessionId.toString()));
                object2 = (AuthRecord)bySid.get(this.session.sessionId.toString());
                object = ((AuthRecord)object2).getTerminal();
                if (object == null) return false;
                ((Terminal)object).lock();
                try {
                    ((AuthRecord)object2).disconnect("old session");
                }
                finally {
                    string = null;
                    ((Terminal)object).unlock();
                }
                Log.notice((String)("Disconnected session by token: " + this.insertToken + " , on terminal: " + this.terminalId));
            } else {
                Log.debug((String)"createClient: New Session..no previous session");
            }
            bySid.put(this.session.sessionId.toString(), this);
        }
        catch (NullPointerException nullPointerException) {
            Log.unexpectedError((String)("createClient: " + nullPointerException));
            object2 = new ByteArrayOutputStream();
            object = new PrintWriter((OutputStream)object2);
            nullPointerException.printStackTrace((PrintWriter)object);
            ((PrintWriter)object).flush();
            Log.unexpectedError((String)((ByteArrayOutputStream)object2).toString());
            System.exit(1);
        }
        if (this.session == null) {
            return false;
        }
        string2 = null;
        object2 = tickets;
        synchronized (object2) {
            while (string2 == null) {
                try {
                    string2 = tickets.elementAt(0);
                    if (string2 == null) continue;
                    tickets.removeElementAt(0);
                }
                catch (NoSuchElementException noSuchElementException) {
                    try {
                        tickets.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        tickets.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        try {
            Log.debug((String)(String.valueOf(this.getName()) + " createClient running: <" + string4 + ">"));
            object2 = Runtime.getRuntime().exec(string4);
            object = new PrintWriter(((Process)object2).getOutputStream());
            String string5 = "CORONA_SESSION=" + this.session.getSid();
            Log.debug((String)(String.valueOf(this.getName()) + " createClient param1: <" + string5 + ">"));
            ((PrintWriter)object).println(string5);
            string5 = "TOKEN_IDENTITY=" + this.tokenName;
            Log.debug((String)(String.valueOf(this.getName()) + " createClient param2: <" + string5 + ">"));
            ((PrintWriter)object).println(string5);
            string5 = "INSERT_TOKEN=" + this.insertToken;
            Log.debug((String)(String.valueOf(this.getName()) + " createClient param3: <" + string5 + ">"));
            ((PrintWriter)object).println(string5);
            string5 = "TERMINAL_ID=" + this.terminalId;
            ((PrintWriter)object).println(string5);
            string5 = "MODEL_ID=" + this.terminal.getModel();
            ((PrintWriter)object).println(string5);
            string5 = "TOKEN_SET=" + string3;
            ((PrintWriter)object).println(string5);
            string = this.terminal.getResolution();
            if (string != null) {
                string5 = "CURRENT_RESOLUTION=" + string;
                Log.debug((String)(String.valueOf(this.getName()) + " createClient param4: <" + string5 + ">"));
                ((PrintWriter)object).println(string5);
            }
            if (this.groupInfo != null) {
                string5 = "GROUP_PRIVATE_DATA=" + this.groupInfo.getPrivateData();
                Log.debug((String)(String.valueOf(this.getName()) + " createClient param5: <" + string5 + ">"));
                ((PrintWriter)object).println(string5);
            }
            this.callbackCookie = Utils.makeCookie();
            string5 = "CALLBACK_COOKIE=" + this.callbackCookie;
            Log.debug((String)("getName() createClient param6: <" + string5 + ">"));
            ((PrintWriter)object).println(string5);
            ((PrintWriter)object).close();
            int n = ((Process)object2).waitFor();
            try {
                byte[] byArray;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                InputStream inputStream = ((Process)object2).getInputStream();
                InputStream inputStream2 = ((Process)object2).getErrorStream();
                try {
                    n2 = inputStream.available();
                    n3 = inputStream2.available();
                }
                catch (Exception exception) {}
                if (n2 > 0) {
                    byArray = new byte[n2];
                    try {
                        n4 = inputStream.read(byArray, 0, n2);
                        Log.notice((String)("AuthRecord::CreateClient:" + string4 + " :child output: " + new String(byArray)));
                    }
                    catch (IOException iOException) {}
                }
                if (n3 > 0) {
                    byArray = new byte[n3];
                    try {
                        n4 = inputStream2.read(byArray, 0, n3);
                        Log.unexpectedError((String)("AuthRecord::CreateClient:" + string4 + " :child error: " + new String(byArray)));
                    }
                    catch (IOException iOException) {}
                }
                inputStream.close();
                inputStream2.close();
            }
            catch (Exception exception) {}
            Log.debug((String)(String.valueOf(this.getName()) + " createClient: exitValue=" + n));
            if (n != 0) {
                Log.unexpectedError((String)("SESSION_ERROR " + this.tokenName + " exitCode=" + n));
                Vector vector = tickets;
                synchronized (vector) {
                    tickets.addElement(string2);
                    tickets.notifyAll();
                    return false;
                }
            }
            Log.notice((String)("SESSION_OK " + this.tokenName));
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("SESSION_ERROR " + this.tokenName + " " + exception + " <" + string4 + ">" + " Client = " + this.client));
            object = tickets;
            synchronized (object) {
                tickets.addElement(string2);
                tickets.notifyAll();
                return false;
            }
        }
        this.clientCreated = true;
        object2 = tickets;
        synchronized (object2) {
            tickets.addElement(string2);
            tickets.notifyAll();
            return true;
        }
    }

    public void destroy() {
        Object object;
        Enumeration enumeration;
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"destroy:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (this.isPrimary) {
            int n = 0;
            while (n < this.secondaries.length) {
                enumeration = this.secondaries[n];
                object = null;
                if (enumeration != null && enumeration != this) {
                    while ((object = ((AuthRecord)((Object)enumeration)).getTerminal()) != null) {
                        Object var5_5;
                        ((Terminal)object).lock();
                        try {
                            if (object != ((AuthRecord)((Object)enumeration)).getTerminal()) {
                                var5_5 = null;
                                ((Terminal)object).unlock();
                                continue;
                            }
                            ((AuthRecord)((Object)enumeration)).destroy();
                        }
                        catch (Throwable throwable) {
                            var5_5 = null;
                            ((Terminal)object).unlock();
                            throw throwable;
                        }
                        var5_5 = null;
                        ((Terminal)object).unlock();
                        break;
                    }
                }
                ++n;
            }
        }
        if (this.connected) {
            this.disconnect("destroy", false, this.isPrimary ^ true);
        }
        this.destroyed = true;
        Log.notice((String)("DESTROY " + this.tokenName + " lifetime=" + (System.currentTimeMillis() - this.createTime)));
        this.lastExist = this.adminEvent("exist=false,session=false", this.lastExist, this.firmware);
        Enumeration enumeration2 = this.taggedControllers.keys();
        while (enumeration2.hasMoreElements()) {
            enumeration = (String)enumeration2.nextElement();
            Log.debug((String)("AuthRecord:: destorying controller: " + (String)((Object)enumeration)));
            object = (Controller)this.taggedControllers.get(enumeration);
            if (object == null) continue;
            object.destroy();
        }
        if (this.terminal.getAuthIPAandPortString() != null) {
            bySocket.remove(this.terminal.getAuthIPAandPortString());
        }
        if (this.terminalId != null) {
            byTerminalId.remove(this.terminalId);
        }
        if (this.session != null) {
            bySid.remove(this.session.sessionId.toString());
        }
        if (this.tokenName != null && ((String)((Object)(enumeration = this.tokenName.substring(0, this.tokenName.indexOf("."))))).equals("mobile") | ((String)((Object)enumeration)).equals("escape") | ((String)((Object)enumeration)).equals("auth")) {
            AuthRecord.dpyTokReplace(this.tokenName);
        }
        this.terminalId = null;
        this.name = null;
        this.tokenName = null;
        this.udpPort = null;
        if (!this.terminal.isActionPending()) {
            this.terminal = null;
        }
        this.firmware = null;
        this.taggedControllers = null;
        this.client = null;
        this.session = null;
        this.clientCreated = false;
        this.lastExist = null;
        if (this.annotations != null) {
            enumeration = this.annotations.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                this.annotations.remove(object);
            }
            this.annotations = null;
        }
        Log.debug((String)"AuthRecord.destroy completed");
    }

    public void disconnect(String string) {
        this.disconnect(string, false, false);
    }

    public void disconnect(String string, boolean bl) {
        this.disconnect(string, bl, false);
    }

    public void disconnect(String string, boolean bl, boolean bl2) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"disconnect:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (this.isPrimary) {
            int n = 0;
            while (n < this.secondaries.length) {
                AuthRecord authRecord = this.secondaries[n];
                Terminal terminal = null;
                if (authRecord != null && authRecord != this) {
                    while ((terminal = authRecord.getTerminal()) != null) {
                        Object var8_9;
                        terminal.lock();
                        try {
                            if (terminal != authRecord.getTerminal()) {
                                var8_9 = null;
                                terminal.unlock();
                                continue;
                            }
                            authRecord.disconnect(string, bl, this.session != null);
                        }
                        catch (Throwable throwable) {
                            var8_9 = null;
                            terminal.unlock();
                            throw throwable;
                        }
                        var8_9 = null;
                        terminal.unlock();
                        break;
                    }
                }
                ++n;
            }
        }
        if (string != null) {
            Log.notice((String)("DISCONNECT " + this.terminalId + ", " + this.tokenName + " " + string));
        } else {
            Log.notice((String)("DISCONNECT " + this.terminalId + ", " + this.tokenName));
        }
        if (this.session != null || bl2) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("module", this.client.getModuleName());
            } else {
                Log.unexpectedError((String)"AuthRecord.disconnect: Null Client");
            }
            hashtable.put("access", "denied");
            this.send("discInf", hashtable);
            this.connected = false;
            this.udpPort = null;
            if (this.session != null) {
                this.session.disconnect(this.ipAddress);
            } else {
                try {
                    jobQueue.submit((TaskListener)new AuthRecord(), (Object)this.primary, m_connRsp, new Object[]{this}, false);
                }
                catch (Exception exception) {
                    Log.unexpectedError((String)("AuthRecord:: disconnect : " + exception));
                }
            }
        }
        if (!string.equals("destroy")) {
            this.destroy();
        }
    }

    private void doSync(Hashtable hashtable, Hashtable hashtable2) {
        UTDtuGroup uTDtuGroup;
        String string = (String)hashtable.get(this.terminalId);
        if (this.groupTerminalId == null) {
            if (string != null) {
                Log.debug((String)("Resetting new terminal added to a group : " + string));
                this.disconnect("syncing terminal groups", true);
            }
            return;
        }
        if (this.terminalId.equals(this.groupTerminalId) && ((uTDtuGroup = (UTDtuGroup)hashtable2.get(this.terminalId)) == null && this.groupInfo != null || uTDtuGroup != null && this.groupInfo == null || !uTDtuGroup.toString().equals(this.groupInfo.toString()))) {
            Log.debug((String)("Resetting old primary : " + this.terminalId));
            this.disconnect("syncing terminal groups", true);
            return;
        }
    }

    private static void dpyTokReplace(String string) {
        String string2 = new String("/var/opt/SUNWut/ctokens/" + string);
        String string3 = null;
        String string4 = null;
        File file = new File(string2);
        if (!file.exists()) {
            Log.debug((String)("AuthRecord::dpyTokReplace:ctoken file" + string2 + " doesnot exist"));
            return;
        }
        try {
            String string5;
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringTokenizer stringTokenizer = null;
            String string6 = null;
            StringBuffer stringBuffer = new StringBuffer("");
            while ((string6 = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string6, "=");
                object = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
                if (((String)object).equals("TOKEN")) {
                    string3 = string5;
                    stringBuffer.append(String.valueOf(string6) + "\n");
                    continue;
                }
                if (((String)object).equals("DISPLAY")) {
                    string4 = string5;
                    stringBuffer.append(String.valueOf(string6) + "\n");
                    continue;
                }
                if (((String)object).equals("INSERT_TOKEN")) {
                    stringBuffer.append("INSERT_TOKEN=" + string3 + "\n");
                    continue;
                }
                if (((String)object).equals("TOKEN_SET")) {
                    stringBuffer.append("TOKEN_SET=" + string3 + "\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(string6) + "\n");
            }
            bufferedReader.close();
            object = new PrintWriter(new FileOutputStream(file));
            ((PrintWriter)object).print(stringBuffer);
            ((PrintWriter)object).close();
            string5 = new String("/tmp/SUNWut/session_proc/" + string4);
            File file2 = new File(string5);
            if (!file2.exists()) {
                Log.unexpectedError((String)("Error: AuthRecord::dpyTokReplace:sessionProc file" + string5 + " doesnot exist"));
                return;
            }
            if (!file2.setLastModified(System.currentTimeMillis())) {
                Log.unexpectedError((String)("Error: AuthRecord::dpyTokReplace:touch failed for sessionProc file " + string5));
            }
        }
        catch (Exception exception) {
            Log.unexpectedError((String)("AuthRecord::dpyTokReplace: " + exception));
        }
    }

    public void finalize() throws Throwable {
        long l = System.currentTimeMillis();
        super.finalize();
    }

    public Object getAnnotation(String string) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"getAnnotation:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return null;
        }
        return this.annotations.get(string);
    }

    public Enumeration getAnnotationKeys() {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"getAnnotationKeys:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return null;
        }
        return this.annotations.keys();
    }

    public Integer getAuthPort() {
        return new Integer(Configuration.port);
    }

    public static AuthRecord getBySid(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (AuthRecord)bySid.get(sessionId.toString());
    }

    public static AuthRecord getBySocket(String string) {
        if (string == null) {
            return null;
        }
        return (AuthRecord)bySocket.get(string);
    }

    public static AuthRecord getByTerminalId(String string) {
        if (string == null) {
            return null;
        }
        return (AuthRecord)byTerminalId.get(string);
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getCurrentMod() {
        return this.currentMod;
    }

    public String getDefaultSessionHost() {
        return Configuration.sessionHost;
    }

    public int getDefaultSessionPort() {
        return Configuration.sessionPort;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public LogicalToken getLogicalToken(String string) {
        if (this.destroyed) {
            return null;
        }
        LogicalToken logicalToken = null;
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            logicalToken = admin.getLogicalToken(string);
        }
        return logicalToken;
    }

    public String getName() {
        Terminal terminal = null;
        if (!this.destroyed) {
            terminal = this.terminal;
        }
        if (terminal != null) {
            return terminal.getAuthIPAandPortString();
        }
        return null;
    }

    public synchronized String getPrimaryId() {
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            return admin.getDtuGrpPrimByDtuCID(this.terminalId, "MULTIHEAD");
        }
        return null;
    }

    public RawToken getRawToken(String string) {
        if (this.destroyed) {
            return null;
        }
        RawToken rawToken = null;
        Admin admin = Admin.getAdmin();
        if (admin != null) {
            rawToken = admin.getRawToken(string);
        }
        return rawToken;
    }

    public String getServiceStartCommand(String string) {
        if ((sessionTypes = AuthRecord.refreshProperties(Configuration.sessionTypesFileName, sessionTypes)) == null) {
            Log.configError((String)"Cannot read session types");
            System.exit(1);
        }
        String string2 = (String)((Hashtable)sessionTypes).get(String.valueOf(string) + ".start");
        return string2;
    }

    public String getServiceStopCommand(String string) {
        if ((sessionTypes = AuthRecord.refreshProperties(Configuration.sessionTypesFileName, sessionTypes)) == null) {
            Log.configError((String)"Cannot read session types");
            System.exit(1);
        }
        String string2 = (String)((Hashtable)sessionTypes).get(String.valueOf(string) + ".stop");
        return string2;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public String getTerminalId() {
        return this.terminalId;
    }

    public String getTokenSet() {
        return this.terminal.getTokenSet();
    }

    public static int gotTerminal(String string) {
        if (AuthRecord.getByTerminalId(string) == null) {
            return 0;
        }
        return 1;
    }

    public static void initTickets(int n) {
        tickets = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            tickets.addElement(new Object());
            ++n2;
        }
    }

    public boolean isGroupManagerEnabled() {
        return Configuration.enableGroupManager;
    }

    private boolean isIdle() {
        String string = (String)this.getAnnotation("x_idle");
        return string != null && string.equals("true");
    }

    public boolean isTerminated() {
        return this.destroyed || this.terminated;
    }

    public String mapModuleToGlobalName(String string) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"mapModuleToGlobalName::Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return null;
        }
        return AuthRecord.mapModuleToGlobalNameImpl(string);
    }

    private static String mapModuleToGlobalNameImpl(String string) {
        String string2;
        String string3 = AuthRecord.rawTokenEquiv(string);
        Admin admin = Admin.getAdmin();
        if (admin != null && (string2 = admin.rawTokenIDtoLogicalTokenID(string3)) != null) {
            string3 = string2;
        }
        return string3;
    }

    public boolean message(String string, Hashtable hashtable) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"message:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return false;
        }
        Log.debug((String)("AuthRecord.message(): command = " + string));
        Log.debug((String)("AuthRecord.message(): param = " + hashtable));
        return this.client.message(string, hashtable);
    }

    public static int numberOfConnections() {
        return byTerminalId.size();
    }

    public boolean primaryConnect(AuthRecord authRecord) {
        boolean bl = true;
        Log.debug((String)("AuthRecord::Primary connected:: " + this.connected));
        bl = this.connRsp(true);
        if (!bl) {
            return bl;
        }
        if (this.destroyed && authRecord != null && authRecord.terminal != null) {
            Log.debug((String)"AuthRecord::primary destroyed. Recycle DTU ");
            authRecord.terminal.close();
            return true;
        }
        return bl;
    }

    private boolean putStatus(BufferedWriter bufferedWriter, Terminal terminal) throws IOException {
        if (this.destroyed) {
            return false;
        }
        bufferedWriter.write("begin");
        bufferedWriter.newLine();
        bufferedWriter.write("terminalId=" + terminal.getModel() + "." + terminal.getSerialNumber());
        bufferedWriter.newLine();
        bufferedWriter.write("terminalCID=" + this.terminalId);
        bufferedWriter.newLine();
        bufferedWriter.write("terminalModel=" + terminal.getModel());
        bufferedWriter.newLine();
        if (this.firmware != null) {
            bufferedWriter.write("firmware=");
            int n = this.firmware.indexOf(",Boot:");
            if (n == -1) {
                bufferedWriter.write(this.firmware);
                bufferedWriter.newLine();
                bufferedWriter.write("boot=unknown");
            } else {
                bufferedWriter.write(this.firmware.substring(0, n));
                bufferedWriter.newLine();
                bufferedWriter.write("boot=" + this.firmware.substring(n + 6));
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.write("connected=" + this.connected);
        bufferedWriter.newLine();
        bufferedWriter.write("createTime=" + this.createTime);
        bufferedWriter.newLine();
        bufferedWriter.write("connectTime=" + this.connectTime);
        bufferedWriter.newLine();
        bufferedWriter.write("terminalIPA=" + this.terminal.getIPAddressString());
        bufferedWriter.newLine();
        if (!Configuration.termAddrIsSecret) {
            bufferedWriter.write("udpPort=" + this.udpPort);
            bufferedWriter.newLine();
        }
        bufferedWriter.write("terminalPort=" + this.terminal.renderPort());
        bufferedWriter.newLine();
        if (this.client != null) {
            bufferedWriter.write("LocalName=" + this.client.getLocalName());
            bufferedWriter.newLine();
            bufferedWriter.write("GlobalName=" + this.client.getGlobalName());
            bufferedWriter.newLine();
            bufferedWriter.write("ModuleName=" + this.client.getModuleName());
            bufferedWriter.newLine();
            bufferedWriter.write("SessionManagerId=" + this.client.getSessionManagerId());
            bufferedWriter.newLine();
            if (this.crypto.getSessionType() == 2) {
                bufferedWriter.write("ServiceInitCommand=" + this.getServiceStartCommand("sessionrefused"));
            } else {
                bufferedWriter.write("ServiceInitCommand=" + this.client.getServiceInitCommand());
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.write("tokenName=" + this.tokenName);
        bufferedWriter.newLine();
        bufferedWriter.write("clientCreated=" + this.clientCreated);
        bufferedWriter.newLine();
        bufferedWriter.write("lifetime=" + (System.currentTimeMillis() - this.createTime));
        bufferedWriter.newLine();
        Enumeration enumeration = this.annotations.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.annotations.get(string);
            if (!string.startsWith("x_")) continue;
            bufferedWriter.write("annotation." + string + "=" + string2);
            bufferedWriter.newLine();
        }
        if (this.destroyed) {
            bufferedWriter.write("destroyed=" + this.destroyed);
            bufferedWriter.newLine();
        }
        bufferedWriter.write(terminal.getTerminalStats());
        bufferedWriter.newLine();
        if (this.groupTerminalId != null) {
            bufferedWriter.write("MultiheadGroupName=" + this.groupInfo.getDtuGroupID());
            bufferedWriter.newLine();
            bufferedWriter.write("MultiheadTerminalIndex=" + this.groupInfo.getTerminalIndex(this.terminalId));
            bufferedWriter.newLine();
            bufferedWriter.write("MultiheadData=" + this.groupInfo.getPrivateData());
            bufferedWriter.newLine();
            bufferedWriter.write("MultiheadPrimary=" + this.isPrimary);
            bufferedWriter.newLine();
        }
        if (this.crypto != null) {
            bufferedWriter.write(this.crypto.getSessionInfo());
            bufferedWriter.newLine();
        }
        bufferedWriter.write("firstServer=" + terminal.getFirstServer());
        bufferedWriter.newLine();
        bufferedWriter.write("end");
        bufferedWriter.newLine();
        bufferedWriter.flush();
        return true;
    }

    private static String rawTokenEquiv(String string) {
        if (Configuration.namesFileName == null) {
            return string;
        }
        if ((nameMappings = AuthRecord.refreshProperties(Configuration.namesFileName, nameMappings)) == null) {
            return string;
        }
        String string2 = (String)((Hashtable)nameMappings).get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean redirect(Hashtable hashtable, boolean bl) {
        Object object;
        String string = null;
        Log.debug((String)"AuthRecord::Doing Redirect");
        if (this.destroyed) {
            return false;
        }
        Hashtable hashtable2 = this.terminal.getStoredParams();
        if (bl) {
            Log.notice((String)("AuthRecord:redirect:: Redirecting terminal " + this.terminalId + " to a trusted host " + hashtable.get("authipa")));
            if (this.tokenName != null) {
                hashtable.put("authtoken", this.tokenName);
                hashtable.put("realType", this.tokenName.substring(0, this.tokenName.indexOf(".")));
                hashtable.put("realId", this.tokenName.substring(this.tokenName.indexOf(".") + 1, this.tokenName.length()));
            }
            string = String.valueOf(RegisterKeys.tokenSetKey) + "=" + this.getTokenSet();
            if (hashtable2 != null && hashtable2.get("auth") != null) {
                string = String.valueOf(string) + " " + RegisterKeys.authKey + "=" + hashtable2.get("auth");
            }
        } else {
            Log.notice((String)("AuthRecord:redirect:: Redirecting terminal " + this.terminalId + " to a non-trusted host " + hashtable.get("authipa")));
            string = String.valueOf(RegisterKeys.authKey) + "=false";
        }
        if (hashtable2 != null) {
            String string2 = (String)hashtable2.get("username");
            if (string2 != null && !string2.equals("")) {
                string = String.valueOf(string) + " " + RegisterKeys.usernameKey + "=" + string2;
            }
            if ((object = (String)hashtable2.get("quicklogin")) != null && !((String)object).equals("")) {
                string = String.valueOf(string) + " " + RegisterKeys.quickloginKey + "=" + (String)object;
            }
        }
        if (string != null) {
            hashtable.put("redirectProps", string);
        }
        if (!this.send("redirectInf", hashtable)) {
            return false;
        }
        if (this.isPrimary && bl) {
            int n = 0;
            while (n < this.secondaries.length) {
                block18: {
                    object = this.secondaries[n];
                    Terminal terminal = null;
                    if (object != null && object != this) {
                        while ((terminal = ((AuthRecord)object).getTerminal()) != null) {
                            Object var9_9;
                            terminal.lock();
                            try {
                                if (terminal != ((AuthRecord)object).getTerminal()) {
                                    var9_9 = null;
                                    terminal.unlock();
                                    continue;
                                }
                                ((AuthRecord)object).redirect(hashtable, bl);
                            }
                            catch (Throwable throwable) {
                                var9_9 = null;
                                terminal.unlock();
                                throw throwable;
                            }
                            var9_9 = null;
                            terminal.unlock();
                            break block18;
                        }
                        Log.notice((String)"redirect: terminal object is null.");
                        return false;
                    }
                }
                ++n;
            }
        }
        if (this.terminal.isActionPending()) {
            this.terminal.setActionPending(false);
            this.terminal.enable();
        }
        return true;
    }

    private static Properties refreshProperties(String string, Properties properties) {
        boolean bl = false;
        if (string == null) {
            Log.configError((String)"refreshProperties: no filename");
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            Log.configError((String)("refreshProperties: file non-existent: " + string));
            return null;
        }
        long l = file.lastModified();
        if (properties != null) {
            long l2 = (Long)((Hashtable)properties).get("=lastReadTime");
            if (l2 != l) {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            Log.debug((String)("refreshProperties: rereading " + string));
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties = new Properties();
                properties.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (Exception exception) {
                Log.configError((String)("cannot read properties file:" + string));
                return null;
            }
            ((Hashtable)properties).put("=lastReadTime", new Long(l));
        }
        return properties;
    }

    public boolean send(String string, Hashtable hashtable) {
        if (this.destroyed) {
            return false;
        }
        return this.terminal.write(string, hashtable);
    }

    public void setClient(AuthenticationClient authenticationClient) {
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"setClient:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        this.client = authenticationClient;
    }

    public void setController(String string, Controller controller) throws Exception {
        if (this.destroyed) {
            return;
        }
        if (string == null) {
            Exception exception = new Exception("Controller is not tagged.");
            exception.fillInStackTrace();
            throw new Exception("Controller is not tagged.");
        }
        if (controller != null) {
            this.taggedControllers.put(string, controller);
            Log.debug((String)("AR: controller added: tag = " + string + " control = " + controller));
        } else {
            this.taggedControllers.remove(string);
        }
    }

    private boolean setSecondary(String string, AuthRecord authRecord) {
        int n = -1;
        if (this.groupInfo == null) {
            return false;
        }
        String[] stringArray = this.groupInfo.getDtuCIDs();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.equals(stringArray[n2])) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return false;
        }
        this.secondaries[n] = authRecord;
        return true;
    }

    public void setTokenState(boolean bl) {
        this.tokenIn = bl;
    }

    public void setupCrypto(String string) {
        String string2 = this.terminal.getClientRandom();
        if (string == null) {
            return;
        }
        this.crypto.resetCrypto();
        this.crypto.readConfig(string);
        this.crypto.setSessionType(string2);
        if (string2 != null) {
            this.crypto.processChallenge(string2);
        }
    }

    private static void startJobQGroup() {
        if (jobQGroup) {
            return;
        }
        Log.debug((String)"Initializing JobQGroup");
        jobQueue = new JobQueue("JobQGroup");
        try {
            m_connRsp = (class$auth$utauthd$AuthRecord != null ? class$auth$utauthd$AuthRecord : (class$auth$utauthd$AuthRecord = AuthRecord.class$("auth.utauthd.AuthRecord"))).getMethod("primaryConnect", class$auth$utauthd$AuthRecord != null ? class$auth$utauthd$AuthRecord : (class$auth$utauthd$AuthRecord = AuthRecord.class$("auth.utauthd.AuthRecord")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.configError((String)("Cannot get AuthRecord.primaryConnect method" + noSuchMethodException));
            System.exit(1);
        }
        jobQGroup = true;
        Log.debug((String)"JobQGroup Initialized");
    }

    public static void status(OutputStream outputStream, String string) throws IOException {
        block9: {
            Hashtable hashtable = (Hashtable)byTerminalId.clone();
            if (string == null) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    AuthRecord.statusImpl(outputStream, (AuthRecord)enumeration.nextElement());
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
                try {
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    if (string2.equalsIgnoreCase("terminalCID")) {
                        AuthRecord.statusImpl(outputStream, (AuthRecord)hashtable.get(string3));
                        break block9;
                    }
                    if (string2.equalsIgnoreCase("tokenName")) {
                        Enumeration enumeration = hashtable.elements();
                        while (enumeration.hasMoreElements()) {
                            AuthRecord authRecord = (AuthRecord)enumeration.nextElement();
                            if (!authRecord.tokenName.equals(string3)) continue;
                            AuthRecord.statusImpl(outputStream, authRecord);
                            if (authRecord.isPrimary || authRecord.primary != null) {
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    return;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
    }

    private static void statusImpl(OutputStream outputStream, AuthRecord authRecord) throws IOException {
        BufferedWriter bufferedWriter;
        if (authRecord == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1500);
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.configError((String)("during status: " + unsupportedEncodingException));
            return;
        }
        Terminal terminal = authRecord.getTerminal();
        if (terminal != null) {
            block6: {
                terminal.lock();
                try {
                    if (!authRecord.putStatus(bufferedWriter, terminal)) break block6;
                    byteArrayOutputStream.writeTo(outputStream);
                    outputStream.flush();
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    terminal.unlock();
                    throw throwable;
                }
            }
            Object var6_6 = null;
            terminal.unlock();
        }
    }

    public static void syncTerminalGroups(Hashtable hashtable, Hashtable hashtable2) throws IOException {
        Hashtable hashtable3 = (Hashtable)byTerminalId.clone();
        Enumeration enumeration = hashtable3.elements();
        while (enumeration.hasMoreElements()) {
            AuthRecord authRecord = (AuthRecord)enumeration.nextElement();
            Terminal terminal = authRecord.getTerminal();
            if (terminal == null) continue;
            terminal.lock();
            try {
                authRecord.doSync(hashtable, hashtable2);
            }
            finally {
                Object var7_6 = null;
                terminal.unlock();
            }
        }
    }

    public void taskEvent(Object object) {
        JobQueueEntry jobQueueEntry = (JobQueueEntry)object;
        Log.debug((String)"AuthRecord.taskEvent:: locking terminal");
        AuthRecord authRecord = (AuthRecord)jobQueueEntry.param;
        Terminal terminal = authRecord.getTerminal();
        if (terminal == null) {
            Log.unexpectedError((String)"AuthRecord.taskEvent: Terminal is null. returning.");
            return;
        }
        terminal.lock();
        JobQueueEntry jobQueueEntry2 = jobQueueEntry;
        synchronized (jobQueueEntry2) {
            try {
                block11: {
                    try {
                        jobQueueEntry.result = jobQueueEntry.method.invoke(jobQueueEntry.param, jobQueueEntry.args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Log.unexpectedError((String)("AuthRecord:taskEvent " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + illegalAccessException));
                        System.exit(1);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println(invocationTargetException.getTargetException());
                        Log.unexpectedError((String)("AuthRecord:taskEvent: " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + invocationTargetException.getTargetException()));
                        System.exit(1);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        Log.unexpectedError((String)("AuthRecord:taskEvent: " + jobQueueEntry.method + " " + jobQueueEntry.args + " " + noClassDefFoundError));
                        System.exit(1);
                    }
                    catch (Exception exception) {
                        jobQueueEntry.exception = exception;
                        if (jobQueueEntry.sync) break block11;
                        Log.unexpectedError((String)("AuthRecord:taskEvent: " + exception));
                    }
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                Log.debug((String)"AuthRecord.taskEvent:: releasing terminal");
                terminal.unlock();
                throw throwable;
            }
            Log.debug((String)"AuthRecord.taskEvent:: releasing terminal");
            terminal.unlock();
            jobQueueEntry.done = true;
        }
    }

    public void terminate(int n, boolean bl) {
        Log.debug((String)("terminate: " + this.tokenName + " join=" + n));
        if (!this.mutex.assert()) {
            Log.unexpectedError((String)"terminate:: Assertion failed.");
            System.exit(1);
        }
        if (this.destroyed) {
            return;
        }
        if (!this.isIdle() && SessionManager.readActiveSessionId(this.tokenName) != null) {
            Log.debug((String)("terminate: session still configured: " + this.tokenName));
            return;
        }
        if (this.terminal.isActionPending()) {
            this.terminal.enable();
        }
        this.disconnect("session terminated", true);
        this.terminated = true;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        try {
            if (this.destroyed) {
                bufferedWriter.write("defunct");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("terminalId=" + this.terminalId);
            bufferedWriter.newLine();
            bufferedWriter.write("tokenName=" + this.tokenName);
            bufferedWriter.newLine();
            if (this.taggedControllers == null) {
                bufferedWriter.write("No tagged controllers");
            } else {
                Enumeration enumeration = this.taggedControllers.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    bufferedWriter.write("Controller : " + string);
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            return "AuthRecord--cannot-toString!";
        }
        return stringWriter.toString().replace('\n', '/');
    }

    private static synchronized String uniqueTransientName() {
        if (uniquePrefix == null) {
            String string = (String)((Hashtable)System.getProperties()).get("prefix");
            string = string != null ? String.valueOf(string) + "." : "";
            uniquePrefix = String.valueOf(string) + System.currentTimeMillis() + ".";
        }
        return String.valueOf(uniquePrefix) + ++uniqueNumber;
    }
}

