/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2003 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

//
// File: Sample1Applet.java
//
// This sample file is provided to show you how easy it is to create a
// working Terminal as a Java applet. It requires an HTML file to operate.
// Sample1Applet.html has been supplied for this purpose.
//

package samples.bean;

import com.sun.emp.pathway.bean.Terminal;

import java.awt.Font;
import javax.swing.JApplet;

public class Sample1Applet extends JApplet {
    private Terminal terminal;

    //
    // Create a new Terminal and set its Host, Port, Model and Font.
    //
    public void init() {
	//
	// Get the Host
	//
	String hostName = getDocumentBase().getHost();
	if ( (hostName == null) || (hostName.length()==0) ) {
	    System.err.println("No valid host could be found");
	}

	//
	// Get the Port
	//
	int port;
	try {
	    port = Integer.parseInt(getParameter("Port"));
	} catch (NumberFormatException e) {
	    port = 2001;
	}

	//
	// Create a Terminal and set the Host, Port, Model and Font.
	//
	terminal = new Terminal();
	terminal.setTN3270Host(hostName);
	terminal.setTN3270Port(port);
	terminal.setModel(Terminal.MODEL_3278_2_E);
	terminal.setFont(new Font("Monospaced", Font.PLAIN, 12));

	//
	// Add the Terminal to the Applet.
	//
	getContentPane().add(terminal);
    }

    public void start() {
	//
	// Connect the Terminal to the host if the emulator is disconnected.
	//
	if (terminal.isDisconnected()) {
	    terminal.connect();
	}
    }

    public void stop() {
	//
	// Disconnect the Terminal from the host if the emulator is connected
	//
	if (terminal.isConnected()) {
	    terminal.disconnect();
	}
    }
}
