/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2003 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

//
// File: Sample1.java
//
// This sample program is provided to demonstrate the simplicity of
// creating a working Terminal. All that is required is to set the host
// and port settings and then issue the connect() command.
//
// This program takes the parameters:
//   The host system	e.g. myhost
//   The port number	e.g. 9993
//
// e.g. java Sample1 myhost 9993
//

package samples.bean;

import com.sun.emp.pathway.bean.Terminal;

import java.awt.Font;
import javax.swing.JFrame;

public class Sample1 {
    public static final void main(String[] args) {
	//
	// If the host and port haven't been supplied, end the program.
	//
	if (args.length !=2) {
	   System.out.println("Usage: java Sample1 <host> <port>");
	   System.exit(0);
	}
	
	//
	// Create a new JFrame and a new Terminal.
	//
	JFrame jf = new JFrame("Sample 1");
	Terminal terminal = new Terminal();

	//
	// Set the Host, Port and Model of the Terminal.
	//
	terminal.setTN3270Host(args[0]);
	terminal.setTN3270Port(Integer.parseInt(args[1]));
	terminal.setModel(Terminal.MODEL_3278_2_E);

	//
	// Set the Font of the Terminal to make it more readable.
	//
	terminal.setFont(new Font("Monospaced", Font.PLAIN, 12));

	//
	// Add the Terminal to the JFrame, then pack and show the JFrame.
	//
	jf.getContentPane().add(terminal);
	jf.pack();
	jf.setVisible(true);

	//
	// Connect the Terminal to the host.
	//
	terminal.connect();
    }
}
