/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2003 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

//
// File: ACCTSample.java
//
// This sample program accesses the MTP system specified and runs
// and runs the ACCT transaction in order to return the account number
// of the first found entry
//
// This program is intended to demonstrate how to call a 3270 Pathway
// generated bean.
//
// This program takes the parameters:
//   The host name	 e.g. myhost
//   The port number	 e.g. 9993
//   The search string	 e.g. Greenfield 
//
// e.g. java ACCTSample myhost 9993 Greenfield
//

package samples.recorder;

import com.sun.emp.pathway.bean.Terminal;

import java.awt.BorderLayout;
import javax.swing.JFrame;

public class ACCTSample {
    public static void main(String[] args) {
	//
	// If the host and port haven't been supplied, end the program.
	//
	if (args.length !=3) {
	   System.out.println("Usage: java ACCTSample <host> <port> <search-string>");
	   System.exit(0);
	}

	//
	// Create a Terminal and set the Host, Port and Model.
	//
	Terminal terminal = new Terminal();
	terminal.setTN3270Host(args[0]);
	terminal.setTN3270Port(Integer.parseInt(args[1]));
	terminal.setModel(Terminal.MODEL_3278_2_E);

	//
	// Uncomment this block of code if you wish to see the Terminal.
	//
	/*
	    JFrame jf = new JFrame();
	    jf.getContentPane().add(BorderLayout.CENTER, terminal);
	    jf.pack();
	    jf.setVisible(true);
	*/

	//
	// Instantiate the generated code and setup the input parameters
	//
	ACCTBean acctBean = new ACCTBean();
	acctBean.setTerminal(terminal);
	acctBean.setSurname(args[2]);

	//
	// Run the ACCT transaction
	//
	acctBean.performWork();

	//
	// Display the 1st account number found
	//
	System.out.println("The first account number for surname: " +
			    args[2] + " is: " +
			    acctBean.getAccountNumber());
    }
}
