package samples.recorder;

import java.util.Vector;
import com.sun.emp.pathway.bean.Terminal;

/**
 * The ACCTBean class is a representation of a 3270 navigation.
 * 
 * Created using the <A HREF=http://www.sun.com>Sun</A>
 * 3270 Pathway product.
 */
public class ACCTBean {
    private Terminal    aTerminal;
    private String      tn3270Host = "myACCTHost";
    private int         tn3270Port = 2001;
    private int         model = Terminal.MODEL_3278_2_E;
    private String      hostCodepage = Terminal.CODEPAGE_IBM1047;
    
    private String      accountNumber =  "";
    private String      surname =  "";
    
    /**
     * Obtain the value of the accountNumber property.
     * @return The value of the accountNumber property.
     */
    public String getAccountNumber() {
        return accountNumber;
    }
    
    /**
     * Set the value of the surname property.
     * @param surname The new value of the surname property.
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }
    
    /**
     * The performWork() method is the core of this class.
     * It's purpose is to recreate the navigation that was recorded in the
     * Pathway recording session.
     * <P>You should replace this text with a description of the function of this class...
     */
    public void performWork() {
        init();
        
        aTerminal.typeString("acct");
        aTerminal.pressEnter();
        aTerminal.waitUntilKeyboardUnlocked();
        
        aTerminal.typeString(surname);
        aTerminal.pressEnter();
        aTerminal.waitUntilKeyboardUnlocked();
        
        accountNumber = aTerminal.getReadableString(1281, 5);
        aTerminal.pressClear();
        aTerminal.waitUntilKeyboardUnlocked();
	
        aTerminal.pressClear();
        aTerminal.waitUntilKeyboardUnlocked();
        
        aTerminal.typeString("cssf logoff");
        aTerminal.pressEnter();
        aTerminal.waitUntilDisconnected();
    }
    
    /**
     * The init() method is designed to set up this class.
     * It is called as the first thing in <A HREF=#performWork()>performWork</A>
     * to ensure that
     * <UL>
     * <LI>The terminal is connected.
     * <LI>The keyboard is unlocked.
     * <LI>Insert mode is off
     * </UL>
     * @see #performWork()
     */
    private void init() {
        if (aTerminal == null) {
            initializeTerminal();
        }
        
        if (aTerminal.isDisconnecting()) {
            aTerminal.waitUntilDisconnected();
        }
        if (aTerminal.isDisconnected()) {
            aTerminal.connect();
        }
        aTerminal.waitUntilConnected();
        aTerminal.setInserting(false);
        aTerminal.waitUntilKeyboardUnlocked();
    }
    
    /**
     * Set the Terminal to be used for this navigation.
     * This terminal need not be connected as it will be connected by the init()
     * method if necessary.
     * @param terminalIn The Terminal
     * @see #getTerminal()
     */
    public void setTerminal(Terminal terminalIn) {
        aTerminal = terminalIn;
    }
    
    /**
     * Get the Terminal used by this navigation.
     * This method may return null if the setTerminal method has not been
     * called and the performWork() method never invoked.
     * @return The Terminal
     * @see #setTerminal(com.sun.emp.pathway.bean.Terminal)
     */
    public Terminal getTerminal() {
        if (aTerminal == null) {
            initializeTerminal();
        }
        return aTerminal;
    }
    
    /**
     * Set the host that is the location of the server.
     * This host is only used when this bean creates a Terminal, and is not
     * used when the terminal is already connected.
     * @param tn3270HostIn The new host
     * @see #getTN3270Host()
     */
    public void setTN3270Host(String tn3270HostIn) {
        tn3270Host = tn3270HostIn;
        if ( aTerminal != null ) {
            aTerminal.setTN3270Host(tn3270Host);
        }
    }
    
    /**
     * Get the host that is the location of the server.
     * @return The host
     * @see #setTN3270Host(java.lang.String)
     */
    public String getTN3270Host() {
        return tn3270Host;
    }
    
    /**
     * Set the port number to be user for communication to the server.
     * This port is only used when this bean creates a Terminal, and is not
     * used when the terminal is already connected.
     * @param tn3270PortIn The new port
     * @see #getTN3270Port()
     */
    public void setTN3270Port(int tn3270PortIn) {
        tn3270Port = tn3270PortIn;
        if ( aTerminal != null ) {
            aTerminal.setTN3270Port(tn3270Port);
        }
    }
    
    /**
     * Get the port number to be user for communication to the server.
     * This port is only used when this bean creates a Terminal, and is not
     * used when the terminal is already connected.
     * @return The port
     * @see #setTN3270Port(int)
     */
    public int getTN3270Port() {
        return tn3270Port;
    }
    
    /**
     * Set the terminal model.
     * This model is only used when this bean creates a Terminal, and is not
     * used when the terminal is already connected.
     * @param modelIn The new model
     * @see #getModel()
     */
    public void setModel(int modelIn) {
        model = modelIn;
        if ( aTerminal != null ) {
            aTerminal.setModel(model);
        }
    }
    
    /**
     * Get the terminal model.
     * @return The model
     * @see #setModel(int)
     */
    public int getModel() {
        return model;
    }
    
    /**
     * Set the codepage used by the 3270 Host.
     * This codepage is only used when this bean creates a Terminal, and is not
     * used when the terminal is already connected.
     * @param hostCodepageIn The new codepage
     * @see #getHostCodepage()
     */
    public void setHostCodepage(String hostCodepageIn) {
        hostCodepage = hostCodepageIn;
        if ( aTerminal != null ) {
            aTerminal.setHostCodepage(hostCodepage);
        }
    }
    
    /**
     * Get the codepage used by the 3270 Host.
     * @return The codepage
     * @see #setHostCodepage(java.lang.String)
     */
    public String getHostCodepage() {
        return hostCodepage;
    }
    
    private void initializeTerminal() {
        aTerminal = new Terminal();
        aTerminal.setTN3270Host(tn3270Host);
        aTerminal.setTN3270Port(tn3270Port);
        aTerminal.setModel(model);
        aTerminal.setHostCodepage(hostCodepage);
        aTerminal.setTN3270EAllowed(true);
        aTerminal.setNetworkInactivityTimeout(0);
    }
    
}
