package Thresholds;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Thresholds.pm,v 1.11 2003/05/13 21:21:07 ccadieux Exp $

sub revision {'$Revision: 1.11 $'}
use Carp;
use System;
use Debug;
use strict;

use vars qw($ERR $CACHE_NAME %SC_DATA %SC_TH $SC_DONE );

#############################################################
#       SCROLLING WINDOW DATA   
#
# TH : a5000.SCSFRT=cnt,period,quiet, W/E, text
# period,quiet: can be hours(h) or minutes(m).
# created by the PDM
# $th = Thresholds->init();
# must implement serialize
# Interface:
#  ($level, $cnt, $desc, $mins) = $th->test      Used by Health Monitors
#  if ($level eq "E" || $level eq "W") ...
#     print "Received $cnt $desc messages in $mins mins";
#
#  $th->init      Executed at PDM creation
#  $th->serialize Executed when PDM serialize.
#
# a5000.SFOFFL=  10, 24h, 4h, W, socal/ifp Offline
# a5000.SFOFFL=  10, 10m, 4m, W, socal/ifp Offline
#############################################################


$CACHE_NAME = "/DATA/thresholds.cache";
%SC_DATA = ();   # data: time, count
%SC_TH = ();     # threshold: cnt, time
$SC_DONE = 0;

sub init {
  my($class) = @_;
  my($l);
  return(\%SC_DATA, \%SC_TH) if ($SC_DONE);
  $SC_DONE = 1;
  my($home) = System->get_home();
  if (open(O, "$home/$CACHE_NAME")) {
     while ($l = <O>) {
        chop($l);
        my @a = split(/\t,\t/, $l);
        $SC_DATA{$a[0]}{$a[1]}{$a[2]} = [$a[3],$a[4]];
     }
  }
  if (open(O, "$home/System/SW_Thresholds")) {
     my(@lines) = <O>; close(O);
     my($x);
     for ($x=0; $x <= $#lines; $x++) {
        $l = $lines[$x];
        chomp($l);
        next if ($l =~ /^ *$/  or substr($l,0,1) eq "#") ;
        my @a = split(/ *[=\.\,\:] */, $l, 7);

        my($comment) = "";
        while (substr($lines[$x+1],0,1) eq "'") {
            $comment .= substr($lines[$x+1],1);
            $x++;
        }  
        $SC_TH{$a[0]}{$a[1]} = [$a[2],$a[3],$a[4],$a[5],$a[6], $comment];
     }
  } else {
     Debug->err(NO_SW  => "$!");
     return 0;
  }
  return (\%SC_DATA, \%SC_TH);
}

#
#  exist('hck.switch','TXW')  # healthcheck.switch TXW

sub exist {
  my($class, $cat, $type) = @_;
  $class->init();
  my($val,$th) = $class->_read($cat, $type, 0);
  return $th;
}

sub toString {
  my($class, $cat, $type) = @_;
  $class->init();
  my($val,$th) = $class->_read($cat, $type, 0);
  my $time = $th->[1];
  my $char = substr($time,-1);
  my %M = (m => 'minutes', h=> 'hours');
  my $level = ($th->[3] eq "E")? "Error":"Warning";
  chop($time);
  my $out = "$th->[0] in $time $M{$char}, severity is $level";
  return ($out, $th->[4]);
}


# $cnt : represents the numbers of new errors or of new log-entries.
# returns undef when no threshold information exist in the database (SW_T..).
#
#  test('a5k','FCOFF', '12', cnt=2)


sub test {
  my($thr, $cat, $type ,$idx, $cnt) = @_;
  my($val, $th, $hrs, $mins, $min1, $th1, $th2);
  $ERR = undef;
  ($val,$th) = $thr->_read($cat, $type, $idx);
  if (!$th) {
    $ERR = "No entry in SW_Threshold for $cat:$type";
    return undef;
  }
  return $thr->_test($th, $val, $cat, $type, $idx, $cnt);
}

#
#  patternTest($lineWithParttern, 'host', 1);
#
sub patternTest {
  my($thr,$text, $cat, $cnt) = @_;
  my($val, $th, $hrs, $mins, $min1, $th1, $th2, $pat, $type);
  $thr->init();

  foreach $type (keys %{$SC_TH{$cat}} ) {
     $val = $SC_DATA{$cat}{$type}{1};
     $th  = $SC_TH{$cat}{$type};
     $pat = $th->[4];
     if (substr($pat,0,1) eq "/") {
       $pat = substr($pat,1,-2);
     } else {
       next;
     }
     next if ($text !~ /$pat/);

     my @ret =$thr->_test($th, $val, $cat, $type, 1,1);
     return @ret if ($#ret >= 0);
  }
}

sub _test {
  my($thr, $th, $val, $cat, $type, $idx, $cnt) = @_;
  my($th1, $th2);
  my $now = int(time/60);   # minutes
  my $min1;
  if (!$val) { # brand new threshold
    $thr->_write($cat,$type,$idx, [$now,0]);
    ($val,$th) = $thr->_read($cat, $type, $idx);
    $min1 = 1;
  } else {
    $min1 = ($now - $val->[0]); #minutes elapsed
  }

  if ($th->[1] =~ /\d+m/) {
    $th1  = $th->[1] + 0;
  } else { # hours
    $th1  = $th->[1] * 60;
  }
  if ($th->[2] =~ /\d+m/) {
    $th2  = $th->[2] + 0;
  } else { # hours
    $th2  = $th->[2] * 60;
  }
  if ($min1 <= 0) {
      my $LB = Labels->read('Thresholds');
      #Debug->print2($LB->expand('Skipping', $type));
     return (); # quiet time
  } elsif ($th->[0] == 1 || $min1 <= $th1) {  #is it in the range
     $val->[1] += $cnt;
     if ($val->[1] >= $th->[0]) { # counter 
        my $ret = $val->[1];
        $val->[0] = $now + $th2;
        $val->[1] = 0;
        my $desc = $th->[4] || $type;
#                                             th=10  in 24hours
        return ($th->[3], $ret, $desc, $min1, $th->[0], $th->[1]);
     }
  } else {   # reset
     $val->[0] = $now;
     $val->[1] = 0;
  }
  return ();
  #return (undef, $cnt, $th->[4] || $type, $now - $val->[0], $th->[0], $th->[1]);
}

sub _read {
  my($thr, $cat, $type, $idx) = @_;
  my($type2) = $type;
  $type2 =~ s/ /_/g;
  $thr->init();
  my $e = $SC_TH{$cat}{$type2};
  return ($SC_DATA{$cat}{$type}{$idx}, $e);
}

sub _write {
  my($thr, $cat, $type, $idx, $data) = @_;

  $SC_DATA{$cat}{$type}{$idx} = $data;
}

sub serialize {
  my($thr) = @_;

  open(O, ">" . System->get_home() . $CACHE_NAME);
  my $del = "\t,\t";
  foreach my $c (sort keys %SC_DATA) {
     my $p = $SC_DATA{$c};
     foreach my $t (sort keys %$p) {
       my $p2 = $p->{$t};
       foreach my $i (sort keys %$p2) {
          my $val1=$p2->{$i}->[0];
          my $val2=$p2->{$i}->[1];
          print O "$c$del$t$del$i$del$val1$del$val2\n";
       }
     }
  }
  close(O);

}

1;

