package Revision::VE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Virtualization Engine Firmware"}
sub class {"oob.VICOM"}
sub type {"ve"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my $rc = [];

  my $rc2 = $class->checkVicomFirmware($Matrix, $InstalledPatches);

  return [@$rc, @$rc2];
}

sub checkVicomFirmware {

    my($class, $Matrix, $InstalledP) = @_;
    my $category = "Vicom";
    my $key ="Vicom";
    my @L;
    my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
    my $found=0;
    my $note ="No vicom device present, please check system setup";
    my $note2="Can not run virtual engine revision check  for current sp image level, please contact your SUN representative for further information";
 
 
    # add check service processor level
    # different level ask different vicom level
    my $mat;
    my $se_version = System::get_se_version();
    if ( $se_version eq "2.0.3" ) {   #  indy +
       $mat = $Matrix->{SPIMAGE_203}; 
    } elsif ( $se_version eq "2.0.2" ) {   #  indy 
       $mat = $Matrix->{SPIMAGE_202}; 
    } elsif ( $se_version eq "2.1.1" ) {     #porsche
      $mat = $Matrix->{SPIMAGE_211};
    } elsif ( $se_version eq "2.1.2" ) {
      $mat = $Matrix->{SPIMAGE_212};
    } elsif ( $se_version eq "2.1.3" ) {
      $mat = $Matrix->{SPIMAGE_213};
    } elsif ( $se_version eq "2.1.4" ) {
      $mat = $Matrix->{SPIMAGE_214};
    } elsif ( $se_version eq "2.2.1.1" ) {
      $mat = $Matrix->{SPIMAGE_2211};
    } elsif ( $se_version eq "2.2.1" ) {
      $mat = $Matrix->{SPIMAGE_221};
    } elsif ( $se_version eq "2.3.1") { 
      $mat = $Matrix->{SPIMAGE_231};
    } elsif ( $se_version eq "2.3.2") { 
      $mat = $Matrix->{SPIMAGE_232};
    } elsif ( $se_version eq "2.3.3") {
      $mat = $Matrix->{SPIMAGE_233};
    } elsif ( $se_version eq "2.3.4") {
      $mat = $Matrix->{SPIMAGE_234};
    } elsif ( $se_version eq "2.3.5") {
      $mat = $Matrix->{SPIMAGE_235};
    } elsif ( $se_version eq "2.3.6") {
      $mat = $Matrix->{SPIMAGE_236};
    } elsif ( $se_version eq "2.3.7") {
      $mat = $Matrix->{SPIMAGE_237};
    } else {     # higher level sp image found
                 # can not do revision check  
      if ($se_version) {
          push(@L, [$category, undef,'ERR',undef,undef,undef,undef,$note2]); 
          return \@L;
      }
    } 
   

    my $information;
    if (!$se_version) {
      $information = " Can not get sp level information, please check your system set-up ";
    } else {
      $information = "Expected Version is used with SP ".$se_version;
    }

    my $el  = $mat->{$key};
    my $req_fw   = $el->[0];
    my $patch = $el->[1];
    my $desc  = $el->[2];

   
    foreach my $dev (@$devs){
       if ( $dev->{class} =~ /ve/) {
           $found =1;
           my($e,$curr_fw) = $class->GetFW($dev->{initiator},$dev->{login});
           if ($e){
               push(@L, [$category, $dev->{name},'ERR',undef,undef,undef,undef,$note]);
           }
           elsif ($el) {
   
              my $comp = $class->compareFwLevels($curr_fw, $req_fw);
              if ( $comp ==0) {
                     push(@L, [$category, $dev->{name},'PASS',$curr_fw, $req_fw,undef,undef,$information]);
              }
              elsif ($comp >0) {
                    push(@L, [$category, $dev->{name},'UPREV',$curr_fw, $req_fw,undef,$patch,$information]);
              }
              elsif ( $comp <0){
                  push(@L, [$category, $dev->{name},'DOWNREV',$curr_fw, $req_fw,undef,$patch,$information]);
              }
           }else {
                  push(@L, [$category, $dev->{name}, 'ERR', undef, undef,undef,undef, "No Key in Matrix/VE"]);
           }
        }
  }
  if ($found ==0) {
           push(@L, [$category, 'N/A', 'ERR', undef, undef,undef,undef, "No VE devices are present, please check system" ]);
  }
  return \@L;

}

################################################################################
#sub GetFW
#returns (vicomFWlevel, error)
################################################################################
sub GetFW{
        (my $this, my $initiator, my $login)= @_;
        my $key;

        if ($initiator == 1) {
             $key = "I00001";
        } elsif ($initiator == 2) {
             $key = "I00002"; 
        } elsif ($initiator == 3) { 
             $key = "I00003";
        } elsif ($initiator == 4) {
             $key = "I00004";
        } else {
             $key = $initiator;   # $initiator already in format I00002 
        }


        my($renv) = System->get_renv();
        my($sve_path) = $renv->{GSV_SVE_PKGDIR} || '/opt/svengine';

        my $command;
        my $err;
        if( -x "$sve_path/sduc/showmap"){
          $command="$sve_path/sduc/showmap -d $login";
          print $command."\n";
        } else { 
          my $note= "cannot run $sve_path/sduc/showmap";
          return($note,undef);
        }
        ($err, my $result) = Util->run_command($command,"/tmp/test.txt");
        if ($#$result < 3) {
          return($result, undef);
        }
        foreach my $line (@$result){
          if($line =~ $key){
            my @fields = split(/\s+/, $line);
            if((!defined($fields[3])) && (!defined($result))){
              $err.="Unable to determine FW level\n";
              return($err,$result);
            }

            if((defined($fields[3]))){
              $result = $fields[3];
            }
          }
       }
       return($err,$result);
}

1;


