package Revision::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::T3;
use PDM::ConfigFile;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class {"oob.t3"}
sub description {"Sun StorEdge T3 and T3+ array firmware/disk/loop/pcu"}
sub type {"t3"}

#;u1d1,fruRevision,EA29;
#;u1l2,fruRevision, 5.01 Flash; if firmware > 3.0 then use fruLoopRevision
#;u1ctr,fruRevision,0210;
#;u1pcu1,fruRevision,refer to label;
#;u1mpn,fruRevision,;


sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my(@R);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  foreach my $dev (@$devs) {
      next if ($dev->{type} ne "t3");
      next if (!Util->isMineToMonitor($dev));

      my $report = Agent::T3->INSTRUMENTATION($dev, 1, 1);
      my $err = $report->{"rc.error"};
      if ($err) {
         push(@R,['T3', $dev->{name}, 'ERR', undef, undef,undef,undef,"Can not instrument the T3 device"]);
      } else {
         my $r1 = $class->REVISION($Matrix,  $InstalledPatches, $dev, $report);
         push(@R, @$r1);
      }
  }
  if ($#R < 0) {
      push(@R,['T3', 'N/A', 'ERR', undef, undef,undef,undef,"No t3 device, please check system setup"]);
  }
  return \@R;
  
}

# runs on only one device, dev is from the configFile
#
sub REVISION {
  my( $class, $Matrix, $InstalledPatches, $dev, $rep) = @_;
 my ( $elemprop0,  $elemprop1, $mat, @R , @R1, @R2, @R3, @R4);
  my $mat_t3b = $Matrix->{T3B};  # used for stand alone t3+
  my $mat_t3 = $Matrix->{T3};    # used for stand alone t3
  my $t3_type;
  my ($vendor, $model, $tem1, $tem2, $firm_rev);
  my $se_version = System::get_se_version();

  if ($rep->{'controller.u1ctr.fruModel'} =~ /501/) {  # diff t3+ and t3
     if ( $se_version =~ /2.0.3/ ) {   #  indy +
          $t3_type = "T3_203";
          $mat = $Matrix->{SPIMAGE_203};
     } elsif ($se_version eq "2.1.1" ) { # porche 
          $t3_type = "T3_211";
          $mat = $Matrix->{SPIMAGE_211};
     } elsif ( $se_version eq "2.0.2" ) { # indy
          $t3_type = "T3_202";
          $mat = $Matrix->{SPIMAGE_202};
     } elsif ( $se_version eq "2.1.2") {
          $t3_type = "T3_212";
          $mat = $Matrix->{SPIMAGE_212};   
     } elsif ( $se_version eq "2.1.3") {
          $t3_type = "T3_213";
          $mat = $Matrix->{SPIMAGE_213}; 
     } elsif  ($se_version eq "2.1.4") { 
          $t3_type = "T3_214";
          $mat = $Matrix->{SPIMAGE_214}; 
     } elsif  ($se_version eq "2.2.1") {
          $t3_type = "T3_221";
          $mat = $Matrix->{SPIMAGE_221};
     } elsif  ($se_version eq "2.2.1.1") { 
          $t3_type = "T3_2211";
          $mat = $Matrix->{SPIMAGE_2211}; 
     } elsif ($se_version eq "2.3.1") {
          $t3_type = "T3_231";
          $mat = $Matrix->{SPIMAGE_231};
     } elsif ($se_version eq "2.3.2") {
          $t3_type = "T3_232";
          $mat = $Matrix->{SPIMAGE_232};
     } elsif ($se_version eq "2.3.3") { 
          $t3_type = "T3_233";
          $mat = $Matrix->{SPIMAGE_233};
     } elsif ($se_version eq "2.3.4") { 
          $t3_type = "T3_234";
          $mat = $Matrix->{SPIMAGE_234};
     } elsif ($se_version eq "2.3.5") { 
          $t3_type = "T3_235";
          $mat = $Matrix->{SPIMAGE_235};
     } elsif ($se_version eq "2.3.6") {
          $t3_type = "T3_236";
          $mat = $Matrix->{SPIMAGE_236};
     } elsif ($se_version eq "2.3.7") {
          $t3_type = "T3_237";
          $mat = $Matrix->{SPIMAGE_237};
     } elsif ( !$se_version)  {   # can not get the service processor image level
                                  # host is not sp, just use t3b matrix
          $mat = $mat_t3b;
          $t3_type = "T3B";
     } elsif ($se_version) {   # 2.3.7 or even higher level sp image, do nothing now
          push(@R,['T3', undef, 'ERR', undef, undef,undef,undef,"Can not run T3 revision check for current sp image level, please contact your SUN representative"]); 
         return \@R;
     }
  } else {   # t3 case
     $mat = $mat_t3;
     $t3_type = "T3";
  }
  my $information;
  if (!$se_version) {
      $information = " Used for T3 enclosure ";
  } else {
      $information = "Used with SP ".$se_version;
  }
  $firm_rev = $rep->{'system.sysRevision'};

  push(@R, $class->devCompare("T3_SYSTEM_FW",undef, $firm_rev, $dev, $mat, "firmrev"));
  my $status = $class->compareFwLevels($firm_rev,"030000");

  foreach my $el (keys %$rep) {
      if (($el =~ /fruRevision/) && ( $el !~ /loopcard/ ) ){
         my $ix = rindex($el, ".");
         my $pre = substr($el, 0, $ix);
         my $vendor = $rep->{"$pre.fruVendor"};
         my $tem_model  = $rep->{"$pre.fruModel"};
         my ($model, $tem) = split(/\s+/, $tem_model);
         my $val   = $rep->{$el};
         my $ix0    = index($el, ".");
         my $elem   = substr($el, $ix0+1);
         my $ix0    = index($elem, ".");
         $elem      = substr($elem, 0, $ix0) if ($ix0 > 0);
         
         if ($el =~ /disk/) {
            if ($model) {  #  $model = '' means dummy disk, skip it
               push(@R1,$class->checkDiskFirmware_t3($Matrix, $InstalledPatches, $vendor, $model, $val,$dev,$elem, "disk", $t3_type, $information));
            }
         } 

     } elsif ( $el =~ /loopcard/) {
         if ( $status < 0) {
            if ( $el =~ /fruRevision/) {
               my $ix = rindex($el, ".");
               my $pre = substr($el, 0, $ix);
               my $vendor = $rep->{"$pre.fruVendor"};
               my $tem_model  = $rep->{"$pre.fruModel"};
               my ($model, $tem) = split(/\s+/, $tem_model);
               my $val   = $rep->{$el};
               my $ix0    = index($el, ".");
               my $elem   = substr($el, $ix0+1);
               my $ix0    = index($elem, ".");
               $elem      = substr($elem, 0, $ix0) if ($ix0 > 0);
               push(@R2, $class->devCompare("T3",$elem, $val, $dev, $mat, "loop"));
            } 
         } else { # firmware > 3.0 case
            if ( $el =~ /fruLoopVersion/) {
               my $ix = rindex($el, ".");
               my $pre = substr($el, 0, $ix);
               my $vendor = $rep->{"$pre.fruVendor"};
               my $tem_model  = $rep->{"$pre.fruModel"};
               my ($model, $tem) = split(/\s+/, $tem_model);
               my $val   = $rep->{$el};
               my $ix0    = index($el, ".");
               my $elem   = substr($el, $ix0+1);
               my $ix0    = index($elem, ".");
               $elem      = substr($elem, 0, $ix0) if ($ix0 > 0);
               push(@R2, $class->devCompare("T3",$elem, $val, $dev, $mat, "loop"));
            }
         } 
     }
 }
 my @SR1 = sort {$a->[1] cmp $b->[1]} @R1 ;
 my @SR2 = sort {$a->[1] cmp $b->[1]} @R2;
 my @SR3 = sort {$a->[1] cmp $b->[1]} @R3;
 my @SR4 = sort {$a->[1] cmp $b->[1]} @R4;
 push (@R, @SR1,@SR2,@SR3,@SR4);
  return \@R;
}

sub checkDiskFirmware_t3 {
     my($class,$Matrix, $InstalledP,$vendor, $model, $val, $dev,$elem,
         $type, $t3_type, $info) = @_;
     my $disk_fw;
     if ($t3_type eq "T3_202") {
         $disk_fw = $Matrix->{T3_FOR_SPIMAGE_202};
     } elsif ( $t3_type eq "T3_203") {
         $disk_fw = $Matrix->{T3_FOR_SPIMAGE_203};
     } elsif ( $t3_type eq "T3_211") {
         $disk_fw = $Matrix->{T3_FOR_SPIMAGE_211};
     } elsif ( $t3_type eq "T3_212") {
         $disk_fw = $Matrix->{T3_FOR_SPIMAGE_212};
     } elsif ( $t3_type eq "T3_213") {
         $disk_fw = $Matrix->{T3_FOR_SPIMAGE_213};
     } elsif ( $t3_type eq "T3_214") {
         $disk_fw = $Matrix->{T3_FOR_SPIMAGE_214};
     } elsif ( $t3_type eq "T3_221") {
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_221};
     } elsif ( $t3_type eq "T3_2211") {
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_2211}; 
     } elsif ( $t3_type eq "T3_231") {
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_231}; 
     } elsif ( $t3_type eq "T3_232") {
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_232}; 
     } elsif ( $t3_type eq "T3_233") { 
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_233};
     } elsif ( $t3_type eq "T3_234") { 
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_234};
     } elsif ( $t3_type eq "T3_235") { 
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_235};
     } elsif ( $t3_type eq "T3_236") {
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_236};
     } elsif ( $t3_type eq "T3_237") {
        $disk_fw = $Matrix->{T3_FOR_SPIMAGE_237};
     } else {
         $disk_fw = $Matrix->{DISK_FW};
     }

     my $category = "T3_DISK_FW";      

     my $key = "$vendor:$model:$t3_type";    # default set up

     my $curr_fw = $val;
     my $cp = ($dev->{name} || $dev->{ip});

     if ($disk_fw->{$key}) {
            my $d = $disk_fw->{$key};
            my $req_fw = $d->[0];
            my $req_patch = $d->[2];
            my $desc =  "$vendor:$model";
            
            # my $desc = "$vendor:$model  ".$info ;    
            my $info =  " No patch available, please contact your SUN representative ";
            my($req_base, $req_rev) = $class->baseRev($req_patch);
            if ($curr_fw < 0){
            return [$category, "$cp.$type.$elem", 'ERR', undef, $req_fw, undef, $req_patch, "Unable to get the device firmware level, please contact you SUN representative"];
            }
            my $comp = $class->compareDiskFwLevels($curr_fw, $req_fw);
            if ($comp == 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                      return [$category, "$cp.$type.$elem", 'PASS', $curr_fw, $req_fw, undef, undef, $info];
               } else {
                      return [$category, "$cp.$type.$elem", 'PASS', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            } elsif ($comp > 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                     return [$category,"$cp.$type.$elem", 'UPREV', $curr_fw, $req_fw, undef, undef, $desc];
               } else {
                     return [$category, "$cp.$type.$elem", 'UPREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            } elsif ($comp < 0) {
               if ( ($req_patch =~ /xxxx/) || ( !$req_patch ) ) {
                    return [$category, "$cp.$type.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, "N/A", $info];
               } else {
                    return [$category, "$cp.$type.$elem", 'DOWNREV', $curr_fw, $req_fw, undef, $req_patch, $desc];
               }
            }
            else {
              return [$category, "$cp.$type.$elem", 'ERR', $curr_fw, $req_fw, undef, $req_patch, "Unable to check $vendor device,please contact your SUN representative and update the device firmware"];
            }
    } else {
           return [$category, "$cp.$type.$elem", 'ERR', undef, undef, undef, undef, "Unable to check the $vendor device, please see sunsolve online for potential patch information or contact your SUN representative"];
    }

}



1;
