package Revision::Switch;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::SWITCH;

use PDM::ConfigFile;
use Logic::SWITCH;
#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class {"oob.switch"}
sub description {"Sun StorEdge network FC switch-8 and switch-16"}
sub type {"switch"}

#IP:     172.20.67.191
#HW:     a03
#PROM:   30300
#FLASH:  b30345
#WWN:    100000c0dd006fc9
#MAC:    00c0dd006fc8

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my( $l, @R, $out);
  my ($wwn, $swtype, $userLabel);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  # add check sevice processor 
  # if the switch is in rack (used with service processor)
  # then it will need different patch as those switch used 
  # with data host

   my $type ; # used to label switch in different config
  my $se_version = System::get_se_version();
  
  if ( $se_version eq "2.0.2" ) {   #  indy 
         $type =1 ;
  } elsif ( $se_version eq "2.0.3" ) { # indy +
         $type =2 ;
  } elsif ( $se_version eq "2.1.1" ) { # porche
         $type =3 ;
  } elsif ( $se_version eq "2.1.2" ) {
         $type =4;
  } elsif ( $se_version eq "2.1.3" ) {
         $type =5;
  } elsif ( $se_version eq "2.1.4" ) {
         $type =6;
  } elsif ( $se_version eq "2.2.1" ) {
         $type =7;
  } elsif ( $se_version eq "2.2.1.1" ) {
         $type =8;
  } elsif ( $se_version eq "2.3.1") { 
         $type =9;
  } elsif ( $se_version eq "2.3.2") {
         $type =10;
  } elsif ( $se_version eq "2.3.3") {
         $type =11;
  } elsif ( $se_version eq "2.3.4") {
         $type =12;
  } elsif ( $se_version eq "2.3.5") {
         $type =13;
  } elsif ( $se_version eq "2.3.6") {
         $type =14;
  } elsif ( $se_version eq "2.3.7") {
         $type =15;
  } elsif ( !$se_version) {  # can not get the service processor image level
                             # host is not sp, just use t3b matrix
         $type =99;
  } elsif ($se_version) {   # higher level sp image
         push(@R, ["Switch", undef,'ERR',undef,undef,undef,undef,"Can not run switch revision check for current level sp image, please contact your SUN representative for further information"]);
         return \@R;

  }
 
  foreach my $dev (@$devs) {
      my $r1;
      next if (!Util->isMineToMonitor($dev));
      next if  ($dev->{type} !~ "switch");
 
      if ($dev->{userLabel} eq "Switch1") {  #  host---switch case
           $r1 = $class->REVISION( $Matrix, $InstalledPatches, $dev, $type);
        push(@R, @$r1);
      } elsif ( !$dev->{userLabel}) {    # sp-----switch case
         ($wwn, $swtype, $userLabel) = Logic::SWITCH->find_wwn($dev->{ip}); 
         if ( $userLabel eq "Switch1") {  # 1G switch or upgraded 1G switch, continue
             $r1 = $class->REVISION( $Matrix, $InstalledPatches, $dev, $type);     
             push(@R, @$r1);
         }
      }
  }
  if ($#R < 0) {
      push(@R,["Switch",'N/A','ERR',undef, undef,undef,undef, "No qlogic 1G switch are present, please check system"]);
  }
  return \@R;
}

sub REVISION {
  my($class, , $Matrix, $InstalledPatches, $dev, $type) = @_;
  my( $l, @R, %VERSION, $out);
  my $TO = 20;
  my $mat;
  my $el;
  my $stat;
  my $comp;
  my $switch_type ="switch";

  if ($type == 99) {
     # $mat = $Matrix->{SWITCH};
     # need differentiate regular 1G switch and upgraded 1G switch
     $stat = get_switch_type ($dev);
     if ($stat == 1) {  # un-upgraded 1G switch
         $mat = $Matrix->{SWITCH};
     } elsif ( $stat == 0)  {  # already upgraded 1G switch
         $mat = $Matrix->{SWITCH_UP_1G};
     } else {  # return -1 case
         $comp = ($dev->{name} || $dev->{ip});
         push (@R,["Switch","$comp",'ERR' , undef, undef, undef , undef, "can not get the switch type information" ]);  
         return \@R; 
     }
  } elsif ($type == 1) {
     $mat = $Matrix->{SPIMAGE_202};
  } elsif ($type == 2) {
     $mat = $Matrix->{SPIMAGE_203};
  } elsif ($type == 3) {
     $mat = $Matrix->{SPIMAGE_211};
  } elsif ($type == 4) {
     $mat = $Matrix->{SPIMAGE_212};
  } elsif ($type == 5) {
     $mat = $Matrix->{SPIMAGE_213};
  } elsif ($type == 6) {
     $mat = $Matrix->{SPIMAGE_214};
  } elsif ($type == 7) {
     $mat = $Matrix->{SPIMAGE_221};
  } elsif ($type == 8) {
     $mat = $Matrix->{SPIMAGE_2211};
  } elsif (($type == 9) || ($type == 10) || ($type == 11) || ($type == 12) || ($type == 13)){
     # Three types of switches are used with sp image 2.3.1 and 2.3.2
     # so need to differentiate them, and assign different switch type 
     # for earlier sp image , they only use one switch : 1G normal switch 
     if ($type == 9) {
         $mat = $Matrix->{SPIMAGE_231};
     } elsif ( $type == 10) {
         $mat = $Matrix->{SPIMAGE_232};
     } elsif ( $type == 11) {
         $mat = $Matrix->{SPIMAGE_233};
     } elsif ( $type == 12) {
         $mat = $Matrix->{SPIMAGE_234};
     } elsif ( $type == 13) {
         $mat = $Matrix->{SPIMAGE_235};
     } elsif ( $type == 14) {
         $mat = $Matrix->{SPIMAGE_236};
     } elsif ( $type == 15) {
         $mat = $Matrix->{SPIMAGE_237};
     }
     $stat = get_switch_type ($dev);
     if ($stat == 1) {  # un-upgraded 1G switch
         $switch_type = "switch_1G_SP";
     } elsif ( $stat == 0)  {  # already upgraded 1G switch
         $switch_type = "switch_1G_2G_SP";
     } else {  # return -1 case
         $comp = ($dev->{name} || $dev->{ip});
       push (@R,["Switch","$comp",'ERR' , undef, undef, undef , undef, "can not get the switch type information" ]);
         return \@R;
 
     }
  } 

  my $V = Agent::SWITCH->getVersion($dev->{ip}, $TO );
  if (!$V) {
     Debug->err(TEXT => "Cannot get version from switch $dev->{ip}");
     next;
  }

  my $hw    = $V->{HW};
  my $prom  = $V->{PROM};
  my $flash = $V->{FLASH};

  push(@R, $class->switch_Compare("Switch",$flash, $dev, $mat, $switch_type,undef));
  return \@R;
}

sub get_switch_type {
  my ($dev) = @_;
  my ($wwn, $swtype, $userLabel) = Logic::SWITCH->find_wwn($dev->{ip});
  if ( $swtype eq "switch2") {
       return 0 ;              # upgraded 1G 
  } elsif ( $swtype eq "switch") {  # normal 1G
       return 1 ;
  } else {
       return (-1);
  } 

}
1;
