package Provider::Trap;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Trap.pm,v 1.13 2003/11/20 16:56:10 tmullen Exp $

use PDM;
use PDM::ConfigFile;
use Carp;
use Message;
use Util;
use System;
use Util::Http;
use SNMPTrap;

use base 'Provider';
sub revision {'$Revision: 1.13 $'}

sub description {'SNMP Traps'}

sub new {
  my($self, $pdm)  = @_;

  my($p) = { pdm => $pdm };

  bless($p,'Provider::Trap');
  return $p;
}

# http://shadow:8080/servlet/InsertService

sub UPDATE {
  my($class, $q) = @_;
  my($active, $ip, $proxy, $to, $err, $info);
  my $G = Labels->read();
  my $L = Labels->read('Provider')->section('trap');

  if ($q->{ACTION_update}) {
    ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

    $renv->{"pro.trap.active"} = $q->{"active"}? "Y":"N";
    for ($x=1; $x <= 5; $x++ ) {
      if (!$q->{"ip$x"}){
         # Make sure this entry doesn't exist
	 delete $renv->{"pro.trap$x.ip"};
         delete $renv->{"pro.trap$x.port"};
         delete $renv->{"pro.trap$x.level"};
      }else{
         # Update this entry
         $renv->{"pro.trap$x.ip"}     = $q->{"ip$x"};
         $renv->{"pro.trap$x.port"}   =  $q->{"port$x"} || 162;
         $renv->{"pro.trap$x.level"}  = $q->{"level$x"};
      }
    }

    PDM::ConfigFile->write( $renv, $dev, $host,$notifs);

    $err = Html->info($L->{err_1});
  }

  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read;

  if ($renv->{'pro.trap.active'} eq "Y") {
    $active = "checked" ;
  } else {
    $info = "<font color=red><b>$G->{inactive}</b>";
  }
  my(%h);

 my($o) =<<EOF;
$err
<form  method=get>
 <input type=hidden name=GO value=GUI::Providers::display>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=2 cellspacing=2 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr>
<td colspan=5 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{label}</td>

<tr><td colspan=2 bgcolor=$Style::LIGHT align=right><b>$G->{active}:</td>
      <td colspan=3 ><input type=checkbox name=active $active> $info
<tr><td colspan=5></td>
<tr bgcolor=#D0D0D0>
    <th><b>#</td>
    <td><b>$L->{ip}</td>
    <td><b>$L->{port}</td>
    <td><b>$L->{min}</td>
EOF
  my($ip, $port, $device, $level, $hostname);

  for ($x=1; $x <= 5; $x++ ) {
   $ip     = $renv->{"pro.trap$x.ip"};
   $port   = $renv->{"pro.trap$x.port"} || 162;
   $level  = $renv->{"pro.trap$x.level"};
   my $ls =  Util->makeSelect("level$x", "1=$G->{warning}|2=$G->{error}|3=$G->{down}|0=$G->{notice}", $level);

   $o .=<<EOF;
   <tr> 
        <th bgcolor=$Style::LIGHT>$x</td>
        <td><input type=text name=ip$x value=\"$ip\" size=20></td>
        <td><input type=text name=port$x value=\"$port\" size=6></td>
        <td>$ls</td>
EOF

  }

  $o .=<<EOF;

</table> </table> <b>
<input type=submit name=ACTION_update value="$G->{submit_update}">
</form>
EOF

  return $o;

}


sub RUN {
  my($pro, $pdm) = @_;
  my($f, $l, $transmit);
  $DB::single = 1;

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();

  return if ($renv->{'pro.trap.active'} ne "Y");

  foreach $ed (@{ $pdm->getMessages}) {
     next if ($ed->type() eq Message::TYPE_ALERT);
     $event_count++;
     Debug->print2("Trap: " . $ed->className . " " . $ed->description );

     my $ev         = $ed->instances()->[0];
     my $event_type = $ev->value("EventType");
     my $actionable = $ev->value("Actionable");

     next if ($ev->value("MgmtLevel") eq "DS"); # C, D, DS
     my $sev        = $ev->value("Severity");
     $sev = int($sev+0.5);
     my $ed_desc    = $ev->value("Description");
     my($ix) = index($event_type, '.');
     my($etype, $cat);
     if ($ix > 0) {
       $cat   = substr($event_type, 0, $ix);
       $etype = substr($event_type, $ix+1);
     }

     for ($x=1; $x <= 5; $x++ ) {
       my $ip     = $renv->{"pro.trap$x.ip"};
       my $port   = $renv->{"pro.trap$x.port"};
       my $level  = $renv->{"pro.trap$x.level"};
       my $hostname= $renv->{"pro.trap$x.hostname"};
       
       next if (!$ip);
       if ($level <= $sev) { # valid for this trap
            my $rc = SNMPTrap->send($ed_desc, 
                 { IP      => $ip, 
                   port    => $port || 162,
                   device  => $cat,
                   alertLevel => $sev
                 });
            Debug->print2("snmpSend: $SNMPTrap::ERR") if (!$rc);
            
       }
     }
  }
}


  
1;
