package Logic::SVE2;

use Util;
use strict;
use Agent::SVE2;
use Logic;

# $q->{host}
# $q->{name}
# $q->{ip}
# $q->{login}
# $q->{password}

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $ipno, $active, $x);
   $active = "Y";
   my @nodes;

   while (1) {
     if (!$q->{ip}) {
        $err = Error->error(103);
        last;
     } else {

        if (!($ipno = Util->testIp($q->{ip}))) {
           $err = Error->warning("cannot_ping",  $q->{ip});
           $active = "N";
        }
        my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
        my $wwn =  Agent::SVE2->getWWN({
                      ipno => $q->{ip}, 
                     login => $q->{login},
                    telnet => $q->{password} });

        my $there;
        foreach $x (@$devs) {
          if ($x->{type} eq "sve2" && $x->{key} eq $wwn) {
             $there = 1;
          }
        }
        if (!$wwn) {
           return (Error->warning("cannot_ping", $ipno), undef);
        }
        if (!$there) {
           $x = $#$devs + 1;
           $devs->[$x]{_name}    = "device" . ($x+1);
           $devs->[$x]{type}     = "sve2";
           $devs->[$x]{class}    = "switch.sve2";
           $devs->[$x]{userLabel} = "DSP";
           $devs->[$x]{key}      = $wwn;
           $devs->[$x]{wwn}      = $wwn;
           $devs->[$x]{name}     = $q->{name};
           $devs->[$x]{active}   = $active;
           $devs->[$x]{ip}       = $q->{ip};
           $devs->[$x]{ipno}     = $ipno;
           $devs->[$x]{host}     = $q->{host};
           Logic->clearSlave($q->{host}, $hosts);
           push(@nodes, $devs->[$x]);
        }
        if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
           $err = Error->error(101);
        }
     }
     last;
    }
out:
    return ($err, \@nodes);
}

1;

