package Health::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: SE.pm,v 1.30 2006/01/06 18:44:04 mckenney Exp $

use base 'Health';
use NWS::SE;
use Ilist;
use Message;
use Catalog;
use Report;
use System;
use Events;
use strict;
use Debug;

sub revision {'$Revision: 1.30 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};

  bless ($self, 'Health::SE');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_SE});
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_SE2});
  return $self;
}

#####################################################

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
# DO NOTHING FOR NOW
  my $renv     = System->get_renv();

  #return if (!$renv->{include_se_device});

  my $rep      = $report->content;
  my $oreport  = PDM->getOldReport($report->fileKey);
  my($ip)      = $report->id('ip');
  $DB::single = 1;
  my $wwn      = $report->id('deviceName');
  my($id)      = $report->id('display');
  my $shortid  = $report->name();
  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  my $se        = $report->category();

  CIM->version("1.1");

  my $invalidate_catalog = 0;

  if ($hm->connectionEvent($wwn, $report, {method => 2} )) {  # IB / OOB
     return;
  }
  my $freq  = $renv->{audit_freq} || 7;
  my $audit = System->get_audit() ? "YES" : Timer->isXdays("Audit$wwn", $freq);

  if (!$oreport || $audit eq "YES" ) {  
                                                        # new t300 or audit time.
     my($etype) = $audit eq "YES" ? "$se.AuditEvent" : "$se.DiscoveryEvent";
     my($title) = $audit eq "YES" ? "Auditing":"Discovering";
     my($dt)    = "A" if (!$audit);
     Grid->setCode($etype);
     $invalidate_catalog = 1;
     $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => $etype  ],
                  [ Target      => "$se:$wwn"    ],
                  [ TargetName  => $id     ],
                  [ MgmtLevel   => $mgmtLevel],
                  [ SourceIP    => $ip     ],
                  [ EventId     => $pdm->getEventSequence  ],
                  [ Description => "$title  $id"],
                [ Data        => $hm->serial($rep) ],
                         ]);

     $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
      
     my($p) = NWS::SE->newSystem($rep);

     $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $p->[0] ],
                  [ DiscoveryType => $dt],
                    ]);
     my($monitors) = CIM::Instance->new('NWS_AgentMonitors', [
                  [ Agent       => $sd->[0]  ],
                  [ Element     => $p->[0] ],
                    ]);

     $ed = Message->new( {  id        => $report->id,
                            instances => [$ev, @$sd, @$p, $monitors, $pertains ],
                            severity  => Message::SEVERITY_NORMAL });

     $pdm->saveMessage($ed);
  }

  $orep = ($oreport)? $oreport->content() : $rep; # same report if new disco.

  $hm->locationChangeEvent($report, $rep, $orep, $wwn);

  my($physicalFrame) = CIM::Key->new( ['CIM_PhysicalFrame',   # key of the frame
                        Tag               => $rep->get("id.wwn") ,
                        CreationClassName => 'CIM_PhysicalFrame' ]);

  if ($rep->get("info.power_sequencer.status")) {
    Grid->setCode("$se.AlarmEvent.power_sequencer");
    my $seq_status     = $rep->get('info.power_sequencer.status');
    if ($seq_status eq "ERR_TIMEOUT"){
      Grid->setCode("$se.AlarmEvent.power_sequencer_timeout");
    }

    $rep->{"id.mgmtLevel"} = "D";
    $hm->alarm($report, $orep, uc($se), "info.power_sequencer", "status",
                 $id, $id, $wwn, "power_sequencer");
    $rep->{"id.mgmtLevel"} = "DS";
  }

  my($SLOTS) = $rep->get('info.slotTotal');
  my($OSLOTS) = $orep->get('info.slotTotal');
  my($comp);
  my($okey, $nkey);
  my $MAX = ($SLOTS > $OSLOTS) ? $SLOTS : $OSLOTS;

  Grid->setCode("$se.StateChangeEvent.sp");
  $hm->sevStateEvent("slot.0", $report, $rep, $orep, 'NWS_Slot', $rep->get("slot.0.dev-key"), $wwn, {logical => 1, label => "SP of"});

  Grid->setCode("$se.StateChangeEvent.links");
  $hm->sevStateEvent("links", $report, $rep, $orep, 'NWS_Slot', "links", $wwn, 
     {logical => 1, label => "Internal Link of" });

  for ($x = 1; $x < $MAX; $x++) {
     $comp = "slot.$x";
     $okey = $orep->get("$comp.dev-key");
     $nkey =  $rep->get("$comp.dev-key");

     if ($okey eq $nkey) {
         my $S = $nkey;
         Grid->setCode("$se.StateChangeEvent.slot");
         $hm->sevStateEvent($comp, $report, $rep, $orep, 'NWS_Slot', $S, $wwn, 
              {logical => 1, label => "Slot $x of" });
     } else {
         if ($okey) {
           Grid->setCode("$se.ComponentRemoveEvent.slot");
           $hm->removeCompEvent($comp,$physicalFrame, $report, 'CIM_Card',$okey, $wwn, {system => 1});
         }
         if ($nkey) {
           my($ctrl) = NWS::SE->newSlot($rep, $comp);
           Grid->setCode("$se.ComponentInsertEvent.slot");
           $hm->insertCompEvent($comp,$physicalFrame, $report, $ctrl, $nkey, $wwn, {system => 1});
         }
     }
  }
  for ($x=$SLOTS+1; $x < $OSLOTS; $x++) {
     $comp = "slot.$x";
     $okey = $orep->get("$comp.dev-key");
     Grid->setCode("$se.ComponentRemoveEvent.slot");
     $hm->removeCompEvent($comp,$physicalFrame, $report, 'CIM_Card',$okey, $wwn, {system => 1});
  }

  for ($x = 0; $x < $rep->get("info.portTotal") ; $x++) {
     $comp = "fcPort.$x";
     if (exists($orep->{"$comp.status-avail"})) {
       my $exname = $rep->{"$comp.encName"};
       Grid->setCode("$se.StateChangeEvent.port");
       $hm->sevStateEvent($comp, $report, $rep, $orep, 'CIM_Card', $comp, $wwn, 
           {label => "External Port of $exname on "} );
     } else {
       my $port = NWS::SE->newPort($rep, $comp);
       my $nkey = $rep->{"$comp.LocalPortWWN"};
       Grid->setCode("$se.ComponentInsertEvent.port");
       $hm->insertCompEvent($comp,$physicalFrame, $report, $port , $nkey, $wwn, {system => 1});
     }
  }
  


  my (%L, %OL);

  my $LUNS  =  $rep->get('info.lunTotal');
  my $OLUNS =  $rep->get('info.lunTotal');

  for ($x=1; $x <= $LUNS; $x++) {
     my $wwn    = $rep->get("lun.$x.lunWwn");
     my $status = $rep->get("lun.$x.lunStatus");
     my $name   = $rep->get("lun.$x.lunName");
     next if (!$wwn || $wwn =~ /^0*$/);
     $L{$wwn} = [$status, $name, $x];
  }
  for ($x=1; $x <= $OLUNS; $x++) {
     my $wwn    = $orep->get("lun.$x.lunWwn");
     my $status = $orep->get("lun.$x.lunStatus");
     my $name   = $orep->get("lun.$x.lunName");
     next if (!$wwn || $wwn =~ /^0*$/);
     $OL{$wwn} = [$status, $name, $x];
  }
  foreach my $wwn0 (keys %L) {
     my $w1  = $L{$wwn0};
     my $comp= "lun." . $w1->[2];
     if (exists($OL{$wwn0})) {
        my $w2  = $OL{$wwn0};
        my $st1 = $w1->[0];
        my $st2 = $w2->[0];
        if ($st1 ne $st2) {
           Grid->setCode("$se.AlarmEvent.lun");
           $hm->alarm($report, $orep, uc($se), $comp, "lunStatus", $id, $id, $wwn, 
                      undef, { info => $w1->[1] } );
        }
     } else {
        my $lun = NWS::SE->newLun($rep, $comp);
        Grid->setCode("$se.ComponentInsertEvent.lun");
        $hm->insertCompEvent($comp, $physicalFrame, $report, $lun, $wwn0, $wwn, {logicalDevice => 1} );
     }
  }
  foreach my $wwn0 (keys %OL) {
     my $w1  = $OL{$wwn0};
     my $comp= "lun." . $w1->[2];
     if (!exists($L{$wwn0})) {
         Grid->setCode("$se.ComponentRemoveEvent.lun");
         $hm->removeCompEvent($comp, $physicalFrame, $report, 'NWS_StorageVolume', $wwn0, $wwn, {logicalDevice => 1});
     }
  }
}

  
sub status {
   my($hm, $rep, $orep, $comp) = @_;

   my $osev = $orep->get("$comp.status-sev") || 0;
   my $nsev =  $rep->get("$comp.status-sev") || 0;

   my $old =  $orep->get("$comp.status-desc");
   my $new =  $rep->get("$comp.status-desc");

   my $oavail =  $orep->get("$comp.status-avail");
   my $navail =  $rep->get("$comp.status-avail");

   return ($old, $new, $osev, $nsev, $oavail, $navail);
}



1;
