package Health::Host;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Host.pm,v 1.50 2004/11/17 07:22:08 kdesai Exp $

 
#             CREATION
####################################################
 
use Health;
use PDM;
use Carp;
use Data::Dumper;
use Report;
use strict;
use CIM::Instance;
use Message;
use Debug;
use TO;
  
use base 'Health';

sub revision {'$Revision: 1.50 $'}
 
sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::Host');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {FINAL => 1});
  #$pdm->reportRequest($self, 'run_backup' , {category => Report::CAT_BACKUP} );
  $pdm->reportRequest($self, 'run_host' ,   {category => Report::CAT_HOST} );
  $pdm->reportRequest($self, 'run_host' ,   {category => Report::CAT_DATAHOST} );
  $pdm->reportRequest($self, 'run_host' ,   {category => Report::CAT_SVE} );
  return $self;
}                     



# runs every time
#
sub run_host {
  my($hm, $report) = @_;
  my($run, $orep, $ompxio, $x);
  my($pdm)     = $hm->{pdm};
  my($renv)    = System->get_renv();
  my $Config   = PDM::ConfigFile->read();

  CIM->version("1.1");
  $DB::single = 1;

  my $rep     = $report->content();
  my $mpxio   = $rep->{mpxio};
  my $oreport = PDM->getOldReport($report->fileKey);
  my $orep    = $oreport->content()  if ($oreport);
  my $to      = $report->id("class") eq "host.datahost" ? $rep->{topo} : TO->readExistingTopo();
  my $id      = $report->deviceName();

  if (exists($rep->{'sp.ntc.status'})) {
     my $tran  = Transition->getTransition( {   
                                          key => $rep->{'sp.ntc.ip'} ,
                                         code => 'ntc',
                                        value => $rep->{'sp.ntc.status'},
                             transition_value => "CannotPing",
                                       repeat => '8h',
                                 });
     if ($tran =~ /IN/  || $tran =~ /OUT/) {
        my ($et, $desc, $sev);
        if ($tran =~ /IN/) {
          $et   = "agent.CommunicationLostEvent";
          Grid->setCode("agent.CommunicationLostEvent");
          $sev  = Message::SEVERITY_ERROR;
          $desc = "Lost Communication(oob) with Terminal-Concentrator /" . $rep->{'sp.ntc.ip'};
        } else {
          $et   = "agent.CommunicationEstablishedEvent";
          Grid->setCode("agent.CommunicationEstablishedEvent");
          $sev  = Message::SEVERITY_NORMAL;
          $desc = "Regained Communication(oob) with Terminal-Concentrator /" . $rep->{'sp.ntc.ip'};
        }
        my $ev = CIM::Instance->new('NWS_CommunicationLostEvent', [
                  [ EventType       => $et  ],
                  [ EventId         => $pdm->getEventSequence  ],
                  [ Severity        => $sev ],
                  [ Actionable      => ($sev > 0) ],
                  [ Component       => "sp.ntc"],
                  [ Target          => $report->fileKey() ],
                  [ Caption         => 'ntc' ],
                  [ Description     => $desc ]
                   ]);
        my $sd = Events->sourceDetector({ event => $ev });
        my $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
                  [ Event      => $ev  ],
                  [ Element    => $sd->[0] ],
                    ]);
        my $ed = Message->new( { id   => {},
                            instances => [$ev, @$sd, $pertains ], severity  => $sev });
        $pdm->saveMessage($ed);

     }

  }
  return if (!$to);   # cannot do ports or mpxio without a topo
#
# PORTS
#
  if ($oreport) {
    my $hosts  = $to->hostList();
    my $host1  = $hosts->[0];
    my $hbas   = $host1->portInfo();

    my $wwn = $id;
    foreach my $p (keys %$rep) {
       next if (substr($p,0,6) ne "ports.") ;
       my $new = $rep->{$p} || "[undefined]";
       my $old = $orep->{$p} || "[undefined]";
       if ($old ne $new) {
         my $sev = ($new =~ /NOT/)? Message::SEVERITY_ERROR: Message::SEVERITY_GREEN;
         my $sign = ($new =~ /NOT/)? "M": "P";
         my $p2 = $p;
         if ($p2 =~ /socal.*:(\d)$/) {
            $p2 = substr($p2,0,-2) . "/sf\@$1";
         }
         my $found;
         for ($x=0; $x <= $#$hbas; $x++ ) {
             my $to_p = Util->ltrim($hbas->[$x]{path});
             if (substr("ports.$to_p",0,length($p2)) eq $p2) {
                $found = $x; last;
             }
             
         }
         my $comp  = defined($found) ? "port.$found" : "ports";
         my $desc0 = "status of hba " . substr($p,6) . " on $wwn changed from $old to $new";
         Grid->setCode("host.AlarmEvent.hba");
         Grid->setSign($sign);
         my $ev = $hm->alarmEvent($comp, "", $report, $wwn, $desc0, $sev, "$sign.hba.$found", {noState => 1});
         if (defined($found)) {
            State->saveState("host", $wwn, "hba.$found", $wwn, $sev, $desc0, 1, $ev);
         }
       }
    }
  }

 
 
# ONLINE OFFLINE STANDBY

  if ($oreport) {
    $orep    = $oreport->content() ;

    foreach my $k (keys %$orep) {
      next if (substr($k,0,6) ne "mpxio.");
      if (!exists $rep->{$k}) {
        my($t, $wwn) = split(/\./, $k);
        my ($dev, $port) = $Config->deviceByWWN($wwn);
        if ($dev) {
           my $o_type = $report->id('category',   $dev->{type});
           my $o_dev  = $report->id('deviceName', $dev->{key});
           Grid->setCode("$dev->{type}.AlarmEvent.device_path");
           $hm->alarmEvent("port.$port.device_path", "", $report, $dev->{key}, 
             "Path $wwn to $dev->{type} $dev->{name}/$dev->{ipno} dissapeared from the host", 2, 
             "port.$port.device_path");
           $report->id('category',   $o_type);
           $report->id('deviceName', $o_dev);
        }
      }
    }
  }

  foreach my $k (keys %$rep) {
     next if (substr($k,0,6) ne "mpxio.");
     my($state, $desc) = split(/\t/, $rep->{$k});
     my $v = "MPXIO: $state on $desc";

     my($ostate, $odesc) = split(/\t/, $orep->{$k});
     if (!$oreport && ($state eq "OFFLINE")) {
       &saveMpx($to,"t3",$k, Message::SEVERITY_ERROR, $v);

     } elsif ($oreport && ($state ne $ostate)) {
        if ($state eq "OFFLINE") {
           &saveMpx($to,"t3",$k, Message::SEVERITY_ERROR, $v);
        } elsif ($state eq "ONLINE") {
           &saveMpx($to,"t3",$k, Message::SEVERITY_GREEN, $v);
        }
     }
  }
#
#  LUNS
# lun.VE.dev-rdsk-c7t2B00006022004188d7s2.statusA' => 'O.K.'
# lun.VE.dev-rdsk-c7t2B00006022004188d7s2.wwn' => 2900006022004188
# lun.T300.dev-rdsk-c14t50020F2300003EE5d0s2.statusA' => 'No UNIX Label'
# lun.T300.dev-rdsk-c14t50020F2300003EE5d0s2.wwn' => '50020f2000003ee5'


  if ($oreport) {
     $orep    = $oreport->content() ;
     # removed
     my $cimkey = $id;
     my $cnt;
     # deleted
     foreach my $key (keys %$orep) {
         if (substr($key,0,4) eq "lun." && substr($key, -3) eq "wwn" ) {
           my($a1, $type, $dev0, $a2) = split(/\./, $key);
           my $wwn    = $orep->{$key};
           if (!exists($rep->{$key}) ) {
              my $dev = $Config->deviceByWWN($wwn, 4); # check only last 4 digits of wwn
              my $info =  "target=$dev->{type}:$dev->{name}/$dev->{ipno}" if ($dev);
              my $name = $id;
              Grid->setCode("host.AlarmEvent.lun.$type");
              $hm->alarm($report, $orep, "host", "lun.$type.$dev0", "statusA", $name, $name , $cimkey, "lun.status", {use_map_id => 1, info => $info }
                  );
              #State->saveState($dev->{type}, $dev->{key}, "e", $dev->{key}, 2, "inband comm lost", 0);
              last if ($cnt++ > 10);
           }
         }
     }
     # changed
     $cnt = 0;
     foreach my $key (keys %$rep) {
         if ( substr($key,0,4) eq "lun." && substr($key, -3) eq "wwn" ) {
           my($a1, $type, $dev0, $a2) = split(/\./, $key);
           my $wwn    = $rep->{$key};

           foreach my $A ('A', 'B') {
             if ( exists( $rep->{"$a1.$type.$dev0.status$A"}) &&
                  exists($orep->{"$a1.$type.$dev0.status$A"}) ) {
                 my $dev = $Config->deviceByWWN($wwn, 4); # check only last 4 digits of wwn
                 my $name = $id;
                 my $info =  "target=$dev->{type}:$dev->{name}/$dev->{ipno}" if ($dev);
                 Grid->setCode("host.AlarmEvent.lun.$type");
                 $hm->alarm($report, $orep, "host", "lun.$type.$dev0", "status$A", $name, $name , $cimkey, "lun.status", {use_map_id => 1, info => $info}
                     );
                 last if ($cnt++ > 10);
             }
           }
         }
     }
  }
  # Check free space for our data files
  foreach my $v (keys %$rep) {
      next if ($v !~ /freeSpace/);
      if ($v =~ /var\/opt\/SUNWstade/ || $v =~ /\|\/$/ || $v =~ /\|\/tmp$/) {
         my $v1 = substr($v, 10);
         my $percent = $rep->{$v};
         my $opercent = $orep->{$v};
         $percent =~ s/%//;
         $opercent =~ s/%//;
   
         if ($percent >= 98 && $opercent < 98) {
             my($desc0) = "Detected file system '$v1' at ${percent}% capacity";
             my $wwn = $id;
             Grid->setCode("host.AlarmEvent.disk_capacity");
             $hm->alarmEvent("freeSpace", "", $report, $wwn, $desc0, 2, "disk_capacity");

         } elsif ($percent < 98 && $opercent >= 98) {
             my($desc0) = "Detected file system '$v1' back to ${percent}% capacity";
             my $wwn = $id;
             Grid->setCode("host.AlarmEvent.disk_capacity");
             $hm->alarmEvent("freeSpace", "", $report, $wwn, $desc0, 0, "disk_capacity_okay");
         }
      }
  }
}

# k = mpxio.wwn

sub saveMpx {
  my($to, $cat, $k, $sev, $desc) = @_;
  my($x,$y);
  my $L = $to->storageList();
  my $done = 0;
  for ($x=0; $x <= $#$L; $x++) {
     my $st = $L->[$x];
     next if ($st->{info}{type} ne $cat);
     my $k1 = $st->{info}{name};
     my $pi = $st->{portInfo};
     my $po = $st->{port};
     next if (!$pi);
     for ($y=0; $y <= $#$pi; $y++) {
       my $pw = $pi->[$y]{PortWWN};
       if ($k =~ /$pw/) {
          my($t2, $k2) = split(/\:/, $po->[$y]);
          State->saveLinkState($cat, "$k1:$y", $t2, $po->[$y],
            $sev, $desc, undef, undef, undef, undef);
          $done = 1 ;last;
       }
     }
     last if ($done);
  }
        
  State->saveState($cat,  $k, "mpxio", undef, $sev, $desc, 0);
}



sub run_backup {
  my($hm, $report ) = @_;

  CIM->version("1.1");
  $DB::single = 1;
  my $mgmtLevel = $report->value('id.mgmtLevel') || 'D';
  my($rep)     = $report->content();

  my($oreport) = PDM->getOldReport($report->fileKey);

  my($orep, $desc, $data, $run, $disco, $obackup, $x);

  if (!$oreport) {
     $run = 1;
  } else {
     $orep  = $oreport->content();

     my $old_backup = $orep->{backup_config};
     $old_backup =~ s/^\s*//gm;

     my $new_backup = $rep->{backup_config};
     $new_backup =~ s/^\s*//gm;

     if ($old_backup ne $new_backup) {
        $run = 1;
     }
  }
  if ($run) {
       Grid->setCode("host.backup");
       my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "host.backup"  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ MgmtLevel   => $mgmtLevel ],
                  [ Description => "Agent backup"],
                  [ Component   => "backup_config"],
                  [ Target      => $report->fileKey ],
                  [ Data        => $rep->{backup_config}]
                         ]);

       my $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
 
       my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $sd->[3]]
                    ]);

       my $ed = Message->new( {  id   => $report->id(),
                            instances => [$ev, @$sd , $pertains],
                            severity  => Message::SEVERITY_NORMAL });

       PDM->saveMessage($ed);
  }

#
#  PACKAGES
#
  $run = 0;
  if (!$oreport || System->get_audit() ) {
     $desc  = "New Patch and Package Information generated";
     $disco = "D";
     foreach my $k (sort keys %$rep) {
       next if (substr($k,0,15) ne "showrev.package" &&
                 substr($k,0,14) ne "showrev.patch." );
       $data .= "ADD=$k|" . substr($rep->{$k},8) . "\n";
     }
     $run = 1; 
  } else {
     $desc  = "Patch and/or Package Information has changed:";
     $orep  = $oreport->content();
     $disco = "A";
     foreach my $k (keys %$rep) {
        next if (substr($k,0,15) ne "showrev.package" &&
                 substr($k,0,14) ne "showrev.patch." );
        if (!$orep->{$k}) {
           $data .= "ADD=$k|" . substr($rep->{$k},8) . "\n";
           $run = 1;
        } elsif ($rep->{$k} ne $orep->{$k}) {
           $data .= "UPDATE=$k|" . substr($rep->{$k},8) . "\n";
           $run = 1;
        }
     }
     foreach my $k (keys %$orep) {
        next if (substr($k,0,15) ne "showrev.package" &&
                 substr($k,0,14) ne "showrev.patch." );
        if (!$rep->{$k}) {
           $data .= "DELETE=$k|" . substr($orep->{$k},8) . "\n";
           $run = 1;
        }
     }
   }
   if ($run) {
       Grid->setCode("host.PatchInfo");
       my $ev = CIM::Instance->new('NWS_Event', [
                  [ EventType   => "host.PatchInfo"  ],
                  [ EventId     => PDM->getEventSequence  ],
                  [ Description => $desc],
                  [ Target      => $report->fileKey ],
                  [ Component   => "showrev"],
                  [ MgmtLevel   => $mgmtLevel ],
                  [ Data        => $data]
                         ]);

       my $sd = Events->sourceDetector({ event => $ev , host => 1, rep => $rep});
 
       my $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                  [ Event       => $ev  ],
                  [ Element     => $sd->[3]],
                  [ DiscoveryType => $disco],
                    ]);

       my $ed = Message->new( {  id        => $report->id,
                            instances => [$ev, @$sd , $pertains],
                            severity  => Message::SEVERITY_NORMAL });

       PDM->saveMessage($ed);
   }
}

sub heartbeat {
  my($class, $desc) = @_;

  Grid->setCode("agent.HeartbeatEvent");
  my $ev = CIM::Instance->new('NWS_HeartbeatEvent', [
           [ EventType   => 'agent.HeartbeatEvent' ],
           [ EventId     => PDM->getEventSequence  ],
           [ Description => "Heartbeat $desc"   ],
           [ MgmtLevel   => "" ],
           [ Interval    => 24 * 60],
                         ]);
  my $sd = Events->sourceDetector({ event => $ev });
  my $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
            [ Event       => $ev  ],
            [ Element     => $sd->[0] ],
              ]);
  my $ed = Message->new( { id   => {},
                      instances => [$ev, @$sd, $pertains ],
                      severity  => Message::SEVERITY_NORMAL });
  return $ed;
}

sub all_logic {
  my($hm ) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $x, $pertains , $sd);
  my($HB) = 'heartbeat';
  CIM->version("1.1");
  my $renv = System->get_renv();
  $DB::single = 1;

#
# RUNS after all health ran.
#
 if ($pdm->getEventCount > 0) {
     Timer->resetTimer($HB);
 } else {
     my($hb_delay) = $renv->{heartbeat} || 24; # hours
     $hb_delay *= 60;
     if (Timer->getTimer($HB) > $hb_delay) { #it's been a day with no transmission.
        Timer->resetTimer($HB);

        $ed = $hm->heartbeat();

        $pdm->saveMessage($ed);
     }
 }

# GET ALL SYSTEM ERRORS AND SEND AS EN EVENT.
 my($sys_errs) = Debug->get_system_errors();
 my $len = length($sys_errs);
 if ($len > 2000) {
   $sys_errs = substr($sys_errs,0,2000) . "\ntotal-size=$len";
 }

 if ($sys_errs) {
    Grid->setCode("agent.AlarmEvent.system_errors");
    $ev = CIM::Instance->new('NWS_Event', [
              [ EventType   => 'agent.AlarmEvent' ],
              [ EventId     => $pdm->getEventSequence  ],
              [ Severity    => Message::SEVERITY_WARNING ],
              [ MgmtLevel   => "" ],
              [ Data        => $sys_errs   ],
              [ Target      => "host:$renv->{hostname}" ],
              [ Description => substr($sys_errs,0,200) . ":"] ,
                     ]);
    $sd = Events->sourceDetector({ event => $ev });

    $pertains = CIM::Instance->new('NWS_EventPertainsToSoftwareElement', [
              [ Event           => $ev  ],
              [ Element         => $sd->[0] ],
                ]);

    $ed = Message->new( { id   => { deviceName => $renv->{hostname} },
                        instances => [$ev, @$sd, $pertains ],
                        severity  => Message::SEVERITY_WARNING});
    $pdm->saveMessage($ed);
  }
} 

1;
