package GUI::VolVerify;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use strict;
use Process;
use Html;
use Html::Tabs;
use PDM;

#  $Id: VolVerify.pm,v 1.32 2003/09/24 20:37:00 mckenney Exp $

sub meta {
  my($q) = @_;
  my $o = "&option=$q->{option}";
  return 
  "<meta http-equiv=Refresh content=\"20;URL=$Http::WEBPROC?GO=GUI::VolVerify::run$o\">"; 
}

sub run {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();
  $q->{option} =1 if (!$q->{option});

  my $table = Html::Tabs->create(list  =>  
            ["1=$L->{title1}", "2=$L->{title2}", "3=$L->{title3}" ],
                       url  => "$System::WEBPROC?GO=GUI::VolVerify::run",
                     width  => "90%",
             selectedColor  => "white",
         selectedTextColor  => "blue",
           backgroundColor  => $main'LIGHT,
        backgroundTextColor => 'black',
                  selection => $q->{option}
         );


  my $info;
  my($warn2, $warn3, $cat, $last_win, $cpid, $running);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_kill}) {
      foreach my $h (@$host) {
         Util::Http->runit($h->{ipno}, "/sbin/volverify -k -b");
      }
      system(System->get_home() . "/sbin/volverify -k -b");
      $running = 1;
      print &meta($q);
      print Html->info($L->{started});
  }
  if ($q->{ACTION_submit} ) {
       require MIME::Base64;
       my $pass = MIME::Base64::encode($q->{telnet}); chomp($pass);
       $renv->{array_password}    = $pass;
       $renv->{volVerify}         = $q->{volVerify} ? "Y": "N";
       $renv->{'volVerify.fix'}   = $q->{fix}       ? "Y": "N";
       $renv->{'volVerify.rate'}  = $q->{rate};
       $renv->{'volVerify.frequency'}  = $q->{freq};
       my $x;
       for ($x=0; $x <= 6; $x++) {
         $renv->{"volVerify.time$x"}  = $q->{"time$x"};
       }
       $renv->{'volVerify.once_a_month'}  = $q->{once_a_month} ? "Y" : "N";
       
  
       if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print Html->error("Cannot write config file!");
       } else {
          System->set_renv($renv);
          print Html->info($L->{upd});
       }
  }
  my $st = Process->status(undef, "volverify");

  if ($st =~ /Running/) {
    print &meta($q);
  }


  if ($q->{option} == 1) {
    print Html->header2("manage.util.volverify", undef, $L->{start});
    print "<table border=0><tr><td></table>$table";
    &verify($q, $renv);

  } elsif ($q->{option} == 2) {
    print Html->header2("manage.util.volverify", undef, $L->{kill0});
    print "<table border=0><tr><td></table>$table";
    &kill($q, $renv, $running);

  } elsif ($q->{option} == 3) {
    print Html->header2("manage.util.volverify", undef, $L->{report});
    print "<table border=0><tr><td></table>$table";
    &report($q, $renv ,$dev, $host);
  }
}

sub verify {
  my($q, $renv) = @_;

  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");
  my $volVerify = "checked" if ($renv->{volVerify} eq "Y");
  my $fix       = "checked" if ($renv->{'volVerify.fix'} eq "Y");

  require MIME::Base64;
  my $telnet    = MIME::Base64::decode($renv->{array_password});
  my $rate      = Html->makeSelect("rate", 
                     "1=1:$L->{slow}|4=4:$L->{mid}|8=8:$L->{high}", 
                     $renv->{'volVerify.rate'});

#  0=always, 1:midnight to 1am, ...  24:11pm to midnight.
  my($x, $tt, $tt2, $x0, $next);
  for ($x0=1; $x0 <= 23; $x0++) {
     my $s;
     if ($x0 == 12) {
        $x = $x0;
        $next = 1;
        $s = "pm";
     } elsif ($x0 > 12) {
        $x = $x0 - 12;
        $next = $x+1;
        $s = "pm";
     } else {
        $s = "am";
        $x = $x0;
        $next = $x+1;
     }
     $tt .= ($x0+1) ."=${x}$s-$next$s|";
  }
  chop($tt2);
  my ($meta, $submit2, $time_html);

  for ($x=0; $x <= 6; $x++) {
     my $t = Html->makeSelect("time$x", "99=$L->{always}|1=Midnight-1am|$tt", 
                             $renv->{"volVerify.time$x"}, {multiple => 3});
     my $d1 = $G->{"day$x"};
     $time_html .= "<tr><td align=right bgcolor=$Style::LIGHT width=35%><b>$d1</b> :<br> $L->{time}: </td><td><table border=0 cellspacing=0 cellpadding=0><tr><td>$t</td><td>";
     $time_html .= $L->{warn1} if ($x==0);
     $time_html .= "</table></td>";
  }
  my $mm = "1|7|10|15|20|25|28|30|35|40|50|60|90|0=Continuously";
  my $monthOnly = Util->makeSelect("freq", $mm, $renv->{'volVerify.frequency'});

  my $o =<<EOF;
<form method=post>
 <input type=hidden name=GO value=GUI::VolVerify::run>
 <input type=hidden name=option value=$q->{option}>
<center>
<table border=0 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td>$L->{warning}
</table>
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{maint}</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{volVerify}: </td>
    <td><input type=checkbox name=volVerify $volVerify>&nbsp;

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{fix}: </td>
    <td><input type=checkbox name=fix $fix>&nbsp;

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{monthly}: </td>
    <td>$monthOnly</td>

$time_html

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{rate}: </td>
    <td>$rate

<tr><td align=right bgcolor=$Style::LIGHT width=40%> $L->{telnet}: </td>
     <td><input type=password size=20 name=telnet value=\"$telnet\">

</table>
<b><table border=0><tr><td></table>
  <input type=submit name=ACTION_submit value=\"$L->{submit}\">
EOF

   print $o;
}

sub kill {
  my($q, $renv, $running) = @_;
  my ($submit2);
  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");
  my $st = Process->status(undef, "volverify");
  $st = "Running" if ($running);

  if ($st !~ /Running/) {
    $submit2 = "<input type=submit name=ACTION_kill value=\"$L->{kill}\">";
  }

  my $o =<<EOF;
<script>
  function log(a) {
    var O = window.open('$Http::WEBPROC?GO=GUI::VolVerify::log', 'killkog',
                'menubar=no,resizable=yes,scrollbars=yes,width=500,height=500');
    O.focus();
  }
</script>
<form method=post>
 <input type=hidden name=GO value=GUI::VolVerify::run>
 <input type=hidden name=option value=$q->{option}>
<table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{kill2}</td>

<tr><td align=right bgcolor=$Style::LIGHT width=40%>$L->{status}:</td>
    <td>&nbsp;$st
<tr><td align=right bgcolor=$Style::LIGHT width=40%>$L->{log}:</td>
    <td>&nbsp;[ <a href=javascript:log(1)>$L->{disp}</a> ]</td>
</table>&nbsp;<br><b>
  $submit2
</form>
EOF

  print $o;
}

sub process {
  my($out, $db) = @_;
  my $VAR1;
  if ($out) {
     eval $out;
     foreach my $el (keys %$VAR1) {
         $db->{$el} = $VAR1->{$el} if (!exists($db->{$el}));
     }
  }
}


sub report {
  my($q, $renv, $devs, $hosts) = @_;

  my $G = Labels->read();
  my $L = Labels->read("GUI::VolVerify");

  print <<EOF;
<script>
  function win1(t,n) {
    var b = '$Http::WEBPROC?WIN=1&GO=GUIAdmin::' + t + '->updDevice&no=' + n;0
    var O = window.open(b,'vol','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
    O.focus();
  }
</script>

<table border=0><tr><td></table>
<table border=1 cellspacing=0 width=90% bgcolor=white>
  <tr bgcolor=$Style::DARK>
     <td colspan=9><font color=white><b>$L->{title}</td>
  <tr bgcolor=$Style::LIGHT>
     <th>$L->{host}</th>
     <th>$L->{dev}</th>
     <th>$L->{ver}</th>
     <th>$L->{vol}</th>
     <th>$L->{start}</th>
     <th>End</th>
     <th>Duration</th>
     <th>Errors</th>
     <th>$L->{status}</th>
EOF
  my $db = Util->deserializeDir("VolVerify");  # keyed by ipno
  
  foreach my $h (@$hosts) {
     my $data = Util::Http->readFile($h->{ipno}, "VolVerify/");
     my @lines = split(/\n/, $data);
     my ($var, $VAR1);
     foreach my $l (@lines) {
       if ($l =~ /\$VAR1/) {
          &process($var, $db);
          $var = $l;
       } else {
          $var .= $l;
       }
     }
     &process($var, $db);
  }
  
  my(%D, $x);
  for ($x=0; $x <= $#$devs; $x++) {
     my $d = $devs->[$x];
     next if (index(",t3,6120,", ",$d->{type},") < 0);
     my $host = $d->{host} || $renv->{hostname};
     $d->{no} = $x;
     $D{"$host.$d->{key}"} = $d;
  }

  my ($last, $last_dev);
  foreach my $name (sort keys %D) {
     my $d = $D{$name};
     my $scrubbing="off";
     (my $readerr, my $rep1) = 
                         Report->readReport($d->{type}.":".$d->{key}, "*");
     if ($rep1) {
       my $v = $rep1->value(); 
       $scrubbing="on" if($v->{"system.sysDiskScrubber"} eq "on");
     }


     my $ver = $d->{volVerify} || $renv->{volVerify};
     my $el = $db->{$d->{ipno}};
     my $host = $d->{host} || $renv->{hostname};
     my $h;
     if ($host ne $last) {
        $last = $host;
        $h = Util->shortHostname($host);
     }
     my $progress = $el->{progress};
     $progress .= "%" if ($progress =~ /^\d+/);
     $progress = "DONE<small> ($el->{end})" if ($el->{end});
     my $type2 = uc($d->{type});
     my $url = "<a href=javascript:win1('$type2','$d->{no}')>$d->{name} / $d->{ipno}</a>";
     if ($last_dev ne $d->{ipno}) {
          print "<tr><td></td>" if ($last_dev);
          $last_dev = $d->{ipno};
     }
     my $end = "RUNNING" if ($el->{start});
     if ($scrubbing eq "on"){
           $progress = 
	     "<font color=red>Warning: This array has internal disk scrubbing" . 
	     " enabled, vol verify cannot be scheduled.</font>";
	}

     print "<tr>
        <td><b>$h</td>
        <td>&nbsp;$url</td>
        <td><center>$ver&nbsp;</td>
        <td>&nbsp;$el->{volume_name} $el->{volume}</td>
        <td>&nbsp;". substr($el->{start},5) . "</td>
        <td>&nbsp;$end</td>
        <td>&nbsp;</td>
        <td>&nbsp;</td>
        <td><center>$progress&nbsp;</td>";

     my $vols = $el->{VOL};
     $h = "";
     foreach my $v (keys %$vols) {
        my $el2 = $vols->{$v};
        next if (!$el2->{end});
        my $dur_h = int($el2->{duration} / 60/60);
        my $dur_m = int($el2->{duration}/60) - $dur_h * 60;
        my $err;
        foreach my $en ('soft','firm','hard') {
          $err = ucfirst($en) . ":$el2->{$en}," if ($el2->{$en});
        }
        chop($err) if ($err);
        $err = $G->{none} if (!$err);
        my $progress = $el2->{progress};
        $progress .= "%" if ($progress =~ /^\d+/);

        print "<tr>
        <td><b>$h</td>
        <td>&nbsp;$url</td>
        <td><center>$ver&nbsp;</td>
        <td>&nbsp;$el2->{volume_name} $el2->{volume}</td>
        <td>&nbsp;" . substr($el2->{start},5) . "</td>
        <td>&nbsp;" . substr($el2->{end},5)   . "</td>
        <td><center>$dur_h:$dur_m:00</td>
        <td>&nbsp;$err</td>
        <td><center>$progress&nbsp;</td>
          ";
     }

  }
  print "</table>&nbsp;<p>";
     
  
}

sub log {
  my($q) = @_;

  print Html->body();
  my $L = Labels->read("GUI::VolVerify");
  open(O, System->get_home() . "/DATA/tmp/volverify.out");
  my($l, $out, $done);
  while ($l = <O>) {
     $out .= $l;
     $done = 1 if ($l =~ /^EXIT/);
  }
  close(O);
  my $meta = "<meta http-equiv=Refresh content=\"20;URL=$Http::WEBPROC?GO=GUI::VolVerify::log\">" if (!$done);

  print "
    $meta
    <table border=0 cellspacing=0 cellpadding=3 bgcolor=$Style::DARK width=100%>
    <tr><td><font color=white><b>$L->{logkill}
    </td><td align=right><font color=white>[ <a href=javascript:window.close()><font color=white>$L->{close}</font></a> ]
    </table>
    </center><pre>$out";
}
 

1;
 
