package GUI::Groups;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
use strict;
use AdminGroup;
use Roles;


sub update {
  my($q) = @_;
  my $G = Labels->read();
  my $LB = Labels->read('GUI::AdminGroup');

  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }
  print Html->body();

  print Html->header2("admin.system.device_groups");

  if (my $err = Roles->verifyRole($q, "admin|c_admin")) {
     print $err;
     return;
  }
  my $groups = AdminGroup->new();

  if ($q->{ACTION_submit}) {
     my $update;
     foreach my $k (keys %$groups) {
        delete $groups->{$k};
     }
     foreach my $el (keys %$q) {
        if (substr($el,0,3) eq "gr_") {
           my $no = substr($el,3) + 0;
           my $code = $q->{"gr_$no"};
           my $val  = $q->{"val_$no"};
           $code = Util->trim($code);
           $code =~ s/ /_/g;
           if ($code && $val) {
              $groups->{$code} = $val;
              $update = 1;
           }
        }
     }
     if ($update) {
         $groups->save(); 
     }
  }
out:
  print "
  <form><input type=hidden name=GO value=\"GUI::Groups::update\">";

  my $head = "<table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK><font color=white><b>$LB->{title}
   <tr bgcolor=$Style::LIGHT>
     <td width=1%><b>&nbsp;#
     <td width=15%><b>&nbsp;$LB->{code}
     <td><b>&nbsp;$LB->{desc}<form>
    ";
  my $gr_cnt = 1;
  foreach my $gr (sort keys %$groups) {
     $head .= "<tr><td width=1%>$gr_cnt</td>
                   <td width=15%><input size=8 maxlength=8 type=text name=gr_$gr_cnt  value=\"$gr\">
                   <td><input type=text size=40 name=val_$gr_cnt value=\"$groups->{$gr}\">
               </td>";
     $gr_cnt++;
  }
  my $MAX = $q->{DOC} ? 8: 20;
  while ($gr_cnt <= $MAX) {
     $head .= "<tr><td width=1%>$gr_cnt</td>
                   <td width=15%><input size=8 maxlength=8 type=text name=gr_$gr_cnt>
                   <td><input type=text size=40 name=val_$gr_cnt>
               </td>";
     $gr_cnt++;
  }
      
  print "$head</table><b>
   <input type=submit name=ACTION_submit value=\"$LB->{submit_1}\">
  </form>";

}
1;

