package FSA;
use System;
use PDM;
use FSA::RuleSet1;
use FSA::Indy;
use strict;
use Events;
use TO;
use Message;
use Grid;


#      OLD          NEW        Agg.
#  ------------+-------------+------+
#  |    [C]    |    [C]      | [A]  |
#  +-----------+-------------+------+
#  will run all FSA rules
#  make old + [C] + [A] the current events
#  move new (non-C) event in old.
#
sub test {
   my (@LIST);

   push(@LIST, [ [ "E5" ], ["sw:c:0", "sw:x:2"]   ]);
   push(@LIST, [ [ "E1" ], ["sw:a:0", "sw:x:0"]   ]);
   push(@LIST, [ [ "E4" ], ["sw:b:1", "sw:y:1"]   ]);
   push(@LIST, [ [ "E2" ], ["sw:a:1", "sw:y:0"]   ]);
   push(@LIST, [ [ "E3" ], ["sw:b:0", "sw:x:1"]   ]);
   push(@LIST, [ [ "E6" ], ["sw:x"]            ]);
   push(@LIST, [ [ "E7" ], ["sw:y"]            ]);

   &merge(\@LIST);
   use Data::Dumper;
   print Dumper(\@LIST);
}

sub clean {
  my($new) = @_;
  my (@clean);
  foreach my $ed (@$new) {
      next if ($ed->type() eq Message::TYPE_ALERT);
      my $ev = $ed->instances(0);
      my $sev = $ev->value("Severity");
      next if (!$sev);  # warn and err only
      push(@clean, $ed);
  }
  return \@clean;
}
      

sub RUN {
  my($class, $TEST) = @_;
  my $renv = System->get_renv();
  if (!$renv->{fsa}) {
     Debug->print2("FSA is off.");
     return 1;
  }
  $DB::single = 1;

  my $topo =  TO->readExistingTopo("MERGE-MASTER") ||  TO->readExistingTopo();
  if (!$topo) {
     Debug->print2("FSA: Cannot find topo");
     return 1;
  }
  my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read();

  Debug->print2("Running FSA...");
  my $OLDF = "previous_events";
  my $new;
  my $old = [];

  $new = PDM->getMessages();

  $old = Util->deserialize($OLDF);
  if (!$old) {
    $class->separate($new, []);
    Debug->print2("FSA: First run, all alerts saved!");
    return 1;
  }

  my @LIST;   # [ [event_list] , [ candidate_node_list] ]
  foreach my $ed (@$old, @$new) {
      next if ($ed->type() eq Message::TYPE_ALERT);
      my $ev = $ed->instances(0);
      my $sev = $ev->value("Severity");
      next if (!$sev);  # warn and err only
      my $target0   =  $ev->value('Target');
      my($type, $target1, $port) = split(/\:/, $target0);
      my $mgmtLevel = $ev->value("MgmtLevel");
      next if ($mgmtLevel eq "DS");                 # skip rack-level events for now.
      my $e0        =  $ev->value('EventType');
      my($cat, $eventType, $rest) = split(/\./, $e0);
      my $component =  $ev->value('Component');
      my $caption   =  $ev->value('Caption');
      my $target = "$type:$target1";
      my $ix = index($target0, ":");
      my $ix2 = rindex($target0, ":");

      my @indy = FSA::Indy->extra_keywords($cat, $eventType, $target, $ev);
      my @keywords = (@indy);

      my $sid = $ev->value("SolutionId");
      if ($eventType eq "CommunicationLostEvent") {
         if ($caption eq "ib") {
           push(@LIST, [ [ $ed ], [@keywords , $target] ]);
         } else {
           push(@LIST, [ [ $ed ], [@keywords, $target, "ETHERNET"] ]);
         }
      } elsif ($eventType =~ /^LinkEvent/) {
         push(@LIST, [ [ $ed ], [@keywords, "$target:$port", &nodeFrom($topo, "$target:$port")] ]);

      # logEvent that was identified as FC_PATH related
      } elsif ($eventType eq "LogEvent" && 
               ($caption eq "PATH" || substr($caption,0,7) eq "driver.") ) {
         push(@LIST, [ [ $ed ], [@keywords, $target, &nodesFrom($topo, $target)] ]);

      } elsif ($component =~ /^port.(\d+)$/ || $component =~ /^fcPort.(\d+)$/) {  # 
         my $port = $1;
         if ($type eq "host") {
            push(@LIST, [ [ $ed ], [@keywords, "$target:$port", &nodesFrom($topo, "$target:$port")] ]);
         } else {
            push(@LIST, [ [ $ed ], [@keywords, "$target:$port", &nodeFrom($topo, "$target:$port")] ]);
         }
      } else {
         if ($type eq "host") {
            push(@LIST, [ [ $ed ], [@keywords, $target, &nodesFrom($topo, $target)] ]);
         } else {
           push(@LIST, [ [ $ed ], [@keywords, $target] ] );
         }
      }
  }
  if ($TEST) {
    showList(\@LIST, "before");
    &merge(\@LIST);
    showList(\@LIST, "after");
  } else {
    &merge(\@LIST);
  }

  foreach my $l (@LIST) {
     my $elist = $l->[0];
     my $nodes = $l->[1];
     if ($#$elist > 0) { # at least 2 events were aggregated.
        $class->findSignature($topo, $nodes, $elist, $Config, $TEST);
     }
  }
  #return 1 if ($#$hosts < 0);

  my $new = PDM->getMessages();
  my (@CURRENT);
  # MOVE OLD EVENTS INTO CURRENT
  foreach my $e (@$old) {
      push(@CURRENT, $e);
  }
  $class->separate($new, \@CURRENT);
  return 1;
}

# SEPARATE EVENTS:
#          OLD                             NEW
#   [ new events sev>0 ]  [ aggregate whole/parts events, new sev=0 ]

sub separate {
  my($class, $new, $CURRENT) = @_;
  my(@OLD);
  my $OLDF = "previous_events";
  foreach my $e (@$new) {
      if ($e->id("inAggregate") || $e->id("aggregate") ) {
         push(@$CURRENT, $e);
      } else {
         my $ev = $e->instances(0);
         my $sev = $ev->value("Severity");
         if (!$sev) { # notice
           push(@$CURRENT, $e);
         } else {
           push(@OLD, $e);
         }
      }
  }
  Util->serialize($OLDF, \@OLD);
  PDM->setMessages($CURRENT);
}

sub eventGroups {
  my($class, $elist) = @_;
  my %G;
  foreach my $e (@$elist) {
     my $ev = $e->instances(0);
     my $type = $ev->value("EventType");
     my ($cat, $et) = split(/\./, $type, 2);
     $G{EventType}{$et}{count}++;
     push(@{$G{EventType}{$et}{events}}, $e);

     $G{Category}{$cat}{count}++;
     push(@{$G{Category}{$cat}{events}}, $e);

     $G{EventType2}{$type}{count}++;
     push(@{$G{EventType2}{$type}{events}}, $e);
  }
  return \%G;
}
     

sub showList {
  my ($LIST, $label) = @_;
  my ($y,$x);
  for ($x=0; $x <= $#$LIST; $x++) {
     my $l = $LIST->[$x];
     my $elist = $l->[0];
     my $nodes = $l->[1];
     next if (!$nodes);
     print "$label-LIST $x\n";
     for ($y=0; $y <= $#$elist; $y++) {
       my $e = $elist->[$y];
       my $ev = $e->instances(0);
       print "      $y:" . $e->description() . ", et=" . $ev->value("EventType") . ", cap=" . 
                    $ev->value("Caption") . ", comp=" . $ev->value("Component") .
                    ", sev=" . $ev->value("Severity") . "\n";
     }
     print   "   Nodes:". join(", ", @$nodes) . "\n" if ($nodes);
     print "--------------------------\n";
  }
}

# all nodes visible from this target (port is optional)
#
sub nodesFrom {
  my($topo, $target) = @_;
  my @L;
  my $list = $topo->visit($target);
  foreach my $el (@$list) {
     push(@L, $el->name());
  }
  return @L;
}

# first nodeport visible from this nodeport
#
sub nodeFrom {
  my($topo, $nodeport) = @_;
  my $target_nodeport = $topo->nodeportTarget($nodeport);
  return ($target_nodeport);
}

sub merge {
  my($LIST) = @_;

  my ($x, $y);
  my $again = 1;
  my $loop = 0;
  while ($again && $loop++ < 100) {
     for ($x=0; $x <= $#$LIST; $x++) {
        my $E1 = $LIST->[$x];
        next if (!$E1);
        for ($y = $x+1; $y <= $#$LIST; $y++) {
           my $E2 = $LIST->[$y];
           next if (!$E2);
           my $int;
           if (($int = &intersect($E1->[1], $E2->[1])) ) {
              my $E1_elist = $E1->[0];
              my $E2_elist = $E2->[0];
              push(@$E1_elist, @$E2_elist);
              if ($E1->[2]) {
                #&uniq($E1->[1], $int);
                $E1->[1] = $int;
              } else {
                $E1->[1] = $int;
                $E1->[2] = 1;
              }
              $LIST->[$y] = undef;
              $again = 1;
           }
        }
     }
  }
}

sub uniq {
  my($l1, $l2) = @_;

  foreach my $el (@$l2) {
      my $found = 0;
      foreach my $el2 (@$l1) {
         if ($el2 eq $el) {
            $found = 1; last;
         }
      }
      if (!$found) {
         push(@$l1, $el);
      }
  }
}
#
# X:1 means enc X, port 1
# X   means enc X, all ports
#
sub intersect {
  my($E1, $E2) = @_;
  my ($x, $y);
  my @INT;
  foreach my $node1 (@$E1) {
     foreach my $node2 (@$E2) {
        my $l1 = length($node1);
        my $l2 = length($node2);
        my ($t1, $k1, $p1) = split(/\:/, $node1);  
        my ($t2, $k2, $p2) = split(/\:/, $node2);  
        if ($node1 eq $node2) {
           push(@INT, $node1);
        } elsif ($l1 < $l2 && substr("$node1:",0,$l1+1) eq substr($node2,0,$l1+1) ) {
           push(@INT, "$t1:$k1");

        } elsif ($l2 < $l1 && substr("$node2:",0,$l2+1) eq substr($node1,0,$l2+1) ) {
           push(@INT, "$t2:$k2");
        }
     }
  }
  return undef if ($#INT < 0);
  return \@INT;
}


################################################
#      CREATE AGGREGATED EVENTS
#
sub findSignature {
  my($class, $topo, $targets, $elist, $Config, $TEST) = @_;
  my ($w);

  CIM->version("1.1");
  my $Config = PDM::ConfigFile->read();

  my($targetName, $target_list, $source_ip) = $class->target_list($targets, $Config);

  my($cnt, $data, $agg_sev, $actionable, $details, $max_gc) = $class->signatureSummary($elist);

  my($ev, $pertains, $rule_no) = FSA::RuleSet1->run($Config, $topo, $targets, $elist, $data);

  $agg_sev = int($agg_sev+0.5);
#TM
  if (!$ev) {  # create generic event
     if ($#$targets == 0) {
        my ($first, $caption, $component, $key1, $comp1, $cat, $desc);
        my $act_cnt = 0;
        $actionable = 0;
        foreach my $ed (@$elist) {
          my $ev  = $ed->instances(0);
          $first = $ev if (!$first);
          if ($ev->value("Actionable") eq "TRUE") {
            $actionable = 1;
            $act_cnt++;
          }
        }
        $desc = $first->value("Description"); # "Aggregated $cnt events ($act_cnt actionable) related to $targetName:";
        my $first_et   = $first->value("EventType");
        my $first_comp = $first->value("Component");
        my $first_cap  = $first->value("Caption");
#/TM

        ($cat, $key1, $comp1) = split(/\:/, $targets->[0]);
        $component = $comp1 || "aggregate";
        Grid->setCode($max_gc);
        my $id = PDM->getEventSequence(); 
        $ev = CIM::Instance->new('NWS_Event', [
                     [ EventType   => $first_et    ],   # TM
                     [ EventId     => $id          ],
                     [ Target      => $target_list ],
                     [ TargetName  => $targetName  ],
                     [ Component   => $first_comp  ],   # TM
                     [ Caption     => $first_cap   ],   # TM
                     [ SourceIP    => $source_ip   ],
                     [ Actionable  => $actionable  ],
                     [ Severity    => $agg_sev     ],
                     [ Aggregate   => ($#$elist+1) ], 
                     [ Description => $desc        ],
                     [ Data        => $data        ],
                            ]);
        my $key = CIM::Key->new( ['NWS_System', Name  => $key1, 
                                    CreationClassName => 'NWS_System'] );
     
        $pertains = CIM::Instance->new('NWS_EventPertainsToSystem', [
                     [ Event       => $ev  ],
                     [ Element     => $key ],
                     ]);
     }
  }
  if ($ev) { # send event
    print "RULE=$rule_no, DESC=" . $ev->value("Description") . "\n" if ($TEST);
    foreach my $ed (@$elist) {
       $ed->id("inAggregate", 1); # mark the members
    }
    my $sd    = Events->sourceDetector({ event => $ev });
    my $ev_id = { aggregate => ($#$elist+1), 
                  deviceName=> $ev->value("Target"), 
                  category  => "aggregate" };

    my $ed    = Message->new({ id => $ev_id, instances => [$ev, @$sd, $pertains] });
    PDM->saveMessage($ed, undef, 1);

  }
}


##################################################################
# FORM A LIST OF TARGETS and TARGET_NAMES
#
sub target_list {
  my($class, $targets, $Config) = @_;
  my ($cat, $key, $targetName, $target_list, $dev ,$source_ip);

  foreach my $t (@$targets) {
      $target_list .= "$t|";
      if (($dev = $Config->deviceByKey($t)) ) {
        $targetName .= "$dev->{type}:$dev->{name}, ";
        $source_ip = $dev->{ipno} if (!$source_ip);
      } else {
        $targetName .= "$t, ";
      }
  }
  if ($targetName) {
    chop($targetName); chop($targetName) ;
  }
  chop($target_list) if ($target_list);

  return ($targetName, $target_list, $source_ip);
}

#  SUMMARY SECTION OF THE AGG. EVENT
#
sub signatureSummary {
  my($class, $elist) = @_;
  my ($actionable);
  my $sev = 0;
  my $cnt = 0;
  my $data = "DEVICE(s) INVOLVED:\n";
  my ($ALL, @DATA, $details, $max_gc, $max_sev, $x);

  foreach my $ed (@$elist) {
     my $ev      = $ed->instances(0);
     my $act     = $ev->value("Actionable");
     $actionable = 1 if ($act eq "TRUE");
     my $sev2    = $ed->severity2();
     $sev        = $sev2 if ( $sev2 > $sev);
     $cnt++;
     my $order = $sev2 * 10;
     $order += 5 if ($act eq "TRUE");
     push(@{$DATA[$order]}, $ed);
  }
  my $sub_events;
  my $cnt2 = 0;
  for ($x=$#DATA; $x >= 0; $x--) {
     if ($DATA[$x]) {
        my $v = $DATA[$x];
        foreach my $ed (@$v) {
           my $ev     = $ed->instances(0);
           my $sev2   = $ed->severity2();
           my $desc   = $ev->value('Description');
           my $comp   = $ev->value('Component');
           my $caption= $ev->value('Caption');
           my $etype  = $ev->value('EventType');
           my $g_no   = $ev->value("GridNo");
           my $g_code = $ev->value("GridCode");
           my @edata  = split(/\n/, $ev->value("Data"));

           my($etype0, $etype1) = split(/\./, $etype);

           $desc =~ s/[\n\r]/ /g;
           my $ta = $ev->value("Target");
           if (index($ALL, $ta) < 0) {
             $data .= " $etype0 " . ($ev->value("TargetName") || $ta) . "\n";
             $ALL .= ",$ta";
           }
           my $text = $Message::SEV_MAP{int($sev2+0.5)};
           if ($sev2 > $max_sev) {
              $max_sev = $sev2; $max_gc = $g_code;
           }
           $sub_events .= $ed->eventTime() . " [$text, $etype.$comp, $g_no]\n$desc\n";
           if (substr($desc,-1) eq ":") {
             $sub_events .= "  $edata[0]\n" if ($edata[0]);
             $sub_events .= "  $edata[1]\n" if ($edata[1]);
             $sub_events .= "  $edata[2]\n" if ($edata[2]);
             $sub_events .= "  $edata[3]\n" if ($edata[3]);
           }

           if ($cnt2 < 2) {
              my $grid_info  = Grid->getInfoString($etype, $caption, $g_code);
              if ($grid_info) {
                $grid_info =~ s/\n/\n  /g;
                $sub_events .= "  $grid_info\n\n";
                $cnt2++;
              }
           }
        }
     }
  }
  $data .= "\nSUB-EVENTS:\n$sub_events";

  return ($cnt, $data, $sev, $actionable, $details, $max_gc);
}

sub wrap {
  my($desc, $space) = @_;
  my ($cnt, $out, $len);
  my @words = split(/\s/, $desc);

  foreach my $w (@words) {
     if ($len+length($w) > 60) {
       $out .= "\n$space"; $len = 0;
     }
     $out .= "$w "; $len += length($w);
  }
  return $out;
}

sub RUN2 {
  my $renv = System->get_renv();
  my $OLDF = "previous_events";
  my $new = PDM->getMessages();
  my $old = Util->deserialize($OLDF);

  if (!$old) {
    Util->serialize($new, $OLDF);
    return;
  }
  my $rules = Modules->load("FSA");
  foreach my $rule0 (@$rules) {
     my $rule = "FSA::$rule0";
     if ($rule->can("RUN")) {
        $rule->RUN( $old, $new);
     }
  }
  my $new = PDM->getMessages();
  my (@CURRENT, @OLD) ;
  foreach my $e (@$old) {
      push(@CURRENT, $e);
  }
  foreach my $e (@$new) {
      if ($e->id("inAggregate") || $e->id("aggregate") ) {
         push(@CURRENT, $e);
      } else {
         push(@OLD, $e);
      }
  }
  Util->serialize(\@OLD, $OLDF);
  PDF->setMessages(\@CURRENT);

}

1;

