package ConfigFile;

# generic configuration reader
use strict;
use System;
use vars qw($err);

# returns a hash

sub read {
  my($class, $file, $key) = @_;
  $err = undef;
  my %H;
  if (!open(C, $file)) {
     $err = "Cannot read $file: $!";
     return undef;
  }
  my ($curr_key, $l, $section);
  while ($l = <C>) { 
    chop($l);
    next if (substr($l,0,1) eq "#");
    if (substr($l,0,1) eq "[") {
       $section = substr($l,1,-1);
    } else {
       my($name, $val) = split(/\s*=\s*/, $l);
       next if (index($l, "=") < 0);
       if ($key && $name eq $key) {
          $curr_key = $val;
       }
       if ($section) {
          my $t = $section;
          $t .= ".$curr_key" if ($curr_key);
          $H{$t}{$name} = $val;

       } elsif ($curr_key) {
          $H{$curr_key}{$name} = $val;

       } else {
          $H{$name} = $val;
       }
    }
  }
  close(C);
  return \%H;
}
     


# SAMPLE

# [t3]
#
# id=system.sysBootMode
# name=BootMode
# value=auto
#
# $H = Configfile->read("/opt/SUNWstade/System/exception.conf", "id");

# will return:
# $H->{'t3.system.sysBootMode'}{name} = BootMode
# $H->{'t3.system.sysBootMode'}{value} = BootMode

1;
