package Client::Diag;
use Client;
use strict;
use AutoForm;
use Scheduler;
use TO;

use vars qw ($TT);
$TT = "ST";

sub help {
  print Client->http_OK();
  print "#<pre>\n";
  print <<EOF;
 Http Syntax:

 http://host:7654/rashttp?GO=Client::Diag::list&key=switch:12012e12
 http://host:7654/rashttp?GO=Client::Diag::list&mgmtLevel=DS
 http://host:7654/rashttp?GO=Client::Diag::list&type=switch|switch2|a5k|se...
 GO=Client::Diag::run&test=se_configcheck&opt_v=on
 GO=Client::Diag::status&pid=121212
 GO=Client::Diag::abort&pid=121212

EOF
}

use Data::Dumper;
 

sub list {
  my($q) = @_;
  my($comp, $tests, $dev, $x, $key0);
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $format = $q->{format} || "tab";
  
  my($err,$af) = AutoForm->new("System/Tests", {noInfo => 1});
  my $key      = $q->{key};
  my $devType  = $q->{type};
  my $cnt=1;

  if ($key) {
     ($devType, $key0) = split(/\:/, $key);

     my $to = TO->readTopo("MERGE-MASTER") || TO->readTopo();
     my($type, $k) = split(/\:/, $key);
     $dev = $to->nodeByName($key);
     if (!$dev) {
         print Client->error($format, 109, "Device $key not found!");
         return;
     }
     $tests = Tasks->ST_getTestList($af, $type, $dev, "e");
     if ($#$tests < 0) {
         print Client->error($format, 110, "No test available for $key");
         return;
     }
     print Client->http_OK();
     print "#<pre>\n";
use Diag;
     foreach my $t (@$tests) {
       my($cn, $reg_select, $all, $all_reg, $node, $multiple) =
          Diag->register_list($type, $af, $t->sectionName() , $dev, "e", {mode => 'list'});
       &printit($af, $t, $cnt, $reg_select);
       $cnt++;
     }
     print "#Done\n";
     return;
  } 

  print Client->http_OK();
  print "#<pre>\n";
  $Data::Dumper::Indent = 1;

# BY DEFAULT, SHOW RACK-LEVEL TESTS
#
  my $mgmtLevel = $q->{mgmtLevel};
  $mgmtLevel = "DS" if (!$devType && !$mgmtLevel);

  foreach my $com ($af->commandList()) {
     my $c = $af->commandByName($com);
     my $info = $c->info();
     next if ($devType && $info->{devType} ne $devType);
     next if ($mgmtLevel eq "DS" && $info->{devType} ne $renv->{solution});
     &printit($af, $c, $cnt);
     $cnt++;
     print "\n";
  }
  print "#Done\n";
}

sub printit {
  my($af, $c, $cnt, $regs) = @_;
  my($x);
     my $info = $c->info();
     foreach my $v (sort keys %$info) {
         print "test.$cnt.info.$v\t$info->{$v}\n";
     }
     if ($regs) {
       $regs =~ s/\t/\|/g;
       print  "test.$cnt.opt.0.desc\tRegister\n".
              "test.$cnt.opt.0.name\tRegister\n".
              "test.$cnt.opt.0.opt\tregister\n".
              "test.$cnt.opt.0.type\tselect\n".
              "test.$cnt.opt.0.values\t$regs\n";
     }
     my $opts = $c->{opts};
     for ($x=0; $x <= $#$opts; $x++) {
         my $opt = $opts->[$x];
         foreach my $v (sort keys %$opt) {
             print "test.$cnt.opt.$x.$v\t$opt->{$v}\n";
         }
     }
     if ($info->{defaults}) {
        my $c = $af->commandByName("DEFAULTS");
        my $def_opts = $c->{opts};
        for ($x=0; $x <= $#$def_opts; $x++) {
            my $opt = $def_opts->[$x];
            foreach my $v (sort keys %$opt) {
               print "test.$cnt.opt." . ($#$opts +1+$x) . ".$v\t$opt->{$v}\n";
            }
        }
     }
}

# GO=Client::Diag::run&key=sve:sdasda&test=se_configcheck&opt_verbose=on&opt_register=port1:1:192..

sub run {
  my($q) = @_;
  my($comp, $tests, $dev, $x);
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $selected_test = $q->{test};
  my $host = $renv->{hostname};
  my $key = $q->{key};
  my $format = $q->{format} || "tab";
  $q->{register} = $q->{opt_register} if ($q->{opt_register});

  if (!$key) {
      print Client->error($format, 110, "Device key not found!");
      return;
  }
  my $to = TO->readTopo("MERGE-MASTER") || TO->readTopo();
  my($type, $k) = split(/\:/, $key);
  my $dev = $to->nodeByName($key);

  if (!$dev) {
      print Client->error($format, 111, "Device $key not found in topo!");
      return;
  }
  my($af_err,$af) = AutoForm->new("System/Tests", {noInfo => 1});
  my $af_test = $af->commandByName($selected_test);

  my($valid_err, $run_err, $text, $pid, $test_command, $opts ) = 
         Diag->run($af, $host, $q, $af_test, $selected_test, $to, $dev, "$key:e", 1);  # quiet
  if ($valid_err) {
      print Client->error($format, 111,"Validation Error: $test_command: $valid_err");
      return;
  }
  if ($text) {
      print Client->http_OK();
      print "Command: $text<br>";
      return;
  }

  if ($run_err) {
      print Client->error($format, 111,"$test_command: $run_err");
      return;
  } else {
      print Client->http_OK();
      if ($q->{DIRECT}) {
         return $pid;
      } else {
         print "OK $pid\n";
      }
   }
}

# returns status and report itself

sub status {
  my($q) = @_;

  print Client->http_OK();
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $selected_test = $q->{test};
  my $host = $renv->{hostname};
  my $pid  = $q->{pid};

  my ($info, $pro, $out, $err) = Scheduler->read($TT, $host, $pid) ;

  print "#<pre>\n";
  foreach my $v (sort keys %$info) {
     if ($v eq "info" ){  
        my $sub = $info->{$v};
        foreach my $v1 (sort keys %$sub) {
           print "info.details.$v1\t$sub->{$v1}\n";
        }
     } else {
        print "info.$v\t$info->{$v}\n";
     }
  }
  my($x, $y);
  for ($x=0; $x <= $#$err; $x++) {
      print "error.$x.value\t$err->[$x]";
  }
  for ($x=0; $x <= $#$out; $x++) {
      my $rc = $out->[$x]{rc}; chomp($rc);
      print "process.$x.rc\t$rc\n";
      print "process.$x.date\t$out->[$x]{date}\n";
      print "#OUTPUT $x\n";
      print "$out->[$x]{output}\n";
  }
  print "#Done\n";
}

sub abort {
  my($q) = @_;

  print Client->http_OK();
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $selected_test = $q->{test};
  my $host = $renv->{hostname};
  my $pid  = $q->{pid};

  my ($info, $pro, $out, $err) = Scheduler->read($TT, $host, $pid) ;

  print "#<pre>\n";
  
  my $done = Scheduler->kill($TT,$pid, $host , {child => 1, signal => 9});
  if (!$done) {
    print "ERROR $Scheduler::ERROR\n";
  } else {
    print "OK killed\n";
  }
}

      
  
1;
