package Service::Array;

use Net::FTP;
use Net::Telnet;
use Net::Ping;
use System;
use strict;

use vars qw($host_file $syslog_conf $target_syslog $root_user $array_name $array_password);

sub add {
  my($class, $ip) = @_;

  $array_name     = $ip;
  $host_file      = "/etc/hosts";
  $syslog_conf    = "/opt/se6320_conf/etc/syslog.conf";
  $target_syslog  = "/etc/syslog.conf";
  $root_user      = "root";
  $array_password = System->getPassword("array");

  if (!&verify_connect() ) {
     return "Error: Can not find the array";
  }
  if (!&try_password($array_password) ) { # bail on no-error
    return undef;
  }
  if (!&change_password() ) {
    return "Error: Cannot change password. If this a new array, a blank password is needed";
  }
  if (!&syslog_transfer() ) {
    return "Error: Failed to open ftp connection with the array";
  }
  my $array_name = &findName($ip);
  if (!&configure_array($array_name) ) {
    return "Error: Failed to modify the array configurations";
  }
  return undef;
}

sub findName {
  my($ip) = @_;
  my($l, $found);

  open(O, "/etc/hosts");
  while ($l = <O>) {
     my($ip0, $name, $rest) = split(/\s+/, $l);
     if ($ip0 eq $ip) {
       $found = $name; last;
     }
  }
  close(O);
  return $found;
}


sub verify_connect
{
  my $ping;
  my $status;
  
  $ping = Net::Ping->new('icmp');
  $status = $ping->ping($array_name);
  $ping->close;

  return($status);
}

# Open ftp section to transfer /opt/array_conf/etc/syslog.conf
# Return 1 if OK and 0 is can not transfer

sub syslog_transfer
{
  my $ftp;
  
  unless ($ftp = Net::FTP->new($array_name)) {
    return 0;
  }
  
  unless ($ftp->login($root_user, $array_password)) {
    return 0;
  }
  
  unless ($ftp->put($syslog_conf, $target_syslog)) {
    return 0;
  }
  $ftp->quit;

  return 1;
}


sub try_password {
  my($pass) = @_;

  my $tnet = new Net::Telnet (
             errmode => "return",
             Timeout   => 10,
             Prompt    => '/<\d+\>/',
             );

  if (!defined($tnet->open(Host => $array_name))) {
      return 0;
  }
  $tnet->login($root_user, $pass);

  return $tnet->errmsg();
}



#
# Open telnet section to change password
# Return 1 if OK or 0 is not
#

sub change_password
{
  my $tnet = new Net::Telnet (
             errmode => "return",
             Timeout   => 10,
             Prompt    => '/<\d+\>/',
             );

  if (!defined($tnet->open(Host => $array_name))) {
      return 0;
  }
  $tnet->login($root_user, "");
  if ($tnet->errmsg()) {
     return 0;
  }
  my @l  = $tnet->cmd(String => "passwd", Prompt => '/\:/');
  my @l2 = $tnet->cmd(String => "",     Prompt => '/\:/');
  my @l3 = $tnet->cmd(String => $array_password,     Prompt => '/\:/');
  my @l4 = $tnet->cmd(String => $array_password,     Prompt => '/<\d+\>/');
  $tnet->cmd("exit");
  return 0 if ("@l4" =~ /sorry/);
  return 1;
}
  
#
# Configure the array
# Return 0 if OK and 1 if not
#
sub configure_array {
  my($array_name) = @_;

  my $tnet = new Net::Telnet (
                        errmode => "return",
                        Timeout   => 10,
                        Prompt    => '/<\d+\>/',
                        );
  #Login
  if (!defined($tnet->open(Host => $array_name))) {
    return 0;
  }

  $tnet->login($root_user,$array_password);
  if ($tnet->errmsg()) {
    return 0;
  }

  my @l  = $tnet->cmd(String => "ntp server 192.168.0.2", Prompt => '/<\d+\>/');
  my @l2 = $tnet->cmd(String => "ntp poll unicast", Prompt => '/<\d+\>/');
  my @l3 = $tnet->cmd(String => "ntp interval 60", Prompt => '/<\d+\>/');
  my @l4 = $tnet->cmd(String => "sys mp_support mpxio", Prompt => '/<\d+\>/');
  if ($array_name) {
    my @l5 = $tnet->cmd(String => "set hostname $array_name", Prompt => '/<\d+\>/');
  }

  $tnet->cmd("exit");
  return 1;
}

1;
