package Linktest::T3;
use strict;
use Linktest::Node;
use base 'Linktest::Node';


sub portTest {0}

sub IOtest {1};

sub class {'storage.t3'}

sub type2 {"ST"}

sub prompt_info {
  my($node) = @_;
  return ($node->{logical}, $node->{port});
}

sub node_isolation {
  my($node_a, $node_b, $failed_node, $mode ) = @_;

  if ($node_a->isT3b() ) {
      $node_a->t3b_node_isolation($node_b, $failed_node, $mode );
  } else {
      $node_a->t3_node_isolation($node_b, $failed_node, $mode );
  }
}

sub isT3b {
  my($node) = @_;

  if ($node->{ctrl_model} =~ /501/ ) {
     return 1;
  }
  return 0;
}



sub t3_node_isolation {
  my($node_a, $node_b, $failed_node, $mode ) = @_;

  Linktest->debug_header( $node_a, $node_b, "t3_node_isolation" );
  my $linkEnv = System->get_linkEnv();

  my $diagnostic_node;
  my $answer;
  my $status;
  my $out;

  if ( $mode eq "PORT" ) {
    $diagnostic_node = $node_a;
  } else {
    $diagnostic_node = $node_b;
  }

  # try the MIA first

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('replace_device_mia' );
  $node_a->prompt('restore_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    # utilize the port diagnostic
    $out = $node_b->start_diagnostic( "E");
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_mia' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new MIA. The MIA is the suspect.
    $node_a->prompt('suspect_device_mia' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  $node_a->prompt('remove_device_cable' );
  $node_a->prompt('restore_device_mia' );
  $node_a->prompt('replace_device_cable' );
  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    # utilize the port diagnostic
    $out = $node_b->start_diagnostic( "E");
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new cable. The cable is the suspect.
    $node_a->prompt('suspect_device_cable' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }
    # it wasn't the MIA or the CABLE.
  $node_a->prompt('multiple_suspects' );
  if ($linkEnv->{option_pattern_type} ne "all") {
    $node_a->prompt('ra_all_patterns' );
  }
  $node_a->prompt('ra_t3_ofdg' );
  $node_a->prompt('ra_t3test' );
  if ( $node_b->{type} eq 'hba' ) {
    $node_b->prompt('ra_hbatest' );
  } elsif ( $node_b->{type} eq 'switch' ) {
    $node_b->prompt('ra_switchtest' );
  } elsif ( $node_b->{type} eq 'switch2' ) {
    $node_b->prompt('ra_switch2test' );
  } elsif ( $node_b->{type} eq 'brocade' ) {
    $node_b->prompt('ra_brocadetest' );
  } elsif ( $node_b->{type} eq 'mcdata' ) {
    $node_b->prompt('ra_mcdatatest' );
  }

  return $Linktest::PROBLEM_UNDETECTED;

}

sub t3b_node_isolation {
  my ( $node_a, $node_b, $failed_node, $mode ) = @_;

  Linktest->debug_header( $node_a, $node_b, "t3b_node_isolation" );

  my $diagnostic_node;
  my $answer;
  my $status;
  my $out;
  my $t3b_direct = "y";
  my $linkEnv = System->get_linkEnv();

  if ( $mode eq "PORT" ) {
    $diagnostic_node = $node_b;
  } else {
    $diagnostic_node = $node_a;
  }

  # ask the user if it's a direct cable or FC Coupler w/Adaptor
  $answer = Linktest->ask_t3b_direct();
  if ( $answer eq "n" ) {

    # try coupler first

    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('replace_device_coupler' );
    $node_a->prompt('restore_device_cable' );
    $answer = Linktest->ask_continue();
    if ( $answer ne "n" ) {
       $out = $diagnostic_node->start_diagnostic("E");
    } else {
      $node_a->prompt('remove_device_cable' );
      $node_a->prompt('restore_device_coupler' );
      $node_a->prompt('restore_device_cable' );
      Linktest->premature_exit();
    }
    if ( $out->{rc} == 0 ) {
      # the test passed with a new coupler. The coupler is the suspect.
      $node_a->prompt('suspect_device_coupler' );
      Linktest->retest_msg();
      return $Linktest::FOUND_SUSPECT_FRU;
    }
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_coupler' );
    $node_a->prompt('replace_device_cable' );

    # try adapter

    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('replace_device_adapter' );
    $node_a->prompt('restore_device_cable' );
    $answer = Linktest->ask_continue();
    if ( $answer ne "n" ) {
      $out = $diagnostic_node->start_diagnostic("E");
    } else {
      $node_a->prompt('remove_device_cable' );
      $node_a->prompt('restore_device_adapter' );
      $node_a->prompt('restore_device_cable' );
      Linktest->premature_exit();
    }
    if ( $out->{rc} == 0 ) {
      # the test passed with a new adapter. The adapter is the suspect.
      $node_a->prompt('suspect_device_adapter' );
      Linktest->retest_msg();
      return $Linktest::FOUND_SUSPECT_FRU;
    }
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_adapter' );
    $node_a->prompt('replace_device_cable' );

  } else {

    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('replace_device_cable' );
  }

  $answer = Linktest->ask_continue();
  if ( $answer ne "n" ) {
    $out = $diagnostic_node->start_diagnostic("E");
  } else {
    $node_a->prompt('remove_device_cable' );
    $node_a->prompt('restore_device_cable' );
    Linktest->premature_exit();
  }
  if ( $out->{rc} == 0 ) {
    # the test passed with a new cable. The cable is the suspect.
    $node_a->prompt('suspect_device_cable' );
    Linktest->retest_msg();
    return $Linktest::FOUND_SUSPECT_FRU;
  }

  # it wasn't the MIA or the CABLE.
  
  $node_a->prompt('multiple_suspects' );
  $node_a->prompt('suspect_controller');

  if ($linkEnv->{option_pattern_type} ne "all") {
    $node_a->prompt('ra_all_patterns' );
  }
  
  $node_a->prompt('ra_t3_ofdg' );
  $node_a->prompt('ra_t3test' );
  if ( $node_a->{type} eq 'hba' ) {
    $node_a->prompt('ra_hbatest' );
  } elsif ( $node_a->{type} eq 'switch' ) {
    $node_a->prompt('ra_switchtest' );
  } elsif ( $node_a->{type} eq 'switch2' ) {
    $node_a->prompt('ra_switch2test' );
  } elsif ( $node_a->{type} eq 'brocade' ) {
    $node_a->prompt('ra_brocadetest' );
  } elsif ( $node_a->{type} eq 'mcdata' ) {
    $node_a->prompt('ra_mcdatatest' );
  }

  return $Linktest::PROBLEM_UNDETECTED;
}

sub start_diagnostic {
  my($node, $mode) = @_;
  my($test, $options, $sparcv9, $estimated_time);

  my($verbose, $wb_patterns, $option_user_pattern) = $node->diag_defaults();

  $test = "t3test";
  $estimated_time = 5;

  $options = "$verbose -q  -f -o " . '"' . "dev=$node->{logical}|partition=2|rawsub=e|method=SyncIO+AsyncIO|rawcover=1|rawiosize=0x32768|selectpattern=$wb_patterns" . $option_user_pattern . '"';

  return $node->run_diagnostic("t3test", $sparcv9, $options, 5);
}



1;
