package Health::SAN;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SAN.pm,v 1.15 2003/07/11 22:27:05 ccadieux Exp $

use base 'Health';
use NWS::SAN;
use Ilist;
use Thresholds;
use Message;
use Report;
use Events;
use FCRules;
use strict;
use Debug;
use TO;

sub revision {'$Revision: 1.15 $'}

sub new {
  my($hm, $pdm) = @_;

  my($self) = {pdm => $pdm};
  bless ($self, 'Health::SAN');

# Specify each callback
#                            HM  Callback,  Filters
  $pdm->reportRequest($self, 'all_logic' , {category => Report::CAT_SAN});
  return $self;
}

#####################################################
# consider skipping the monitoring of a link if end-points are
# in categories that are turned-off
#

sub all_logic {
  my($hm, $report) = @_;
  my($pdm) = $hm->{pdm};
  my($ev, $ed, $pertains, $x ,$y, $contain, $sd);
  my($orep, $key);
  my($rep)     = $report->content;
  
  $DB::single = 1;
  my($oreport) = PDM->getOldReport($report->fileKey);

  return if (!$oreport);
  $orep = $oreport->content;

  my($new, $old, $found, @o1,  @n1, $o_crc , $n_crc , $r, $ix);
  my(@a, $x0);

  $found = 0;

  my($reads)       = $rep->{reads};
  my($writes)      = $rep->{writes};

  my @rules = FCRules->load_rules();
  Thresholds->init();
  my $To = TO->readExistingTopo("MERGE-MASTER") || TO->readExistingTopo();

  foreach my $r (keys %$rep) {  
    next if (substr($r, 0, 3) ne "FC_");
    eval {
      $new = $rep->{$r}{data};
      $old = $orep->{$r}{data};
    };
    if ($@) {
       Debug->err(ERROR => "invalid report in SAN.pm: $@");
       next;
    }
    next if (!$old);  # this category is not in the old one, skip
    my $FC = {info =>  { hba => $rep->{$r}{hba}, enc => $rep->{$r}{enc}} };
    my $cnt2 = 0;
    foreach my $k (sort keys %$new) {
       my($hba, $wwn, $comp, $type) = split(/\|/, $k);
       next if (!exists $old->{$k});

       @n1 = split(/\t/, $new->{$k});
       @o1 = split(/\t/, $old->{$k});
       $o_crc = $o1[3]; 
       $n_crc = $n1[3];
  
       if ($n_crc > $o_crc) {
            next if ($type eq "switch" && ($#o1 > 5) && ($o1[6] == $n1[6]) && ($o1[7] == $n1[7]));
            $found++;
            $FC->{error}[$cnt2] = {key => $k, type => "CRC", count => $n_crc - $o_crc}; $cnt2++;
            Debug->print2("CRC went up by " . ($n_crc - $o_crc) . " in $k");
       }
       my $o_itw = $o1[5];
       my $n_itw = $n1[5];
       if ($n_itw > $o_itw) {
            $found++;
            Debug->print2("ITW went up by " . ($n_itw - $o_itw) . " in $k");
            $FC->{error}[$cnt2] = {key => $k, type => "ITW", count => $n_itw - $o_itw}; $cnt2++;
       }
       my $o_sig = $o1[1];
       my $n_sig = $n1[1];
       if ($n_sig > $o_sig) {
           $found++;
           Debug->print2("SIGNAL-LOSS went up by " . ($n_sig - $o_sig) . " in $k");
            $FC->{error}[$cnt2] = {key => $k, type => "SIG", count =>  $n_sig - $o_sig }; $cnt2++;
       }
    }
    if ($cnt2) {
      if ( Util->findMaster() ) {# slave
        $hm->fcEvent($FC) ;
      } elsif ($To) {                   # master
        $hm->processFC($FC, \@rules, $To);
      }
    }
  }
  if (!$found) { 
     Debug->print2("Nothing found (no changes in CRC/ITW/SIG counters)");
  }
}

sub processFC {
  my($hm, $FC, $rules, $To) = @_;

  my $report = Report->new({ deviceName  => "san",  
                             name        => "san", 
                             category    => "san"}  , {});

  my $errors = $FC->{error};
  my($x);
  for ($x=0; $x <= $#$errors; $x++) {
     my $v = $errors->[$x];
     foreach my $rule (@$rules) {
        my($error, $event) = $rule->run($To, $hm, $report, $v->{count},
                              $v->{key}, $FC->{info}, [], [], $v->{type});
        Debug->print2($event) if ($event);
     }
  }
}


1;

