package GUI::Notifs;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Html;
#  $Id: Notifs.pm,v 1.73 2003/05/19 17:17:24 ccadieux Exp $

use Labels;
use Agent;
use  Html::Tabs;
use strict;

sub get_PRIO {
  my $G = Labels->read();
  return (0 => $G->{sev0}, 1 => $G->{sev1}, 2 => $G->{sev2}, 3 => $G->{sev3},
          9 => "$G->{sev1}+$G->{sev2}+$G->{sev3}", 91 => $G->{sevA}, '*' => $G->{all});
}


sub list {
  my($q) = @_;
  my($ho, $o);

  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
  my $Lang = Util->languageList(1);

  print Html->body();
  if ( Util->findMaster()) {
    print "\n<body bgcolor=white><h1><center>$G->{e_101}";
    return;
  }

  if ($q->{ACTION_add}) {
     &add($q);
     return;
  } elsif ($q->{ACTION_max}) {
     unlink System->get_home() . "/DATA/Max_events";
     unlink System->get_home() . "/DATA/Max_email";
     print Html->info($L->{'email.reset_done'});
  } 
  print Html->header2("admin.gen_maint.email");
  &emaillist($q);
}



sub emaillist {
  my($q) = @_;
  my ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
  my %PRIO = &get_PRIO();
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
  my($x, $h, $lnk, $type, $device, $prio, $ho);
  for ($x=0; $x <= $#$notifs; $x++) {
    $h    = $notifs->[$x];
    my $val = $h->{email} || $h->{script};
    $lnk  = "<a href=$Http::WEBPROC?GO=GUI::Notifs::upd&no=$x><b>$val</b></a>";
    $type = $h->{type};
    $device = ($h->{device}   eq "*") ? $G->{all}: $h->{device};
    $prio   = ($h->{priority} eq "*") ? $G->{all}: $PRIO{$h->{priority}};
    my @a      = split(/\|/,  $h->{event});
    my $events = "";
    foreach $x (@a) {
      if ($x eq "*") {
        $events .= "$L->{'email.l1'}<br>";
      } else {
        $events .= "$x<br>";
      }
    }
    my $grp = $h->{groups} || $G->{all};
    $ho .= "<tr>
                <td><center>$type</td>
                <td>$lnk</td>
                <td><center>$device</td>
                <td>$events</td>
                <td><center>$prio</td>
                <td><center>$grp&nbsp;</td>
           ";
                #<td><center>" . ($Lang->{$h->{language}} || $h->{language}) . "</td>
  }
  if ($#$notifs < 0) {
     $ho .= "<tr><td colspan=5><b>$L->{'email.err_1'}</td>";
  }
  my $o =<<EOF;
<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::list>
$q->{ERR}
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100% bgcolor=#F0F0F0>
<tr><td colspan=6 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{'email.l2'}</td>
<tr>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'email.l3'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'email.l4'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'email.l5'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'email.l6'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'email.l7'}</td>
    <td bgcolor=$Style::LIGHT><center><b>$L->{'email.groups'}</td>
$ho
</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
    print "<input type=submit name=ACTION_add value=\"$L->{'email.submit1'}\">";
    print "<input type=submit name=ACTION_max value=\"$L->{'email.reset_max'}\">";
  }
  print "</form>";
}

sub selectAgents {
  my($select);
  my($cat) = Agent->findSelectableAgents();
  my ($c0);
  foreach $c0 (@$cat) {
     my ($c, $c2) = split(/\=/, $c0);
     my $n1 = Util->abb(lc($c) . ".medium") || $c;
     $select .= lc($c)  ."=$n1|";
  }
  chop($select) if ($select);
  return $select;
}

sub upd {
  my($q) = @_;
  my($ho, $o);
  my($name,$renv, $dev, $hosts, $notifs);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs');
  my $deny = Roles->verifyRole($q, "admin");
  my($err, $renv, $dev, $host, $notifs, $x, $h);

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;
  } elsif ($q->{ACTION_update}) {
    print Html->body();
    my @SCR = split(/\s+/, $q->{script});
    if ($q->{script}) {
      if (!-x $SCR[0]) {
         print Html->warning($L->expand('email.err_2', $q->{script}));
      }
    } elsif (!$q->{email}) {
        $err = Html->error($L->{'email.err_3'});
        goto out;
    }
    ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;

    my $x = $q->{no};
    $notifs->[$x]{email}  = $q->{email};
    $notifs->[$x]{device} = $q->{device};
    $q->{group}  = "" if (index($q->{group} , "_ALL_") >= 0);
    $q->{group} =~ s/\t/\|/g;
    $notifs->[$x]{groups}   = $q->{group};
    $notifs->[$x]{type}   = $q->{type};
    $notifs->[$x]{skip_agg} = $q->{skip_agg} ? 1:0;
    #$notifs->[$x]{include_graph} = $q->{graph} ? 1:0;
  
    $notifs->[$x]{language} = ""; # $q->{language};
    $notifs->[$x]{email_type} = $q->{email_type};
    $notifs->[$x]{script}   = $q->{script};
    $notifs->[$x]{no_grid}  = $q->{no_grid} ? "Y" : "N";
    $notifs->[$x]{priority} = $q->{priority};
    $notifs->[$x]{device} = "*" if (!$q->{device});
    $notifs->[$x]{apply_filters}  = $q->{filters} ? "Y" : "N";

    if (!$q->{event} || (index($q->{event}, "*") >= 0) ) {
       $notifs->[$x]{event}     = "*" ;
    } else {
       my $s = $q->{event}; $s =~ s/\t/|/g;
       $notifs->[$x]{event}     = $s;
    }
    PDM::ConfigFile->write($renv, $dev, $host, $notifs);
    $err = Html->info($L->{'email.info_1'});

  } elsif ($q->{ACTION_delete}) {
    print Html->body();
    ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
    $x = $q->{no};
    $notifs->[$x]{_name} = "";
    $name = $notifs->[$x]{email};
    PDM::ConfigFile->write( $renv, $dev, $host, $notifs);
    $q->{ERR} = Html->warning($L->expand('email.info_2', $name));
    &list($q);
    return;

  }
out:
  print Html->body();
  my $h1 = Html->header2("admin.gen_maint.email", undef, "#2");

  ($renv, $dev, $hosts, $notifs) = PDM::ConfigFile->read;
  $h = $notifs->[$q->{no}];
  my %PRIO = &get_PRIO();

  my $device = ($h->{device} eq "*")? $G->{all}: $h->{device};
  my $prio   = ($h->{priority} eq "*")? $G->{all}: "$h->{priority}: $PRIO{$h->{priority}}";

  my $sel = &priorities();
  my $priority = "<select name=priority ><option value=*>$L->{'email.l8'}</option>" .
              &main::select($sel, $h->{priority});

  my @a      = split(/\|/,  $h->{event});
  my $events = "";
  my %w = ();
  foreach $x (@a) {
    $w{'event_'.$x} = 1;
  }

  my $select = &selectAgents();

  $device   = Html->makeSelect("device", "*=$L->{'email.l9'}|$select", $h->{device},
                  {multiple => 4} );
  $events = "<select name=event size=8 multiple>".
              &main::select("*=$L->{'email.l1'}|" . &find_events , $h->{event}, 1);
  my $lang = Html->makeSelect("language", Util->languageList(), $h->{language});

  my $email_type = Html->makeSelect("email_type",
           "S=$L->{'email.type_s'}|C=$L->{'email.type_c'}" , $h->{email_type},
              {multiple => 2} );
  my $agg = "checked" if ($h->{skip_agg});
  #my $graph = "checked" if ($h->{include_graph});
  my ($t1, $val);
  if ($h->{type} eq "Script") {
     $t1 = $L->{'email.script'};
     $val =<<EOF;
<tr><td bgcolor=$Style::LIGHT align=right width=20%>$L->{'email.l12'}:</td>
    <td colspan=3><input type=text name=script value="$h->{script}" size=60>
   [ <a href=javascript:win2()>$G->{help}</a> ]</td>
EOF
  } else {
     $t1 = $h->{type} eq "Email" ? $L->{'email.l22'} : $L->{'email.l23'};
     $val =<<EOF;
<tr><td bgcolor=$Style::LIGHT align=right width=20%>$L->{'email.l11'}:</td>
    <td colspan=3><input type=text name=email value="$h->{email}" size=40>
      </td>
EOF

  }
  my $no_grid = "checked" if ($h->{no_grid} eq "Y");
  my $filters = "<input type=checkbox name=filters " . ($h->{apply_filters} eq "Y"? "checked":"") . ">";
  my $groups = &groups($h->{groups});

  $o =<<EOF;
<script>
    function win2(t) {
      var b = 'email_script.html';
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
      O.focus();
    }
    </script>
<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::upd>
 <input type=hidden name=no value=$q->{no}>
<center>
$h1
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100% >
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{'email.l10'}</td>

<tr><td bgcolor=$Style::LIGHT align=right width=20%>$L->{'email.l3'}:</td>
    <td colspan=3><b><input type=hidden name=type value=$h->{type}>&nbsp;$t1</td>
  
$val

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.type'}:</td>
    <td>$email_type</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.l5'}:</td>
    <td colspan=3>&nbsp;$device</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.l7'}:</td>
    <td colspan=3>&nbsp;$priority</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.l6'}:</td>
    <td colspan=3>&nbsp;$events</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.groups'}:</td>
    <td  colspan=3>$groups </td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.filters'}:</td>
    <td  colspan=3>$filters</td>


<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.skip_agg_parts'}:</td>
    <td colspan=3><input type=checkbox name=skip_agg $agg></td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{'email.no_grid'}:</td>
    <td colspan=3><input type=checkbox name=no_grid $no_grid></td>

</table>
</table>
<b>
EOF

  print $o;
  if (!$deny) {
    print "<input type=submit name=ACTION_update value=\"$G->{submit_update}\">
           <input type=submit name=ACTION_delete value=\"$G->{submit_delete}\">";
  }
  print "&nbsp;<input type=submit name=ACTION_back value=\"$G->{submit_back}\"> </form>";
}

sub priorities {
  my $sel;
  my  %PRIO = &get_PRIO();
  
  foreach my $k (sort keys %PRIO) {
    next if ($k eq "*");
    my $xx = "$k=$PRIO{$k}";
    $sel .= $xx;
    $sel .= " ($k)" if ($k >= 0 && $k < 9);
    $sel .= "|";
  }
  chop($sel);
  return $sel;
}
sub groups { 
  my($val) = @_;

  my $G = Labels->read();
  my $Group = Util->deserialize("admin_groups");
  my $groups = "<select name=group multiple size=2><option value=_ALL_>$G->{all}</option>";
  foreach my $e (keys %$Group, 'SYSTEM') {
    my $sel = "selected" if (index("|$val|", "|$e|") >= 0);
    my $v;
    if ($e eq "SYSTEM") {
        $v = "System/Agent Events";
    } else {
        $v = $Group->{$e};
    }
    $groups .= "<option $sel value=\"$e\">$e - $v</option>";
  }
  $groups .= "</select>";
  return $groups;
}

sub add {
  my($q) = @_;
  my($ho, $o, $err);

  my $G = Labels->read();
  my $L = Labels->read('GUI::Notifs')->section('email');
  my($renv, $dev, $host, $notifs, $info);

  if ($q->{ACTION_back}) {
    $q->{option} = "";
    &list($q);
    return;

  } elsif ($q->{ACTION_add1}) {
    print Html->body();
    while (1) {
     my @SCR = split(/\s+/, $q->{script});
     if ($q->{script} && $q->{email}) {
        $err = Html->error($L->{both});
        last;
     }
     if ($q->{script} && !-x $SCR[0]) {
        print Html->warning($L->expand('err_2', $q->{script}));
     }
     if ($q->{type} ne "Script" && $q->{email} !~ /^.+\@.+/) {
        $err = Html->error($L->{err_4});
        last;
     } else {
        ($renv, $dev, $host, $notifs) = PDM::ConfigFile->read;
        my $x = $#$notifs + 1;
        $notifs->[$x]{_name}    = "notification" . ($x+1);
        $notifs->[$x]{email}    = $q->{email};
        $notifs->[$x]{device}   = $q->{device};
        $q->{group}  = "" if (index($q->{group} , "_ALL_") >= 0);
        $q->{group} =~ s/\t/\|/g;
        $notifs->[$x]{groups}   = $q->{group};
        $notifs->[$x]{language} = "";
        #$notifs->[$x]{include_graph} = $q->{graph} ? 1:0;
        $notifs->[$x]{email_type} = $q->{email_type};
        $notifs->[$x]{script}   = $q->{script};
        $notifs->[$x]{apply_filters}  = $q->{filters} ? "Y" : "N";
        $notifs->[$x]{skip_agg} = $q->{skip_agg} ? 1:0;
        $notifs->[$x]{no_grid}  = $q->{no_grid} ? "Y" : "N";
        $notifs->[$x]{type}     = $q->{type};
        $notifs->[$x]{priority} = $q->{priority};
        $notifs->[$x]{device} = "*" if (!$q->{device});

        if (!$q->{event} || (index($q->{event}, "*") >= 0) ) {
          $notifs->[$x]{event}     = "*" ;
        } else {
          my $s = $q->{event}; $s =~ s/\t/|/g;
          $notifs->[$x]{event}     = $s;
        }
        $notifs->[$x]{event}    = "*"  if ($q->{priority} == 91);


        if (!PDM::ConfigFile->write($renv, $dev, $host, $notifs)) {
           print "$G->{'e_100'} <br>";
        } else {
           $info = Html->info($L->{info_3});
        }
        $q->{option} = "";
        &list($q);
        return;
     }
     last;
    }
  }
out:
  print Html->body();
  print <<EOF;
<script>
    function win2(t) {
      var b = 'email_script.html';
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=500');
      O.focus();
    }
    </script>
EOF

  my $h = Html->header2("admin.gen_maint.email", undef, "#3");

  my $select = &selectAgents();

  my $device = "<select name=device size=4 multiple><option value=*>$L->{all_cat}</option>" .
              &main::select($select, $q->{device});
  
  my $sel = &priorities() ;
  my $priority = "<select name=priority ><option value=*>$L->{l8}</option>" .
              &main::select($sel, $q->{priority});
  my $ev = "";
  $ev = &display_event_list($q, '-h');
  my $evH = &display_event_list($q, 'h');

  my $events = "<select name=event size=5 multiple><option value=*>$L->{l1}</option>" .
              &main::select(&find_events);
  my $lang = Html->makeSelect("language", Util->languageList());
  my $email_type = Html->makeSelect("email_type", "S=$L->{type_s}|C=$L->{type_c}",
            "C", {multiple => 2});
  my $groups = &groups();
  my $filters = "<input type=checkbox name=filters>";

  $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form  method=get>
 <input type=hidden name=GO value=GUI::Notifs::add>
<center>
$h
$err
<table border=1 cellspacing=0 width=90% bgcolor=white><tr><td>
<table border=0 cellspacing=2 width=100%>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{l20} </td>

<tr><td bgcolor=$Style::LIGHT align=right width=20%>$L->{l21}:</td>
    <td colspan=3>
        <input type=radio name=type value=Email checked>:$L->{l22}&nbsp;&nbsp;
        <input type=radio name=type value=Pager>:$L->{l23}&nbsp;&nbsp;
        <input type=radio name=type value=Script>:$L->{script}&nbsp;&nbsp;
    </td>

<tr><td bgcolor=$Style::LIGHT align=right width=20%>$L->{l24}:</td>
       <td colspan=3><input type=text name=email size=40 maxlength=60 value="$q->{email}"></td>

<tr><td bgcolor=$Style::LIGHT align=right width=20%>$L->{l12}:</td>
       <td colspan=3><input type=text name=script  size=60>
       [ <a href=javascript:win2()>$G->{help}</a> ]</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{type}:</td>
    <td>$email_type</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{l7}:</td>
    <td colspan=3>$priority</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{l5}:</td>
    <td colspan=3>$device</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{l6}:</td>
    <td colspan=3>$events</td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{groups}:</td>
    <td  colspan=3>$groups </td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{filters}:</td>
    <td  colspan=3>$filters</td>


<tr><td bgcolor=$Style::LIGHT width=20% align=right>$L->{skip_agg_parts}:</td>
    <td colspan=3><input type=checkbox name=skip_agg checked></td>

<tr><td bgcolor=$Style::LIGHT align=right>$L->{no_grid}:</td>
    <td colspan=3><input type=checkbox name=no_grid></td>


</table>
</table>
<b>
<input type=submit name=ACTION_add1 value="$G->{submit_add}">
<input type=submit name=ACTION_back value="$G->{submit_back}">
</form>
EOF

  print $o;

}

sub display_event_list {
  my($q, $filter) = @_;
  my($x, $ck, $out);

  foreach $x (sort keys %{Event->get_types} ) {
     if (substr($filter,0,1) eq "-") {
        next if (Event->get_category($x) eq substr($filter,1));
        $ck = ($q->{"event_$x"})? "checked":"";
        $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";

     } else {
       if (Event->get_category($x) eq $filter) {
         $ck = ($q->{"event_$x"})? "checked":"";
         $out .= "<input type=checkbox name=event_$x $ck>: " .
             Event->get_description($x) . "<br>";
       }
     }
  }
  return $out;
}


sub find_events {
  my $ruser = System->get_ruser();
  my $renv = System->get_renv();
  my($l);
  my $lang = $ruser->{language} || $renv->{language};

  my $F = System->get_home() ."/Lang/System/Labels/$lang/Events.lb";
  if (-f $F) {
    open(O, $F);
  } else {
    open(O, System->get_home() . "/System/Labels/Events.lb");
  }
  my($out); 
  while ($l = <O>) {
    chop($l);
    $l =~ s/\s*=\s*/=/;
    $out .= "$l|";
  }
  close(O);
  chop($out);
  return $out;
}




1;
