package GUI::Master;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>


use System;


sub reset {
  my($q) = @_;

  my $G = Labels->read();
  my $L = Labels->read('GUI::Master');

  while (1) {
   if ($q->{ACTION_recover}) {
     if ($q->{recover}) {
       if (!Util->ping($q->{alt})) {
           print Html->error($G->expand('e_111',$q->{alt}));
           last;
       }
       $file = Util::Http->readFile($q->{alt}, "rasagent.conf");
       if ($file) {
           open(O, ">" . System->get_home() . "/DATA/rasagent.conf");
           print O $file;
           close(O);
           my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
           my $localhost = System->hostname();

           foreach my $h (@$hosts) {
              if ($h->{hostname} eq $localhost) {
                 foreach my $x (keys %$h) {
                     next if ($x eq "_name");
                     my $save = $h->{$x};
                     $h->{$x} = $renv->{$x};
                     $renv->{$x} = $save;
                 }
                 last;
              }
           }
           $renv->{hostname} = $localhost;

           foreach my $d (@$devs) {
              if ($d->{host} eq $renv->{hostname}) {
                 $d->{host} = "";
              }
           }
           PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs);

           print "Recovered the Config file from $q->{alt} ";
           print " (size=" . length($file) . ")<br>";

       } else {
           print Html->error($G->{cannot_read});
       }
     }
     if ($q->{reset}) {
         my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
         my $ip = Util->name2ip($renv->{hostname}) || $renv->{hostname};
         foreach my $h (@$hosts) {
            if ($h->{hostname} ne $renv->{hostname}) {
               my $target = $h->{ipno} || $h->{hostname};
               print "-> " . $L->expand('setting', $target, $ip) . "<br>\n";
               if (Util->ping($target, 7)) {
                 Util::Http->deleteFile($target, "ALTACTIVE");
                 Util::Http->saveFile($target, "MASTER", $ip);
               }
            }
         }
     }
   }
   last;
  }

  print Html->body();
  print Html->header2('admin.system.recover_config');

  print "\n
   <table border=0 cellpadding=4 width=90% bgcolor=white>
    <tr><td><form>
      <input type=hidden name=GO value=GUI::Master::reset>
      </table>
   <table border=0><tr><td></table>
  ";

  print "
   <table border=1 cellspacing=0 cellpadding=2 width=90% bgcolor=white>
    <tr><td colspan=2 bgcolor=$Style::DARK><font color=white><b>
       $L->{label}
    <tr><td align=right bgcolor=$Style::LIGHT width=30%>$L->{ip}:</td>
        <td><input type=text size=30 name=alt></td>
    <tr><td align=right bgcolor=$Style::LIGHT width=30%>$L->{recover}:</td>
        <td><input type=checkbox name=recover checked></td>
    <tr><td align=right bgcolor=$Style::LIGHT width=30%>$L->{reset}:</td>
        <td><input type=checkbox checked name=reset></td>
    </table>
    <b><input type=submit name=ACTION_recover value=\"$L->{submit1}\">
  
   ";


}
1;
