package Agent::SE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SE2.pm,v 1.20 2003/05/01 15:45:06 ccadieux Exp $

use Catalog;
use strict;
use Report;
use Agent;
use State;
use Agent::SE;
use base 'Agent::SE';
use Agent::SWITCH;

sub isSelectable { "Sun 6320"  }  # used to control rack-as-device 
sub type         { Report::CAT_SE2 }
sub revision     {'$Revision: 1.20 $'}

use vars qw ($MGMT_DIR);
$MGMT_DIR = "/opt/se6x20";


sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SE2');
  return $self;
}

# return 1 is sequencer is off.
use vars qw ($SEQUENCER $SEQ_ERR);

sub enclosure {
  my($class, $rep) = @_;

  $rep->{"info.power_sequencer.status"} = $SEQUENCER;
  $rep->{"info.power_sequencer.error"}  = $SEQ_ERR;
}

# returns ON,OFF,ERR ...

sub call_sequencer {
   my($class, $renv) = @_;
   my $command    = "$MGMT_DIR/tools/checkPower";
   my $TO         = 20;

   my($err,$com) = Util->run_command( $command, "login" ,$TO); 

   if ($com->[0] eq "") {
     return "ERROR : checkPower dreturned nothing!";
   } else {
     return $com->[0];
   }
}


# return SKIP_value:   0=OK/NOT_INSTALLED or 1=PROBLEM

sub sequencer_status {
  my($class) = @_;
  my $renv = System->get_renv();
  return 0 if ($renv->{solution} ne "se2" || !-f "$MGMT_DIR/PSDATA/PS");

  $SEQ_ERR = "";
  $SEQUENCER = $class->call_sequencer($renv);

#  ON DOWN REMOTE_SEQUENCER_ERROR  UNKNOWN 

  if ($SEQUENCER =~ /DOWN/) {
     $SEQUENCER = "OFF";
     if (Debug->errNoRepeat(ERROR => "rack_$renv->{solution_model}", 8, 
               "Power Sequencer on '$renv->{hostname}' is OFF")) {
          Util->run_command("/opt/se6x20/bin/vmcfg status -t rack -s DOWN",
                            "vmfcfg", 30, { cache => 0 } );
     }
     return 1;

  } elsif ($SEQUENCER =~ /ERROR/ || $SEQUENCER =~ /UNKNOWN/ ) {
    $SEQ_ERR   = $SEQUENCER;
    $SEQUENCER = "ERR";
    return 0;

  } elsif ($SEQUENCER =~ /ON/) {
     $SEQUENCER = "ON";
     return 0;
  }
  return 0;
}
  


#######################################################

sub slotOrder {
  my($class, $devs, $renv) = @_;
  my (@MAP1, @MAP2, @MAP3, @MAP4);

  foreach my $d (@$devs) {
    next if ($d->{mgmtLevel} ne "C");
    my $h = $d->{host} || $renv->{hostname};
    next if ($h ne $renv->{hostname});
    my $last = substr($d->{ipno},-2);
    if ($last ==30 || $last == 31) {
        push(@MAP1, $d);
    } elsif (substr($last,0,1) eq "2") {
        push(@MAP2, $d);
    } elsif ($last == 32 || $last == 33) {
        push(@MAP3, $d);
    } else {
        push(@MAP4, $d);
    }
  }
  push(@MAP1, @MAP2, @MAP3, @MAP4);
  return (\@MAP1);
}

sub FCCounters {
  my($class ,$arg) = @_;
  my (%X, $x);

  my($renv, $devs, $host,$notifs) = PDM::ConfigFile->read();

  my $to = $renv->{'timeout.http'} || 60;

  foreach my $d (@$devs) {
    next if ($d->{type} ne "se2");
    next if ($d->{active} eq "N");
    next if (!$d->isMineToMonitor());
    my $report = Report->readNew("$d->{type}:$d->{key}");
    next if (!$report);
    my $rep = $report->value();

    for ($x = 0; $x <= 100; $x++) {
      last if (!exists $rep->{"fcPort.$x.INF"});
      my @t = split(/\:/, $rep->{"fcPort.$x.nodeId"});
      my $y = $x + 1;
      my $k   = "fcPort.$x";
      my $val = $rep->{"$k.LINK"} . "\t" .
                $rep->{"$k.SIG"}  . "\t" .
                $rep->{"$k.SEQ"}  . "\t" .
                $rep->{"$k.CRC"}  . "\t" .
                $rep->{"$k.SYNC"} . "\t" .
                $rep->{"$k.ITW"} ;

      $X{"0|$d->{key}|port.$t[2]|se2"} = $val;
    }
  }
  return {data => \%X, hba => {}} ;
}



1;
