package Agent::MCDATA;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2002, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: MCDATA.pm,v 1.33 2003/04/23 22:18:50 ccadieux Exp $

use strict;
use Agent::SWITCH_Parent;
use base 'Agent::SWITCH_Parent';
use Net::Telnet;
use Util;
#Report::CAT_MCDATA

sub isSelectable {"McDATA"}

sub revision {'$Revision: 1.33 $'}
sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::MCDATA');
  return $self;
}
use vars qw($ERR);


sub getWWN {
  my($class, $ip, $host, $TO) = @_;
  my $rc;
  $ERR = undef;
  if ($host) {
      $rc = Util::Http->getCommand($host, "Agent::MCDATA::WWN&ip=$ip&HTTP=1", $TO);
      if ($rc =~ /ERR/) {
         $ERR = $rc;
         return undef;
      } else {
         return substr($rc,4);
      }
  } else {
      return get_WWN({ip => $ip});
  }
}

sub get_WWN {
  my($q) = @_;
  my $ip = $q->{ip};
  my ($name, $wwn);
  my $DIR = System->get_home();

  my $comm =   "$DIR/snmp/bin/snmpwalk -r 1 -t 10 -m $DIR/snmp/share/snmp/mibs/mcdata/fcfe.mib -Os $ip public fcElementName";
  my($err,$id) = Util->run_command($comm, "getWWN", 10);

  ($name, $wwn) = split(/ *= */, $id->[0]);
  $wwn = lc($wwn);
  $wwn =~ s/hex://; 
  $wwn =~ s/ //g;

  if ($q->{HTTP}) {
    if ($wwn) {
      print "\nOK $wwn";
    } else {
      print "\nERR $err";
    }
  } else {
    return $wwn;
  }
}


sub getDevStatus {
  my($class, $dev) = @_;
  my %R;
  $ENV{LD_LIBRARY_PATH} = System->get_home() . "/bin/lib";
  my $OPT;
  my $ip = $dev->{ipno};

  $ERR = $class->getStatusLinks($OPT, $dev, \%R);
  return ($ERR, \%R);
}


sub getStatusLinks {
  my($class, $OPT, $dev, $R) = @_;
  my($x, $err, $ports, $rem, $portids);
  my $DIR  = System->get_home() . "/snmp";
  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 10;
  
 
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";

  # Get number of ports
  $R->{"port.count"} = $class->getnumports($dev->{ipno});


   # Get port admin state and blade/port information
   #fcFxPortPhysAdminStatus.6.3 = online(1)
   #fcFxPortPhysAdminStatus.6.4 = online(1)
   #fcFxPortPhysAdminStatus.7.1 = online(1)
   #fcFxPortPhysAdminStatus.7.2 = online(1)

   $OPT = "-r 1 -t $TO -m $MIBS/fcfe.mib -Os ";
   my ($portinfo);
   ($err,$portinfo) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $dev->{ipno} public fcFxPortPhysAdminStatus ", 
                 "sanbox_version.txt", $TO+5);


   foreach my $l (@$portinfo) {
      if ($l =~ /^fcFxPortPhysAdminStatus.(\d+)\.(\d+) = (.+)/) {
	    my $value = $3;
	    my $blade = $1 - 1;
	    my $blade_port = $2 - 1;
	    my $gl_port = ($blade  * 4) + $blade_port;
            my $ix = index($value,"(");
            my $type = substr($value,0,$ix);
            $R->{"port.$gl_port.state.AdmStatus"} = $type;
	    # Save off blade and blade port info
	    $R->{"port.$gl_port.blade"} = $blade;
	    $R->{"port.$gl_port.blade_port"} = $blade_port;
      }
   }



  # get WWN of devices attached to port
  # first get an array of ports and there id's
  #/opt/SUNWstade/snmp/bin/snmpwalk -r 1 -t 10 -m /opt/SUNWstade/snmp/share/snmp/mibs/mcdata/fcmgmt.mib -Os  172.20.35.162 public fcConnUnitLinkPortNumberX
  #fcConnUnitLinkPortNumberX.'.....L........'.14 = 16
  #fcConnUnitLinkPortNumberX.'.....L........'.15 = 17
  #fcConnUnitLinkPortNumberX.'.....L........'.20 = 20
  #fcConnUnitLinkPortNumberX.'.....L........'.21 = 21
  #fcConnUnitLinkPortNumberX.'.....L........'.22 = 18
  #fcConnUnitLinkPortNumberX.'.....L........'.23 = 19

  $OPT = "-r 1 -t $TO -m $MIBS/fcmgmt.mib -Os ";
  ($err,$portids) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $dev->{ipno} public fcConnUnitLinkPortNumberX", 
                 "sanbox_version.txt", $TO+5);
   my (@port_array);
   foreach my $l (@$portids) {
      if ($l =~ /^fcConnUnitLinkPortNumberX.+\.(\d+) = (\d+)/) {
	 $port_array[$1] = $2;

      }
   }

   # now get attached WWN's 
   #/opt/SUNWstade/snmp/bin/snmpwalk -r 1 -t 10 -m /opt/SUNWstade/snmp/share/snmp/mibs/mcdata/fcmgmt.mib -Os  172.20.35.162 public fcConnUnitLinkPortWwnY
   #fcConnUnitLinkPortWwnY.'.....L........'.14 =  Hex: 20 04 08 00 88 A0 4C 0E 
   #fcConnUnitLinkPortWwnY.'.....L........'.15 =  Hex: 20 05 08 00 88 A0 4C 0E 
   #fcConnUnitLinkPortWwnY.'.....L........'.20 =  Hex: 20 08 08 00 88 A0 4C 0E 
   #fcConnUnitLinkPortWwnY.'.....L........'.21 =  Hex: 20 09 08 00 88 A0 4C 0E 
   #fcConnUnitLinkPortWwnY.'.....L........'.22 =  Hex: 20 04 08 00 88 A0 28 EA 
   #fcConnUnitLinkPortWwnY.'.....L........'.23 =  Hex: 20 05 08 00 88 A0 28 EA 
   ($err,$portids) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $dev->{ipno} public fcConnUnitLinkPortWwnY", 
                 "sanbox_version.txt", $TO+5);
   foreach my $l (@$portids) {
      if ($l =~ /^fcConnUnitLinkPortWwnY.+\.(\d+) =  Hex: (.+)/) {
         my ($portindex) = $1;
	 my ($wwn) = $2;
	 $wwn =~ s/ //g;

         $R->{"port.$port_array[$portindex].link_wwn"} = lc(substr($wwn,0,16));
      }
   }

   # Get port information - Type, state and status
   #/opt/SUNWstade/snmp/bin/snmpwalk -r 1 -t 10 -m /opt/SUNWstade/snmp/share/snmp/mibs/mcdata/fcmgmt.mib -Os  172.20.35.162 public fcConnUnitPortType
   #fcConnUnitPortType.'.....L........'.1 = fPort(8)
   #fcConnUnitPortType.'.....L........'.2 = fPort(8)
   #fcConnUnitPortType.'.....L........'.3 = gPort(10)

   $OPT = "-r 1 -t $TO -m $MIBS/fcmgmt.mib -Os ";
   foreach my $el ('Type','State','Status') {

     ($err,$portinfo) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $dev->{ipno} public fcConnUnitPort$el", 
                 "sanbox_version.txt", $TO+5);

      foreach my $l (@$portinfo) {
         if ($l =~ /^fcConnUnitPort$el.+\.(\d+) = (.+)/) {
	    my $portindex = $1 - 1;
	    my $value = $2;
            my $ix = index($value,"(");
            my $type = substr($value,0,$ix);
            $R->{"port.$portindex." . lc($el)} = $type;
	 }
      }
   }



   # Get port wwn's
   $OPT = "-r 1 -t $TO -m $MIBS/fcmgmt.mib -Os ";

   ($err,$portids) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $dev->{ipno} public fcConnUnitPortWwn", 
                 "mcdata.txt", $TO+5);

   #fcConnUnitPortWwn.'.....L.........'.25 =  Hex: 20 1C 08 00 88 A0 4C 0E 
   #fcConnUnitPortWwn.'.....L.........'.26 =  Hex: 20 1D 08 00 88 A0 4C 0E 
   #fcConnUnitPortWwn.'.....L.........'.27 =  Hex: 20 1E 08 00 88 A0 4C 0E 

   foreach my $l (@$portids) {
      if ($l =~ /^fcConnUnitPortWwn.+\.(\d+) =  Hex: (.+)/) {
         my ($portindex) = $1 - 1;
	 my ($wwn) = $2;
	 $wwn =~ s/ //g;

         $R->{"port.$portindex.stats.Wwn"} = lc($wwn);
      }
   }

}

sub getnumports {
  my($class, $ip) = @_;


  my $DIR  = System->get_home() . "/snmp";
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";

  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 60;

  # Get number of ports
  my($OPT) = "-r 1 -t $TO -m $MIBS/ef-6000.mib -Os  ";
  my ($err,$ports) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $ip public Ef6000PortIndex", 
                 "sanbox_version.txt", $TO+5);
  my $mycount  = $#$ports;

  return $mycount +1;
}

sub getStats {
  my($class, $OPT, $ip, $R, $dev) = @_;


  my $DIR  = System->get_home() . "/snmp";
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";


  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 60;

  my($TO)    = $renv->{'timeout.snmp'} || 60;
  my ($OPTS);
  my($MIBS)  = System->get_home() . "/snmp/share/snmp/mibs/mcdata";

  ($OPTS)   = "-r 1 -t $TO -m $MIBS/fcfe.mib -Os ";



    
  $R->{"port.count"} = $class->getnumports($ip);


  #Gettting stats take longer than most operations so increase time out.
  $TO = $TO + 30;
 

  my ($err5,$ports) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPTS $ip public fcFxPortErrorEntry", 
                 "sanbox_version.txt", $TO+5);


  if ($err5) {
     Debug->print2("snmpwalk $ip fcFxPortErrorEntry: $err5");
     return undef;
  }
  my($ERR_LIST) = ",LinkFailures,SyncLosses,SigLosses,PrimSeqProtoErrors,InvalidTxWords,InvalidCrcs,DelimiterErrors,AddressIdErrors,LinkResetIns,LinkResetOuts,OlsOuts";
  #fcFxPortLinkFailures.1.1 = Counter32: 1
  #fcFxPortLinkFailures.1.2 = Counter32: 1
  #fcFxPortLinkFailures.2.1 = Counter32: 0
 
  my($x, $port, $name);
  foreach my $l (@$ports) {
		 #fcFxPortLinkFailures.2.1 = Counter32: 0
		 #fcFxPortLinkFailures.  2  .  1   = Counter32:   0
		 #fcFxPort(.+        ).(\d+).(\d+) = Counter32: (\d+)
     if ($l =~ /^fcFxPort(.+)\.(\d+)\.(\d+) = Counter32: (\d+)/){
        my $name    = $1;
	my $blade   = $2 - 1;
	my $blade_port = $3 - 1;
	my $gl_port = ($blade * 4) + $blade_port;
	my $value   = $4;

        if (index($ERR_LIST, ",$name,") >= 0) {
           $R->{"port.$gl_port.error.$name"} =  $value;
        } else {
           $R->{"port.$gl_port.stats.$name"} =  $value;
        }
     }
   }




	
}



sub getVersion {
  my($agent, $ip) = @_;

  my($renv) = System->get_renv();
  my $DIR  = System->get_home() . "/snmp";
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";
  my($TO) = $renv->{'timeout.snmp'} || 60;

  # Get version
  my $OPT = "-r 1 -t $TO -m $MIBS/ef-6000.mib -Os ";
  my($err_version,$version) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $ip public ef6000SysFirmwareVersion", 
                 "mcdata.txt", $TO+5);

  if ($err_version) {
     $ERR = $err_version;
     return undef;
  } else {
     my ($x, $y) = split(/\s*=\s*/, "@$version");
     if (substr($y,0,1) eq "\"") {
        $y = substr($y,1,-1);
     }
     return $y;
  }

}

sub INSTRUMENTATION {
  my($agent, $device) = @_;
  my(@s, %dev, $in, %info);
  my($connect_err, %C);
  my($port,  $config);
  my(%R);
  my($ip)    = $device->{ip};
  my(@counts, @stats, $stat, $x);
  my($DIR)   = System->get_home() . "/snmp/bin";
  my($renv)  = System->get_renv();
  my($TO)    = $renv->{'timeout.snmp'};
  my ($OPT);
  $DB::single = 1;

  my($MIBS)  = System->get_home() . "/snmp/share/snmp/mibs/mcdata";

  #Get system uptime
  ($OPT)   = "-r 1 -t $TO -m all -Os ";

  my($err8,$uptime) = Util->run_command("$DIR/snmpwalk $OPT $ip public sysuptime ", 
                       "sanbox_version.txt", $TO+5);

  if ($err8) {
    Debug->err(SNMP => "Cannot run snmp on $ip:$err8");
    $R{'rc.error'} = "snmp failed on $ip: $err8";
    return \%R;
  } elsif ($#$uptime < 0) {
    $R{'rc.error'} = "No answer from switch at $ip";
    return \%R;
  }

  # get environmental DATA - Fans, power supplies 
  $OPT = "-t $TO -r 1 -m $MIBS/fcmgmt.mib -Os ";
  my($err0,$sensors) = Util->run_command("$DIR/snmpwalk $OPT $ip public connUnitSensor",
                       "mcdata.txt", $TO+5);

  if ($err0) {
     $R{'rc.error'} = $err0;
     return \%R;

  } elsif ("@$sensors" =~ /Timeout:/) {
     $R{'rc.error'} = "@$sensors";
     return \%R;
  }


  # Parse the sensor data
  # First create an array of sensors types and index number
  my ($max, $l);
  my (%CNT, @MAP);
  foreach my $x (@$sensors) {
    if($x =~ /fcConnUnitSensorType.+\.(\d+) = (.+)/){

       my $sensorIndex = $1;
       my $sensorType = $2;
       $max =  $sensorIndex if ($sensorIndex > $max);
       my $i = index($sensorType,"(");
       $sensorType = substr($sensorType,0,$i) if ($i > 0);
       $CNT{$sensorType}++;
       $MAP[$sensorIndex] = "$sensorType." . $CNT{$sensorType};
    }
  }

    # Now get sensor valus
    foreach my $x (@$sensors) {
    if($x =~ /fcConnUnitSensorStatus.+\.(\d+) = (.+)/){
       my $sensorIndex = $1;
       my $sensorValue = $2;
       my $i = index($sensorValue,"(");
       $sensorValue = substr($sensorValue,0,$i) if ($i > 0);
       my $ix2 = $MAP[$sensorIndex];
       $R{"sensor.$ix2.status"} = $sensorValue;

    }
    if($x =~ /fcConnUnitSensorName.+\.(\d+) = (.+)/){
       my $sensorIndex = $1;
       my $sensorValue = $2;
       my $i = index($sensorValue,"(");
       $sensorValue = substr($sensorValue,0,$i) if ($i > 0);
       my $ix2 = $MAP[$sensorIndex];
       $R{"sensor.$ix2.name"} = $sensorValue;

    }
  }

  $R{"sensor.count"} = $max;

  # Save system uptime
  foreach my $x (@$uptime) {
     my(@a) = split(/\(/, $x);
     my(@b) = split(/\)/, $a[1]);
     $R{"system.uptime"} =  $b[0];
     $R{"system.calendar_uptime"} = $b[1];
  }


  
  $agent->getStats($OPT, $ip, \%R, $device);
  $agent->getStatusLinks($OPT, $device, \%R);
  $agent->getProductID($ip, \%R, $device);

  if (index("|$renv->{categories}|", "|san|") >= 0 &&
        $device->isMineToMonitor() ) {
     $R{"FC_COUNTERS"} = $agent->FCfromDevice($device);
  }

  $agent->addIdentification(\%R);

  $R{"id.wwn"}         = Util->snmpWWN($ip);
  $R{"id.switch_type"} = "McDATA";
  $R{'rc.key'}         = $R{"id.wwn"};
  return \%R;
}


sub FCfromDevice {
  my($class, $dev) = @_;
  my (%X, @R, $x);
  my $renv = System->get_renv();
  my $ip = $dev->{ipno} || $dev->{ip};
  my ($inframes, $outframes);



  my $DIR  = System->get_home() . "/snmp";
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";
  my($TO) = $renv->{'timeout.snmp'} || 60;
    

  #Gettting stats take longer than most operations so increase time out.
  $TO = $TO + 30;
 

  # Get port indexes
  #/opt/SUNWstade/snmp/bin/snmpwalk -r 1 -t 10 -m /opt/SUNWstade/snmp/share/snmp/mibs/mcdata/fcfe.mib -Os  172.20.35.161 public fcFxPortErrorModuleIndex
  #fcFxPortErrorModuleIndex.1.1 = 1
  #fcFxPortErrorModuleIndex.1.2 = 1
  #fcFxPortErrorModuleIndex.1.3 = 1
  #fcFxPortErrorModuleIndex.1.4 = 1
  #fcFxPortErrorModuleIndex.2.1 = 2
  #fcFxPortErrorModuleIndex.2.2 = 2
  #fcFxPortErrorModuleIndex.2.3 = 2

  my ($OPT) = "-r 1 -t $TO -m $MIBS/fcfe.mib -Os ";
  my($err4,$ports) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $ip public fcFxPortErrorModuleIndex", 
                 "mcdata.txt", $TO+5, {cache => 0});


  if ($err4) {
     Debug->print2("snmpwalk $ip fcFxPortErrorModuleIndex: $err4");
     return undef;
  }

  
  my($err5,$errors) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $ip public fcFxPortErrorEntry", 
                 "sanbox_version.txt", $TO+5, {cache => 0});


  if ($err5) {
     Debug->print2("snmpwalk $ip fcFxPortErrorEntry: $err5");
     return undef;
  }
  my($ERR_LIST) = ",LinkFailures,SyncLosses,SigLosses,PrimSeqProtoErrors,InvalidTxWords,InvalidCrcs,DelimiterErrors,AddressIdErrors,LinkResetIns,LinkResetOuts,OlsOuts";
  #fcFxPortLinkFailures.1.1 = Counter32: 1
  #fcFxPortLinkFailures.1.2 = Counter32: 1
  #fcFxPortLinkFailures.2.1 = Counter32: 0
 
  foreach my $l (@$errors) {
		 #fcFxPortLinkFailures.2.1 = Counter32: 0
		 #fcFxPortLinkFailures.  2  .  1   = Counter32:   0
		 #fcFxPort(.+        ).(\d+).(\d+) = Counter32: (\d+)
     if ($l =~ /^fcFxPort(.+)\.(\d+)\.(\d+) = Counter32: (\d+)/){
        my $name    = $1;
	my $blade   = $2 - 1;
	my $portnum = $3;
	my $value   = $4;
        if (index($ERR_LIST, ",$name,") >= 0) {
	   my $porthere = ($blade *4) + $portnum;
	   $R[$porthere]{$name} =  $value + 0;
        }
     }
   }


   # Get in and out Frames

   foreach my $type ('In','Out') {
      # Get all class Frames
      foreach my $class ('C1','C2','C3') {

         my($err5,$errors) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $ip public fcFxPort${class}${type}Frames", 
                 "mcdata.txt", $TO+5, {cache => 0});


         if ($err5) {
            Debug->print2("snmpwalk $ip fcFxPort${class}${type}Frames: $err5");
            return undef;
         }
         #fcFxPortC1InFrames.7.2 = Counter32: 0
         #fcFxPortC1InFrames.8.1 = Counter32: 0
         foreach my $l (@$errors) {
	     my $name = $class . $type;
            if ($l =~ /^fcFxPort${class}${type}Frames\.(\d+)\.(\d+) = Counter32: (\d+)/){
	      my $blade   = $1 - 1;
	      my $portnum = $2;
	      my $value   = $3;
	      my $porthere = ($blade * 4) + $portnum;
	      my $frametype = $type . "frames";
	      $R[$porthere]{$frametype} +=  $value + 0;
            }
         }
      }# End each class
   }#End in out

  my ($portnum)  = 0;
  $portnum = $class->getnumports($ip);
  for ($x=0; $x < $portnum; $x++) {

      my $key = "|$dev->{key}|port.$x|switch";

      if (!defined($R[$x])){
         $X{$key} = (0) . "\t".
		    (0) . "\t".
		    (0) . "\t".
		    (0) . "\t".
		    (0) . "\t".
		    (0) . "\t".
                    (0) . "\t".
                    (0) ;

      }
      else{

      
         $X{$key} = ($R[$x]{'LinkFailures'}+0)       . "\t".
		    ($R[$x]{'SigLosses'}+0)          . "\t".
		    ($R[$x]{'PrimSeqProtoErrors'}+0) . "\t".
		    ($R[$x]{'InvalidCrcs'}+0)        . "\t".
		    ($R[$x]{'SyncLosses'}+0)         . "\t".
		    ($R[$x]{'InvalidTxWords'}+0)     . "\t".
                    ($R[$x]{'Inframes'}+0)           . "\t".
                    ($R[$x]{'Outframes'}+0) ;
     }

  }
  return {enc => {$dev->{wwn} => $dev->{name}} , data => \%X};
}


sub REPORT {
  my($class, $host, $r, $arg) = @_;

  my($out);
  my($v) = $r->{_value};

  my $last;
  $out = $class->reportHead("McDATA", $r, undef, $v->{"id.connect_errs"});

  my $port;

  my $header_line;
  my $fan_line;

  if($v->{"port.count"} < 33){
    $header_line = "<th>Port</th>";
  }else{
     $header_line = "<th>#</th><th>Slot- Port</th>";
  }
  my $pow = $v->{'sensor.powerSupply.1.status'} . " / " . 
            $v->{'sensor.powerSupply.2.status'};

  if($v->{"port.count"}  == 24){
    $fan_line = "<td colspan=2>&nbsp;</td>";
  }else{
     my $fan = $v->{'sensor.fan.1.status'} . " / " . 
            $v->{'sensor.fan.2.status'} ;

     $fan_line = "<td bgcolor=$Style::LIGHT align=right>Fan:</td>   <td>&nbsp;$fan</td>";
  }  

  $out .= "
     <tr><td bgcolor=$Style::LIGHT align=right>Name:</td> <td>&nbsp;$v->{'id.device_name'}</td>
         <td bgcolor=$Style::LIGHT align=right>IP:</td>   <td>&nbsp;$v->{'id.device_ip'}</td>
     <tr><td bgcolor=$Style::LIGHT align=right>Product:</td> <td>&nbsp;$v->{'id.productID'}</td>
         <td bgcolor=$Style::LIGHT align=right>WWN:</td>   <td>&nbsp;$v->{'id.wwn'}</td>
     <tr><td bgcolor=$Style::LIGHT align=right>Power:</td> <td>&nbsp;$pow</td>
     $fan_line
     </table>
     <table border=1 width=95% bgcolor=white cellspacing=0 cellpadding=0>
     <tr bgcolor=$Style::LIGHT>
        $header_line
        <th>Admin/Port State</th>
        <th>Attached WWN</th>";
     for ($port=0; $port < $v->{"port.count"}; $port++) {

        my ($admstat);
	if($v->{"port.$port.state.AdmStatus"}){
	   $admstat = $v->{"port.$port.state.AdmStatus"};
	} else {
	   $admstat = "Uninstalled";
	}

        my $state = $v->{"port.$port.state"};
        my $bg = ($state eq "offline")? "bgcolor=#FFFFD0":"";

	my $blade;
	if(exists($v->{"port.$port.blade"})){
	   $blade = $v->{"port.$port.blade"};
	}else{
	   $blade = int($port / 4);
	}

	my $blade_port;
	if(exists($v->{"port.$port.blade_port"})){
	   $blade_port = $v->{"port.$port.blade_port"};
	}else{
	   $blade_port = $port%4;
	}

	my $attached_wwn;
	if(exists($v->{"port.$port.link_wwn"})){
	   $attached_wwn = $v->{"port.$port.link_wwn"};
	}else{
	   $attached_wwn = "Not Connected";
	}

	my $port_stat;
	if($admstat =~ /Uninstalled/){
	   $port_stat = "Not Installed";
	}else{
	   $port_stat = "$admstat-$state";
	}

	   
	if($v->{"port.count"} < 33){
	   $out .= "<tr><td>&nbsp;$port</td>
                    <td $bg>&nbsp;$port_stat</td>
                    <td>&nbsp;$attached_wwn</td>";

        }else{
           $out .= "<tr><td><center>&nbsp;$port</td><td><center>$blade-$blade_port</td><td $bg>&nbsp;$port_stat</td><td>&nbsp;$attached_wwn</td>";
        }
     }
  $out .= "</table>&nbsp;<table border=1 cellspacing=0 width=95% bgcolor=white>";


  foreach my $el (sort keys %$v) {
     if($el =~ /id.device_telnet/ || substr($el,0,3) eq "rc."){
        #skip displaying password
        next;
     }
     if($el =~ /port\./){
      next;
     }
     next if (ref($v->{$el}) eq "HASH");
     my($a, $b) = split(/\./, $el);
     if ($a ne $last) {
        $out .= "<tr bgcolor=$Style::LIGHT><td colspan=2>&nbsp;<b>$a<th> <th></th></td>\n" if ($a);
        $last = $a;
     }

     $out .= "<tr><td>&nbsp;$el<td>&nbsp;$v->{$el}</td>";
  }
  $out .= "</table>";
  return $out;

}


sub getZones {
  my($class, $DIR, $s_ip, $V, $dev) = @_;
  my(%Z);
  my $totzones;
  $totzones = -1;
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";
  my($err);
  my $renv = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 60;


   # Get my domain id
   my $mydomainid;
   my ($num_zones) = 0;
   my ($OPT) = "-r 1 -t $TO -m $MIBS/fcmgmt.mib -Ose ";

   my($err1,$id) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $s_ip public fcConnUnitDomainId", 
                 "mcdata.txt", $TO+5);

   foreach my $l (@$id) {
      if ($l =~ /^fcConnUnitDomainId.+ =  Hex: .. .. (..)/) {
         $mydomainid = $1;
	 $mydomainid = int($mydomainid);
      }
   }


   # Get active member table
   $OPT = "-r 1 -t $TO -m $MIBS/ef-6000.mib -Ose ";

   my($err2,$active_table) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $s_ip public ef6000ActiveMemberTable", 
                 "mcdata.txt", $TO+5);

   my ($zone_number);
   foreach my $l (@$active_table) {
      if ($l =~ /^ef6000MemberZoneIndex\.(\d+)\.(\d+) = (\d+)/) {
         my $zone = $1;
	 my $index_of_zone = $2;
	 my $zone_number = $3;
	 $totzones = $zone_number if($zone_number > $num_zones);
	 $Z{"$zone.$index_of_zone.zone_number"} = $zone_number;

      }
      # find the indexes with this switches domain id


      if ($l =~ /^ef6000MemberDomainID\.(\d+)\.(\d+) = (\d+)/) {
         my $zone = $1;
	 my $index_of_zone = $2;
	 my $domain_id = $3;
	 if($mydomainid eq $domain_id){
	    $Z{"$zone.$index_of_zone.port"} = $domain_id;
	 }
      }
      # find the port numbers for this switch that are in zones
      if ($l =~ /^ef6000MemberPortNumber\.(\d+)\.(\d+) = (\d+)/) {
         my $zone = $1;
	 my $index_of_zone = $2;
	 my $port = $3;
	 if($Z{"$zone.$index_of_zone.port"}){
	    $Z{"$zone.$index_of_zone.zone_port"} = $port;
	    my ($zone_index) = $Z{"$zone.$index_of_zone.zone_number"};
	    $V->{"zone.hd.$zone_index.members"} .= "$port ";

	 }
      }

   }

   # Get zone names
    my($err2,$active_table) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $s_ip public ef6000ActiveZoneTable", 
                 "mcdata.txt", $TO+5);

   my ($zone_number);
   foreach my $l (@$active_table) {
      if ($l =~ /^ef6000ZoneName\.(\d+) = (.*)/) {
	 my $index = $1;
	 my $zone_name = $2;
	 my $zoneindex = "zone" . $index . "name";
	 $V->{"zone.hd_name.$index.name"} = $zone_name;

      }
   }
   # end get zone names

  $V->{"zone.total"} = $totzones +1;
  return $err;

}





sub getModel {
  my($agent, $ip) = @_;

  return "McDATA";

}



sub getProductID {
  my($class, $ip, $R, $dev) = @_;


  my $DIR  = System->get_home() . "/snmp";
  my($MIBS) = $DIR . "/share/snmp/mibs/mcdata";


  my($renv) = System->get_renv();
  my($TO) = $renv->{'timeout.snmp'} || 60;
    
  my $OPT = "-r 1 -t $TO -m $MIBS/fcmgmt.mib -Os ";


  my ($err,$product) = Util->run_command(
                 "$DIR/bin/snmpwalk $OPT $ip public fcConnUnitProduct", 
                 "sanbox_version.txt", $TO+5);


  if ($err) {
     Debug->print2("snmpwalk $ip fcConnUnitProduct: $err");
     return undef;
  }
  #/opt/SUNWstade/snmp/bin/snmpwalk -r 1 -t 10 -m /opt/SUNWstade/snmp/share/snmp/mibs/mcdata/fcmgmt.mib -Os  172.20.35.163 public fcConnUnitProduct
  #fcConnUnitProduct.'.....L.........' = ES-3232
  my($x, $port, $name);

  foreach my $l (@$product) {
     if ($l =~ /^fcConnUnitProduct.+ = (.+)/){
           $R->{"id.productID"} =  $1;
     }
   }

}

1;
