package TO::SVE2;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
use strict;
use TO;
sub leaf { 1 }

sub newFromDev {
  my($class, $Topo, $host, $dev, $mode) = @_;
  my($x);
  my $name = "sve2:$dev->{wwn}";
  my $new = 0;

  my($switches) = $Topo->[1];
  my($syns)     = $Topo->[4];
  my $renv      = System->get_renv();

  if (!defined($switches->{$name})) {
     $new= 1;
     my($obj) = {};
     $obj->{info}{name}    = $name;
     $obj->{info}{type}    = "sve2";
     $obj->{info}{BoxName} = $dev->{name};
     $obj->{info}{mgmtLevel} = $dev->{mgmtLevel} || "D";
     $obj->{info}{class}   = "switch.sve2";
     $obj->{info}{sw_WWN}  = $dev->{wwn};
     $obj->{info}{sw_ipAddr} = $dev->{ipno};

     $obj->{port} = [];

     require Agent::SVE2;
     my ($err, $report) = Agent::SVE2->getLinks($dev);
     if ($report) {
       my ($x);
       for ($x=0; $x <= $report->{"info.port_cnt"}; $x++) {
            #my $wwn = $report->{"port.$x.LocalPortWWN"};
            my $wwn = $report->{"port.$x.WWN"};
            $syns->{$wwn} = "$name:$x";
            $obj->{port}[$x] = undef;
            $obj->{portInfo}[$x] = { 
                       PortWWN => $report->{"port.$x.PortWWN"},
                         State => $report->{"port.$x.disk_state"},
                          Proc => $report->{"port.$x.disk_proc"},
                          Path => $report->{"port.$x.disk_path"},
                  LocalPortWWN => $wwn,
                                     };
       }
     }
     $obj->{info}{ProductID} = "SVE2";
     $obj->{info}{host}      = $host;
     $obj->{info}{host_type} = "oob";

     bless($obj, 'TO::SVE2');
     $syns->{$dev->{wwn}} = $name;
     $switches->{$name}  = $obj;
  }
  return ($new ,$switches->{$name});
}

sub addFromConfig {
  my($class, $topo, $Config) = @_;

  my $devs = $Config->myDevices();
  my $renv = $Config->renv();

  foreach my $dev (@$devs) {
     next if ($dev->{type} ne "sve2");
     next if (!$dev->isMineToMonitor());
     my $k = $dev->{type} . ":" . $dev->key();
     next if ($topo->nodeByName($k));
     $class->newFromDev($topo, $renv->{hostname}, $dev);
  }
}

sub iconLayout {
  my($sw) = @_;
  return "F0D0F0/sve2.gif,P,Power";
}


sub statusFunc {
  my($class, $name, $State) = @_;

  my $Comp = $State->components();
  my $i = $Comp->value("$name:e");
  my $enc = $i->[0];
  my $encInfo = $i->[1];
  my ($disk, $diskInfo);

  my $other;
  my $otherInfo;

  my($x, $port, $portInfo);

  return ($enc, $port, $disk, $other, $encInfo,
          $portInfo, $diskInfo, $otherInfo);
}

sub type { "sve2"};

sub revision {
  my $sw = @_;
  my $vol = $sw->volInfo();
  if ($vol) {
     foreach my $k (keys %$vol) {
         return $vol->{$k}{Revision};
     }
  }
  return undef;
}

sub isCascaded { 0 }


sub getLogicalPaths{
  my($self) = @_;
  my $volinfo =$self->volInfo();
  my @paths;
  foreach my $path (keys %$volinfo){
    push(@paths, $path);
  }
  return @paths;
}
1;
