package Service::Util;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use Net::Telnet;
use Labels;
use Logic::Ethers;
use strict;
use Html;
use PPRO;
use Inventory;
use Events;
use vars qw ($DETECT $DB  $FILE $PROXY_HOST $PROXY_PORT $CDTARGET $CACHETARGET);

$DETECT    = "patchpro.detectors.source.url";
$DB        = "patchpro.database.source.url";
$CDTARGET   = "/var/sadm/spool";
$CACHETARGET= "/var/opt/SUNWppro/lib/cache";

$FILE        = "/etc/opt/SUNWppro/etc/patchpro.conf";
$PROXY_HOST  = "patchpro.proxyserver.host";
$PROXY_PORT  = "patchpro.proxyserver.port";


use vars qw(%CONN);

#  $Id: Util.pm,v 1.49 2003/05/22 20:13:55 ccadieux Exp $

sub ether {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("Service::Util")->section("ether");

  print Html->body();
  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  my $info;
  if ($q->{ACTION_submit} ) {
     my ($error, $new);
     my %E = &readEther();
     foreach my $el (sort %$q) {
        next if (substr($el,0,3) ne "et_");
	my $name = substr($el, 3);
        my $et = $q->{$el};
	$et = uc(Util->trim($et));
	if (!$et){
	   delete $E{$name};
	   next;
	}
	if (!Logic::Ethers->valid($et)) {
           $error .= "Ether on $name is invalid ($et)<br>";
	} else {
           $new .= "$et\t$name\n";
           delete $E{$name};
	}
     }
     if (!$error) {
       foreach my $el (keys %E) {
         $new .= "$E{$el}\t$el\n";
       }
       open(O, ">/etc/ethers");
       print O $new;
       close(O);
       $info = Html->info("Ether file updated!");
     } else {
       $info = Html->error($error);
     }
  }

  print Html->header2("manage.service.ether_upd");

  my $o =<<EOF;
$info
<form method=post>
 <input type=hidden name=GO value=Service::Util::ether>
 <table border=1 cellspacing=0 bgcolor=white cellpadding=0 width=80%>
  <tr><td colspan=3 bgcolor=$Style::DARK><font color=white><b>$L->{title}</td>
  <tr bgcolor=$Style::LIGHT>
      <th>$L->{name}</th>
      <th>$L->{ip}</th>
      <th>$L->{mac}</th>
EOF

  my ($l);
  my $H = Logic::Ethers->readHosts("192.168");
  
  my @L;
  open(O, "/etc/hosts");
  foreach my $ip (sort keys %$H) {
     my $el = $H->{$ip};

     my $val = "<input type=text size=20 name=et_$el->[0] value=\"$el->[1]\">";
     $o .= "<tr><td>&nbsp;$el->[0]&nbsp;</td>
                <td>&nbsp;$ip&nbsp;</td>
		<td>$val</td>
		";
  }
  close(O);
  $o .= "</table><b>
     <input type=submit name=ACTION_submit value=\"$L->{submit}\">
     </form>";

  print $o;
}

# 00:C0:DD:00:B2:01	sw1b

sub readEther {
  my (%E,$l);
  open(O, "/etc/ethers");
  while ($l = <O>) {
     my($et, $name) = split(/\s+/, $l);
     $E{$name} = $et;
  }
  close(O);
  return %E;
}


sub setup {
  my($q, $post) = @_;
  my($renv, $dev, $host, $notifs, $c1, $c2);
  my($err1, $info, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("Service::Util")->section("setup");

  print Html->body();
  print Html->header2("manage.service.rev_setup");
  my $setup = PPRO->setup_path();

  $info = "";
  my($warn2, $warn3, $cat, $last_win);
  ($renv, $dev, $host,$notifs) = PDM::ConfigFile->read();

  if ($q->{ACTION_copy} ) {
     if ( !-d "/cdrom/cdrom0/Patches") {
       print Html->error("No Patches on CD or CD not present!");
     } else {
       &ppro_copy();
     }

  } elsif ($q->{ACTION_update} ) {
     if ($q->{source} eq "CD" && !-d "/cdrom/cdrom0/Patches") {
       print Html->error("No Patches on CD or CD not present!");
     } else {
       $renv->{'ppro.timeout'}       = $q->{timeout};
       $renv->{'ppro.proxy'}         = $q->{proxy};
       $renv->{'ppro.patch_server'}  = $q->{patch};
       if ($renv->{'ppro.proxy_port'} ne $q->{proxy_port}) {
           my $p = $q->{proxy_port};
           if (($p >= 1024 && $p <= 65535) || ($p == 443) || ($p == "")) {
             $renv->{'ppro.proxy_port'} = $q->{proxy_port};
             system("/usr/local/bin/FW_config --set_port_val patchpro=$q->{proxy_port} >/dev/null 2>&1");
             print Html->info("Proxy port updated!");
           } else {
             print Html->error("Proxy port should be in the of range 1024 - 65535 or 443");
           }
       }
       if (-x $setup) {
         my $info;
         if ($q->{proxy} ) {
            system("$setup -x \"$q->{proxy}\"");
            $info .= "-x \"$q->{proxy}\", ";
         }
         $q->{patch} = Util->trim($q->{patch});

         my($err, $rc) = &fix_patchpro_conf($q->{source}, $q->{proxy_host}, 
                            $q->{proxy_port}, $q->{patch});
         &ppro_copy() if ($q->{source} eq "CD" && 
                          ($q->{source} ne $renv->{'ppro.source'}) );

         system("$setup -m $q->{source} >/dev/null");
         if ($err) {
           print Html->error($err);
         } elsif ($rc) {
           print Html->info($rc);
         }
       } else {
         print Html->error("Cannot run $setup: $!");
       }

       if (!PDM::ConfigFile->write( $renv, $dev, $host,$notifs)) {
          print "Cannot write ConfigFile <br>";
       }
     }
  }
  my(%LAST, %CURR);
  my($err, $rc) = &patchpro_read(\%LAST, \%CURR);

  $renv->{'ppro.source'} = $CURR{$DETECT} =~ /\/cache/ ? "CD" : "Server";
  my $proxy_host         = $CURR{$PROXY_HOST};
  my $proxy_port         = $CURR{$PROXY_PORT};

  my $sel = Html->makeSelect("source", "Server=PatchPro Server|CD=CD", $renv->{'ppro.source'});

  my $o =<<EOF;

<body bgcolor=$Style::BGCOLOR>
<form method=post>
 <input type=hidden name=GO value=Service::Util::setup>
<center>
$info
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=4 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{options}</td>
<tr><td bgcolor=$Style::LIGHT width=40% align=right>$L->{proxy} :</td>
    <td>&nbsp;<input type=text size=30 name=proxy_host value=\"$proxy_host\">

<tr><td bgcolor=$Style::LIGHT width=40% align=right>$L->{proxyport} :</td>
    <td>&nbsp;<input type=text size=5 name=proxy_port value=\"$proxy_port\">

<tr><td bgcolor=$Style::LIGHT width=40% align=right>$L->{source} :</td>
    <td>&nbsp;$sel</td>

<tr><td bgcolor=$Style::LIGHT width=40% align=right>$L->{timeout} :</td>
    <td>&nbsp;<input type=text size=4 name=timeout value=\"$renv->{'ppro.timeout'}\"> (mins)

</table>
 <input type=submit name=ACTION_update value="$L->{submit_upd}">
 <input type=submit name=ACTION_copy value="Copy CDROM info">
EOF
  print $o;
}

sub ppro_copy {

  my @D = split(/\//, substr($CDTARGET,1));
  my $dir;
  foreach my $el (@D) {
    $dir .= "/$el";
    mkdir $dir, 0777 if (!-d $dir);
  }

  print "Copying /cdrom0/Patches...<br>\n";
  system("/bin/cp /cdrom/cdrom0/Patches/* $CDTARGET");
  print "Copying /cdrom0/Misc to cache ...<br>\n";
  system("/bin/cp /cdrom/cdrom0/Misc/* $CACHETARGET");
}
  

sub patchpro_read {
  my($LAST, $CURR) = @_;
  my($l, $content);

  open(O, $FILE);
  while ($l = <O>) {
     chop($l);
     my($name, $val) = split(/\=/, $l);
     if ($l =~ /^#LAST (.*)=(.*)/) {
        $LAST->{$1} = $2;

     } elsif ($name eq $DETECT || $name eq $DB ) {
        $CURR->{$name} = $val;
     } elsif ($name eq $PROXY_HOST || $name eq $PROXY_PORT) {
        $CURR->{$name} = $val;

     } else {
        $content .= "$l\n";
     }
  }
  close(O);
  return $content;
}

sub fix_patchpro_conf {
  my($source, $proxy_host, $proxy_port, $patch_value) = @_;

  my ($content, %LASTCD, %LASTServer, $l, %CURR, %LAST);

  #$proxy_port = "" if (!$proxy_port);

  $LASTCD{$DETECT} = "file:///var/opt/SUNWppro/lib/cache/ppromas3det.jar";
  $LASTCD{$DB}     = "file:///var/opt/SUNWppro/lib/cache/ppromas3db.zip";

  $LASTServer{$DETECT} = "https://patchpro.sun.com/expert/ppromas3det.jar";
  $LASTServer{$DB}     = "https://patchpro.sun.com/expert/ppromas3db.zip";

  $content = &patchpro_read( \%LAST, \%CURR);

  my ($err, $rc);
  if (!open(W, ">$FILE")) {
       return ("Cannot open $FILE: $!");
  }
  my $change;
  print W $content;
  if ($source eq "CD") {
     print W "$DETECT=$LASTCD{$DETECT}\n";
     print W "$DB=$LASTCD{$DB}\n";
     $change = 1 if ($LASTCD{$DETECT} ne $CURR{$DETECT});

  } else {
     print W "$DETECT=$LASTServer{$DETECT}\n";
     print W "$DB=$LASTServer{$DB}\n";
     $change = 1 if ($LASTServer{$DETECT} ne $CURR{$DETECT});
  }
  print W "$PROXY_HOST=$proxy_host\n";
  print W "$PROXY_PORT=$proxy_port\n";

  close(W);
  return (undef, "patchpro.conf updated");
}

sub cim_password {
  my($q) = @_;

  print Html->body();
  print Html->header2("manage.configure.se2_util");
  if ($q->{ACTION_save}) {
     if ($q->{password}) {
       System->setPassword("cim_guest", $q->{password});
       print Html->info("Password updated!");
     } else {
       print Html->error("Enter a password!");
     }
  }
  print "
   <form><input type=hidden name=GO value=Service::Util::cim_password>
   <table border=1 cellspacing=0 width=90% bgcolor=white>
   <tr bgcolor=$Style::DARK>
      <td colspan=2><font color=white>Enter New Password</td>
   <tr><td align=right bgcolor=$Style::LIGHT>Password:</td>
       <td><input type=password name=password size=20>
  </table>
  <b><input type=submit name=ACTION_save value=\"Change Password\">
   </form>
  ";
}

sub configure {
  my($q, $post) = @_;
  my($c1, $c2);
  my($err1, $err2, $err3, $err5, $err6, $err8);
  my($error);
  my $deny = Roles->verifyRole($q, "admin");
  my $G = Labels->read();
  my $L = Labels->read("Service::Util")->section("configure");

  print Html->body();
  my($warn2, $warn3, $cat, $last_win);
  my($renv, $devs, $host,$notifs, $Config) = PDM::ConfigFile->read();

  if ($q->{ACTION_conf_sel} || $q->{ACTION_unconf_sel}) {
     my $command = $q->{ACTION_conf_sel} ? "configure" : "unconfigure";
     foreach my $x (keys %$q) {
        if (substr($x,0,6) eq "array_") {
           my $ip = substr($x, 6);
           my $dev = $Config->deviceByIP($ip);
           Events->saveEvent("CFG", ucfirst($command), 
                             "$dev->{name}/$ip on Sun Solution $renv->{solution_name}");
           my ($err, $rc) = Inventory->run_vmcfg0($ip, $command);
           if ($err) {
             print Html->error("'$command': $err");
           } elsif ("@$rc" =~ /usage:/) {
             print Html->warning("'$command': @$rc<br> Invalid argument(s), if the storage array password was not saved, use 'sysbin/saveArrayPassword' to save it.");
           } else {
             print Html->info("'$command' command executed on device $ip:@$rc");
           }
        }
     }
  }

  if ( $q->{ACTION_conf} || $q->{ACTION_unconf} ) {
     my $command = $q->{ACTION_conf} ? "configure" : "unconfigure";
     my $info;
     foreach my $d (@$devs) {
        next if ($d->{type} ne "6120");
        my ($err, $rc) = Inventory->run_vmcfg0($d->{ipno}, $command);
        if ($err) {
          print "Error on '$command': $err <br>";
        } else {
          $info .= "'$command' command executed on device $d->{ipno}:@$rc<br>";
        }
     }
     print Html->info($info) if ($info);
  }

  print Html->header2("manage.service.conf");

  if ($q->{ACTION_update} ) {
       $renv->{'ppro.timeout'}       = $q->{timeout};
       $renv->{'ppro.proxy'}         = $q->{proxy};
       $renv->{'ppro.patch_server'}  = $q->{patch};
       $renv->{'ppro.source'}        = $q->{source};
         print Html->info(
           " -x $q->{proxy}, -P $q->{patch}, -m $q->{source} <br>done.\n");
       if (!PDM::ConfigFile->write( $renv, $devs, $host,$notifs)) {
          print "Cannot write ConfigFile <br>";
       }
  }
  my $sel = Html->makeSelect("source", "Server=PatchPro Server|CD=CD", $renv->{'ppro.source'});

  my $o =<<EOF;

<form method=post>
 <input type=hidden name=GO value=Service::Util::configure>
<center>
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$L->{title}</td>
<tr bgcolor=$Style::LIGHT>
    <th>$L->{sel}
    <th>$L->{name}
    <th>$L->{ip}
EOF

    foreach my $d (@$devs) {
       next if ($d->{type} ne "6120");
       $o .= "<tr><td><center><input type=checkbox name=array_$d->{ipno}></td>
                  <td>$d->{name}</td>
                  <td>$d->{ipno}</td>";
    }
    $o .=<<EOF;
</table> 
  <table border=0 cellspacing=0 cellpadding=0 width=90%>
  <tr><td><b>
          <input type=submit name=ACTION_conf_sel value="$L->{conf_sel}"><br>
          <input type=submit name=ACTION_unconf_sel value="$L->{unc_sel}">
      </td>

      <td align=right><b>
          <input type=submit name=ACTION_conf value="$L->{conf_all}"><br>
          <input type=submit name=ACTION_unconf value="$L->{unc_all}"></td>
  </table>
  </form>
EOF

  print $o;
}

sub ejectCD {
  my($q) = @_;
 
  print Html->body();
  print Html->header2("manage.util.ejectcd");
  if ($q->{ACTION_eject}) {
     my $com = "/usr/bin/eject";
     my $rc = `$com 2>&1`;

     print Html->info("Command $com executed:<br> $rc");
  }


  print "<form><b>
         <input type=hidden name=GO value=Service::Util::ejectCD>
         <input type=submit name=ACTION_eject value=\"Eject CD\">
         </form>
      ";

}


sub changePasswords {
  my($q) = @_;

  print Html->body();
  print Html->header2("manage.util.chpwd");
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  my $LB = Labels->read("Service::Util")->section("password");

  if ($q->{ACTION_change}) {
     if ($q->{confirm} ne $q->{new}) {
       print Html->error($LB->{err1});
     } else {
       my($o1, $n1);
       if ($q->{s_old} eq "M") {
         $q->{old} = "BLANK" if (!$q->{old});
         $o1 = "-o $q->{old}" ;
       }
       if ($q->{s_new} eq "M") {
         $q->{new} = "BLANK" if (!$q->{new});
         $n1 = "-n $q->{new}" ;
       }
       my $com = System->get_home() . "/sysbin/changeArrayPasswords $o1 $n1";
       print "Command : sysbin/changeArrayPasswords <pre></center>";
       my($err, $o) = Util->run_command($com, "test", 120);
       print "$err" . join("\n",  @$o) . "<br>";
       print "</pre><center>";
       print Html->info($LB->{go_to_config});
     }
  }

  my $sel1 = Util->makeSelect("s_old", "S=$LB->{save}|M=$LB->{manual}");
  my $sel2 = Util->makeSelect("s_new", "M=$LB->{manual}|S=$LB->{save}");
  print <<EOF;
<form>
   <input type=hidden name=GO value=Service::Util::changePasswords>
   <table border=1 cellspacing=0 cellpadding=0 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK>
        <font color=white><b>Enter Passwords</td>
   <tr><td align=right bgcolor=$Style::LIGHT>
         Old Password:</td>
       <td width=10%>&nbsp;$sel1</td>
       <td>&nbsp;<input type=password name=old size=20>

   <tr><td align=right bgcolor=$Style::LIGHT>
         New Password:</td>
       <td width=10%>&nbsp;$sel2</td>
       <td>&nbsp;<input type=password name=new size=20>
   <tr><td align=right bgcolor=$Style::LIGHT>
         Confirm New Password:</td>
       <td width=10%>&nbsp;</td>
       <td>&nbsp;<input type=password name=confirm size=20>
   </table><b>
   <input type=submit name=ACTION_change value=\"$LB->{submit}\" 
          onclick="return confirm('$LB->{sure}')" >
   </form>
EOF

}


1;
