package Service::Upgrade;
use Inventory;
use PPRO;
use Util;
use strict;
use Html;
use Process;
use Html::Flow;
use Labels;

sub setup {
  my($q) = @_;

}

sub rev_mgr {
  my($q) = @_;

}

sub fix {
  my($q) = @_;
  my $SID;
  my $info;
  print Html->body();
  my $D = System->get_home() . "/DATA/tmp";
  my $LB = Labels->read("Service::Upgrade");
  my $just_started;
  if ($q->{kill}) {
    my ($status, $pid1) = Process->status(undef, $q->{kill});
    if ($pid1) {
      Util->killPID($pid1);
      unlink "$D/$q->{kill}";
      unlink "$D/$q->{kill}_pid";
      print Html->info("Killed $q->{kill} ($pid1)");
    } else {
      print Html->warning("Cannot kill $q->{kill} (no PID)");
    }

  } elsif ($q->{ACTION_clear}) {
    unlink "$D/Upgrade";
    unlink "$D/Upgrade_pid";
    unlink "$D/Patchlist";
    unlink "$D/Patchlist_pid";

  } elsif ($q->{ACTION_generate}) {
    $SID = "storade";
    my $command =  System->get_home() . "/bin/ras_patchlist -S $SID -b";
    system($command);
    sleep(1);
    $info = Html->info("Started $command");
    $just_started = 1;

  } elsif ($q->{ACTION_apply}) {
    &fix2($q);
    return;
  } 
  my ($status, $pid1) = Process->status(undef, "Patchlist");
  my ($ins_status, $pid2) = Process->status(undef, "Upgrade");
  my ($kill1, $kill2);
  if ($pid1 && $status =~ /Running/) {
     $kill1 = "[ <a href=$Http::WEBPROC?GO=Service::Upgrade::fix&kill=Patchlist>$LB->{kill}</a> ]";
  }
  if ($pid2 && $ins_status =~ /Running/) {
     $kill2 = "<a href=$Http::WEBPROC?GO=Service::Upgrade::fix&kill=Upgrade>$LB->{kill}</a> | ";
  }
  if ("$status $ins_status" =~ /Running/ || $just_started) {
    print "<meta http-equiv=Refresh content=\"30;URL=$Http::WEBPROC?GO=Service::Upgrade::fix\">";
  }
  print $info;
  print Html->header2("manage.service.rev_fix");

  my ($b1);
  my $rep = Process->read(undef, "Patchlist");
  my ($out, $apply, $create, $clear);
  my $apply;
  if ($ins_status !~ /Running/) {
    if ($status !~ /Running/) {
      $create = "<input type=submit name=ACTION_generate value=\"$LB->{create}\">";
      $clear  = "<input type=submit name=ACTION_clear value=\"$LB->{clear}\">";
    }
    if ($rep && $status =~ /Done/) {
      $apply = "&nbsp;"; # "<input type=submit name=ACTION_apply value=\"$LB->{select}\">";
    }
  }

  print Html::Flow->display([
      [ $LB->{report1},  'Service::Upgrade::fix',    1, 1 ],
      [ $LB->{report2},  'Service::Upgrade::fix2',   0, $apply ],
      [ $LB->{report3},  'Service::Upgrade::fix3',   0, 1 ],
        ], {width => "90%"});

  print <<EOF;
&nbsp;
 <script>
  function win1(t) {
     var b = '$Http::WEBPROC?GO=Service::Upgrade::upgrade_log';
     var O = window.open(b,'log','menubar=no,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
  }
 </script>
 <table border=1 cellspacing=0 cellpadding=3 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;$LB->{summ}
   <tr><td align=right bgcolor=$Style::LIGHT width=40%><form>
         <input type=hidden name=GO value=Service::Upgrade::fix>
         <input type=hidden name=SID value=storade>
         $LB->{patch_status}:</td>
       <td>&nbsp;$status</td><td><center>&nbsp;$kill1</td>
   <tr><td align=right bgcolor=$Style::LIGHT width=30%>
         $LB->{patch_ins}:</td>
       <td>&nbsp;$ins_status</td><td><center>[&nbsp;$kill2
       <a href=javascript:win1() $Http::WEBPROC?GO=Service::Upgrade::upgrade_log>$LB->{log}</a> ]
           </td>
 </table>
 <table border=0><tr><td></table>
 <table border=0 width=90%>
  <tr><td><b>$create &nbsp; $apply
  </td>
  <td align=right>
        <b>$clear
  </table>
  </form>
EOF

}

sub upgrade_log {
  my($q) = @_;

  my $LB = Labels->read("Service::Upgrade");

  print Html->body(undef, {color => "white", extra => "onload=window.scroll(0,100000)" } );
  print "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=Service::Upgrade::upgrade_log\"></center>";
  print "<table border=0 cellspacing=0 width=100% bgcolor=$Style::DARK>
     <tr><td><b><font color=white>$LB->{rev}</table><pre>";

  open(O, System->get_home() . "/DATA/tmp/Upgrade.log");
  my($l);
  while ($l = <O>) {
     $l =~ s/</&lt;/g;
     print $l;
  }
  close(O);
}


##################################
# GENERATE PATCHES
##################################
#

sub fix2 {
  my($q) = @_;
  print Html->body();
  print Html->header2("manage.service.rev_fix");

  my $LB = Labels->read("Service::Upgrade");

  my $cli  = PPRO->cli_path();
  my $renv = System->get_renv();
  my $TO   = $renv->{"ppro.timeout"} || 30;
  my ($SID, $XML_FILE);
  my $Config = PDM::ConfigFile->read();

  print Html::Flow->display([
      [ $LB->{report1},  'Service::Upgrade::fix',    0, 1 ],
      [ $LB->{report2},  'Service::Upgrade::fix2',   1, 0 ],
      [ $LB->{report3},  'Service::Upgrade::fix3',     0, 0 ],
        ], {width => "90%"});

  my $rep = Process->read(undef, "Patchlist");
  my $ppro = PPRO->parse($rep->{data}{report});
  if ($PPRO::ERROR) {
     print Html->warning("PPRO::parse XML Error</b>: $PPRO::ERROR");
     return;
  }
  my $inv = Inventory->readInventory();
  my %IP;  # map devices by ipno
  foreach my $d (@{$inv->getDevices()}) {
     $IP{$d->{ipno}} = $d;
  }

  print <<EOF;
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
  <tr><td colspan=6 bgcolor=$Style::DARK><form>
       <input type=hidden name=GO value=Service::Upgrade::fix3>
       <input type=hidden name=SID value=$SID>
       <font color=white><b>$LB->{apply}</td>
  <tr bgcolor=$Style::LIGHT>
      <th>$LB->{dev}</th>
      <th>$LB->{dev2}</th>
      <th>$LB->{ip}</th>
      <th width=1%>$LB->{patch}</th>
      <th width=2%>$LB->{id}</th>
      <th>Info</th>
EOF
   my @GIF = ("al_ok3.gif", "al_alert3.gif", "al_crit3.gif", "al_down3.gif");
   my $State = State->getComponentState(0);

   foreach my $pp (@{$ppro->devices()}) {
      my $inv_d = $IP{$pp->key()};
      my $ip   = $pp->key();
      my $name = $inv_d->{name};
      my $type = lc($pp->type());
      my $dev  = $Config->deviceByIP($ip);
      my ($label, $k, $sev, $info);
      $sev = 0;
      if ($type eq "sunos") {
        $label = $LB->{sp};
        $k     = "host:" . $renv->{hostname};
      } elsif ($dev) {
        $label = "$dev->{type}: $dev->{name}";
        $k     = "$dev->{type}:$dev->{key}";
      } elsif ($name) {
        $label = "$type:$name";
      } else {
        $label = "$type:<font color=red>UNKNOWN</font>";
      }
      if (exists $State->{$k}) {
        $sev  = int($State->{$k}[0] + 0.5);
        $info = "<br><font color=red><small>" . $State->{$k}[1] . "</small></font><br>";
      }

      my $P = $pp->patches();
      my $pcnt = $#$P +1;
      my $sel  = "<input type=checkbox name=\"sel_$ip\">" if ($pcnt > 0);
      my $t2 = $LB->{patches};
      print "\n<tr><td ><center>$sel&nbsp;<td><center><b>$label</td>
             <td ><center><b>$ip <img src=/gif/$GIF[$sev]>
             <td colspan=3>$info<center><b>$pcnt</b> $t2 &nbsp;</td>";
      my $cnt = 0;
      foreach my $patch (@$P) {
         my $pid = $patch->{patchID};
         my $syn = $patch->{synopsis};
         my $err = $pp->error($patch->{error});
         my $frus;
         foreach my $fru (@{$patch->frus()}) {
            $frus .= "$fru->{locator}, ";
         }
         if ($frus) {
            chop($frus); chop($frus);
         }
         my $err2 = "<br><font color=red>$err->{message}" . ": " . $err->{remedy} . "</font>" if ($err->{message});
         if ($dev->{type} eq "6120") {
            print "<tr><td colspan=3></td>
             <td width=1%><center><input type=checkbox name=\"patch_$ip#$pid\">";
         } else {
            print "<tr><td colspan=4></td>";
         }
         print "<td width=2%>&nbsp;$pid</td>";
         my $t1 = $syn;
         $t1 .= " " if ($syn && $err2);
         $t1 .= $err2;
         $t1 .= "<br>" if (length($t1) > 1 && $frus);
         $t1 .= "<b>Frus:</b> $frus" if ($frus);
         $t1 .= "&nbsp;";
         print "<td>$t1</td>"; #<tr><td colspan=5></td>";
         $cnt++;
      }
      print "\n<tr><td></td><td></td><td></td><tr><td></td>";
   }
   print "</table>&nbsp;<br><b>
    <input type=submit name=ACTION_selected value=\"$LB->{submit_sel}\" 
                onclick=\"return confirm('$LB->{confirm_sel}')\"> &nbsp;
    <input type=submit name=ACTION_all value=\"$LB->{submit_all}\" 
                onclick=\"return confirm('$LB->{confirm_all}')\"> &nbsp;
    </form>";
}
#  <tr><td colspan=5><center>
#    <table border=0 cellspacing=0>
#      <tr><td align=right>Run Mode:</td><td><select name=mode><option value=S>Serial<option value=P>Parallel</select></table></td>



##################################
# PATCH INSTALLATION STATUS
##################################
#
sub fix3 {
  my($q) = @_;
  print Html->body();

  my $LB = Labels->read("Service::Upgrade");
  my $meta= "<meta http-equiv=Refresh content=\"30;URL=$Http::WEBPROC?GO=Service::Upgrade::fix3\">";


  my $cli  = PPRO->cli_path();
  my $renv = System->get_renv();
  my $TO   = $renv->{"ppro.timeout"} || 30;
  my ($SID, $XML_FILE);
  my $Config = PDM::ConfigFile->read();

  if ($q->{ACTION_all} || $q->{ACTION_selected}) {
    $SID         =  "storade";
    my $rep = Process->read(undef, "Patchlist");
    my $ppro = PPRO->parse($rep->{data}{report});

    if ($PPRO::ERROR) {
       print Html->warning("PPRO::parse XML Error</b>: $PPRO::ERROR");
       return;
    }
    my $list;
    if ($q->{ACTION_all} ) {
      $list = "_ALL_";
      #foreach my $pp (@{$ppro->devices()}) {
      #  $list .= $pp->key() . ":";
      #}
    } else {
      my (%DEV, $err);
      foreach my $el (keys %$q) {
         if (substr($el,0,4) eq "sel_") {
            my $k = substr($el,4);
            $list .= "$k:";
            $DEV{substr($el,4)} = 1;
         }
      }
      foreach my $el (keys %$q) {
         if (substr($el,0,6) eq "patch_") {
            my($ip0, $patch0) = split(/\#/, substr($el,6));
            if (!$DEV{$ip0}) {
               $list .= substr($el,6) . ":";
            } else {
               $err .= $LB->expand(ignore => $patch0, $ip0);
            }
         }
      }
      print Html->warning($err) if ($err);
    }
    chop($list) if ($list);
    if (!$list) {
       print Html->warning($LB->{select_one});
    } else { 
      print $meta;
      my $command =  System->get_home() . "/bin/ras_upgrade -m S -S $SID -i \"$list\" -b";
      system($command);
      sleep(1);
      print Html->info("Started $command");
    }
  }

  my $ins_status = Process->status(undef, "Upgrade");
  print $meta if ( $ins_status =~ /Running/);

  print Html->header2("manage.service.rev_fix");
  print Html::Flow->display([
      [ $LB->{report1},  'Service::Upgrade::fix',    0, 1 ],
      [ $LB->{report2},  'Service::Upgrade::fix2',   0, 0 ],
      [ $LB->{report3},  'Service::Upgrade::fix3',   1, 1 ],
        ], {width => "90%"});

  my ($b1);
  my $rep = Process->read(undef, "Upgrade");
  my ($out);

  if ($ins_status =~ /Done/) {
    print "<table border=0><tr><td></table>";
    &report({TITLE=> $LB->{patch_status2} } );

  } else {
    print <<EOF;
 <script>
  function win1(t) {
     var b = '$Http::WEBPROC?GO=Service::Upgrade::upgrade_log';
     var O = window.open(b,'log','menubar=no,resizable=yes,scrollbars=yes,width=500,height=600');
      O.focus();
  }
 </script>
&nbsp;
 <table border=1 cellspacing=0 cellpadding=3 width=90% bgcolor=white>
   <tr><td colspan=3 bgcolor=$Style::DARK><b><font color=white>&nbsp;Patch Installation
   <tr><td align=right bgcolor=$Style::LIGHT width=30%>
         $LB->{patch_status}</td>
       <td>&nbsp;$ins_status</td>
       <td><center> [ <a href=javascript:win1() $Http::WEBPROC?GO=Service::Upgrade::upgrade_log>$LB->{log}</a> ]
 </table>
 <table border=0><tr><td></table>
EOF
  }
}




sub report {
  my($q) = @_;
  my $renv = System->get_renv();

  my $LB = Labels->read("Service::Upgrade");

  print Html->body();
  if (!$q->{TITLE}) {
    print Html->header2("manage.service.rev_report", undef, $q->{hist}?"Historical":"",undef , {noDoc=>1});
  }
  my $ID = "Upgrade";
  my $l;
  if ($q->{ACTION_hist}) {
     my $RF =  System->get_home() . "/DATA/tmp/Upgrade";
     my $date1 = Util->get_file_created($RF);
     $date1 =~ s/ /_/g;
     open(R, $RF);
     my $w = $renv->{hostname} . ".$date1";
     print Html->info("Copying $w to $ID history");
     open(W, ">" . System->get_home() . "/DATA/${ID}_history/$w");
     while ($l = <R>) {
        $l =~ s/\.+/.../;
        print W $l;
     }
     close(R); close(W);
     unlink $RF;
  }
  my $RF;
  if ($q->{hist}) {
    $RF =  System->get_home() . "/DATA/Upgrade_history/$q->{hist}";
  } else {
    $RF =  System->get_home() . "/DATA/tmp/Upgrade";
  }
  if (!open(O, $RF)) {
     print Html->warning($LB->{no_upgrade});
     return;
  }
  my($l,$report, $VAR1);
  while ($l = <O>) {
     $l =~ s/\.+/.../;
     $report .= $l;
  }
  close(O);
  eval $report;
  my $run_date = $VAR1->{date};
  my $data     = $VAR1->{data};
  my $err      = $VAR1->{error_cnt};
  my $trace    = $data->{trace};
  $trace =~ s/\n/<br>\n/g;
  my $ppro     = $data->{report};
  
  my $inv = Inventory->readInventory();
  if (!$inv) {
    print Html->warning("No Inventory available!");
    return;
  }
  my %IP;  # map devices by ipno
  foreach my $d (@{$inv->getDevices()}) {
     $IP{$d->{ipno}} = $d;
  }
  my $model = $inv->{model};

  print <<EOF;
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
<tr><td colspan=2 bgcolor=$Style::DARK><b><font color=white>&nbsp;$q->{TITLE} SE $model</td>
<tr><td align=right bgcolor=$Style::LIGHT>$LB->{date}:</td><td>&nbsp;$run_date</td>
<tr><td align=right bgcolor=$Style::LIGHT>$LB->{err}:</td><td>&nbsp;$err</td>
<tr><td colspan=2>$trace</td>
</table>
<table border=1 cellspacing=0 cellpadding=1 width=90% bgcolor=white>
  <tr><td colspan=5 bgcolor=$Style::DARK>
  <tr bgcolor=$Style::LIGHT>
      <th>$LB->{dev2}</th><th>$LB->{ip2}</th><th>$LB->{id}</th><th>$LB->{info}</th>
EOF
   foreach my $pp (@{$ppro->devices()}) {
      my $inv_d = $IP{$pp->key()};
      my $ip   = $pp->key();
      my $name = $inv_d->{name};
      my $type = lc($pp->type());
      my $P = $pp->patches();
      print "\n<tr><td valign=top><center><b>$type:$name</td><td valign=top><center><b>$ip
        <td colspan=2><center><b>" . ($#$P +1) . "</b> patch(es)";

      my $cnt = 0;
      foreach my $patch (@$P) {
         my $pid = $patch->{patchID};
         my $syn = $patch->{synopsis};
         my $err = $pp->error($patch->{error});
         my $frus;
         foreach my $fru (@{$patch->frus()}) {
            $frus .= "$fru->{locator}, ";
         }
         if ($frus) {
            chop($frus); chop($frus);
         }
         my $err2 = "<br><font color=red>$err->{message}" . ": " . $err->{remedy} . "</font>" if ($err->{message});
         print "<tr><td colspan=2><td valign=top>&nbsp;$pid<td>$syn $err2";
         print "<br><b>Frus:</b> $frus" if ($frus);
         print "</td><tr><td colspan=4></td>";
         $cnt++;
      }
      print "\n<tr><td></td><td></td><td></td>";
   }
   print "</table><form><input type=hidden name=GO value=Service::Upgrade::report><b>
   <input type=submit name=ACTION_hist value=\"$LB->{submit_move}\">
   </form>";
  
}


1;
