package Service::Telnet;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use PDM::ConfigFile;
use Net::Telnet;
use Labels;
use strict;
use Html;

use vars qw(%CONN);

#  $Id: Telnet.pm,v 1.10 2003/02/04 21:13:01 ccadieux Exp $


######################################################
#                     TELNET
######################################################

sub telnet {
  my($q) = @_;
  print Html->body();
  my $LB = Labels->read("Service::Util")->section("telnet");

  if ($q->{ACTION_start}) {
     my ($cat, $ipno)  = split(/\:/, $q->{ip});
     if (!$ipno) {
        print Html->error("No device was selected!");
     } elsif (Util->ping($ipno)) {
        &telnet2($q);
        return;
     } else {
        print Html->error("Cannot ping $q->{ip}");
     }
  }

  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read();
  my $list;
  my $cat = $q->{cat};
  my $cnt=0;
  my $lastdev;
  foreach my $dev (@$devs) {
     if (index("t3,3310,sve2", $dev->{type}) >= 0) {
        next if ($cat && $dev->{type} ne $cat);
        $list .= "$dev->{type}:$dev->{ipno}:$dev->{name}=$dev->{name}|";
        $cnt++;
        $lastdev = $dev;
     }
  }
#
#  single device, skip login page
#
  if ($cnt == 1 && $lastdev->{login}) {
     if (Util->ping($lastdev->{ipno})) {
        &telnet2({login => $lastdev->{login}, password => $lastdev->{telnet}, help => $q->{help},
                  ip => "$lastdev->{type}:$lastdev->{ipno}:$lastdev->{name}" });
     } else {
        print Html->err("Cannot ping $lastdev->{name} / $lastdev->{ipno}");
     }
     return;
  }
  #print Html->header2("manage.util.telnet");

     
  my $select = Util->makeSelect("ip", $list);

  print <<EOF;
<table border=1 cellspacing=0 cellpadding=2 bgcolor=white width=90%>
  <tr><td align=right bgcolor=$Style::LIGHT>
      <form><input type=hidden name=GO value=Service::Telnet::telnet>
         $LB->{dev}:</td>
      <td>$select
  <tr><td align=right bgcolor=$Style::LIGHT>$LB->{login}:</td>
      <td><input type=text name=login size=20 value=root>

  <tr><td align=right bgcolor=$Style::LIGHT>$LB->{password}:</td>
      <td><input type=password name=password size=20 value=\"\">

  </table><b>
  <input type=submit name=ACTION_start value=\"$LB->{connect}\">
</form>
EOF
   
}


sub telnet2 {
  my($q) = @_;

  my $help = "[ <a href=javascript:win2()>Help</a> ]" if ($q->{help});
  my $ipno  = $q->{ip};
  my($cat, $x, $name) = split(/\:/, $ipno);

  my $LB = Labels->read("Service::Util")->section("telnet");

  my $login = $q->{login};
  my $pass  = Util->decode($q->{password});

  my $rem = $ENV{REMOTE_USER} || $cat || "U1";
  foreach my $e (keys %CONN) {
     my $v = $CONN{$e};
     if (time - $v->{last_activity} > (2*60*60)) {
        my $con = $CONN{$e}{con};
        my @out = $con->cmd("exit");
        delete $CONN{$e};
     }
  }

  if ($CONN{$rem}) { # disconnect for now
      my $con = $CONN{$rem}{con};
      my @out = $con->cmd("exit");
      delete $CONN{$rem};
  }

  my ($last, $request);
  print Html->body();
print <<EOF;
<script>
    function win2(t) {
      var b = '/$q->{help}.html';
      var O = window.open(b,'sve2','menubar=no,resizable=yes,scrollbars=yes,width=600,height=600');
      O.focus();
    }
    </script>
EOF

  if ($cat eq "sve2") {
    print "<table border=0 cellspacing=0 width=96%>
      <tr><td><b>$LB->{virtual}</td>
          <td align=right>$help
     </table>";
  } else {
    print Html->header2("manage.util.telnet", "97%");
  }
  my $code = "Telnet";
  my $applet = System->appletHeader("code=telnetApplet.class codebase=$code" , 50,60);
  my $rashttp = Http->getRashttpName();
   print <<EOF;
<table border=0 cellspacing=0 cellpadding=0 bgcolor=white><tr><td>
<font color=red><b>$LB->{warning}</b>
</table>

<table border=0 cellpadding=2 bgcolor=$Style::DARK width=97%>
  <tr><td><font color=white><b>&nbsp;$name ($x) / $login
</table>
<table border=0 cellspacing=0 width=95%><tr><td><center>
$applet
 <param name=url value="GO=Service::Telnet::run">
 <param name=rashttp value="$rashttp">
 <param name=info value="&ip=$ipno&login=$login&password=$pass">
 <param name=live value="Y">
</applet>
</table>
EOF

}

sub run {
  my($q) = @_;
  my ($cat, $ipno, $name)  = split(/\:/, $q->{ip});
  my $login = $q->{login};
  my $pass  = $q->{password};
  my ($last, $request);
  print "HTTP/1.0 200 OK\n\n";

  my $rem = $ENV{REMOTE_USER} || $cat || "U1";

  while (1) {
      $request = $q->{command};
      if ($request =~ /^\s+$/) {
         print "Enter command!\n";
         last;
      }

      if (!$CONN{$rem}) {
         print "#new connection\n";
 
         my $t;
         if ($cat eq "t3") {
            $t  = new Net::Telnet (
              errmode => "return",
              Timeout   => 10,
              Prompt    => '/<\d+\>/'
               );
         } elsif ($cat eq "sve2") {
            $t  = new Net::Telnet (
              errmode => "return",
              Timeout   => 10,
              Prompt    =>  '/([#?] $|\033\[\dD )/',
               );
         }

         if (!defined($t->open($ipno))) {
            print "ERR: Cannot open $ipno\n";
            last;
         }
         $t->login($login, $pass);
         if ($t->errmsg()) {
            print "ERR: " . $t->errmsg() . "\n";
            last;
         }
         $CONN{$rem}{con} = $t;
         $CONN{$rem}{id}  = $q->{ip};
         $CONN{$rem}{last_connect} = time;
         if ($cat eq "sve2") {
            my @out  = $t->cmd("no page-mode");
            my @out  = $t->cmd("terminal width 110");
         }
      }
      my $conn = $CONN{$rem}{con};
      my @out;
      if (lc($request) eq " m") {
        print "#Invalid remote command!\n";
      } elsif (lc($request) =~ "^ more") {
        print "#Invalid remote command!\n";

      } else {
        if ($cat eq "sve2") {
          @out  = $conn->cmd($request);
          if ("@out" =~ /Error: Invalid para/) {
            $conn->cmd("^U");
            $conn->cmd("^U");
          }
        } else {
          @out  = $conn->cmd($request);
        }
        $CONN{$rem}{last_activity} = time;
      }

      if ($request eq " EXIT") {
         $conn->close();
         delete $CONN{$rem};
         print "# Bye\n";
      }
      print join("",@out);
      last;
  }
}

1;
