package Service::Inventory;
use strict;
use System;
use Inventory;
use Html::Flow;
use Labels;

sub upd {
  my($q) = @_;
  print Html->body();
  print Html->header2("manage.service.invent_upd");
  my $ruser      = System->get_ruser();

  my $LB = Labels->read("Service::Inventory");

  print Html::Flow->display([
      [ $LB->{curr}, 'Service::Inventory::upd',         1, 1 ],
      [ $LB->{gen},  'Service::Inventory::upd2',  0, 0 ],
      [ $LB->{save},'Service::Inventory::upd3',  0, 0 ],
        ], {width => "90%"});

  my $inv = Inventory->readInventory();
  if (!$inv) {
     print Html->warning($LB->{no_inv});
  } else {
    print &show_($q, $inv, "Service::Inventory::upd");
  }

  print "<br><table border=0 cellspacing=0 width=90%>
    <tr><td><form><input type=hidden name=GO value=Service::Inventory::upd2>
    <center><b>
    <input type=submit name=ACTION_disco value=\"$LB->{submit_gen}\">
    </table>";
  print "</form>";
  
}

sub upd2 {
  my($q) = @_;
  print Html->body();
  print Html->header2("manage.service.invent_upd");
  my $LB = Labels->read("Service::Inventory");

  print Html::Flow->display([
      [ $LB->{curr}, 'Service::Inventory::upd',           0, 1 ],
      [ $LB->{gen},  'Service::Inventory::upd2',    1, 0 ],
      [ $LB->{save}, 'Service::Inventory::upd3',    0, 0 ],
        ], {width => "90%"});

  my $renv = System->get_renv();
  my $model = $renv->{solution_model};
  my $short = System->hostname();
  my $ix = index($short, ".");
  if ($ix > 0) {
     $short = substr($short,0,$ix);
  }
  my $oinv = Inventory->readInventory();
  print "</center>Probing...<br>\n";
  my($trace_out, $inv) = Inventory->readMaserati($short, undef, 1, 1);    
  if (!$inv) {
     print "$LB->{failed} $model!";
     return;
  }
  $inv->{model} = $model;
  my $F = "/tmp/inv_upd_$$";
  $inv->writeInventory($F);

  print &display_($inv, $oinv);

  print "<br><table border=0 cellspacing=0 width=90%>
    <tr><td><form>
     <input type=hidden name=GO value=Service::Inventory::upd3>
     <input type=hidden name=F value=$F>
    <center><b>
    <input type=submit name=ACTION_save value=\"$LB->{submit_save}\">
    </table>";
  print "</form>";

}

sub upd3 {
  my($q) = @_;
  print Html->body();
  print Html->header2("manage.service.invent_upd");
  my $ruser      = System->get_ruser();
  my $LB = Labels->read("Service::Inventory");

  print Html::Flow->display([
      [ $LB->{curr},  'Service::Inventory::upd',            0, 1 ],
      [ $LB->{gen} ,  'Service::Inventory::upd2',     0, 1 ],
      [ $LB->{save},  'Service::Inventory::upd3',     1, 0 ],
        ], {width => "90%"});


  if ($q->{ACTION_save}) {
     my $inv = Inventory->readInventory($q->{F});
     if ($inv) {
       $inv->writeInventory();
       $inv->writeConfig("write");
       print Html->info("Inventory saved!");
       my $cnt = $inv->deviceCount();
       Inventory->log($LB->expand(new_inv => $ruser->{userid}, $cnt));
       unlink $q->{F};
     } else {
       print Html->warning($LB->{no_inv});
     }
  }

  my $inv = Inventory->readInventory();
  if (!$inv) {
     print Html->warning($LB->{no_inv});
  } else {
    print &show_($q, $inv, "Service::Inventory::upd", $LB->{upd_inv});
  }
}


sub display_ {
  my($inv, $oinv) = @_;
  my $LB = Labels->read("Service::Inventory");

  my $out =  "<table border=1 cellspacing=0 cellpadding=0 bgcolor=white width=90%>
  <tr><td colspan=4 bgcolor=$Style::DARK><font color=white><b>$LB->{curr}</td>
  <tr bgcolor=$Style::LIGHT>
       <th>$LB->{type}
       <th>$LB->{name}
       <th>$LB->{ip}
       <th>$LB->{status}
  ";
  my $tot;
  if (!$oinv) {
    my $devs = $inv->getDevices();
    foreach my $d (@$devs) {
      $out .= "<tr><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}<td>&nbsp;</td>";
    }
    $out .= "</table>";
  } else {
    my $devs = $inv->getKeys();
    my $odevs = $oinv->getKeys();
    foreach my $k (keys %$devs) {
      my $d = $devs->{$k};
      if (exists($odevs->{$k})) {
         my $frus = $d->frus();
         my $ofrus   = $odevs->{$k}{frus};
         my $changes;
         foreach my $fruid (keys %$frus) {
             my $fru = $frus->{$fruid};
             my $ofru = $ofrus->{$fruid} || {};
             if ($ofru->{serialNo} && !$fru->{serialNo}) {
                $changes .= "-Fru $fruid was deleted.<br>";
             } elsif ($ofru->{serialNo}) {
                if ($fru->{serialNo} ne $ofru->{serialNo}) {
                  $changes .= "-SerialNo of $fruid changed from '$ofru->{serialNo}' to '$fru->{serialNo}'<br> ";
                } elsif ($fru->{revision} ne $ofru->{revision}) {
                  $changes .= "-Revision of $fruid changed from '$ofru->{revision}' to '$fru->{revision}'<br> ";
                }
             }
         }
         foreach my $fruid (keys %$ofrus) {
             my $ofru = $ofrus->{$fruid};
             my $fru = $frus->{$fruid} || {};
             if ($fru->{serialNo} && !$ofru->{serialNo}) {
                $changes .= "-Fru $fruid was added.<br>";
             }
         }
         if ($changes) {
           $out .= "<tr><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}</td><td><b><center><font color=red>Fru Changes</td>";
           $out .= "<tr><td>&nbsp;<td colspan=3><font color=navy>$changes</td>";
           $tot++;
         } else {
           $out .= "<tr><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}</td><td><font color=green><b><center>$LB->{no_change}</td>";
         }
      } else {
         $out .= "<tr bgcolor=#CCFFCC><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}<td><center><b>$LB->{added}</td>";
         $tot++;
      }
    }
    foreach my $k (keys %$odevs) {
      if (!exists($devs->{$k})) {
         my $d = $odevs->{$k};
         $out .= "<tr bgcolor=#FFCCCC><td><center>$d->{type}<td>&nbsp;$d->{name}<td>&nbsp;$d->{ipno}<td><center><b>$LB->{delete}</td>";
         $tot++;
      }
    }
  }
  $out .= "</table>";
  #$out .= "<b>Inventory is current!</b>" if (!$tot);
  return $out;
}

sub show {
  my($q) = @_;
  print Html->body();
  print Html->header2("manage.util.invent_show");
  my $inv = Inventory->readInventory();
  if (!$inv) {
     print Html->warning("No inventory available!");
     return;
  }
  print &show_($q, $inv, "Service::Inventory::show");
}


sub show_ {
  my($q, $inv, $url, $label) = @_;
  my $renv = System->get_renv();
  my $details = $q->{details};
  my $IP      = $q->{ip};
  my ($b1,$b2, $b11, $b21);
  my $LB = Labels->read("Service::Inventory");

  if ($q->{details}) {
    $b1 = "<b>"; $b11 = "</b>";
  } else {
    $b2 = "<b>"; $b21 = "</b>";
  }
  $label = $LB->{curr} if (!$label);
  my $out =  "
  <table border=1 cellspacing=0 cellpadding=1 bgcolor=white width=90%>
  <tr><td colspan=6 bgcolor=$Style::DARK>
    <table border=0 cellspacing=0 cellpadding=1 width=100%>
      <tr><td><font color=white><b>$label</td>
      <td align=right><font color=white>[ <a href=\"$Http::WEBPROC?GO=$url\"><font color=white>${b2}$LB->{summ}${b21}</font></a> | <a href=\"$Http::WEBPROC?GO=$url&details=1\"><font color=white>${b1}$LB->{detail}${b11}</font></a> ]</td>
    </table>
  <tr bgcolor=$Style::LIGHT>
       <th>$LB->{type}</th>
       <th>$LB->{name}</th>
       <th>$LB->{ip}</th>
       <th>$LB->{fru}</th>
       <th>$LB->{vendor}</th>
       <th>$LB->{rev}</th>
  ";
  my $devs = $inv->getDevices();
  foreach my $d (@$devs) {
      my $u = "<a href=\"$Http::WEBPROC?GO=$url&ip=$d->{ipno}\">$d->{name}</a>";
      my $sign = "<b>" if ($IP eq $d->{ipno});
      $out .= "<tr><td><center>$d->{type}</td><td>&nbsp;$sign$u</td>
               <td>&nbsp;$d->{ipno}</td><td colspan=3>&nbsp;</td>";
      if ($details || $IP eq $d->{ipno}) {
        my $frus = $d->frus();
        foreach my $fruid (sort keys %$frus) {
           my $fru = $frus->{$fruid};
           
           my $prod = $fru->{serialNo} ? $fru->{vendor} . " / " . $fru->{model} . " / " . $fru->{serialNo} : "N/A";
           $out .= "<tr><td colspan=3><td>&nbsp;$fruid</td><td>&nbsp;<small>$prod</td><td>&nbsp;$fru->{revision}</td>";
        }
      }
  }
  $out .= "</table>";
  return $out;
}

1;
