package NWS::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SE.pm,v 1.11 2003/04/09 23:23:18 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.11 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my $wwn  = $rep->get('id.wwn'); # really the key now
  my $renv = System->get_renv();

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn ],
                    [OtherIdentifyingInfo  => $rep->{display} ],
                    [SystemName         => $rep->get('id.name')],
                    [IP 		=> $rep->get('id.ipno')],
                    [FruCount           => $rep->get('info.slotTotal')],
                    [VolCount 		=> $rep->get('info.lunTotal')],
                    [SysRevision 	=> $rep->get('info.sp_revision')],
                    [Caption            => $rep->get('info.model')],
                    [SolutionModel      => $rep->get('info.model')],
                    [RedundantController=> $rep->get('info.isRedundantController')],
                    [SupportedRAIDType  => $rep->get('info.supportedRAIDType')],
                    [TotalCapacity      => $rep->get('info.totalCapacity')],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $wwn],
                  [Name			=> $wwn],
                  [Manufacturer 	=> $rep->get("info.vendor")],
                  [Model 		=> $rep->get("info.model")],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  my $SLOTS =  $rep->get('info.slotTotal');

  for ($i = 0; $i < $SLOTS; $i++) {
    $dd = $class->newSlot($rep,"slot.$i");
    next if (!$dd);
    $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "slot.$i"],
                   ]);
    push (@pil, @$dd);
    push (@pil, $a);
  }

  my $LUNS =  $rep->get('info.lunTotal');
  for ($i = 1; $i <= $LUNS; $i++) {
    $dd = $class->newLun($rep,"lun.$i");
    my $v2 =  CIM::Instance->new('CIM_MediaPresent', [
                       [Antecedent => $p1 ],
                       [Dependent  => $dd->[0] ],
                       ]);
    push (@pil, @$dd, $v2);
  }

  my $PORTS =  $rep->get('info.portTotal');
  for ($i = 0; $i < $PORTS; $i++) {
    $dd = $class->newPort($rep,"fcPort.$i", $p2);
    my $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "port$i"],
                   ]);
    push (@pil, @$dd, $a);

  }

  return Ilist->new(\@pil);

}

sub newSlot {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1);
  
  my $wwn       = $rep->get('id.wwn');
  my $serial_no = "$wwn.$cd";

  my $key       = $rep->get("$cd.dev-key");

  return undef if (!$serial_no);
  my($port)   = substr($cd,11,-3) . "p1";
  my($status) = $rep->get("${cd}.status-avail");

  $p1 = CIM::Instance->new('NWS_Slot', [
                    [SystemName  =>  $serial_no], # se.dvt1.slot.7
                    [DeviceID     => $rep->get("$cd.dev-key")], # slr-mi.370-3990-01-e-f1.019662
                    [Name         => $serial_no],
                    [StatusInfo   => $rep->get("$cd.status-desc") ],
                    [Status       => $status ],
                    [Type         => $rep->get("$cd.dev-type")],
                    [IpNo         => $rep->get("$cd.dev-ipno")],
                    [Key          => $key],
                    [OtherIdentifyingInfo => $rep->get("$cd.dev-name")],
                    [LinkWWN      => $rep->get("$cd.link_wwn")],
                    ]);
  push(@il, $p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => "No"],
               [Tag                 => $serial_no],
               [SerialNumber        => $serial_no],
               [Manufacturer        => "Sun"],
               [Model               => $rep->get('info.model') ],
               [PartNumber          => $key ],
               [Version             => ""    ],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  my $slotsys = CIM::Key->new( ['NWS_System',
                       CreationClassName => 'NWS_System',
                       Name              =>  $rep->get("id.wwn"),
                      ]);

  my($p2) = CIM::Instance->new('NWS_Slot_System', [
                  [Slot       => $p1],
                  [System     => $slotsys],
                  ]);
  push(@il, $p2);
  return Ilist->new(\@il);
}

sub newFru {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1);
  
  my($wwn) = $rep->get('id.wwn');

  my($serial_no) = "$wwn.$cd";

  return undef if (!$serial_no);
  my($port)   = substr($cd,11,-3) . "p1";
  my($status) = $rep->get("${cd}.status-avail");

  $p1 = CIM::Instance->new('NWS_Fru', [
                    [SystemName  =>  $serial_no], # se.dvt1.slot.7
                    [DeviceID     => $serial_no], 
                    [Name         => $serial_no],
                    [StatusInfo   => $rep->get("$cd.status-desc") ],
                    [Status       => $status ],
                    [Type         => $rep->get("$cd.dev-type")],
                    [IpNo         => $rep->get("$cd.dev-ipno")],
                    [Key          => $rep->get("$cd.dev-key")],
                    [OtherIdentifyingInfo => $rep->get("$cd.dev-name")],
                    [LinkWWN      => $rep->get("$cd.link_wwn")],
                    ]);
  push(@il, $p1);

  $c1 = CIM::Instance->new('CIM_Card', [
               [Removable           => "No"],
               [Tag                 => $serial_no],
               [SerialNumber        => $serial_no],
               [Manufacturer        => "Sun"],
               [Model               => $rep->get('info.model') ],
               [Version             => ""],
                    ]);
  push(@il, $c1);

  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent     => $c1],
                [Dependent      => $p1],
                    ]);
  push(@il,$a1);

  my $slotsys = CIM::Key->new( ['NWS_System',
                       CreationClassName => 'NWS_System',
                       Name              =>  $rep->get("id.wwn"),
                      ]);

  my($p2) = CIM::Instance->new('NWS_Fru_System', [
                  [Slot       => $p1],
                  [System     => $slotsys],
                  ]);
  push(@il, $p2);
  return Ilist->new(\@il);
}

sub newLun {
  my($class, $rep, $cd) = @_;
  my @pil;
  my $wwn =  $rep->{"$cd.lunWwn"} ;
  my $v1 = CIM::Instance->new('NWS_StorageVolume', [
                  [ SystemName      => $wwn ], 
                  [ DeviceID        => $wwn ],
                  [ VolWWN          => $wwn ],
                  [ VolName         => $rep->{"$cd.lunName"}   ],
                  [ VolId           => $rep->{"$cd.lunName"}  ],
                  [ Capacity        => $rep->{"$cd.lunCapacity"} ],
                  [ VolStatus       => $rep->{"$cd.lunStatus"}   ],
                         ]);

   push(@pil, $v1);
   return Ilist->new(\@pil);
}



sub newPort {
  my($class, $rep, $cd) = @_;
  my @il;
  my $serial_no = $rep->{"$cd.LocalPortWWN"};

  my $p1 = CIM::Instance->new('NWS_SwitchPort',  [
             [SystemName   => "SE" ], 
             [DeviceID     => $serial_no ],
             [Name         => $serial_no ],
             [Status       => 1 ],
                    ]);

  push(@il,$p1);

  my $c1 = CIM::Instance->new('CIM_Card', [
                [Removable        => "Yes"],
                [Tag              => $serial_no],
                [Name             => $serial_no],
                [SerialNumber     => $serial_no],
                    ]);
  push(@il, $c1);

  return Ilist->new(\@il);

}

1;
