package Logic::T3;

use Util;
use strict;
use Agent::T3;
use Logic;

sub addToConfig {
   my($class, $q) = @_;
   my ($err, $ipno, $active, $x);
   my $node;
   my $active = "Y";
   while (1) {
     if ($q->{name} eq "") {
        $err = Error->error(102);
        last;
     } elsif (!$q->{ip}) {
        $err = Error->error(103);
        last;
     } else {
        $active = "Y";  
        if (!($ipno = Util->testIp($q->{ip}))) {
           $err = Error->warning("t3.101",  $q->{ip});
           $active = "N";
	   last;
        }
        my($renv, $devs, $hosts,$notifs) =PDM::ConfigFile->read;
        my $hash = Agent::T3->getWWN($q->{ip}, $q->{host});
	if($hash->{err}){
	   $err = Error->error("t3.104", ,$q->{ip}, $hash->{err});

	   last;
	}
  
        my($key, $wwn, $t3name, $label) = 
                 ($hash->{key}, $hash->{wwn}, $hash->{name}, $hash->{userLabel});
        my($type) = $hash->{type}; 

        if (!$key) {
             $err = Error->error("t3.102", $q->{ip});
             last;
        } elsif (length($wwn) < 3) {
             $err = Error->error("t3.103");
             last;
        }

        foreach $x (@$devs) {
          if ($x->{name} eq $q->{name}) {
             $err = Error->error(106);
             goto out;
          } elsif ($wwn && $x->{wwn} eq $wwn) {
             $err = Error->error(107);
             goto out;
          }
        }
            
        $x = $#$devs + 1;
        $devs->[$x]{_name}    = "device" . ($x+1);
        $devs->[$x]{type}     = $type || 't3';
        $devs->[$x]{class}    = "storage." . ($type || 't3');
        $devs->[$x]{wwn}      = $wwn;
        $devs->[$x]{wwn2}     = $hash->{wwn2};
        $devs->[$x]{ctrl_model} = $hash->{ctrl_model};
        $devs->[$x]{userLabel} = $label;
        $devs->[$x]{key}      = $key;
        $devs->[$x]{units}    = $hash->{units};
        $devs->[$x]{name}     = $t3name || $q->{name};
        $devs->[$x]{active}   = $active;
        $devs->[$x]{ip}       = $q->{ip};
        $devs->[$x]{telnet}   = Util->encodeAll($q->{telnet});
        $devs->[$x]{ipno}     = $ipno;
        $devs->[$x]{host}     = $q->{host};
        Logic->clearSlave($q->{host}, $hosts);
        $node = $devs->[$x];

        if (!PDM::ConfigFile->write( $renv, $devs, $hosts,$notifs)) {
           $err = Error->error(101);

        }
     }
     last;
    }
out:
    return ($err, $node);
}

# 
# find ip# from messages.t3
# return pointer to array of IPs
#

sub find_message_ip {
  my($class, $logfile) = @_;
  my ($cnt1, $l, %local, @IPS);
  if (open(O, $logfile)) {
      my $cnt1;
      while ($l = <O>) {
          last if ($cnt1++ > 40000);
          my @a = split(/ +/, $l);
          my $loc = $a[3];
          $loc = substr($loc,1) if (substr($loc,0,1) eq "[");
          chop($loc) if (substr($loc,-1) eq "]");
          $loc = substr($loc,0, -4) if (substr($loc,-4) eq ".2.2");
          next if ($loc =~ /\:/);
          $local{$loc} = 1;
      }
      close(O);
  }
  foreach my $el (keys %local) {
     my $el0 = $el;
     if ($el0 !~ /^\d+\.\d+\./) {
        $el0 = Util->name2ip($el);
     }
     push(@IPS, $el0);
  }
  return \@IPS;
}

1;

