package Layout;

use TO;
use System;
use strict;

use vars qw($INC_I $INC_J $PER_ROW $ALT $ROW_CNT $COL_CNT $ALT_X $EXT $TOP);

sub position {
  my($XY, $all_nodes, $list, $node_set, $i, $j) = @_;

  foreach my $el (values %$node_set ) {
     my $name ;
     if (!exists $el->{empty}) {
       next if ($list && index($list, $el->name()) < 0);
       next if ($el->info("mgmtLevel") eq "DS");
       $name = $el->id();
     } else {
       $name = "empty-$el->{empty}";
     }
     if ($ROW_CNT >= $PER_ROW) {
        $$i += $INC_I; 
        $ALT = $ALT == 0 ? $INC_J/2: 0;
        $$j = $TOP + $ALT;
        $ROW_CNT=0;
        $COL_CNT++;
     }
     $ALT_X = $ALT_X == 0 ? 10: 0;
     $ROW_CNT++;
     $el->{info}{pos_x} = $$i + $ALT_X;
     $el->{info}{pos_y} = $$j; 
     #print "$name x=" . $$i . ", y=" . $$j . " col_cnt=$ROW_CNT\n";
     $$j += $INC_J;
     $XY->{$el->name()} = $el->{info};
     push(@$all_nodes, $el);
  }
}

sub empty_node {
  my($x) = @_;
    my $en = {empty => $x, info => {}, port => []};
    bless($en, 'TO::Node');
    return $en;  
}

sub debug {
  my($str, $all_nodes, $x, $y) = @_;
  my $n1 = $all_nodes->[$x];
  my $n2 = $all_nodes->[$y];
  my $name1 = (exists $n1->{empty}) ? " **EMPTY:$n1->{empty}" : $n1->id();
  my $name2 = (exists $n2->{empty}) ? " **EMPTY:$n2->{empty}" : $n2->id();
  print "$str $name1 with $name2 \n";
}

#  Layout->shortest_route($topo_name, $topo, $filter, $debug, $width, $height);
#  Layout->shortest_route("MERGE-MASTER", $to, "island:2", 0, 1000, 800);
#  assume zoom=3, 25% meaning height*2 and width*2

sub shortest_route {
  my($class, $topo_name, $to, $filter, $debug, $WIDTH, $HEIGHT, $layout, $row_size, $arg) = @_;
  my ($node_set, $y, $x, @BAGS, @all_nodes);

  my $CLI = $arg->{CLI};
  my $PASSES = $arg->{PASSES} || 20;
  $layout = 1 if (!$layout);
  $WIDTH  = 1000 if (!$WIDTH);
  $HEIGHT = 700 if (!$HEIGHT);
  $HEIGHT *= 2;
  $WIDTH  *= 2;
  $TOP    = 30;
  $INC_I  = 170;
  $INC_J  = 180;
  my %XY;

  my($ZONE_ID, $FILTER_LIST, $GR, $GR_MAP) = $to->filter_list($filter);
  return if ($filter =~ /^group:/);

  my $TOT_NODES;
  foreach my $k (keys %{$to->[0]}) { $TOT_NODES++ }
  foreach my $k (keys %{$to->[1]}) { $TOT_NODES++ }
  foreach my $k (keys %{$to->[2]}) { $TOT_NODES++ }
  return undef if ($TOT_NODES > 80 && !$CLI);
  print "Node Count: $TOT_NODES\n" if ($CLI);

  my $i  = $TOP; # x
  my $j  = $TOP; # y
  if ($row_size) {
    $PER_ROW = $row_size;
  } else {
    $PER_ROW = int($HEIGHT / $INC_J);
    my $cols = int($TOT_NODES / $PER_ROW);
#   open(OO, ">>/tmp/x"); print OO "TOT=$TOT_NODES, height=$HEIGHT, per_row=$PER_ROW, cols=$cols \n"; close(OO);
    $PER_ROW -=2  if ($cols < $PER_ROW); # switch from 10x2 to 2x10, 
  }

# EMPTY NODES
  my(%EMPTY_NODES);
  for($x=0; $x < $PER_ROW; $x++) {
    $EMPTY_NODES{"node$x"} = &empty_node($x);
  }
  my($pass, $best_pass, $START, $END, $START2, $END2, $START3, $END3);

  if ($layout == 1) {
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[0], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[1], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[3], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[2], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  \%EMPTY_NODES, \$i, \$j);
    $START = 0; $END = $#all_nodes;

  } elsif ($layout == 2) {
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[0], \$i, \$j);
    $START2 = 0; $END2 = $#all_nodes;
    $START = $#all_nodes + 1;
    $i += $INC_I; $j = $TOP; $ROW_CNT = 0;
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[1], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[3], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[2], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  \%EMPTY_NODES, \$i, \$j);
    $END = $#all_nodes;

  } elsif ($layout == 3) {
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[0], \$i, \$j);
    $START2 = 0; $END2 = $#all_nodes;

    $START = $#all_nodes + 1;
    $i += $INC_I; $j = $TOP; $ROW_CNT = 0;
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[1], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[3], \$i, \$j);
    $END = $#all_nodes; 

    $START3 = $#all_nodes+1;
    $i += $INC_I; $j = $TOP; $ROW_CNT = 0;
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[2], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  \%EMPTY_NODES, \$i, \$j);
    $END3 = $#all_nodes;

  } elsif ($layout == 4) {
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[0], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[1], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[3], \$i, \$j);
    $START = 0; $END = $#all_nodes;

    $START2 = $#all_nodes + 1;
    $i += $INC_I; $j = $TOP; $ROW_CNT = 0;
    &position(\%XY, \@all_nodes, $FILTER_LIST,  $to->[2], \$i, \$j);
    &position(\%XY, \@all_nodes, $FILTER_LIST,  \%EMPTY_NODES, \$i, \$j);
    $END2 = $#all_nodes;
  }

  my $lowest = 1000000;
  for ($pass=1; $pass <= $PASSES; $pass++) {
    print "Pass $pass\n" if ($CLI);
    my $swap_cnt = 0;
    my $tot_cost;
    for ($x=$START; $x <= $END; $x++) {
      $tot_cost += &permutate(\@all_nodes, $x, $to,  $START, $END, \%XY, $debug, \$swap_cnt);
    }
    $tot_cost = int($tot_cost);
    if ($tot_cost < $lowest) {
      $lowest = $tot_cost ; $best_pass = $pass;
    }
    if ($END2) {
      for ($x=$START2; $x <= $END2; $x++) {
        $tot_cost += &permutate(\@all_nodes, $x, $to,  $START2, $END2, \%XY, $debug, \$swap_cnt);
      }
    }
    if ($END3) {
      for ($x=$START3; $x <= $END3; $x++) {
        $tot_cost += &permutate(\@all_nodes, $x, $to,  $START3, $END3, \%XY, $debug, \$swap_cnt);
      }
    }
    print "pass $pass: $tot_cost, gain=$lowest, swap=$swap_cnt \n" if ($debug);
    last if ($swap_cnt <= 1);
  }
  &save($topo_name, $filter, \@all_nodes);
  return $to;
}

sub permutate {
  my($all_nodes, $x, $to, $START, $END, $XY, $debug, $swap_cnt) = @_;
  my $n = $all_nodes->[$x];
  my ($tot_cost, $y);
  return if (exists $n->{empty});
  my $best_swap = -1;
  my $n_cost = &calc_cost($XY, $to, $n,   $n->{info}{pos_x},  $n->{info}{pos_y});
  $tot_cost += $n_cost;
  my $best_gain = 0;
  for ($y = $START;  $y <= $END; $y++) {
     next if ($y == $x);
     my $key = ($x < $y) ?  "$x-$y" : "$y-$x";
     my $n2 = $all_nodes->[$y];
     my($gain);
     if (exists $n2->{empty}) {
       my $n_new_cost  = &calc_cost($XY,$to, $n,  $n2->{info}{pos_x}, $n2->{info}{pos_y});
       $gain =  ($n_cost - $n_new_cost);
     } else {
       my $n2_cost     = &calc_cost($XY,$to, $n2, $n2->{info}{pos_x}, $n2->{info}{pos_y});
       my $save_x = $n->{info}{pos_x};
       my $save_y = $n->{info}{pos_y};
       my $save2_x = $n2->{info}{pos_x};
       my $save2_y = $n2->{info}{pos_y};
       $n2->{info}{pos_x} = $save_x;
       $n2->{info}{pos_y} = $save_y;
       $n->{info}{pos_x}  = $save2_x;
       $n->{info}{pos_y}  = $save2_y;
       my $n_new_cost  = &calc_cost($XY,$to, $n,  $n->{info}{pos_x}, $n->{info}{pos_y});
       my $n2_new_cost = &calc_cost($XY,$to, $n2, $n2->{info}{pos_x}, $n2->{info}{pos_y});

       $n->{info}{pos_x}  = $save_x;
       $n->{info}{pos_y}  = $save_y;
       $n2->{info}{pos_x} = $save2_x;
       $n2->{info}{pos_y} = $save2_y;

       $gain = ($n_cost - $n_new_cost) + ($n2_cost - $n2_new_cost);
     }
     if ($gain > $best_gain) {
        $best_gain= $gain; $best_swap = $y;
     }
  }
  if ($best_swap >= 0) {
     #&debug("swapping", $all_nodes, $x, $best_swap) if ($debug);
     &swap($all_nodes, $x, $best_swap);
     $$swap_cnt = $$swap_cnt + 1;
     my $key = ($x < $best_swap) ?  "$x-$best_swap" : "$best_swap-$x";
     $tot_cost -= $best_gain;
  }
  return $tot_cost;
}


sub save {
  my($topo_name, $filter, $all_nodes) = @_;

  $filter = "*" if (!$filter);
  my $XY_LOC = System->get_home() . "/DATA/tmp/topoxy_$topo_name$filter";
  open(O, $XY_LOC);
  my $line1 = <O>; close(O);
  open(O, ">$XY_LOC");
  print O "z=3|orient=v|\n";
  my($x);
  for ($x = 0; $x <= $#$all_nodes; $x++) {
      my $n = $all_nodes->[$x];
      next if (exists $n->{empty});
      print O $n->name(). "|v|s|" . $n->name() . "|$n->{info}{pos_x}|$n->{info}{pos_y}\n";
  }
  close(O);
}




sub calc_cost {
  my($XY, $to, $n, $pos_x, $pos_y) = @_;
  my $ports = $n->port();
  my $len = 0;
  # print "   => " . $n->id() . " at $pos_x, $pos_y \n";
  foreach my $p (@$ports) {
     next if (!$p);
     my $ix = rindex($p, ":");
     my $p0 = substr($p, 0, $ix);
     my $n2 = $XY->{$p0};
     if ($n2) {
        my $pos2_x = $n2->{pos_x};
        my $pos2_y = $n2->{pos_y};
        my $a1 = abs($pos2_x - $pos_x);
        my $a2 = abs($pos2_y - $pos_y);
        #$a1 *= 3 if (substr($n2->{class},0,2) ne "sw");
        my $dist =  sqrt($a1 * $a1 + $a2 * $a2);
        #my $dist =  $a1 + $a2;
        $len +=  $dist;
     } 
  }
  return $len;
}




sub swap {
  my($all_nodes, $x, $y) = @_;

  my $swap = $all_nodes->[$x];
  my $x_x = $all_nodes->[$x]{info}{pos_x};
  my $x_y = $all_nodes->[$x]{info}{pos_y};
  my $y_x = $all_nodes->[$y]{info}{pos_x};
  my $y_y = $all_nodes->[$y]{info}{pos_y};

  $all_nodes->[$x] = $all_nodes->[$y];
  $all_nodes->[$y] = $swap;
  $all_nodes->[$x]{info}{pos_x} = $x_x;
  $all_nodes->[$x]{info}{pos_y} = $x_y;

  $all_nodes->[$y]{info}{pos_x} = $y_x;
  $all_nodes->[$y]{info}{pos_y} = $y_y;

}


1;
