package GUI::Index;
use System;
use strict;
use PDM::ConfigFile;

use vars qw($AGE $CACHE @CACHEX);

sub run {
  my($q) = @_;
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
  my $MAX = 10;
  my $sc = $q->{search}; $sc =~ s/`//g;
  my $LB = Labels->read("GUI::Index");
  print Html->text_header();

  print "\n<body bgcolor=$Style::LEFT_BG link=$Style::LEFT_FG alink=red vlink=$Style::LEFT_FG leftmargin=0 topmargin=0 marginwidth=0 marginheight=0>";
  print "<script>
   function islands(){ 
      var b = '$Http::WEBPROC?GO=GUI::Islands::report';
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=500,height=700');
      O.focus();
    }
    </script>
   ";


  my $DD =  System->get_home() . "/DATA/topo";
  opendir(O, $DD); my(@files) = readdir(O); closedir(O);
  my(@H, @T, $host_cnt, $topo_cnt);
  my($in) = 0;
  my ($out, $exclude, $once);
  foreach my $f (sort @files, "MERGE-MASTER") {
     next if (-d "$DD/$f");
     next if ($f eq "MERGE-MASTER" && $once++ ==1);
     my($ms) = ($renv->{hostname} eq $f)? "M:": "S:";
     if (substr($f,0,6) eq "MERGE-") {
        my $f0 = substr($f,6);
        push(@T, [$f0,  "$Http::WEBPROC?GO=GUI::Graph::run3&topo=$f"]);
        $exclude .= ",$f0,";
        $topo_cnt++;
     } else {
        next if ($sc && $f !~ /$sc/);
        my $i = index($f, ".");
        my $f0 = $f;
        if ($i > 0 && $f !~ /^\d+\./) {
          $f0 = substr($f,0, $i) 
        }
        push(@H, ["$ms$f0", "$Http::WEBPROC?GO=GUI::Graph::run3&topo=$f"]);
        $host_cnt++;
     }
  }
  open(O, System->get_home() . "/DATA/topo_merge");
  my $l;
  while ($l = <O>) {
     chop($l);
     my(@x) = split(/\|/, $l);
     next if ($x[0] eq "MASTER");
     next if (index($exclude, ",$x[0],") >= 0);
     push(@T, [$x[0],  "$Http::WEBPROC?GO=GUI::Graph::run3&topo=MERGE-$x[0]"]);
     $topo_cnt++;
  }
  close(O);


  if ( $topo_cnt + $host_cnt == 0) {
    print "<center><table border=0 Xbgcolor=white><tr><td><center><b>$LB->{no_topo}</b>
    <br> -<a href=$Http::WEBPROC?GO=GUI::SAN::snapshot target=bottom>$LB->{gen_topo}</a><br></table>";

  } else {
   
    my ($x);
    my $first = 1;
    my $page = 0;
    my $currPage = $q->{page} || 1;
    for ($x=0; $x <= $#H; $x++) {
      my $el = $H[$x];
      if ($x % $MAX == 0) {
        $page++;
        my $last = $first + $MAX - 1;
        $last = $#H + 1 if ($last > $#H+1);
        my $lnk = "<a href=$Http::WEBPROC?GO=GUI::Index::run&page=$page><font><b>$LB->{hosts}</b>";
        $lnk .= " " . substr($el->[0],2,5) . ".."  if ($#H+1 > $MAX);
        $lnk .= "</font></a>";
        $out .= "<tr><td>$lnk</td>";
        $first += $MAX;
      }
      $out .= "<tr><td>&nbsp;&nbsp;<a href=$el->[1] target=main>$el->[0]</a></td>"
              if ($page eq $currPage) ;
    }

    $out .= "<tr><td></td><tr><td><b><font color=$Style::LEFT_FG>$LB->{topos}</font></b></td>";
    foreach my $el (@T) {
      $out .= "<tr><td>&nbsp;&nbsp;<a href=$el->[1] target=main>$el->[0]</a></td>";
    }
    if ($topo_cnt > 0) {
    $out .= "<tr><td>&nbsp;&nbsp;<a href=javascript:islands()><font color=$Style::LEFT_FG>$LB->{islands}</font></a></td>";
    }
     #push(@T, [$x[0],  "$Http::WEBPROC?GO=GUI::Graph::run3&topo=MERGE-$x[0]"]);

use Grouping;
    my $glist = Grouping->groupList("MERGE-MASTER");
    if ($#$glist >= 0) {
      $out .= "<tr><td></td><tr><td xbgcolor=#4040A0><font color=$Style::LEFT_FG><b>$LB->{groups}</b></font></td>";
      foreach my $el (@$glist) {
        my $h = $el->{host};
        $out .= "<tr><td>&nbsp;&nbsp;<a href=$Http::WEBPROC?GO=GUI::Graph::run3&topo=$h&FILTER=group:$h:$el->{group} target=main>" . ucfirst($el->{group}) . "</a></td>";
      }
    }
    my $search = "<input type=text name=search value=\"$LB->{search}\" size=10 onfocus=\"value=''\">" if ($page > 1);
 
    print "<center>
       <table border=0 cellspacing=0 cellpadding=3 width=110%  bgcolor=$Style::LEFT_HEAD_BG>
        <tr><td><center><table border=0><tr><td><font color=$Style::LEFT_HEAD_FG><b>$LB->{topology}</table></td>
       </table>
       <table border=0 border=0 cellspacing=0><tr><td></table>
       <table border=0 cellpadding=2 cellspacing=0 width=110% bgcolorX=white>
        $out
       </table>
     <table border=0 border=0><tr><td></table>
     <table border=0 cellspacing=0 cellpadding=0 bgcolor=#D0D0F0><tr><td>
       <form>
       <input type=hidden name=GO value=GUI::Index::run>
        $search 
     </table>
     </form>
       ";

  }
  
}

# target = graph | diag
sub search {
  my($q) = @_;
  my $LB = Labels->read("GUI::Index");
  print Html->body();
  print "<table border=0 cellpadding=2 width=%95 bgcolor=white><tr><td>$LB->{info}</table>";
  print "\n<body bgcolor=#F0F0F0>\n";
  print "<table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=$Style::DARK><td colspan=2><b><font color=white>$LB->{search1}</td>
   <tr><td align=right bgcolor=$Style::LIGHT><table border=0><tr><td>$LB->{host2}:</table></td>
       <td>&nbsp;$q->{topo}</td>
   <tr><td align=right bgcolor=$Style::LIGHT><form>
       <input type=hidden name=GO value=GUI::Index::search>
       <input type=hidden name=topo value=\"$q->{topo}\">
       <input type=hidden name=LINKH value=\"$q->{LINKH}\">
       <input type=hidden name=target value=\"$q->{target}\">
       $LB->{name}:</td>
       <td><input type=text name=name size=20 value=\"$q->{name}\"></td>
   <tr><td align=right bgcolor=$Style::LIGHT>
       $LB->{ip}:</td>
       <td><input type=text name=ipno size=20 value=\"$q->{ipno}\"></td>
   </table>
   <center><b><input type=submit name=ACTION_search value=\"$LB->{search}\">
   </form>";
   if ($q->{ACTION_search}) {
      my $target = $q->{target} || "left";
      my $out = "<table border=1 cellspacing=0 cellpadding=0 width=100% bgcolor=white>
       <tr bgcolor=$Style::LIGHT><td colspan=2><b>Results</td>";
      require TO;
      my $to = TO->readExistingTopo($q->{topo});
      my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
      my(@X);
      foreach my $d (@$devs) {
         if ($q->{name} && $d->{name} =~ /$q->{name}/) {
            push(@X, [$d->{type}, $d->{key}, $d->{name}]);
         } elsif ($q->{ipno} && $d->{ipno} =~ /$q->{ipno}/) {
            push(@X, [$d->{type}, $d->{key}, $d->{name}]);
         }
      }
      my $prgm = "GUI::Graph::run3";

      foreach my $el (@X) {
        my $url;
        my $n = $to->nodeByName("$el->[0]:$el->[1]");
        if ($n) {
          my $k = $n->name();
          $url = "<a href=\"$Http::WEBPROC?GO=$prgm&topo=$q->{topo}&LINKH=$q->{LINKH}&FILTER=$k&key=$k\" target=main
>$el->[2]</a>\n";
        } else {
          $url = $el->[2] . "\n";
        }
        $out .= "<tr><td>&nbsp;$el->[0]<td>&nbsp;$url</td>";
      }
      $out .= "</table>";
      print $out;
   }
}


1;
