package GUI::Grouping;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use System;
use TO;
use Util;
use Grouping;
use Html;
use Html::Tabs;
use Html::List;
use strict;


sub index {
  my($q) = @_;

  print Html->body();
  print Html->header2("admin.topo.grouping",  "95%");

  my $LB = Labels->read("GUI::Grouping");

  if ($q->{ACTION_addcat}) {
      if ($q->{code} && $q->{desc}) {
         $q->{code} =~ s/\W/_/g;
         Grouping->addCategory($q->{host}, $q->{code}, $q->{desc});
      } else {
         print "<font color=red><b>$LB->{enter_code}";
      }
  }
  if ($q->{ACTION_delete}) {
     foreach my $el (keys %$q) {
        if (substr($el,0,4) eq "del_") {
           Grouping->deleteCategory(substr($el,4));
        }
     }
  }
  my $list = Grouping->groupList();

  $q->{option} = 1 if (!$q->{option});
  my $ck = "selected" if ($q->{option} eq "1");
  my $sels = "<select name=option Xonchange='form.submit()'><option value=1 $ck>$LB->{list}</option>";

  my $ck = "selected" if ($q->{option} eq "2");
  $sels .= "<option value=2 $ck>$LB->{new}</option>";

  
  foreach my $el (@$list) {
    next if (!$el->{host});
    my $v1 = Util->shortHostname($el->{host});
    my $ck = "selected" if ($q->{option} eq "$v1:$el->{group}");
    $sels .= "<option value=\"$v1:$el->{group}\" $ck>$LB->{update} $v1 : $el->{group}</option>";
  }

  my $ck = "selected" if ($q->{option} eq "3");
  $sels .= "<option value=3 $ck>$LB->{islands}</option>";

  my $ck = "selected" if ($q->{option} eq "4");
  $sels .= "<option value=4 $ck>$LB->{adm}</option>";

  $sels .= "</select>";
  print "<table border=0 cellspacing=0 width=95%><tr><td>
          <table border=1 cellpadding=3 cellspacing=0 ><tr><td><b>
    <form>$LB->{selectf}: <input type=hidden name=GO value=GUI::Grouping::index>$sels 
          <input type=submit name=ACTION value=GO></td></form></table></table>
         ";

  if ($q->{option} == 1) {
    &group_maintain($q);
  } elsif ($q->{option} == 2) {
    &newGroup($q);

  } elsif ($q->{option} == 3) {
    print "</center>&nbsp;<p>$LB->{gen1}...<br>\n";
    Grouping->group_islands($q);
    print "Done!<br>\n";

  } elsif ($q->{option} == 4) {
    print "</center>&nbsp;<p>$LB->{gen2}...<br>\n";
    Grouping->group_adm($q);
    print "Done!<br>\n";

  } else {
    $q->{code} = $q->{option};
    &group_build($q);
  }

}


sub group_build {
  my($q) = @_;
  my $group = $q->{code};
  my($group_host, $group_id) = split(/\:/, $group);
  my $deny = Roles->verifyRole($q, "admin");
  my $LB = Labels->read("GUI::Grouping");

  if ($q->{ACTION_update}) {
     my $grp = Grouping->read($group);
     foreach my $v (keys %$q) {
        if (substr($v,0,4) eq "sel_") { 
           my $k = substr($v,4);
           $q->{groupID} =~ s/[^\w\.\-]/_/g;
           $grp->setGroup($group, $k, $q->{groupID});
        }
     }
     $grp->save();
  }

  if ($q->{ACTION_updid}) {
     my $grp = Grouping->read($group);
     foreach my $v (keys %$q) {
        if (substr($v,0,5) eq "desc_") { 
           my $k = substr($v,5);
           my $desc = $q->{$v};
           my $style = $q->{"style_$k"};
           my $color = $q->{"color_$k"};
           if ($desc || $style || $color) {
             $grp->updateId($k, $desc, $style, $color);
           }
        }
     }
     $grp->save();
  }

  Grouping->refreshMap($group);
  my $grp     = Grouping->read($group);
  my $members = $grp->members();
  my $map     = $grp->map();
  my $info    = $grp->info();

  if ($q->{SUMM}) {
      print "
   <table border=0><tr><td></table>
   <table border=1 cellspacing=0 width=95% bgcolor=white>
     <tr bgcolor=$Style::DARK><td colspan=5>
       <form method=post><input type=hidden name=GO value=\"GUI::Grouping::index\">
       <input type=hidden name=option value=\"$q->{option}\">
       <input type=hidden name=SORT value=\"$q->{SORT}\">
       <input type=hidden name=SUMM value=1>
       <table border=0 cellspacing=0 cellpadding=0 width=100%>
        <tr><td><table border=0 width=100%>
          <tr><td><b><font color=white>$LB->{title1} '$group'</td>
              <td align=right><font color=white>[ 
           <a href=\"$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&HOST=$q->{HOST}&TYPE=$q->{TYPE}\"><font color=white>$LB->{details}</font></a> | 
           <a href=\"$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&SUMM=1&HOST=$q->{HOST}&TYPE=$q->{TYPE}\"><font color=white><b>$LB->{summary}</b></font></a> ]
          </table>
       </table>
     <tr bgcolor=$Style::LIGHT>
        <td>&nbsp;$LB->{catid}
        <td>#Member
        <td>&nbsp;$LB->{desc}
        <td>&nbsp;$LB->{style}
        <td>&nbsp;$LB->{color}";
     my(%X);
     foreach my $el (keys %$members) {
         my $v0 = $members->{$el};
         next if (!$v0 || $v0 eq $group);
         my $v = $X{$v0};
         if ($v) {
           $X{$v0} = [$v->[0]+1,undef];
         } else {
           $X{$v0} = [1, undef];
         }
         my ($f1, $f2) = split(/\./, $v0);
         if ($f2) {
            $v = $X{$f1};
            if ($v) {
              $X{$f1} = [$v->[0]+1,undef];
            } else {
              $X{$f1} = [1, undef];
            }
         }
     }
     foreach my $el (keys %$map) {
         if ($X{$el}) {
            $X{$el}[1] = $map->{$el};
         } else {
            $X{$el} = [0, $map->{$el}];
         }
     }
     my $cnt;
     my $del = 0;
     foreach my $el (sort keys %X) {
        next if ($el eq $group);
        if (!$X{$el}[0]) {
           $grp->deleteId($group, $el); $del++;
           next;
        }
        my $v = $X{$el};
        my $styl = "<select name=\"style_$el\">";
        foreach my $st0 (Grouping::GROUP_TYPE) {
           my($f1, $f2) = split(/\=/, $st0);
           my $sel = ($v->[1][1] eq $f1)? "selected":"";
           $styl .= "<option $sel value=\"$f1\">$f2</option>";
        }
        $styl .= "</select>";

        my $color = "<select name=\"color_$el\">";
        foreach my $st0 (@Grouping::COLORS) {
           my($f1, $f2) = split(/\=/, $st0);
           my $sel = ($v->[1][2] eq $f1)? "selected":"";
           $color .= "<option $sel value=\"$f1\">$f2</option>";
        }
        $color .= "</select>";
        my $ix0 = CORE::index($el,":");
        my$ el0 = substr($el,$ix0+1);
        print "<tr><td>&nbsp;$el0<td>&nbsp;$v->[0]
         <td>&nbsp;<input type=text size=25 name=\"desc_$el\" value=\"$v->[1][0]\">
         <td>$styl<td>$color</td>\n";
     }
     $grp->save() if ($del);
     print "</table>";
     if (!$deny) {
       print "<input type=submit name=ACTION_updid value=\"$LB->{submit_updid}\">";
     }
     print "</form>\n";
     return;
  } 
#
# DETAILS
#
  my %L;
  #foreach my $el (keys %$members) {
  #   $L{$el} = [ $members->{$el} ];
  #}

  my($hosts) = Util->shortHostname($info->{host});
  my($types) = "<select name=TYPE><option value=\"\">$LB->{all}</option>";
  my(%TY);
  my $short =  Util->shortHostname($info->{host});

  my $to = TO->readTopo($info->{host});
  my $sw_list = $to ? $to->switchList()  : [];
  my $st_list = $to ? $to->storageList() : [];
  my $ho_list = $to ? $to->hostList()    : [];
  foreach my $el (@$sw_list, @$st_list, @$ho_list) {
         my $k = $el->name();
         $TY{$el->type()} = 1;
         my $name = $el->boxName();
         $L{$k}[1] = $el->boxName();
         $L{$k}[0] = $members->{$k};
         #if ($L{$k}) {
         #  $L{$k}[1] = $name;
         #} else {
         #  $L{$k} = [undef, $name];
         #}
  }
  foreach my $ty (sort keys %TY) {
    my $sel = ($q->{TYPE} eq $ty) ? "selected":"";
    $types .= "<option $sel>$ty</option>";
  }
  $types .= "</select>";
  my (@L2);
  foreach my $x (keys %L) {
     my($type, $wwn) = split(/\:/, $x);
     next if ($q->{TYPE} && $type ne $q->{TYPE});

     push(@L2, [$type, $wwn,  $L{$x}[1], 
                substr($L{$x}[0],length($group)+1),
                "<input type=checkbox name=\"sel_$x\">" ]);
  }
 
  $q->{SORT} = 1 if (!$q->{SORT});
  my($pageInfo, $list) = Html::List->makeList($q,
                        \@L2,
                    [$LB->{type}, $LB->{id}, $LB->{name}, "$group_id-$LB->{id}", $LB->{select}],
                    [  'l',  'l',     'l',     'l' ,   'c'  ],
                    [ '+sn',  '+',     '+',     '+sn'  ],
                       {pageSize => 200, interactive => 1});

  print "<table border=0><tr><td></table>";
  
  my $gsel;
  if (!$deny) {
    $gsel = "
      <table border=1 cellspacing=0 cellpadding=1 bgcolor=$Style::LIGHT>
        <tr><td>&nbsp;<b>$LB->{sel} $group_id-Id: <input type=text name=groupID size=20>
           <input type=submit name=ACTION_update value=$LB->{submit_upd}> &nbsp;
      </table>";
  }
       
  print "<table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=$Style::DARK>
   <td colspan=5>
     <table border=0 cellspacing=0 cellpadding=0 width=100%>
     <tr><td>
       <b><font color=white>$LB->{cat} '$group'</td>
       <form><input type=hidden name=GO value=GUI::Grouping::index>
       <input type=hidden name=option value=$q->{option}>
       <input type=hidden name=SORT value=$q->{SORT}>
       </td>
     <td><font color=white><b>Type:$types&nbsp<small> <input type=submit name=ACTION value=GO></td>
     <td align=right>
      <font color=white>[ <a href=$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&TYPE=$q->{TYPE}&HOST=$q->{HOST}><font color=white><b>$LB->{details}</b></font></a> | 
    <a href=$Http::WEBPROC?GO=GUI::Grouping::index&option=$q->{option}&SUMM=1&TYPE=$q->{TYPE}&HOST=$q->{HOST}><font color=white>$LB->{summ}</font></a> ]</td></table>

   $list
   </table>
  <table border=0 width=95%> <tr><td> $pageInfo <td align=right>$gsel </td>
  </table>
  </form>
  ";
}

sub group_maintain {
  my($q) = @_;

  my $l = Grouping->groupList();

  my $select_host = TO->topoListSelect("host");
  my $LB = Labels->read("GUI::Grouping");

  if (length($select_host) < 30) {
     print Html->info($LB->{no_topo});
     return;
  }

  print "
   <table border=0><tr><td></table>
   <table border=1 cellspacing=0 width=95% bgcolor=white>
   <tr bgcolor=$Style::DARK>
    <td colspan=4>
     <form><input type=hidden name=GO value=GUI::Grouping::index>
           <input type=hidden name=option value=1>
     <b><font color=white>$LB->{grouping_list}
    <tr bgcolor=$Style::LIGHT>
       <td><b>$LB->{group_code}</td>
       <td><b>$LB->{host}</td>
       <td><b>$LB->{desc}</td>
       <td><b><center>$LB->{delete}</td>
       ";
  my $cnt;
  foreach my $el (@$l) {
     $cnt++;
     my $d = "$el->{host}:$el->{group}";
     my $url = "<a href=$Http::WEBPROC?GO=GUI::Grouping::index&option=$d>$el->{group}</a>";
     print "<tr>
                <td>&nbsp;$url
                <td>$el->{host}
                <td>$el->{description}
            <td><center><input type=checkbox name=del_$d>
           ";
  }
  my($info, $del);
  if (!$cnt) {
    print "<tr><td colspan=3><b><font color=red>$LB->{no_grouping}";
  }
  print "</table>";
  my $deny = Roles->verifyRole($q, "admin");
  if ($cnt && !$deny) {
    $del = "<input type=submit name=ACTION_delete value=\"$LB->{submit_delete}\">";
    print "<table border=0 width=95%><tr><td align=right>$del</table>";
  }
}

sub newGroup {
  my($q) = @_;

  my $l = Grouping->groupList();
  my $select_host = TO->topoListSelect("host");
  my $LB = Labels->read("GUI::Grouping");
  my $deny = Roles->verifyRole($q, "admin");

  my $but1 = "<input type=submit name=ACTION_addcat value=\"$LB->{submit_addcat}\">" if (!$deny);
  print "
    <table border=0><tr><td></table>
    <table border=1 cellspacing=0 cellpadding=4 width=95% bgcolor=white>
    <tr>
      <td colspan=2 bgcolor=$Style::DARK><form><b><font color=white>$LB->{new_grouping}
           <input type=hidden name=GO value=GUI::Grouping::index>
           <input type=hidden name=option value=1>
       <tr>
           <td align=right bgcolor=$Style::LIGHT><b>$LB->{code}:</td>
           <td><input type=text size=10 name=code>&nbsp;&nbsp;&nbsp;</td>
       <tr>
           <td align=right  bgcolor=$Style::LIGHT><b>$LB->{host}:</td>
           <td>$select_host &nbsp;</td>
       <tr>
           <td align=right  bgcolor=$Style::LIGHT><b>$LB->{desc}:</td>
           <td><input type=text size=30 name=desc> </td>
     </table>&nbsp;<br>
        $but1 </form>";
}

1;
