package GUI::DumpConfig;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Id: DumpConfig.pm,v 1.6 2003/05/07 21:44:38 ccadieux Exp $

use Util;
use Grid;
use Labels;
use Launch;
use Html;
use System;
#use Agent;
use Modules;
use Report;
use State;
use strict;

#  dates are in ISO8601 (e.g. "1972-09-24 20:05") 

sub dumpConfig {
  my($q) = @_;
  print "\n<body bgcolor=$Style::BGCOLOR>";
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
  my($acronym) = $renv->{GSV_ACRONYM};
  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('dumpConfig');

  if ($q->{ACTION_email}) {
     if ($q->{email_address} !~ /.+\@.+/) {
        print "<big><font color=red><b>$L->{err_email}</font>";
     } else {
        &dumpConfig1($q);
        print "<font color=green size=+1><b>$L->{info_1} $q->{email_address} </b></font>";
     }
  }
  print "<center>";
  opendir(O, System->get_home() . "/DATA/topo");
  my @dirs = readdir(O); closedir(O);
  my $checks = "";
  my $bg = "bgcolor=D0D0FF";
  my $ho = System->hostname();
  $checks .= "<tr><td align=right $bg>$ho:<td> <input type=radio name=radioHost value=$ho></td>";
  foreach $ho (@$hosts) {
    $checks .= "<tr><td align=right $bg>$ho->{hostname}:<td> <input type=radio name=radioHost value=$ho->{hostname}></td>";
  }

  print Html->header2('admin.system.email_config');

  print "<table border=1 width=90%  cellspacing=0 cellpadding=3 bgcolor=white>
  <form><input type=hidden name=GO value=GUI::DumpConfig::dumpConfig>
  <tr bgcolor=$Style::DARK>
    <td colspan=2><font color=white><b>$L->{label}
  
  <tr><td align=right $bg>$L->{l1}:</td>
      <td><input type=text size=60 name=email_address>
  <tr><td align=right $bg>$L->{l2}:</td>
      <td><input type=text size=60 name=info>
  </table>
  <b><input type=submit name=ACTION_email value=$L->{submit_email}>
  </form>";
}



sub dumpConfig1 {
  my($q) = @_;
  my($renv, $devs, $hosts, $notifs) = PDM::ConfigFile->read;
  my($space) = "&nbsp;";
  my($out);
  my($today) = `/usr/bin/date`; # Util->today();
  my($master) = System->hostname();
  $q->{email} = 1;
  my($acronym) = $renv->{GSV_ACRONYM};

  my $G = Labels->read();
  my $L = Labels->read('GUI::Instr')->section('dumpConfig');

  $out .= "\n<body bgcolor=#F0F0F0>
  <table border=0 cellspacing=0 width=100%><tr><td>
     <h3>$L->{conf} $renv->{customer}</h3></td>
     <td align=right><b>$renv->{hostname} - $renv->{version}<br>$today</table>
  <table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
  <tr bgcolor=$Style::DARK><td colspan=2>
  <font color=white><big><b>$L->{label2}
  <tr><td>
  <table border=0 cellspacing=0 bgcolor=white>
    <tr><td align=right bgcolor=$Style::BGCOLOR>$L->{name}:</td>
        <td>&nbsp;$renv->{customer}</td>
    <tr><td align=right valign=top bgcolor=$Style::BGCOLOR>$L->{addr}:</td>
        <td>&nbsp;$renv->{site_address}<br>
           &nbsp;$renv->{site_city} $renv->{site_state} $renv->{site_zip} $renv->{site_country}<br>
    <tr><td align=right bgcolor=$Style::BGCOLOR>$L->{l_contact}:</td>
        <td>&nbsp;$renv->{site_contact} $renv->{site_email}</td>
  </table>
  <td valign=top><table border=0 cellspacing=0>
    <tr><td align=right bgcolor=$Style::BGCOLOR>$L->{custno}:</td>
        <td>&nbsp;$renv->{cust_no} &nbsp;$L->{contract}: $renv->{contract}</td>
    <tr><td align=right bgcolor=$Style::BGCOLOR>$L->{host}:</td>
        <td>&nbsp;$q->{radioHost}</td>
    <tr><td align=right bgcolor=$Style::BGCOLOR>$L->{admin}:</td>
        <td>&nbsp;$renv->{site_email}</td>
    <tr><td align=right bgcolor=$Style::BGCOLOR>$L->{polling}:</td>
        <td>&nbsp;$renv->{frequency} $L->{mins}</td>
    </table>
  </table>
  ";
  my $b;
  $b = ($q->{radioHost} eq System->hostname())? "<b>":"";

  $out .= "$space<table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
  <tr bgcolor=$Style::DARK>
  <td colspan=7><big><FONT color=white><b>$L->{labvel3}</td>
  <tr bgcolor=$Style::BGCOLOR> $L->{header2}
    ";

    $out .= "<tr><td>$b$master".
    "<td>$renv->{hostname}</td>".
    "<td>" . System->hostname() . "</td>".
    "<td>&nbsp;</td>".
    "<td><center>Y</td>".
    "<td><center>$renv->{frequency}</td>
    <td>$renv->{categories}&nbsp;</td>
     ";
  my(@L) ;
  foreach my $h (@$hosts) {
    push(@L, "$h->{hostname}\t$h->{hostid}\t$h->{ip}\t$h->{ipno}\t$h->{active}\t$h->{frequency}\t$h->{categories}");
  }
  foreach my $h (sort @L) {
    my(@a) = split(/\t/, $h);
    $b = ($a[0] eq $q->{radioHost}) ? "<b>":"";
    $out .= "<tr><td>$b$a[0]<td>$a[1]<td>$a[2]<td>$a[3]
    <td><center>$a[4]</td>
    <td><center>$a[5]</td>
    <td>$a[6]&nbsp;</td>
     ";
  }
  $out .= "</table><table border=0><tr><td></table>";
  my $outmaster;

  opendir(O, System->get_home() . "/DATA/topo");
  my @dirs = readdir(O); closedir(O);

  foreach my $el (@dirs) {
    my $F = System->get_home()  . "/DATA/topo/$el";
    if (-f $F) {
      my $o;
      print "topology for $el...<br>\n";
      $o .= "<table border=1 width=100% cellspacing=0  cellpadding=3 bgcolor=$Style::DARK>
         <tr><td><font color=white><b>$L->{label4} $el</table>";
          
      #require GUI::Graph;
      #$o .= GUI::Graph::genApplet({topo => $el, email => 1, height => 400,  zoom => 3});

      my $topo = TO->readTopo($el);
      $out .= "<table border=1 bgcolor=white width=100%><tr><td><b>Topology: $el</b><br><pre>" . $topo->toC2(1) . "</table>";
    }
  }

  $out .= "$space<table border=1 cellspacing=0 cellpadding=2 width=100% bgcolor=white>
  <tr bgcolor=$Style::DARK>
  <td colspan=7><big><FONT color=white><b>$L->{label5}</td>
  <tr bgcolor=$Style::BGCOLOR> $L->{header3}
    ";

  foreach my $d (@$devs) {  # master devices
     my $hd = $d->{host} || $renv->{hostname};
     #next if ($q->{radioHost} ne $hd);
     $out .= "<tr><td>$hd<td>$d->{type}<td>$d->{name}<td>$d->{ip}&nbsp;<td>$d->{active}</td>";
  }

  $out .= "</table>";

  print $L->{reading} . "<br> "; 

  my $D = System->get_home() . "/DATA/REMOTE_LISTS";
  opendir(O, $D);
  my @fs = readdir(O); closedir(O);
  my $cnt=0;
  Modules->load("Agent");
  foreach my $f (@fs) {
    next if (substr($f,0,1) eq ".");
    #next if ($f ne $q->{radioHost});
    open(O, "$D/$f");
    my $host = $f;
    $out .= "&nbsp;<p><table border=1 cellspacing=0 width=100% bgcolor=white>
       <tr bgcolor=$Style::DARK><td><font color=white><big><b>$L->{instr} $host</td></table>";
    my($l);
    while ($l = <O>) {
      my($file_1, $date_1, $acces_1, $name_1) = split(/=/, $l);
      my($type, $xxx) =   split(/:/, $file_1);
      next if (!$xxx);
    
      my ($err, $VAR1) = Report->readReport($file_1, $host, 10);
      if ($err) {
        $out .= "$err";
      } else {
        my $module = "Agent::" . uc($type);
        if ($module->can("REPORT")) {
          print " report $file_1 <br>";
          my $rep = $module->REPORT($host, $VAR1, {host => $xxx} );
          $out .= "$rep &nbsp;";
        }
      }
    }
    close(O);
  }

  my($hostname) = System->hostname();
  my($email) = Util->email_html("$acronym", 
                  "$acronym Configuration at $renv->{customer}", 
                  $q->{email_address},
                  "Email from $acronym on $master.
$q->{info}
$L->{email_head} $q->{radioHost}

  $L->{cust1} $renv->{customer} ($renv->{ticker})
  $L->{site1} $renv->{site_name}
  $L->{addr1} $renv->{site_address}   
  $L->{city} $renv->{site_city} $renv->{site_state} $renv->{site_zip}
  $L->{country} $renv->{site_country} 
  $L->{contact} $renv->{site_contact} $renv->{site_email}
 ",
                  "rasconfig.html", $out, "html",
         );
  
  open(O, ">/tmp/xx"); print O $email ; close(O);
  my($mailer) = $renv->{mailer};
  open(O,"|$mailer $q->{email_address}");
  print O $email;
  close(O);
}


1;
 
